/*
 * Decompiled with CFR 0.152.
 */
package ancestris.usage;

import ancestris.usage.Constants;
import genj.util.EnvironmentChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UsageManager
implements Constants {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private static String id = "";
    private static String version = "";
    private static String OS = "";
    private static String java = "";
    private static boolean isConnect = true;

    private static void setActiveUsage() {
        id = UsageManager.truncate(UsageManager.setField(EnvironmentChecker.getProperty("user.home.ancestris", "", ""), "FC7E90DB1F7AH2H3"));
        version = UsageManager.truncate(EnvironmentChecker.getAncestrisVersion());
        OS = UsageManager.truncate(EnvironmentChecker.getProperty("os.name", "", "") + " " + EnvironmentChecker.getProperty("os.version", "", ""));
        java = UsageManager.truncate(EnvironmentChecker.getProperty("java.version", "", ""));
    }

    public static boolean isConnectable() {
        return isConnect;
    }

    public static boolean writeUsage(String action) {
        if (id.isEmpty()) {
            UsageManager.setActiveUsage();
        }
        if (!isConnect) {
            return true;
        }
        String key1 = "&ID=" + id;
        String key2 = "&ACT=" + action;
        String key3 = "&VER=" + version;
        String key4 = "&OS=" + OS;
        String key5 = "&JAVA=" + java;
        String outputString = UsageManager.query("http://serv01.ancestris.org/usagelogPut.php?user=treeshare01&pw=DhZP8imP" + key1 + key2 + key3 + key4 + key5);
        return outputString.isEmpty();
    }

    public static String getKey(String key) {
        if (id.isEmpty() || version.isEmpty() || OS.isEmpty() || !isConnect) {
            return null;
        }
        Object ret = "";
        String key1 = "&ID=" + id;
        String key2 = "&VER=" + version;
        String key3 = "&OS=" + OS;
        String key4 = "&cle=" + key;
        String outputString = UsageManager.query("http://serv01.ancestris.org/registerGet.php?" + key1 + key2 + key3 + key4);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(outputString));
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName(key);
            Element node = (Element)nodeList.item(0);
            String str = StringEscapeUtils.unescapeHtml((String)node.getElementsByTagName("value1").item(0).getTextContent());
            ret = (String)ret + UsageManager.read(str);
            ret = (String)ret + " ";
            str = StringEscapeUtils.unescapeHtml((String)node.getElementsByTagName("value2").item(0).getTextContent());
            ret = (String)ret + UsageManager.read(str);
        }
        catch (IOException | NullPointerException | ParserConfigurationException | DOMException | SAXException ex) {
            LOG.log(Level.FINEST, "get Key error", ex);
        }
        return ((String)ret).trim();
    }

    private static String query(String url) {
        Object ret = "";
        try {
            String responseString = "";
            URL data = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)data.openConnection();
            connection.setConnectTimeout(5000);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((responseString = in.readLine()) != null) {
                ret = (String)ret + responseString;
            }
            in.close();
            connection.disconnect();
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Query error", ex);
            isConnect = false;
            ret = "";
        }
        return ret;
    }

    private static String truncate(String text) {
        if (text == null) {
            return text;
        }
        return text.substring(0, Math.min(text.length(), 30)).replace(" ", "_");
    }

    private static String setField(String text, String cst) {
        try {
            if (text == null || cst == null) {
                return null;
            }
            char[] keys = cst.toCharArray();
            char[] mesg = text.toCharArray();
            int ml = mesg.length;
            int kl = keys.length;
            char[] newmsg = new char[ml];
            for (int i = 0; i < ml; ++i) {
                char c = (char)(mesg[i] ^ keys[i % kl]);
                newmsg[i] = UsageManager.toHex(c % 16);
            }
            return new String(newmsg);
        }
        catch (Exception e) {
            return "UNK";
        }
    }

    private static char toHex(int nybble) {
        if (nybble < 0 || nybble > 15) {
            throw new IllegalArgumentException();
        }
        return "0123456789ABCDEF".charAt(nybble);
    }

    private static String read(String mp) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            byte[] bytes = Base64.getDecoder().decode("JYry2QendQg=");
            cipher.init(2, new SecretKeySpec(bytes, 0, bytes.length, "DES"));
            byte[] dec = Base64.getDecoder().decode(mp);
            return new String(cipher.doFinal(dec), "UTF8");
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.log(Level.FINEST, "read error", ex);
            return "";
        }
    }

    private static String write(String mp) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            byte[] bytes = Base64.getDecoder().decode("JYry2QendQg=");
            cipher.init(1, new SecretKeySpec(bytes, 0, bytes.length, "DES"));
            byte[] enc = cipher.doFinal(mp.getBytes(StandardCharsets.UTF_8));
            byte[] b64 = Base64.getEncoder().encode(enc);
            return new String(b64);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.log(Level.FINEST, "write error", ex);
            return "";
        }
    }
}

