/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.Iterator;
import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.DepthFirstIterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.stream.SourceBase;

public abstract class AbstractNode
extends AbstractElement
implements Node {
    protected AbstractGraph graph;

    protected AbstractNode(AbstractGraph graph, String id) {
        super(id);
        this.graph = graph;
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        this.graph.listeners.sendAttributeChangedEvent(this.id, SourceBase.ElementType.NODE, attribute, event, oldValue, newValue);
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Edge getEdgeToward(int index) {
        return this.getEdgeToward(this.graph.getNode(index));
    }

    @Override
    public Edge getEdgeToward(String id) {
        return this.getEdgeToward(this.graph.getNode(id));
    }

    @Override
    public Edge getEdgeFrom(int index) {
        return this.getEdgeFrom(this.graph.getNode(index));
    }

    @Override
    public Edge getEdgeFrom(String id) {
        return this.getEdgeFrom(this.graph.getNode(id));
    }

    @Override
    public Edge getEdgeBetween(int index) {
        return this.getEdgeBetween(this.graph.getNode(index));
    }

    @Override
    public Edge getEdgeBetween(String id) {
        return this.getEdgeBetween(this.graph.getNode(id));
    }

    @Override
    public Iterator<Node> getBreadthFirstIterator() {
        return new BreadthFirstIterator(this);
    }

    @Override
    public Iterator<Node> getBreadthFirstIterator(boolean directed) {
        return new BreadthFirstIterator(this, directed);
    }

    @Override
    public Iterator<Node> getDepthFirstIterator() {
        return new DepthFirstIterator(this);
    }

    @Override
    public Iterator<Node> getDepthFirstIterator(boolean directed) {
        return new DepthFirstIterator(this, directed);
    }

    protected abstract boolean addEdgeCallback(AbstractEdge var1);

    protected abstract void removeEdgeCallback(AbstractEdge var1);

    protected abstract void clearCallback();

    public boolean isEnteringEdge(Edge e) {
        return e.getTargetNode() == this || !e.isDirected() && e.getSourceNode() == this;
    }

    public boolean isLeavingEdge(Edge e) {
        return e.getSourceNode() == this || !e.isDirected() && e.getTargetNode() == this;
    }

    public boolean isIncidentEdge(Edge e) {
        return e.getSourceNode() == this || e.getTargetNode() == this;
    }
}

