/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph.graphstream;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.file.FileSink;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Color;
import org.graphstream.ui.graphicGraph.stylesheet.Colors;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;

public class AncestrisFileSinkSvg
implements FileSink {
    private final Graph leGraph;

    public AncestrisFileSinkSvg(Graph graph) {
        this.leGraph = graph;
    }

    public void begin(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void begin(OutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void begin(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void end() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
    }

    public void writeAll(Graph graph, String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.writeAll(graph, out);
        out.close();
    }

    public void writeAll(Graph graph, OutputStream stream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        this.writeAll(graph, out);
    }

    public void writeAll(Graph g, Writer w) throws IOException {
        XMLWriter out = new XMLWriter();
        SVGContext ctx = new SVGContext();
        try {
            out.start(w);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        try {
            ctx.init(out, g);
            ctx.writeElements(out, g);
            ctx.end(out);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        try {
            out.end();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String d(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }

    private static double getX(Node n) {
        Object[] xyz;
        Object[] xy;
        if (n.hasNumber("x")) {
            return n.getNumber("x");
        }
        if (n.hasArray("xy") && (xy = n.getArray("xy")) != null && xy.length > 0 && xy[0] instanceof Number) {
            return ((Number)xy[0]).doubleValue();
        }
        if (n.hasArray("xyz") && (xyz = n.getArray("xyz")) != null && xyz.length > 0 && xyz[0] instanceof Number) {
            return ((Number)xyz[0]).doubleValue();
        }
        System.err.printf("[WARNING] no x attribute for node \"%s\" %s\n", n.getId(), n.hasAttribute("xyz"));
        return Math.random();
    }

    private static double getY(Node n) {
        Object[] xyz;
        Object[] xy;
        if (n.hasNumber("y")) {
            return 1000.0 - n.getNumber("y");
        }
        if (n.hasArray("xy") && (xy = n.getArray("xy")) != null && xy.length > 1 && xy[1] instanceof Number) {
            return 1000.0 - ((Number)xy[1]).doubleValue();
        }
        if (n.hasArray("xyz") && (xyz = n.getArray("xyz")) != null && xyz.length > 1 && xyz[1] instanceof Number) {
            return 1000.0 - ((Number)xyz[1]).doubleValue();
        }
        return Math.random();
    }

    private static String getSize(Value v) {
        String u = v.units.name().toLowerCase();
        return String.format(Locale.ROOT, "%f%s", v.value, u);
    }

    private static String getSize(Values v, int index) {
        String u = v.units.name().toLowerCase();
        if (StyleConstants.Units.PERCENTS.equals((Object)v.units)) {
            u = "%";
        }
        return String.format(Locale.ROOT, "%f%s", v.get(index), u);
    }

    private static void concat(StringBuilder buffer, Object ... args) {
        if (args != null) {
            for (Object arg : args) {
                buffer.append(arg.toString());
            }
        }
    }

    private static String toHexColor(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
    }

    public void graphCleared(String sourceId, long timeId) {
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
    }

    public void stepBegins(String sourceId, long timeId, double step) {
    }

    private static class XMLWriter {
        XMLStreamWriter out;
        int depth;
        boolean closed;

        private XMLWriter() {
        }

        void start(Writer w) throws XMLStreamException, FactoryConfigurationError, IOException {
            if (this.out != null) {
                this.end();
            }
            this.out = XMLOutputFactory.newInstance().createXMLStreamWriter(w);
            this.out.writeStartDocument();
        }

        void end() throws XMLStreamException {
            this.out.writeEndDocument();
            this.out.flush();
            this.out.close();
            this.out = null;
        }

        void open(String name) throws XMLStreamException {
            this.out.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                this.out.writeCharacters("  ");
            }
            this.out.writeStartElement(name);
            ++this.depth;
        }

        void close() throws XMLStreamException {
            this.out.writeEndElement();
            --this.depth;
        }

        void attribute(String key, String value) throws XMLStreamException {
            this.out.writeAttribute(key, value);
        }

        void characters(String data) throws XMLStreamException {
            this.out.writeCharacters(data);
        }
    }

    static class SVGContext {
        StyleGroupSet groups;
        StyleSheet stylesheet = new StyleSheet();
        HashMap<StyleGroup, SVGStyle> svgStyles;
        ViewBox viewBox;

        public SVGContext() {
            this.groups = new StyleGroupSet(this.stylesheet);
            this.svgStyles = new HashMap();
            this.viewBox = new ViewBox(0.0, 0.0, 1000.0, 1000.0);
        }

        public void init(XMLWriter out, Graph g) throws IOException, XMLStreamException {
            block6: {
                if (g.hasAttribute("ui.stylesheet")) {
                    this.stylesheet.load((String)g.getAttribute("ui.stylesheet"));
                }
                this.groups.addElement((Element)g);
                this.viewBox.compute(g, this.groups.getStyleFor(g));
                out.open("svg");
                out.attribute("xmlns", "http://www.w3.org/2000/svg");
                out.attribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
                out.attribute("xmlns:cc", "http://creativecommons.org/ns#");
                out.attribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                out.attribute("xmlns:svg", "http://www.w3.org/2000/svg");
                out.attribute("viewBox", String.format(Locale.ROOT, "%f %f %f %f", this.viewBox.x1, this.viewBox.y1, this.viewBox.x2, this.viewBox.y2));
                out.attribute("id", g.getId());
                out.attribute("version", "1.1");
                try {
                    g.edges().forEach(e -> {
                        this.groups.addElement((Element)e);
                        if (e.hasAttribute("ui.style")) {
                            try {
                                this.stylesheet.parseStyleFromString(new Selector(Selector.Type.EDGE, e.getId(), null), (String)e.getAttribute("ui.style"));
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        this.groups.checkElementStyleGroup((Element)e);
                    });
                    g.nodes().forEach(n -> {
                        this.groups.addElement((Element)n);
                        if (n.hasAttribute("ui.style")) {
                            try {
                                this.stylesheet.parseStyleFromString(new Selector(Selector.Type.NODE, n.getId(), null), (String)n.getAttribute("ui.style"));
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        this.groups.checkElementStyleGroup((Element)n);
                    });
                }
                catch (RuntimeException e2) {
                    if (e2.getCause() instanceof IOException) {
                        throw (IOException)e2.getCause();
                    }
                    if (!(e2.getCause() instanceof XMLStreamException)) break block6;
                    throw (IOException)e2.getCause();
                }
            }
            for (StyleGroup group : this.groups.groups()) {
                this.svgStyles.put(group, new SVGStyle(group));
            }
            out.open("defs");
            for (SVGStyle svgStyle : this.svgStyles.values()) {
                svgStyle.writeDef(out);
            }
            out.close();
        }

        public void end(XMLWriter out) throws XMLStreamException {
            out.close();
        }

        public void writeElements(XMLWriter out, Graph g) throws XMLStreamException {
            out.open("g");
            out.attribute("id", "graph-misc");
            this.writeElement(out, (Element)g);
            out.close();
            Iterator it = this.groups.getZIterator();
            out.open("g");
            out.attribute("id", "elements");
            while (it.hasNext()) {
                HashSet set = (HashSet)it.next();
                for (StyleGroup sg : set) {
                    for (Element e : sg.elements()) {
                        this.writeElement(out, e);
                    }
                }
            }
            out.close();
        }

        public void writeElement(XMLWriter out, Element e) throws XMLStreamException {
            String id = "";
            SVGStyle style = null;
            String transform = null;
            if (e instanceof Edge) {
                id = String.format("egde-%s", e.getId());
                style = this.svgStyles.get(this.groups.getStyleFor((Edge)e));
            } else if (e instanceof Node) {
                id = String.format("node-%s", e.getId());
                style = this.svgStyles.get(this.groups.getStyleFor((Node)e));
                transform = String.format(Locale.ROOT, "translate(%f,%f)", this.viewBox.convertX((Node)e), this.viewBox.convertY((Node)e));
            } else if (e instanceof Graph) {
                id = "graph-background";
                style = this.svgStyles.get(this.groups.getStyleFor((Graph)e));
            }
            out.open("g");
            out.attribute("id", id);
            out.open("path");
            if (style != null) {
                out.attribute("style", style.getElementStyle(e));
            }
            if (transform != null) {
                out.attribute("transform", transform);
            }
            out.attribute("d", this.getPath(e, style));
            out.close();
            if (e.hasLabel("label")) {
                this.writeElementText(out, (String)e.getAttribute("label"), e, style.group);
            }
            out.close();
        }

        public void writeElementText(XMLWriter out, String text, Element e, StyleGroup style) throws XMLStreamException {
            if (style == null || style.getTextVisibilityMode() != StyleConstants.TextVisibilityMode.HIDDEN) {
                double x = 0.0;
                double y = 0.0;
                if (e instanceof Node) {
                    x = this.viewBox.convertX((Node)e);
                    y = this.viewBox.convertY((Node)e);
                } else if (e instanceof Edge) {
                    Node n0 = ((Edge)e).getNode0();
                    Node n1 = ((Edge)e).getNode0();
                    x = this.viewBox.convertX((AncestrisFileSinkSvg.getX(n0) + AncestrisFileSinkSvg.getX(n1)) / 2.0);
                    y = this.viewBox.convertY((AncestrisFileSinkSvg.getY(n0) + AncestrisFileSinkSvg.getY(n1)) / 2.0);
                }
                out.open("g");
                out.open("text");
                out.attribute("x", AncestrisFileSinkSvg.d(x));
                out.attribute("y", AncestrisFileSinkSvg.d(y));
                if (style != null) {
                    if (style.getTextColorCount() > 0) {
                        out.attribute("fill", AncestrisFileSinkSvg.toHexColor(style.getTextColor(0)));
                    }
                    switch (style.getTextAlignment()) {
                        case CENTER: {
                            out.attribute("text-anchor", "middle");
                            out.attribute("alignment-baseline", "central");
                            break;
                        }
                        case LEFT: {
                            out.attribute("text-anchor", "start");
                            break;
                        }
                        case RIGHT: {
                            out.attribute("text-anchor", "end");
                            break;
                        }
                    }
                    switch (style.getTextSize().units) {
                        case PX: 
                        case GU: {
                            out.attribute("font-size", AncestrisFileSinkSvg.d(style.getTextSize().value));
                            break;
                        }
                        case PERCENTS: {
                            out.attribute("font-size", AncestrisFileSinkSvg.d(style.getTextSize().value) + "%");
                        }
                    }
                    if (style.getTextFont() != null) {
                        out.attribute("font-family", style.getTextFont());
                    }
                    switch (style.getTextStyle()) {
                        case NORMAL: {
                            break;
                        }
                        case ITALIC: {
                            out.attribute("font-style", "italic");
                            break;
                        }
                        case BOLD: {
                            out.attribute("font-weight", "bold");
                            break;
                        }
                        case BOLD_ITALIC: {
                            out.attribute("font-weight", "bold");
                            out.attribute("font-style", "italic");
                        }
                    }
                }
                out.characters(text);
                out.close();
                out.close();
            }
        }

        public String getPath(Element e, SVGStyle style) {
            StringBuilder buffer = new StringBuilder();
            if (e instanceof Node) {
                Values size = style.group.getSize();
                double sx = this.getValue(size.get(0), size.units, true);
                double sy = size.getValueCount() > 1 ? this.getValue(size.get(1), size.units, false) : this.getValue(size.get(0), size.units, false);
                switch (style.group.getShape()) {
                    case ROUNDED_BOX: {
                        double rx = Math.min(5.0, sx / 2.0);
                        double ry = Math.min(5.0, sy / 2.0);
                        AncestrisFileSinkSvg.concat(buffer, " m ", AncestrisFileSinkSvg.d(-sx / 2.0 + rx), " ", AncestrisFileSinkSvg.d(-sy / 2.0));
                        AncestrisFileSinkSvg.concat(buffer, " h ", AncestrisFileSinkSvg.d(sx - 2.0 * rx));
                        AncestrisFileSinkSvg.concat(buffer, " a ", AncestrisFileSinkSvg.d(rx), ",", AncestrisFileSinkSvg.d(ry), " 0 0 1 ", AncestrisFileSinkSvg.d(rx), ",", AncestrisFileSinkSvg.d(ry));
                        AncestrisFileSinkSvg.concat(buffer, " v ", AncestrisFileSinkSvg.d(sy - 2.0 * ry));
                        AncestrisFileSinkSvg.concat(buffer, " a ", AncestrisFileSinkSvg.d(rx), ",", AncestrisFileSinkSvg.d(ry), " 0 0 1 -", AncestrisFileSinkSvg.d(rx), ",", AncestrisFileSinkSvg.d(ry));
                        AncestrisFileSinkSvg.concat(buffer, " h ", AncestrisFileSinkSvg.d(-sx + 2.0 * rx));
                        AncestrisFileSinkSvg.concat(buffer, " a ", AncestrisFileSinkSvg.d(rx), ",", AncestrisFileSinkSvg.d(ry), " 0 0 1 -", AncestrisFileSinkSvg.d(rx), ",-", AncestrisFileSinkSvg.d(ry));
                        AncestrisFileSinkSvg.concat(buffer, " v ", AncestrisFileSinkSvg.d(-sy + 2.0 * ry));
                        AncestrisFileSinkSvg.concat(buffer, " a ", AncestrisFileSinkSvg.d(rx), ",", AncestrisFileSinkSvg.d(ry), " 0 0 1 ", AncestrisFileSinkSvg.d(rx), "-", AncestrisFileSinkSvg.d(ry));
                        AncestrisFileSinkSvg.concat(buffer, " z");
                        break;
                    }
                    case BOX: {
                        AncestrisFileSinkSvg.concat(buffer, " m ", AncestrisFileSinkSvg.d(-sx / 2.0), " ", AncestrisFileSinkSvg.d(-sy / 2.0));
                        AncestrisFileSinkSvg.concat(buffer, " h ", AncestrisFileSinkSvg.d(sx));
                        AncestrisFileSinkSvg.concat(buffer, " v ", AncestrisFileSinkSvg.d(sy));
                        AncestrisFileSinkSvg.concat(buffer, " h ", AncestrisFileSinkSvg.d(-sx));
                        AncestrisFileSinkSvg.concat(buffer, " z");
                        break;
                    }
                    case DIAMOND: {
                        AncestrisFileSinkSvg.concat(buffer, " m ", AncestrisFileSinkSvg.d(-sx / 2.0), " 0");
                        AncestrisFileSinkSvg.concat(buffer, " l ", AncestrisFileSinkSvg.d(sx / 2.0), " ", AncestrisFileSinkSvg.d(-sy / 2.0));
                        AncestrisFileSinkSvg.concat(buffer, " l ", AncestrisFileSinkSvg.d(sx / 2.0), " ", AncestrisFileSinkSvg.d(sy / 2.0));
                        AncestrisFileSinkSvg.concat(buffer, " l ", AncestrisFileSinkSvg.d(-sx / 2.0), " ", AncestrisFileSinkSvg.d(sy / 2.0));
                        AncestrisFileSinkSvg.concat(buffer, " z");
                        break;
                    }
                    case TRIANGLE: {
                        AncestrisFileSinkSvg.concat(buffer, " m ", AncestrisFileSinkSvg.d(0.0), " ", AncestrisFileSinkSvg.d(-sy / 2.0));
                        AncestrisFileSinkSvg.concat(buffer, " l ", AncestrisFileSinkSvg.d(sx / 2.0), " ", AncestrisFileSinkSvg.d(sy));
                        AncestrisFileSinkSvg.concat(buffer, " h ", AncestrisFileSinkSvg.d(-sx));
                        AncestrisFileSinkSvg.concat(buffer, " z");
                        break;
                    }
                    default: {
                        AncestrisFileSinkSvg.concat(buffer, " m ", AncestrisFileSinkSvg.d(-sx / 2.0), " 0");
                        AncestrisFileSinkSvg.concat(buffer, " a ", AncestrisFileSinkSvg.d(sx / 2.0), ",", AncestrisFileSinkSvg.d(sy / 2.0), " 0 1 0 ", AncestrisFileSinkSvg.d(sx), ",0");
                        AncestrisFileSinkSvg.concat(buffer, " ", AncestrisFileSinkSvg.d(sx / 2.0), ",", AncestrisFileSinkSvg.d(sy / 2.0), " 0 1 0 -", AncestrisFileSinkSvg.d(sx), ",0");
                        AncestrisFileSinkSvg.concat(buffer, " z");
                        break;
                    }
                }
            } else if (e instanceof Graph) {
                AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(this.viewBox.x1), " ", AncestrisFileSinkSvg.d(this.viewBox.y1));
                AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(this.viewBox.x2), " ", AncestrisFileSinkSvg.d(this.viewBox.y1));
                AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(this.viewBox.x2), " ", AncestrisFileSinkSvg.d(this.viewBox.y2));
                AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(this.viewBox.x1), " ", AncestrisFileSinkSvg.d(this.viewBox.y2));
                AncestrisFileSinkSvg.concat(buffer, " Z");
            } else if (e instanceof Edge) {
                double[] perpen;
                double nodeSize;
                double sizeEdge = this.getValue(style.group.getSize().get(0), style.group.getSize().units, true);
                Values sizeArrow = style.group.getArrowSize();
                double sx = this.getValue(sizeArrow.get(0), sizeArrow.units, true);
                double sy = sizeArrow.getValueCount() > 1 ? this.getValue(sizeArrow.get(1), sizeArrow.units, false) : this.getValue(sizeArrow.get(0), sizeArrow.units, false);
                Edge edge = (Edge)e;
                Node src = edge.getSourceNode();
                Node trg = edge.getTargetNode();
                double x1 = this.viewBox.convertX(src);
                double y1 = this.viewBox.convertY(src);
                double x2 = this.viewBox.convertX(trg);
                double y2 = this.viewBox.convertY(trg);
                switch (style.group.getShape()) {
                    case ANGLE: {
                        double[] perpendicular = this.getPerpendicular(x1, y1, x2, y2, sizeEdge);
                        double x1Prim = perpendicular[0];
                        double y1Prim = perpendicular[1];
                        double x2Prim = perpendicular[2];
                        double y2Prim = perpendicular[3];
                        AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(x1), " ", AncestrisFileSinkSvg.d(y1));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x1Prim), " ", AncestrisFileSinkSvg.d(y1Prim));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2Prim), " ", AncestrisFileSinkSvg.d(y2Prim));
                        AncestrisFileSinkSvg.concat(buffer, " Z");
                        break;
                    }
                    case CUBIC_CURVE: {
                        nodeSize = this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(0);
                        if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().getValueCount() > 1) {
                            nodeSize = Math.max(nodeSize, this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1));
                        }
                        double xCenter = (x1 + x2) / 2.0;
                        double yCenter = (y1 + y2) / 2.0;
                        perpen = this.getPerpendicular(x1, y1, xCenter, yCenter, Math.sqrt(Math.pow(Math.abs(x1 - xCenter), 2.0) + Math.pow(Math.abs(y1 - yCenter), 2.0)) * 2.0);
                        double x45degrees = (x1 + perpen[2]) / 2.0;
                        double y45degrees = (y1 + perpen[3]) / 2.0;
                        double xCenterCenter = (x1 + xCenter) / 2.0;
                        double yCenterCenter = (y1 + yCenter) / 2.0;
                        double x20degrees = (xCenterCenter + x45degrees) / 2.0;
                        double y20degrees = (yCenterCenter + y45degrees) / 2.0;
                        AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(x1), " ", AncestrisFileSinkSvg.d(y1));
                        AncestrisFileSinkSvg.concat(buffer, " C ", AncestrisFileSinkSvg.d(x20degrees), " ", AncestrisFileSinkSvg.d(y20degrees), " ", AncestrisFileSinkSvg.d(x20degrees), " ", AncestrisFileSinkSvg.d(y20degrees), " ", AncestrisFileSinkSvg.d(xCenter), " ", AncestrisFileSinkSvg.d(yCenter));
                        double x45degrees2nd = (x2 + perpen[0]) / 2.0;
                        double y45degrees2nd = (y2 + perpen[1]) / 2.0;
                        double xCenterCenter2nd = (x2 + xCenter) / 2.0;
                        double yCenterCenter2nd = (y2 + yCenter) / 2.0;
                        double x20degrees2nd = (xCenterCenter2nd + x45degrees2nd) / 2.0;
                        double y20degrees2nd = (yCenterCenter2nd + y45degrees2nd) / 2.0;
                        AncestrisFileSinkSvg.concat(buffer, " S ", AncestrisFileSinkSvg.d(x20degrees2nd), " ", AncestrisFileSinkSvg.d(y20degrees2nd), " ", AncestrisFileSinkSvg.d(x2), " ", AncestrisFileSinkSvg.d(y2));
                        AncestrisFileSinkSvg.concat(buffer, " C ", AncestrisFileSinkSvg.d(x20degrees2nd), " ", AncestrisFileSinkSvg.d(y20degrees2nd), " ", AncestrisFileSinkSvg.d(x20degrees2nd), " ", AncestrisFileSinkSvg.d(y20degrees2nd), " ", AncestrisFileSinkSvg.d(xCenter), " ", AncestrisFileSinkSvg.d(yCenter));
                        AncestrisFileSinkSvg.concat(buffer, " S ", AncestrisFileSinkSvg.d(x20degrees), " ", AncestrisFileSinkSvg.d(y20degrees), " ", AncestrisFileSinkSvg.d(x1), " ", AncestrisFileSinkSvg.d(y1));
                        AncestrisFileSinkSvg.concat(buffer, " Z");
                        break;
                    }
                    case BLOB: {
                        nodeSize = this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(0);
                        if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().getValueCount() > 1) {
                            nodeSize = Math.max(nodeSize, this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1));
                        }
                        double xCenter = (x1 + x2) / 2.0;
                        double yCenter = (y1 + y2) / 2.0;
                        double xCenterCenter = (x1 + xCenter) / 2.0;
                        double yCenterCenter = (y1 + yCenter) / 2.0;
                        double[] perpenCenter = this.getPerpendicular(x1, y1, xCenter, yCenter, sizeEdge);
                        double[] perpenX1 = this.getPerpendicular(xCenter, yCenter, x1, y1, nodeSize);
                        double[] perpenXCenter1 = this.getPerpendicular(x1, y1, xCenterCenter, yCenterCenter, sizeEdge);
                        AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(perpenX1[0]), " ", AncestrisFileSinkSvg.d(perpenX1[1]));
                        AncestrisFileSinkSvg.concat(buffer, " Q ", AncestrisFileSinkSvg.d(perpenXCenter1[0]), " ", AncestrisFileSinkSvg.d(perpenXCenter1[1]), " ", AncestrisFileSinkSvg.d(perpenCenter[0]), " ", AncestrisFileSinkSvg.d(perpenCenter[1]));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2), " ", AncestrisFileSinkSvg.d(y2));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(perpenCenter[2]), " ", AncestrisFileSinkSvg.d(perpenCenter[3]));
                        AncestrisFileSinkSvg.concat(buffer, " Q ", AncestrisFileSinkSvg.d(perpenXCenter1[2]), " ", AncestrisFileSinkSvg.d(perpenXCenter1[3]), " ", AncestrisFileSinkSvg.d(perpenX1[2]), " ", AncestrisFileSinkSvg.d(perpenX1[3]));
                        AncestrisFileSinkSvg.concat(buffer, " Z");
                        if (edge.isDirected()) break;
                        double[] perpenX2 = this.getPerpendicular(xCenter, yCenter, x2, y2, nodeSize);
                        double xCenterCenter2nd = (x2 + xCenter) / 2.0;
                        double yCenterCenter2nd = (y2 + yCenter) / 2.0;
                        double[] perpenXCenter2 = this.getPerpendicular(x2, y2, xCenterCenter2nd, yCenterCenter2nd, sizeEdge);
                        AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(perpenX2[0]), " ", AncestrisFileSinkSvg.d(perpenX2[1]));
                        AncestrisFileSinkSvg.concat(buffer, " Q ", AncestrisFileSinkSvg.d(perpenXCenter2[0]), " ", AncestrisFileSinkSvg.d(perpenXCenter2[1]), " ", AncestrisFileSinkSvg.d(perpenCenter[0]), " ", AncestrisFileSinkSvg.d(perpenCenter[1]));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x1), " ", AncestrisFileSinkSvg.d(y1));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(perpenCenter[2]), " ", AncestrisFileSinkSvg.d(perpenCenter[3]));
                        AncestrisFileSinkSvg.concat(buffer, " Q ", AncestrisFileSinkSvg.d(perpenXCenter2[2]), " ", AncestrisFileSinkSvg.d(perpenXCenter2[3]), " ", AncestrisFileSinkSvg.d(perpenX2[2]), " ", AncestrisFileSinkSvg.d(perpenX2[3]));
                        AncestrisFileSinkSvg.concat(buffer, " Z");
                        break;
                    }
                    default: {
                        AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(x1), " ", AncestrisFileSinkSvg.d(y1));
                        AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2), " ", AncestrisFileSinkSvg.d(y2));
                    }
                }
                if (edge.isDirected()) {
                    nodeSize = this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(0);
                    double diag = -1.0;
                    if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().getValueCount() > 1) {
                        diag = Math.sqrt(Math.pow(nodeSize, 2.0) + Math.pow(this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1), 2.0));
                        nodeSize = Math.min(nodeSize, this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1));
                    } else {
                        diag = Math.sqrt(Math.pow(nodeSize, 2.0) + Math.pow(nodeSize, 2.0));
                    }
                    if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.CIRCLE)) {
                        nodeSize /= 2.0;
                    } else if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.BOX) || this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.ROUNDED_BOX) || this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.DIAMOND) || this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.TRIANGLE)) {
                        nodeSize = diag / 2.0;
                    }
                    double distance = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    switch (style.group.getArrowShape()) {
                        case CIRCLE: {
                            double ratioPoint = 1.0 - nodeSize / distance;
                            double ratioLine = 1.0 - (sx / 2.0 + nodeSize) / distance;
                            double x2Root = (1.0 - ratioLine) * x1 + ratioLine * x2;
                            double y2Root = (1.0 - ratioLine) * y1 + ratioLine * y2;
                            double x2Point = (1.0 - ratioPoint) * x1 + ratioPoint * x2;
                            double y2Point = (1.0 - ratioPoint) * y1 + ratioPoint * y2;
                            perpen = this.getPerpendicular(x2, y2, x2Root, y2Root, sy);
                            double x1Prim = perpen[0];
                            double y1Prim = perpen[1];
                            double x2Prim = perpen[2];
                            double y2Prim = perpen[3];
                            AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(x1Prim), " ", AncestrisFileSinkSvg.d(y1Prim));
                            AncestrisFileSinkSvg.concat(buffer, " A ", AncestrisFileSinkSvg.d(sx / 4.0), " ", AncestrisFileSinkSvg.d(sy / 4.0), " 0 1 0 ", AncestrisFileSinkSvg.d(x2Prim), " ", AncestrisFileSinkSvg.d(y2Prim));
                            AncestrisFileSinkSvg.concat(buffer, " ", AncestrisFileSinkSvg.d(sx / 4.0), " ", AncestrisFileSinkSvg.d(sy / 4.0), " 0 1 0 ", AncestrisFileSinkSvg.d(x1Prim), " ", AncestrisFileSinkSvg.d(y1Prim));
                            AncestrisFileSinkSvg.concat(buffer, " Z");
                            break;
                        }
                        case DIAMOND: {
                            double ratioPoint = 1.0 - nodeSize / distance;
                            double ratioLine = 1.0 - (sx / 2.0 + nodeSize) / distance;
                            double x2Root = (1.0 - ratioLine) * x1 + ratioLine * x2;
                            double y2Root = (1.0 - ratioLine) * y1 + ratioLine * y2;
                            double x2Point = (1.0 - ratioPoint) * x1 + ratioPoint * x2;
                            double y2Point = (1.0 - ratioPoint) * y1 + ratioPoint * y2;
                            System.out.println(nodeSize + " " + sx);
                            double ratioEnd = 1.0 - (sx + nodeSize) / distance;
                            double x2End = (1.0 - ratioEnd) * x1 + ratioEnd * x2;
                            double y2End = (1.0 - ratioEnd) * y1 + ratioEnd * y2;
                            perpen = this.getPerpendicular(x2, y2, x2Root, y2Root, sy);
                            double x1Prim = perpen[0];
                            double y1Prim = perpen[1];
                            double x2Prim = perpen[2];
                            double y2Prim = perpen[3];
                            AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(x2Point), " ", AncestrisFileSinkSvg.d(y2Point));
                            AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x1Prim), " ", AncestrisFileSinkSvg.d(y1Prim));
                            AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2End), " ", AncestrisFileSinkSvg.d(y2End));
                            AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2Prim), " ", AncestrisFileSinkSvg.d(y2Prim));
                            AncestrisFileSinkSvg.concat(buffer, " Z");
                            break;
                        }
                        default: {
                            double ratioPoint = 1.0 - nodeSize / distance;
                            double ratioLine = 1.0 - (sx + nodeSize) / distance;
                            double x2Root = (1.0 - ratioLine) * x1 + ratioLine * x2;
                            double y2Root = (1.0 - ratioLine) * y1 + ratioLine * y2;
                            double x2Point = (1.0 - ratioPoint) * x1 + ratioPoint * x2;
                            double y2Point = (1.0 - ratioPoint) * y1 + ratioPoint * y2;
                            perpen = this.getPerpendicular(x2, y2, x2Root, y2Root, sy);
                            double x1Prim = perpen[0];
                            double y1Prim = perpen[1];
                            double x2Prim = perpen[2];
                            double y2Prim = perpen[3];
                            if (style.group.getShape().equals((Object)StyleConstants.Shape.CUBIC_CURVE)) {
                                double rotation = 25.0;
                                System.out.println(y2Point - y2);
                                if (y2Point - y2 <= 1.0) {
                                    rotation = -rotation;
                                }
                                Vector2 v = SVGContext.rotatePoint(x2, y2, rotation, x2Point, y2Point);
                                x2Point = v.x();
                                y2Point = v.y();
                                v = SVGContext.rotatePoint(x2, y2, rotation, x1Prim, y1Prim);
                                x1Prim = v.x();
                                y1Prim = v.y();
                                v = SVGContext.rotatePoint(x2, y2, rotation, x2Prim, y2Prim);
                                x2Prim = v.x();
                                y2Prim = v.y();
                            }
                            AncestrisFileSinkSvg.concat(buffer, " M ", AncestrisFileSinkSvg.d(x1Prim), " ", AncestrisFileSinkSvg.d(y1Prim));
                            AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2Prim), " ", AncestrisFileSinkSvg.d(y2Prim));
                            AncestrisFileSinkSvg.concat(buffer, " L ", AncestrisFileSinkSvg.d(x2Point), " ", AncestrisFileSinkSvg.d(y2Point));
                            AncestrisFileSinkSvg.concat(buffer, " Z");
                            System.out.println("Arrow = (" + x1Prim + ", " + y1Prim + ") (" + x1Prim + ", " + y2Prim + ") (" + x2Point + ", " + y2Point + ")");
                        }
                    }
                }
            }
            return buffer.toString();
        }

        public static Vector2 rotatePoint(double cx, double cy, double angle, double px, double py) {
            double ynew;
            double xnew;
            double absangl = Math.abs(angle);
            double s = Math.sin(Math.toRadians(absangl));
            double c = Math.cos(Math.toRadians(absangl));
            px -= cx;
            py -= cy;
            if (angle > 0.0) {
                xnew = px * c - py * s;
                ynew = px * s + py * c;
            } else {
                xnew = px * c + py * s;
                ynew = -px * s + py * c;
            }
            px = xnew + cx;
            py = ynew + cy;
            return new Vector2(px, py);
        }

        public double[] getPerpendicular(double x1, double y1, double x2, double y2, double size) {
            double y2Prim;
            double x2Prim;
            double y1Prim;
            double x1Prim;
            double slope = (y2 - y1) / (x2 - x1);
            if (Double.isInfinite(slope)) {
                x1Prim = x2 - size / 2.0;
                y1Prim = y2;
                x2Prim = x2 + size / 2.0;
                y2Prim = y2;
            } else if (slope == 0.0) {
                x1Prim = x2;
                y1Prim = y2 - size / 2.0;
                x2Prim = x2;
                y2Prim = y2 + size / 2.0;
            } else {
                double slopePerpen = -1.0 / slope;
                double deltaX = 1.0 / Math.sqrt(slopePerpen * slopePerpen + 1.0);
                double deltaY = slopePerpen / Math.sqrt(slopePerpen * slopePerpen + 1.0);
                x1Prim = x2 - size / 2.0 * deltaX;
                y1Prim = y2 - size / 2.0 * deltaY;
                x2Prim = x2 + size / 2.0 * deltaX;
                y2Prim = y2 + size / 2.0 * deltaY;
            }
            return new double[]{x1Prim, y1Prim, x2Prim, y2Prim};
        }

        public double getValue(Value v, boolean horizontal) {
            return this.getValue(v.value, v.units, horizontal);
        }

        public double getValue(double d, StyleConstants.Units units, boolean horizontal) {
            switch (units) {
                case PX: {
                    return d;
                }
                case GU: {
                    return d;
                }
                case PERCENTS: {
                    if (horizontal) {
                        return (this.viewBox.x2 - this.viewBox.x1) * d / 100.0;
                    }
                    return (this.viewBox.y2 - this.viewBox.y1) * d / 100.0;
                }
            }
            return d;
        }
    }

    private static class SVGStyle {
        static int gradientId = 0;
        String style;
        StyleGroup group;
        boolean gradient;
        boolean dynfill;

        public SVGStyle(StyleGroup group) throws XMLStreamException {
            this.group = group;
            this.gradient = false;
            this.dynfill = false;
            switch (group.getType()) {
                case EDGE: {
                    this.buildEdgeStyle();
                    break;
                }
                case NODE: {
                    this.buildNodeStyle();
                    break;
                }
                case GRAPH: {
                    this.buildGraphStyle();
                    break;
                }
            }
        }

        final void buildNodeStyle() {
            StringBuilder styleSB = new StringBuilder();
            switch (this.group.getFillMode()) {
                case GRADIENT_RADIAL: 
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    AncestrisFileSinkSvg.concat(styleSB, "fill:url(#%gradient-id%);");
                    this.gradient = true;
                    break;
                }
                case PLAIN: {
                    AncestrisFileSinkSvg.concat(styleSB, "fill:", AncestrisFileSinkSvg.toHexColor(this.group.getFillColor(0)), ";");
                    AncestrisFileSinkSvg.concat(styleSB, "fill-opacity:", AncestrisFileSinkSvg.d((double)this.group.getFillColor(0).getAlpha() / 255.0), ";");
                    break;
                }
                case DYN_PLAIN: {
                    this.dynfill = true;
                    AncestrisFileSinkSvg.concat(styleSB, "fill:%fill-color%;");
                    AncestrisFileSinkSvg.concat(styleSB, "fill-opacity:%fill-opacity%;");
                    break;
                }
            }
            AncestrisFileSinkSvg.concat(styleSB, "fill-rule:nonzero;");
            if (this.group.getStrokeMode() != StyleConstants.StrokeMode.NONE) {
                AncestrisFileSinkSvg.concat(styleSB, "stroke:", AncestrisFileSinkSvg.toHexColor(this.group.getStrokeColor(0)), ";");
                AncestrisFileSinkSvg.concat(styleSB, "stroke-width:", AncestrisFileSinkSvg.getSize(this.group.getStrokeWidth()), ";");
            }
            this.style = styleSB.toString();
        }

        final void buildGraphStyle() {
            this.buildNodeStyle();
        }

        final void buildEdgeStyle() {
            StringBuilder styleSB = new StringBuilder();
            switch (this.group.getFillMode()) {
                case GRADIENT_RADIAL: 
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    AncestrisFileSinkSvg.concat(styleSB, "stroke:url(#%gradient-id%);");
                    this.gradient = true;
                    break;
                }
                case PLAIN: {
                    AncestrisFileSinkSvg.concat(styleSB, "fill:", AncestrisFileSinkSvg.toHexColor(this.group.getFillColor(0)), ";");
                    AncestrisFileSinkSvg.concat(styleSB, "fill-opacity:", AncestrisFileSinkSvg.d((double)this.group.getFillColor(0).getAlpha() / 255.0), ";");
                    AncestrisFileSinkSvg.concat(styleSB, "stroke:", AncestrisFileSinkSvg.toHexColor(this.group.getFillColor(0)), ";");
                    break;
                }
                case DYN_PLAIN: {
                    AncestrisFileSinkSvg.concat(styleSB, "stroke:", AncestrisFileSinkSvg.toHexColor(this.group.getFillColor(0)), ";");
                    break;
                }
            }
            if (!this.group.getShape().equals((Object)StyleConstants.Shape.ANGLE) && !this.group.getShape().equals((Object)StyleConstants.Shape.BLOB)) {
                AncestrisFileSinkSvg.concat(styleSB, "stroke-width:", AncestrisFileSinkSvg.getSize(this.group.getSize(), 0), ";");
            }
            this.style = styleSB.toString();
        }

        public void writeDef(XMLWriter out) throws XMLStreamException {
            if (this.gradient) {
                String gid = String.format("gradient%x", gradientId++);
                String type = "linearGradient";
                String x1 = null;
                String x2 = null;
                String y1 = null;
                String y2 = null;
                switch (this.group.getFillMode()) {
                    case GRADIENT_RADIAL: {
                        type = "radialGradient";
                        break;
                    }
                    case GRADIENT_HORIZONTAL: {
                        x1 = "0%";
                        y1 = "50%";
                        x2 = "100%";
                        y2 = "50%";
                        break;
                    }
                    case GRADIENT_VERTICAL: {
                        x1 = "50%";
                        y1 = "0%";
                        x2 = "50%";
                        y2 = "100%";
                        break;
                    }
                    case GRADIENT_DIAGONAL1: {
                        x1 = "0%";
                        y1 = "0%";
                        x2 = "100%";
                        y2 = "100%";
                        break;
                    }
                    case GRADIENT_DIAGONAL2: {
                        x1 = "100%";
                        y1 = "100%";
                        x2 = "0%";
                        y2 = "0%";
                        break;
                    }
                }
                out.open(type);
                out.attribute("id", gid);
                out.attribute("gradientUnits", "objectBoundingBox");
                if (type.equals("linearGradient")) {
                    out.attribute("x1", x1);
                    out.attribute("y1", y1);
                    out.attribute("x2", x2);
                    out.attribute("y2", y2);
                }
                for (int i = 0; i < this.group.getFillColorCount(); ++i) {
                    out.open("stop");
                    out.attribute("stop-color", AncestrisFileSinkSvg.toHexColor(this.group.getFillColor(i)));
                    out.attribute("stop-opacity", AncestrisFileSinkSvg.d((double)this.group.getFillColor(i).getAlpha() / 255.0));
                    out.attribute("offset", Double.toString((double)i / (double)(this.group.getFillColorCount() - 1)));
                    out.close();
                }
                out.close();
                this.style = this.style.replace("%gradient-id%", gid);
            }
        }

        public String getElementStyle(Element e) {
            String st = this.style;
            if (this.dynfill && this.group.getFillColorCount() > 1) {
                double d = e.hasNumber("ui.color") ? e.getNumber("ui.color") : 0.0;
                Colors colors = this.group.getFillColors();
                int s = Math.min((int)(d * (double)this.group.getFillColorCount()), colors.size() - 2);
                double a = (double)s / (double)(colors.size() - 1);
                double b = (double)(s + 1) / (double)(colors.size() - 1);
                d = (d - a) / (b - a);
                Color c1 = (Color)colors.get(s);
                Color c2 = (Color)colors.get(s + 1);
                String color = String.format("#%02x%02x%02x", (int)((double)c1.getRed() + d * (double)(c2.getRed() - c1.getRed())), (int)((double)c1.getGreen() + d * (double)(c2.getGreen() - c1.getGreen())), (int)((double)c1.getBlue() + d * (double)(c2.getBlue() - c1.getBlue())));
                String opacity = Double.toString(((double)c1.getAlpha() + d * (double)(c2.getAlpha() - c1.getAlpha())) / 255.0);
                st = st.replace("%fill-color%", color);
                st = st.replace("%fill-opacity%", opacity);
            }
            return st;
        }
    }

    private static class ViewBox {
        double x1;
        double y1;
        double x2;
        double y2;
        double x3;
        double y3;
        double x4;
        double y4;
        double[] padding = new double[]{0.0, 0.0};

        ViewBox(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        void compute(Graph g, StyleGroup style) {
            this.y3 = Double.MAX_VALUE;
            this.x3 = Double.MAX_VALUE;
            this.y4 = Double.MIN_VALUE;
            this.x4 = Double.MIN_VALUE;
            g.nodes().forEach(n -> {
                this.x3 = Math.min(this.x3, AncestrisFileSinkSvg.getX(n));
                this.y3 = Math.min(this.y3, AncestrisFileSinkSvg.getY(n));
                this.x4 = Math.max(this.x4, AncestrisFileSinkSvg.getX(n));
                this.y4 = Math.max(this.y4, AncestrisFileSinkSvg.getY(n));
            });
            Values v = style.getPadding();
            if (v.getValueCount() > 0) {
                this.padding[0] = v.get(0);
                this.padding[1] = v.getValueCount() > 1 ? v.get(1) : v.get(0);
            }
        }

        double convertX(double x) {
            return (this.x2 - this.x1 - 2.0 * this.padding[0]) * (x - this.x3) / (this.x4 - this.x3) + this.x1 + this.padding[0];
        }

        double convertX(Node n) {
            return this.convertX(AncestrisFileSinkSvg.getX(n));
        }

        double convertY(double y) {
            return (this.y2 - this.y1 - 2.0 * this.padding[1]) * (y - this.y3) / (this.y4 - this.y3) + this.y1 + this.padding[1];
        }

        double convertY(Node n) {
            return this.convertY(AncestrisFileSinkSvg.getY(n));
        }
    }
}

