/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import genj.gedcom.Gedcom;
import genj.gedcom.PropertyFile;
import java.io.File;
import java.util.Map;
import org.openide.util.NbBundle;

public class MediaConverter {
    private Gedcom gedcom = null;
    private Map<PropertyFile, String> property2PathMap = null;
    private int nbOfMediaChanges = 0;
    private Exception error = null;

    public MediaConverter(Gedcom gedcom, Map<PropertyFile, String> property2PathMap) {
        this.gedcom = gedcom;
        this.property2PathMap = property2PathMap;
    }

    public boolean convert() {
        this.nbOfMediaChanges = 0;
        for (PropertyFile pFile : this.property2PathMap.keySet()) {
            String oldValue = pFile.getValue();
            File f = new File(oldValue);
            String name = f.getName();
            String newValue = this.property2PathMap.get(pFile) + name;
            if (newValue.equals(oldValue)) continue;
            pFile.setValueAsIs(newValue);
            ++this.nbOfMediaChanges;
        }
        return true;
    }

    public int getNbOfChangedMedia() {
        return this.nbOfMediaChanges;
    }

    public Exception getError() {
        if (this.error == null) {
            this.error = new Exception(NbBundle.getMessage(MediaConverter.class, (String)"ERR_Unknown"));
        }
        return this.error;
    }
}

