/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;

public class PropertyFamilySpouse
extends PropertyXRef {
    PropertyFamilySpouse() {
        super("FAMS");
    }

    PropertyFamilySpouse(String tag) {
        super(tag);
        this.assertTag("FAMS");
    }

    @Override
    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.fams.veto");
    }

    public Fam getFamily() {
        return (Fam)this.getTargetEntity();
    }

    @Override
    public void link() throws GedcomException {
        Indi indi;
        try {
            indi = (Indi)this.getEntity();
        }
        catch (ClassCastException ex) {
            throw new GedcomException(resources.getString("error.noenclosingindi"));
        }
        Fam fam = (Fam)this.getCandidate();
        Indi husband = fam.getHusband();
        Indi wife = fam.getWife();
        if (husband != null && wife != null) {
            throw new GedcomException(resources.getString("error.already.spouses", fam));
        }
        if (husband == indi || wife == indi) {
            throw new GedcomException(resources.getString("error.already.spouse", indi.toString(), fam.toString()));
        }
        Fam[] familiesWhereChild = indi.getFamiliesWhereChild();
        for (int i = 0; i < familiesWhereChild.length; ++i) {
            if (familiesWhereChild[i] != fam) continue;
            throw new GedcomException(resources.getString("error.already.child", indi.toString(), fam.toString()));
        }
        if (indi.isDescendantOf(fam)) {
            throw new GedcomException(resources.getString("error.already.descendant", indi.toString(), fam.toString()));
        }
        if (indi.getSex() == 0) {
            indi.setSex(husband == null ? 1 : 2);
        }
        Property[] husbands = fam.getProperties("HUSB", false);
        for (int i = 0; i < husbands.length; ++i) {
            PropertyHusband ph;
            if (!(husbands[i] instanceof PropertyHusband) || !(ph = (PropertyHusband)husbands[i]).isCandidate(indi)) continue;
            this.link(ph);
            return;
        }
        Property[] wifes = fam.getProperties("WIFE", false);
        for (int i = 0; i < wifes.length; ++i) {
            PropertyWife pw;
            if (!(wifes[i] instanceof PropertyWife) || !(pw = (PropertyWife)wifes[i]).isCandidate(indi)) continue;
            this.link(pw);
            return;
        }
        if (indi.getSex() == 1) {
            if (husband != null && husband.getSex() != 1) {
                fam.swapSpouses();
            }
            PropertyHusband backref = new PropertyHusband();
            fam.addProperty(backref);
            this.link(backref);
        } else {
            if (wife != null) {
                fam.swapSpouses();
            }
            PropertyWife backref = new PropertyWife();
            fam.addProperty(backref);
            this.link(backref);
        }
    }

    @Override
    public String getTargetType() {
        return "FAM";
    }
}

