/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.core.actions.SubMenuAction;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.util.swing.NestedBlockLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class CreateEntity
extends AbstractChange {
    private static final String ADD_ACTION_SUBMENU = "Ancestris/Actions/GedcomProperty/CreateOther";
    private String tag;
    private JTextField requestID;

    public CreateEntity(String tag) {
        this.setImageText(GedcomConstants.getEntityImage((String)tag).getOverLayed(imgNew), resources.getString("create." + tag.toLowerCase(), new Object[]{Gedcom.getName((String)tag, (boolean)false)}));
        this.tag = tag;
    }

    @Override
    protected JPanel getDialogContent() {
        JPanel result = new JPanel((LayoutManager)new NestedBlockLayout("<col><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
        this.requestID = new JTextField(this.getGedcom().getNextAvailableID(this.tag), 8);
        this.requestID.setEditable(false);
        final JCheckBox check = new JCheckBox(resources.getString("assign_id"));
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateEntity.this.requestID.setEditable(check.isSelected());
                if (check.isSelected()) {
                    CreateEntity.this.requestID.requestFocusInWindow();
                }
            }
        });
        result.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        result.add(this.getConfirmComponent());
        result.add(check);
        result.add(this.requestID);
        result.setPreferredSize(new Dimension(520, 220));
        return result;
    }

    @Override
    protected String getConfirmMessage() {
        String about = resources.getString("confirm.new", new Object[]{Gedcom.getName((String)this.tag, (boolean)false), this.getGedcom()});
        String detail = resources.getString("confirm.new.unrelated");
        return about + "<br><br>" + detail;
    }

    @Override
    protected Context execute(Gedcom gedcom, ActionEvent event) throws GedcomException {
        String id = null;
        if (this.requestID.isEditable() && gedcom.getEntity(this.tag, id = this.requestID.getText()) != null) {
            throw new GedcomException(resources.getString("assign_id_error", new Object[]{id}));
        }
        Entity entity = gedcom.createEntity(this.tag, id);
        entity.addDefaultProperties();
        return new Context(entity);
    }

    public static CreateEntity createIndiFactory() {
        return new CreateEntity("INDI");
    }

    public static CreateEntity createFamFactory() {
        return new CreateEntity("FAM");
    }

    public static CreateEntity createNoteFactory() {
        return new CreateEntity("NOTE");
    }

    public static CreateEntity createObjeFactory() {
        return new CreateEntity("OBJE");
    }

    public static CreateEntity createSourFactory() {
        return new CreateEntity("SOUR");
    }

    public static CreateEntity createRepoFactory() {
        return new CreateEntity("REPO");
    }

    public static CreateEntity createSubmFactory() {
        return new CreateEntity("SUBM");
    }

    public static SubMenuAction getCreateEntityMenu() {
        SubMenuAction menuAction = new SubMenuAction(NbBundle.getMessage(CreateEntity.class, (String)"create.entity"));
        menuAction.putValue("SmallIcon", (Object)Gedcom.getImage());
        menuAction.addAction((Action)((Object)CreateEntity.createIndiFactory()));
        menuAction.addAction((Action)((Object)CreateEntity.createFamFactory()));
        menuAction.addAction((Action)((Object)CreateEntity.createNoteFactory()));
        menuAction.addAction((Action)((Object)CreateEntity.createObjeFactory()));
        menuAction.addAction((Action)((Object)CreateEntity.createSourFactory()));
        menuAction.addAction((Action)((Object)CreateEntity.createRepoFactory()));
        menuAction.addAction((Action)((Object)CreateEntity.createSubmFactory()));
        return menuAction;
    }
}

