/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const { ConsoleMessage } =
  require("devtools/client/webconsole/types");

const stubPreparedMessages = new Map();
const stubPackets = new Map();
stubPreparedMessages.set(`console.log('foobar', 'test')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924471,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "foobar",
    "test"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foobar\",\"test\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log(undefined)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924479,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "undefined"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"undefined\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.warn('danger, will robinson!')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924487,
  "type": "warn",
  "helperType": null,
  "level": "warn",
  "category": null,
  "messageText": null,
  "parameters": [
    "danger, will robinson!"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":null,\"parameters\":[\"danger, will robinson!\"],\"source\":\"console-api\",\"type\":\"warn\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log(NaN)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924495,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "NaN"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"NaN\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log(null)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924501,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "null"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"null\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('鼬')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924506,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "鼬"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"鼬\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.clear()`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924512,
  "type": "clear",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "Console was cleared."
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Console was cleared.\"],\"source\":\"console-api\",\"type\":\"clear\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count('bar')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924515,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "bar: 1",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"bar: 1\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.assert(false, {message: 'foobar'})`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924521,
  "type": "assert",
  "helperType": null,
  "level": "error",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj30",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "message": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "foobar"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source33\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"error\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj30\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"message\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"foobar\"}},\"ownSymbols\":[],\"ownPropertiesLength\":1,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"assert\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":[{\"columnNumber\":35,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"triggerPacket\",\"lineNumber\":1,\"sourceId\":159}]}",
  "stacktrace": [
    {
      "columnNumber": 35,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 1,
      "sourceId": 159
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source33",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('hello \nfrom \rthe \"string world!')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924528,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "hello \nfrom \rthe \"string world!"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"hello \\nfrom \\rthe \\\"string world!\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('úṇĩçödê țĕșť')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924586,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "úṇĩçödê țĕșť"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"úṇĩçödê țĕșť\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.dirxml(window)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924596,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj31",
      "class": "Window",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 830,
      "preview": {
        "kind": "ObjectWithURL",
        "url": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html"
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj31\",\"class\":\"Window\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":830,\"preview\":{\"kind\":\"ObjectWithURL\",\"url\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\"}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('myarray', ['red', 'green', 'blue'])`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924604,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "myarray",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj32",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "red",
          "green",
          "blue"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myarray\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj32\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"red\",\"green\",\"blue\"]}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('myregex', /a.b.c/)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924610,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "myregex",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj33",
      "class": "RegExp",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "displayString": "/a.b.c/"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myregex\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj33\",\"class\":\"RegExp\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"displayString\":\"/a.b.c/\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.table(['red', 'green', 'blue']);`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924612,
  "type": "table",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj34",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "red",
          "green",
          "blue"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj34\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"red\",\"green\",\"blue\"]}}],\"source\":\"console-api\",\"type\":\"table\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924614,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "myobject",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj35",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 3,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "red": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "redValue"
          },
          "green": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "greenValue"
          },
          "blue": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "blueValue"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 3,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myobject\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj35\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":3,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"red\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"redValue\"},\"green\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"greenValue\"},\"blue\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"blueValue\"}},\"ownSymbols\":[],\"ownPropertiesLength\":3,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.debug('debug message');`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924621,
  "type": "debug",
  "helperType": null,
  "level": "debug",
  "category": null,
  "messageText": null,
  "parameters": [
    "debug message"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"debug\",\"messageText\":null,\"parameters\":[\"debug message\"],\"source\":\"console-api\",\"type\":\"debug\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.info('info message');`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924625,
  "type": "info",
  "helperType": null,
  "level": "info",
  "category": null,
  "messageText": null,
  "parameters": [
    "info message"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"info\",\"messageText\":null,\"parameters\":[\"info message\"],\"source\":\"console-api\",\"type\":\"info\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.error('error message');`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924628,
  "type": "error",
  "helperType": null,
  "level": "error",
  "category": null,
  "messageText": null,
  "parameters": [
    "error message"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source33\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"error\",\"messageText\":null,\"parameters\":[\"error message\"],\"source\":\"console-api\",\"type\":\"error\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":[{\"columnNumber\":35,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"triggerPacket\",\"lineNumber\":1,\"sourceId\":159}]}",
  "stacktrace": [
    {
      "columnNumber": 35,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 1,
      "sourceId": 159
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source33",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('mymap')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924631,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "mymap",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj36",
      "class": "Map",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 0,
      "preview": {
        "kind": "MapLike",
        "size": 2,
        "entries": [
          [
            "key1",
            "value1"
          ],
          [
            "key2",
            "value2"
          ]
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source50\",\"line\":5,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"mymap\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj36\",\"class\":\"Map\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":0,\"preview\":{\"kind\":\"MapLike\",\"size\":2,\"entries\":[[\"key1\",\"value1\"],[\"key2\",\"value2\"]]}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source50",
    "line": 5,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log('myset')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924746,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "myset",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj37",
      "class": "Set",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 0,
      "preview": {
        "kind": "ArrayLike",
        "length": 2,
        "items": [
          "a",
          "b"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myset\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj37\",\"class\":\"Set\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":0,\"preview\":{\"kind\":\"ArrayLike\",\"length\":2,\"items\":[\"a\",\"b\"]}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.trace()`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924752,
  "type": "trace",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source55\",\"line\":3,\"column\":11},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[],\"source\":\"console-api\",\"type\":\"trace\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":[{\"columnNumber\":11,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"testStacktraceFiltering\",\"lineNumber\":3,\"sourceId\":193},{\"columnNumber\":3,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"foo\",\"lineNumber\":6,\"sourceId\":193},{\"columnNumber\":1,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"triggerPacket\",\"lineNumber\":9,\"sourceId\":193}]}",
  "stacktrace": [
    {
      "columnNumber": 11,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "testStacktraceFiltering",
      "lineNumber": 3,
      "sourceId": 193
    },
    {
      "columnNumber": 3,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "foo",
      "lineNumber": 6,
      "sourceId": 193
    },
    {
      "columnNumber": 1,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 9,
      "sourceId": 193
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source55",
    "line": 3,
    "column": 11
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.trace('bar', {'foo': 'bar'}, [1,2,3])`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1538037986659,
  "type": "trace",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "bar",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj35",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "foo": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "bar"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    },
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj36",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          1,
          2,
          3
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source56\",\"line\":3,\"column\":11},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj35\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"foo\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"bar\"}},\"ownSymbols\":[],\"ownPropertiesLength\":1,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}},{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj36\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[1,2,3]}}],\"source\":\"console-api\",\"type\":\"trace\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":[{\"columnNumber\":11,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"testStacktraceWithLog\",\"lineNumber\":3,\"sourceId\":195},{\"columnNumber\":3,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"foo\",\"lineNumber\":6,\"sourceId\":193},{\"columnNumber\":1,\"filename\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"triggerPacket\",\"lineNumber\":9,\"sourceId\":193}]}",
  "stacktrace": [
    {
      "columnNumber": 11,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "testStacktraceWithLog",
      "lineNumber": 3,
      "sourceId": 195
    },
    {
      "columnNumber": 3,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "foo",
      "lineNumber": 6,
      "sourceId": 193
    },
    {
      "columnNumber": 1,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 9,
      "sourceId": 193
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source56",
    "line": 3,
    "column": 11
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.time('bar')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924757,
  "type": "nullMessage",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"nullMessage\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`timerAlreadyExists`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924758,
  "type": "time",
  "helperType": null,
  "level": "warn",
  "category": null,
  "messageText": "Timer “bar” already exists.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":3,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Timer “bar” already exists.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"time\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 3,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.timeLog('bar') - 1`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999996,
  "type": "timeLog",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "bar: 1ms"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":4,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar: 1ms\"],\"source\":\"console-api\",\"type\":\"timeLog\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 4,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.timeLog('bar') - 2`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999996,
  "type": "timeLog",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "bar: 1ms",
    "second call",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj34",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "state": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": 1
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source50\",\"line\":5,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar: 1ms\",\"second call\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj34\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"state\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":1}},\"ownSymbols\":[],\"ownPropertiesLength\":1,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"timeLog\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source50",
    "line": 5,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.timeEnd('bar')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924759,
  "type": "timeEnd",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "bar: 1.21ms - timer ended",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":6,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"bar: 1.21ms - timer ended\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"timeEnd\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 6,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`timeEnd.timerDoesntExist`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999998,
  "type": "timeEnd",
  "helperType": null,
  "level": "warn",
  "category": null,
  "messageText": "Timer “bar” doesn’t exist.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":7,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Timer “bar” doesn’t exist.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"timeEnd\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 7,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`timeLog.timerDoesntExist`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999999,
  "type": "timeLog",
  "helperType": null,
  "level": "warn",
  "category": null,
  "messageText": "Timer “bar” doesn’t exist.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":8,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Timer “bar” doesn’t exist.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"timeLog\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 8,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.table('bar')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924801,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.table(['a', 'b', 'c'])`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924859,
  "type": "table",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj39",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "a",
          "b",
          "c"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj39\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"a\",\"b\",\"c\"]}}],\"source\":\"console-api\",\"type\":\"table\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.group('bar')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924863,
  "type": "startGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"source\":\"console-api\",\"type\":\"startGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupEnd('bar')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924864,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":3,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 3,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupCollapsed('foo')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924870,
  "type": "startGroupCollapsed",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "foo"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\"],\"source\":\"console-api\",\"type\":\"startGroupCollapsed\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupEnd('foo')`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924871,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":3,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 3,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.group()`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924878,
  "type": "startGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "<no group label>"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"<no group label>\"],\"source\":\"console-api\",\"type\":\"startGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupEnd()`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924879,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":3,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 3,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log(%cfoobar)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924883,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "foo",
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[\"color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; \",\"color:red; line-height: 1.5; background:url('http://example.com/test')\"],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [
    "color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; ",
    "color:red; line-height: 1.5; background:url('http://example.com/test')"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.log("%cHello%c|%cWorld")`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1518681614352,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "Hello",
    "|",
    "World"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source68\",\"line\":2,\"column\":11},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Hello\",\"|\",\"World\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[\"color:red\",\"\",\"color: blue\"],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source68",
    "line": 2,
    "column": 11
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [
    "color:red",
    "",
    "color: blue"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.group(%cfoo%cbar)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924887,
  "type": "startGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "foo",
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"source\":\"console-api\",\"type\":\"startGroup\",\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupEnd(%cfoo%cbar)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924887,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":6,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 6,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupCollapsed(%cfoo%cbaz)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924892,
  "type": "startGroupCollapsed",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "foo",
    "baz"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source52\",\"line\":2,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"baz\"],\"source\":\"console-api\",\"type\":\"startGroupCollapsed\",\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source52",
    "line": 2,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.groupEnd(%cfoo%cbaz)`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924893,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source59\",\"line\":6,\"column\":9},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source59",
    "line": 6,
    "column": 9
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.dir({C, M, Y, K})`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924899,
  "type": "dir",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj36",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "cyan": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "C"
          },
          "magenta": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "M"
          },
          "yellow": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "Y"
          },
          "black": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "K"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 4,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source25\",\"line\":1,\"column\":35},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj36\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"cyan\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"C\"},\"magenta\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"M\"},\"yellow\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"Y\"},\"black\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"K\"}},\"ownSymbols\":[],\"ownPropertiesLength\":4,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"dir\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source25",
    "line": 1,
    "column": 35
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | default: 1`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913333,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "default: 1",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":2,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 1\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 2,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | default: 2`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "default: 2",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":3,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 2\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 3,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | test counter: 1`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "test counter: 1",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":4,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 1\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 4,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | test counter: 2`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "test counter: 2",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":5,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 2\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 5,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | default: 3`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "default: 3",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":6,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 3\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 6,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | clear`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "clear",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": null,
  "parameters": [
    "Console was cleared."
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":7,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Console was cleared.\"],\"source\":\"console-api\",\"type\":\"clear\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 7,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | default: 4`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913335,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "default: 4",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":8,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 4\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 8,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.count | test counter: 3`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913335,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "test counter: 3",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":9,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 3\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 9,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.countReset | test counter: 0`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920412190,
  "type": "log",
  "helperType": null,
  "level": "log",
  "category": null,
  "messageText": "test counter: 0",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":10,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 0\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 10,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPreparedMessages.set(`console.countReset | counterDoesntExist`, new ConsoleMessage({
  "id": "1",
  "innerWindowID": null,
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920412191,
  "type": "log",
  "helperType": null,
  "level": "warn",
  "category": null,
  "messageText": "Counter “test counter” doesn’t exist.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"sourceId\":\"server1.conn0.child1/source73\",\"line\":11,\"column\":13},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Counter “test counter” doesn’t exist.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false,\"stacktrace\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "sourceId": "server1.conn0.child1/source73",
    "line": 11,
    "column": 13
  },
  "groupId": null,
  "errorMessageName": null,
  "exceptionDocURL": null,
  "cssSelectors": "",
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false,
  "chromeContext": false
}));

stubPackets.set(`console.log('foobar', 'test')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foobar",
      "test"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924471,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log(undefined)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "undefined"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924479,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.warn('danger, will robinson!')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "danger, will robinson!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "warn",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924487,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log(NaN)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "NaN"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924495,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log(null)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "null"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924501,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('鼬')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "鼬"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924506,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.clear()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "timeStamp": 1502884924512,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": {
      "count": 1,
      "label": "bar"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "timeStamp": 1502884924515,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.assert(false, {message: 'foobar'})`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj30",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "message": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "foobar"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "assert",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source33",
    "styles": [],
    "timeStamp": 1502884924521,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": 159
      }
    ],
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('hello \nfrom \rthe \"string world!')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "hello \nfrom \rthe \"string world!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924528,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('úṇĩçödê țĕșť')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "úṇĩçödê țĕșť"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924586,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.dirxml(window)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj31",
        "class": "Window",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 830,
        "preview": {
          "kind": "ObjectWithURL",
          "url": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html"
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dirxml",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "timeStamp": 1502884924596,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('myarray', ['red', 'green', 'blue'])`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myarray",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj32",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "red",
            "green",
            "blue"
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924604,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('myregex', /a.b.c/)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myregex",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj33",
        "class": "RegExp",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "displayString": "/a.b.c/"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924610,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.table(['red', 'green', 'blue']);`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj34",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "red",
            "green",
            "blue"
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "timeStamp": 1502884924612,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myobject",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj35",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 3,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "red": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "redValue"
            },
            "green": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "greenValue"
            },
            "blue": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "blueValue"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 3,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924614,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.debug('debug message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "debug message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "debug",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924621,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.info('info message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "info message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "info",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "styles": [],
    "timeStamp": 1502884924625,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.error('error message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "error message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "error",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source33",
    "styles": [],
    "timeStamp": 1502884924628,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": 159
      }
    ],
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('mymap')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "mymap",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj36",
        "class": "Map",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 0,
        "preview": {
          "kind": "MapLike",
          "size": 2,
          "entries": [
            [
              "key1",
              "value1"
            ],
            [
              "key2",
              "value2"
            ]
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source50",
    "styles": [],
    "timeStamp": 1502884924631,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log('myset')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myset",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj37",
        "class": "Set",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 0,
        "preview": {
          "kind": "ArrayLike",
          "length": 2,
          "items": [
            "a",
            "b"
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [],
    "timeStamp": 1502884924746,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.trace()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "testStacktraceFiltering",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source55",
    "timeStamp": 1502884924752,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 11,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "testStacktraceFiltering",
        "lineNumber": 3,
        "sourceId": 193
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": 193
      },
      {
        "columnNumber": 1,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": 193
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.trace('bar', {'foo': 'bar'}, [1,2,3])`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj35",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "foo": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "bar"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      },
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj36",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            1,
            2,
            3
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "testStacktraceWithLog",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source56",
    "timeStamp": 1538037986659,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 11,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "testStacktraceWithLog",
        "lineNumber": 3,
        "sourceId": 195
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": 193
      },
      {
        "columnNumber": 1,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": 193
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.time('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "timeStamp": 1502884924757,
    "timer": {
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`timerAlreadyExists`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924758,
    "timer": {
      "error": "timerAlreadyExists",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.timeLog('bar') - 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1526920999996,
    "timer": {
      "duration": 1,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.timeLog('bar') - 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      "second call",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj34",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "state": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": 1
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source50",
    "timeStamp": 1526920999996,
    "timer": {
      "duration": 1,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.timeEnd('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924759,
    "timer": {
      "duration": 1.2149999999999181,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`timeEnd.timerDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1526920999998,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`timeLog.timerDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1526920999999,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.table('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "timeStamp": 1502884924801,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.table(['a', 'b', 'c'])`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj39",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "a",
            "b",
            "c"
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "timeStamp": 1502884924859,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.group('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [],
    "timeStamp": 1502884924863,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupEnd('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924864,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupCollapsed('foo')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [],
    "timeStamp": 1502884924870,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupEnd('foo')`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924871,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.group()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [],
    "timeStamp": 1502884924878,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupEnd()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924879,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log(%cfoobar)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [
      "color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; ",
      "color:red; line-height: 1.5; background:url('http://example.com/test')"
    ],
    "timeStamp": 1502884924883,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.log("%cHello%c|%cWorld")`, {
  "message": {
    "addonId": "",
    "arguments": [
      "Hello",
      "|",
      "World"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source68",
    "styles": [
      "color:red",
      "",
      "color: blue"
    ],
    "timeStamp": 1518681614352,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.group(%cfoo%cbar)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1502884924887,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupEnd(%cfoo%cbar)`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924887,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupCollapsed(%cfoo%cbaz)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "baz"
    ],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source52",
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1502884924892,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.groupEnd(%cfoo%cbaz)`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 9,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source59",
    "timeStamp": 1502884924893,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.dir({C, M, Y, K})`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj36",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "cyan": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "C"
            },
            "magenta": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "M"
            },
            "yellow": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "Y"
            },
            "black": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "K"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 4,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dir",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source25",
    "timeStamp": 1502884924899,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | default: 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 1,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913333,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | default: 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 2,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | test counter: 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 1,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | test counter: 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 2,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | default: 3`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 3,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | clear`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | default: 4`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 4,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913335,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.count | test counter: 3`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 3,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 9,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1511365913335,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.countReset | test counter: 0`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "count": 0,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 10,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1526920412190,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

stubPackets.set(`console.countReset | counterDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": {
      "error": "counterDoesntExist",
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 11,
    "prefix": "",
    "private": false,
    "sourceId": "server1.conn0.child1/source73",
    "timeStamp": 1526920412191,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 10737418243
  },
  "type": "consoleAPICall",
  "from": "server1.conn0.child1/consoleActor2"
});

module.exports = {
  stubPreparedMessages,
  stubPackets,
};
