/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class MySQLGrant
implements DBSObject,
DBAPrivilegeGrant {
    public static final Pattern TABLE_GRANT_PATTERN = Pattern.compile("GRANT\\s+(.+)\\s+ON\\s+`?([^`]+)`?\\.`?([^`]+)`?\\s+TO\\s+");
    public static final Pattern GLOBAL_GRANT_PATTERN = Pattern.compile("GRANT\\s+(.+)\\s+ON\\s+(.+)\\s+TO\\s+");
    private final MySQLUser user;
    private final List<MySQLPrivilege> privileges;
    @Nullable
    private final String catalogName;
    @Nullable
    private final String tableName;
    private final boolean allPrivileges;
    private boolean grantOption;

    public MySQLGrant(MySQLUser user, List<MySQLPrivilege> privileges, @Nullable String catalogName, @Nullable String tableName, boolean allPrivileges, boolean grantOption) {
        this.user = user;
        this.privileges = privileges;
        this.catalogName = catalogName;
        this.tableName = tableName;
        this.allPrivileges = allPrivileges;
        this.grantOption = grantOption;
    }

    @Nullable
    public MySQLUser getParentObject() {
        return this.user;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.user.getDataSource();
    }

    @NotNull
    public String getName() {
        return this.allPrivileges ? "ALL PRIVILEGES" : this.privileges.toString();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public MySQLUser getSubject(@NotNull DBRProgressMonitor monitor) {
        return this.user;
    }

    public Object getObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        MySQLTable table;
        MySQLCatalog catalog;
        if (this.catalogName != null && !this.isAllCatalogs() && (catalog = this.user.getDataSource().getCatalog(this.catalogName)) != null && !this.isAllTables() && (table = catalog.getTable(monitor, this.tableName)) != null) {
            return table;
        }
        return this.catalogName + "." + this.tableName;
    }

    public MySQLPrivilege[] getPrivileges() {
        return this.privileges.toArray(new MySQLPrivilege[0]);
    }

    @Property(viewable=true, order=1)
    public String getPrivilegeNames() {
        return this.allPrivileges ? "ALL PRIVILEGES" : this.privileges.toString();
    }

    public boolean isGranted() {
        return true;
    }

    public boolean isAllCatalogs() {
        return "*".equals(this.catalogName);
    }

    @Property(viewable=true, order=10)
    @Nullable
    public String getCatalog() {
        return this.catalogName;
    }

    @Property(viewable=true, order=11)
    @Nullable
    public String getTable() {
        return this.tableName;
    }

    public boolean isAllTables() {
        return "*".equals(this.tableName);
    }

    public boolean isAllPrivileges() {
        return this.allPrivileges;
    }

    public void addPrivilege(MySQLPrivilege privilege) {
        this.privileges.add(privilege);
    }

    public void removePrivilege(MySQLPrivilege privilege) {
        this.privileges.remove(privilege);
    }

    public boolean isGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(boolean grantOption) {
        this.grantOption = grantOption;
    }

    public boolean isEmpty() {
        return this.privileges.isEmpty() && !this.isAllPrivileges() && !this.isGrantOption();
    }

    public boolean matches(@Nullable MySQLCatalog catalog) {
        return catalog == null && this.isAllCatalogs() || catalog != null && CommonUtils.isNotEmpty((String)this.catalogName) && !this.isAllCatalogs() && SQLUtils.matchesLike((String)catalog.getName(), (String)this.catalogName);
    }

    public boolean matches(MySQLTableBase table) {
        return table == null && this.isAllTables() || table != null && table.getName().equalsIgnoreCase(this.tableName);
    }

    public boolean hasNonAdminPrivileges() {
        for (MySQLPrivilege priv : this.privileges) {
            if (priv.getKind() == MySQLPrivilege.Kind.ADMIN) continue;
            return true;
        }
        return false;
    }

    public boolean isStatic() {
        return CommonUtils.isEmpty((String)this.catalogName) || "*".equals(this.catalogName);
    }
}

