/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import com.google.gson.annotations.SerializedName;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotModels;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class CopilotProperties
implements AIEngineProperties {
    private static final String COPILOT_ACCESS_TOKEN = "copilot.access.token";
    private static final String GPT_MODEL = "gpt.model";
    private static final String GPT_CONTEXT_WINDOW_SIZE = "gpt.contextWindowSize";
    private static final String GPT_MODEL_TEMPERATURE = "gpt.model.temperature";
    private static final String GPT_LOG_QUERY = "gpt.log.query";
    @SecureProperty
    @SerializedName(value="copilot.access.token")
    @Nullable
    private String token;
    @SerializedName(value="gpt.model")
    @Nullable
    private String model;
    @SerializedName(value="gpt.contextWindowSize")
    @Nullable
    private Integer contextWindowSize;
    @SerializedName(value="gpt.model.temperature")
    private double temperature;
    @SerializedName(value="gpt.log.query")
    private boolean loggingEnabled;

    @Property(order=1, password=true, required=true)
    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    @Override
    @Property(order=2)
    @Nullable
    public String getModel() {
        return this.model;
    }

    public void setModel(@Nullable String model) {
        this.model = model;
    }

    @Override
    @Property(order=3)
    public double getTemperature() {
        if (this.temperature != 0.0) {
            return this.temperature;
        }
        return CopilotModels.getModelByName(this.model).map(AIModel::defaultTemperature).orElse(0.0);
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    @Property(order=4)
    @Nullable
    public Integer getContextWindowSize() {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        return CopilotModels.getModelByName(this.model).map(AIModel::contextWindowSize).orElse(null);
    }

    public void setContextWindowSize(@Nullable Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }

    @Override
    @Property(order=5)
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault(COPILOT_ACCESS_TOKEN, this.token);
    }

    @Override
    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(COPILOT_ACCESS_TOKEN, this.token);
        }
    }

    @Override
    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.getToken());
    }
}

