/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.core.ui.services.ApplicationPolicyService;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.SWTBrowserRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageDescriptor;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorPreferences;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseUserInterface
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main";
    private Button automaticUpdateCheck;
    private Combo workspaceLanguage;
    @Nullable
    private Combo clientTimezone;
    private final boolean isStandalone = DesktopPlatform.isStandalone();
    private Combo browserCombo;
    private Button useEmbeddedBrowserAuth;
    private Button statusBarShowBreadcrumbsCheck;
    private Button statusBarShowStatusCheck;
    private Combo statusBarBreadcrumbPositionCombo;

    public PrefPageDatabaseUserInterface() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        if (this.isStandalone && !ApplicationPolicyService.getInstance().isInstallUpdateDisabled()) {
            Composite groupObjects = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_general, (int)2, (int)2);
            this.automaticUpdateCheck = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_checkbox_automatic_updates, null, (boolean)false, (int)2);
        }
        if (this.isStandalone) {
            Composite regionalSettingsGroup = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_regional, (int)2, (int)770, (int)0);
            this.workspaceLanguage = UIUtils.createLabelCombo((Composite)regionalSettingsGroup, (String)CoreMessages.pref_page_ui_general_combo_language, (String)CoreMessages.pref_page_ui_general_combo_language_tip, (int)12);
            this.workspaceLanguage.setLayoutData((Object)new GridData(32));
            List languages = PlatformLanguageRegistry.getInstance().getLanguages();
            DBPPlatformLanguage pLanguage = DBPPlatformDesktop.getInstance().getPlatformLanguage();
            int i = 0;
            while (i < languages.size()) {
                PlatformLanguageDescriptor lang = (PlatformLanguageDescriptor)languages.get(i);
                this.workspaceLanguage.add(lang.getLabel());
                if (CommonUtils.equalObjects((Object)pLanguage, (Object)lang)) {
                    this.workspaceLanguage.select(i);
                }
                ++i;
            }
            if (this.workspaceLanguage.getSelectionIndex() < 0) {
                this.workspaceLanguage.select(0);
            }
            this.clientTimezone = UIUtils.createLabelCombo((Composite)regionalSettingsGroup, (String)CoreMessages.pref_page_ui_general_combo_timezone, (String)CoreMessages.pref_page_ui_general_combo_timezone_tip, (int)4);
            this.clientTimezone.setLayoutData((Object)new GridData(32));
            this.clientTimezone.add("Default");
            for (String timezoneName : TimezoneRegistry.getTimezoneNames()) {
                this.clientTimezone.add(timezoneName);
            }
            this.clientTimezone.addModifyListener(e -> {
                this.updateApplyButton();
                this.getContainer().updateButtons();
            });
            IContentProposalProvider proposalProvider = (contents, position) -> {
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                String[] stringArray = this.clientTimezone.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.toLowerCase().contains(contents.toLowerCase())) {
                        proposals.add(new ContentProposal(item));
                    }
                    ++n2;
                }
                return (IContentProposal[])proposals.toArray(IContentProposal[]::new);
            };
            ContentAssistUtils.installContentProposal((Control)this.clientTimezone, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider);
            Control tipLabelRestart = UIUtils.createInfoLabel((Composite)regionalSettingsGroup, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
            tipLabelRestart.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            Composite groupObjects = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_browser, (int)2, (int)770);
            if (RuntimeUtils.isWindows()) {
                this.browserCombo = UIUtils.createLabelCombo((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_combo_browser, (int)8);
                this.browserCombo.setLayoutData((Object)new GridData(32));
                SWTBrowserRegistry.BrowserSelection[] browserSelectionArray = SWTBrowserRegistry.BrowserSelection.values();
                int n = browserSelectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SWTBrowserRegistry.BrowserSelection value = browserSelectionArray[n2];
                    this.browserCombo.add(value.getFullName(), value.ordinal());
                    ++n2;
                }
                Control tipLabel = UIUtils.createInfoLabel((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_combo_browser_tip);
                tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            }
            this.useEmbeddedBrowserAuth = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_check_browser_auth, (String)CoreMessages.pref_page_ui_general_check_browser_auth_tip, (boolean)false, (int)2);
            this.useEmbeddedBrowserAuth.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            if (this.browserCombo != null) {
                this.browserCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (PrefPageDatabaseUserInterface.this.browserCombo.getSelectionIndex() == SWTBrowserRegistry.BrowserSelection.IE.ordinal()) {
                            PrefPageDatabaseUserInterface.this.useEmbeddedBrowserAuth.setEnabled(false);
                            PrefPageDatabaseUserInterface.this.useEmbeddedBrowserAuth.setSelection(false);
                        } else {
                            PrefPageDatabaseUserInterface.this.useEmbeddedBrowserAuth.setEnabled(true);
                        }
                    }
                });
            }
        }
        Composite breadcrumbs = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_ui_status_bar, (int)2, (int)770);
        this.statusBarShowBreadcrumbsCheck = UIUtils.createCheckbox((Composite)breadcrumbs, (String)CoreMessages.pref_page_ui_status_bar_show_breadcrumbs_check_label, (String)CoreMessages.pref_page_ui_status_bar_show_breadcrumbs_check_tip, (boolean)true, (int)1);
        this.statusBarShowBreadcrumbsCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.statusBarBreadcrumbPositionCombo.setEnabled(this.statusBarShowBreadcrumbsCheck.getSelection())));
        this.statusBarBreadcrumbPositionCombo = new Combo(breadcrumbs, 12);
        this.statusBarBreadcrumbPositionCombo.add(CoreMessages.pref_page_ui_status_bar_show_breadcrumbs_status_bar_label);
        this.statusBarBreadcrumbPositionCombo.add(CoreMessages.pref_page_ui_status_bar_show_breadcrumbs_editors_label);
        this.statusBarBreadcrumbPositionCombo.select(0);
        this.statusBarShowStatusCheck = UIUtils.createCheckbox((Composite)breadcrumbs, (String)CoreMessages.pref_page_ui_status_bar_show_status_line_check_label, (String)CoreMessages.pref_page_ui_status_bar_show_status_line_check_tip, (boolean)true, (int)2);
        this.setSettings();
        return composite;
    }

    private void setSettings() {
        DatabaseEditorPreferences.BreadcrumbLocation breadcrumbLocation;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isWindowsDesktopClient()) {
            SWTBrowserRegistry.getActiveBrowser();
            this.browserCombo.select(SWTBrowserRegistry.getActiveBrowser().ordinal());
            this.useEmbeddedBrowserAuth.setEnabled(!SWTBrowserRegistry.getActiveBrowser().equals((Object)SWTBrowserRegistry.BrowserSelection.IE));
        }
        if (this.isStandalone) {
            if (!ApplicationPolicyService.getInstance().isInstallUpdateDisabled()) {
                this.automaticUpdateCheck.setSelection(store.getBoolean("ui.auto.update.check"));
            }
            this.useEmbeddedBrowserAuth.setSelection(store.getBoolean("ui.use.redirect.auth"));
        }
        String timezone = store.getString("java.client.timezone");
        if (this.clientTimezone != null) {
            if ("Default".equals(timezone)) {
                this.clientTimezone.setText("Default");
            } else {
                this.clientTimezone.setText(timezone);
            }
        }
        this.statusBarShowBreadcrumbsCheck.setSelection((breadcrumbLocation = DatabaseEditorPreferences.BreadcrumbLocation.get((DBPPreferenceStore)store)) != DatabaseEditorPreferences.BreadcrumbLocation.HIDDEN);
        this.statusBarBreadcrumbPositionCombo.select(breadcrumbLocation == DatabaseEditorPreferences.BreadcrumbLocation.IN_EDITORS ? 1 : 0);
        this.statusBarBreadcrumbPositionCombo.setEnabled(this.statusBarShowBreadcrumbsCheck.getSelection());
        this.statusBarShowStatusCheck.setSelection(store.getBoolean("ui.statusBar.show.statusLine"));
    }

    protected void performDefaults() {
        DatabaseEditorPreferences.BreadcrumbLocation location;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isStandalone) {
            this.useEmbeddedBrowserAuth.setSelection(store.getDefaultBoolean("ui.use.redirect.auth"));
            if (!ApplicationPolicyService.getInstance().isInstallUpdateDisabled()) {
                this.automaticUpdateCheck.setSelection(store.getDefaultBoolean("ui.auto.update.check"));
            }
        }
        if (this.isWindowsDesktopClient()) {
            SWTBrowserRegistry.getActiveBrowser();
            this.browserCombo.select(SWTBrowserRegistry.getDefaultBrowser().ordinal());
        }
        if (this.clientTimezone != null) {
            UIUtils.setComboSelection((Combo)this.clientTimezone, (String)store.getDefaultString("java.client.timezone"));
        }
        this.statusBarShowBreadcrumbsCheck.setSelection((location = DatabaseEditorPreferences.BreadcrumbLocation.getDefault((DBPPreferenceStore)store)) != DatabaseEditorPreferences.BreadcrumbLocation.HIDDEN);
        this.statusBarBreadcrumbPositionCombo.select(location == DatabaseEditorPreferences.BreadcrumbLocation.IN_STATUS_BAR ? 0 : 1);
        this.statusBarShowStatusCheck.setSelection(store.getDefaultBoolean("ui.statusBar.show.statusLine"));
    }

    private boolean isWindowsDesktopClient() {
        return this.isStandalone && RuntimeUtils.isWindows();
    }

    public boolean isValid() {
        return super.isValid();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isStandalone) {
            store.setValue("ui.use.redirect.auth", this.useEmbeddedBrowserAuth.getSelection());
            if (!ApplicationPolicyService.getInstance().isInstallUpdateDisabled()) {
                store.setValue("ui.auto.update.check", this.automaticUpdateCheck.getSelection());
            } else {
                store.setValue("ui.auto.update.check", Boolean.FALSE.booleanValue());
            }
            if (this.isWindowsDesktopClient()) {
                SWTBrowserRegistry.setActiveBrowser(SWTBrowserRegistry.BrowserSelection.values()[this.browserCombo.getSelectionIndex()]);
            }
            PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
            if (this.clientTimezone != null) {
                if ("Default".equals(this.clientTimezone.getText())) {
                    TimezoneRegistry.setDefaultZone(null, (boolean)true);
                } else {
                    TimezoneRegistry.setDefaultZone((ZoneId)ZoneId.of(TimezoneRegistry.extractTimezoneId((String)this.clientTimezone.getText())), (boolean)true);
                }
            }
            DatabaseEditorPreferences.BreadcrumbLocation breadcrumbLocation = !this.statusBarShowBreadcrumbsCheck.getSelection() ? DatabaseEditorPreferences.BreadcrumbLocation.HIDDEN : (this.statusBarBreadcrumbPositionCombo.getSelectionIndex() == 0 ? DatabaseEditorPreferences.BreadcrumbLocation.IN_STATUS_BAR : DatabaseEditorPreferences.BreadcrumbLocation.IN_EDITORS);
            store.setValue("ui.statusBar.show.breadcrumbs", breadcrumbLocation.name());
            store.setValue("ui.statusBar.show.statusLine", this.statusBarShowStatusCheck.getSelection());
            if (this.workspaceLanguage.getSelectionIndex() >= 0) {
                PlatformLanguageDescriptor language = (PlatformLanguageDescriptor)PlatformLanguageRegistry.getInstance().getLanguages().get(this.workspaceLanguage.getSelectionIndex());
                DBPPlatformLanguage curLanguage = DBPPlatformDesktop.getInstance().getPlatformLanguage();
                try {
                    if (curLanguage != language) {
                        DBPPlatform dBPPlatform = DBWorkbench.getPlatform();
                        if (dBPPlatform instanceof DBPPlatformLanguageManager) {
                            DBPPlatformLanguageManager languageManager = (DBPPlatformLanguageManager)dBPPlatform;
                            languageManager.setPlatformLanguage((DBPPlatformLanguage)language);
                        }
                        if (UIUtils.confirmAction((Shell)this.getShell(), (String)("Restart " + GeneralUtils.getProductName()), (String)("You need to restart " + GeneralUtils.getProductName() + " to perform actual language change.\nDo you want to restart?"))) {
                            this.restartWorkbenchOnPrefChange();
                        }
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Change language", "Can't switch language to " + String.valueOf(language), (Throwable)e);
                }
            }
        }
        return true;
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

