/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.convert.impl;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.ui.editors.sql.convert.ISQLTextConverter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;
import org.jkiss.utils.CommonUtils;

public abstract class SourceCodeSQLConverter
implements ISQLTextConverter {
    private static final Log log = Log.getLog(SourceCodeSQLConverter.class);
    public static final String OPTION_KEEP_FORMATTING = "keep-formatting";
    public static final String OPTION_LINE_DELIMITER = "line-delimiter";
    private static final String DEF_LINE_DELIMITER = "\\n";

    @Override
    @NotNull
    public String convertText(@NotNull SQLDialect dialect, @NotNull SQLSyntaxManager syntaxManager, @NotNull SQLRuleScanner ruleManager, @NotNull IDocument document, int startPos, int length, @NotNull Map<String, Object> options) {
        try {
            String lineDelimiter;
            String sourceText = document.get(startPos, length);
            String[] sourceLines = sourceText.contains("\n") || sourceText.contains("\r") ? sourceText.split("[\\n\\r]+") : new String[]{sourceText};
            boolean keepFormatting = CommonUtils.toBoolean((Object)options.get(OPTION_KEEP_FORMATTING));
            if (!keepFormatting) {
                int i = 0;
                while (i < sourceLines.length) {
                    sourceLines[i] = sourceLines[i].trim();
                    ++i;
                }
            }
            if (CommonUtils.isEmpty((String)(lineDelimiter = CommonUtils.toString((Object)options.get(OPTION_LINE_DELIMITER), (String)DEF_LINE_DELIMITER)))) {
                lineDelimiter = " ";
            }
            StringBuilder result = new StringBuilder();
            this.convertSourceLines(result, sourceLines, lineDelimiter, options);
            return result.toString();
        }
        catch (BadLocationException e) {
            log.error((Object)e);
            return "";
        }
    }

    protected abstract void convertSourceLines(StringBuilder var1, String[] var2, String var3, Map<String, Object> var4);
}

