/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;
import org.jkiss.utils.CommonUtils;

public class AIPromptGeneratorDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "com.dbeaver.ai.prompt";
    private final IConfigurationElement contributorConfig;
    private final AbstractDescriptor.ObjectType objectType;
    private final String label;
    private final DBPImage icon;
    private final String[] dependsOn;

    protected AIPromptGeneratorDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.contributorConfig = config;
        this.objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config, "class");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.label = config.getAttribute("label");
        this.dependsOn = CommonUtils.splitString((String)config.getAttribute("dependsOn"), (char)',').toArray(new String[0]);
    }

    @NotNull
    public String getId() {
        return this.contributorConfig.getAttribute("id");
    }

    @Nullable
    public DBPImage getIcon() {
        return this.icon;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @NotNull
    public String[] getDependsOn() {
        return this.dependsOn;
    }

    @NotNull
    public AIPromptGenerator createGenerator(@NotNull DBSLogicalDataSourceSupplier dataSource) throws DBException {
        Class objectClass = this.objectType.getObjectClass(AIPromptGenerator.class);
        if (objectClass == null) {
            throw new DBException("Object class " + this.objectType.getImplName() + " not found");
        }
        try {
            Method createMethod = objectClass.getMethod("create", DBSLogicalDataSourceSupplier.class);
            if (Modifier.isStatic(createMethod.getModifiers())) {
                return (AIPromptGenerator)createMethod.invoke(null, dataSource);
            }
            throw new DBException("Prompt method '" + String.valueOf(createMethod) + "' is not static");
        }
        catch (Exception e) {
            throw new DBException("Error creating prompt generator " + this.getId(), (Throwable)e);
        }
    }
}

