/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCollation;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridCharset
implements DBSObject {
    private String name;
    private CubridDataSource dataSource;
    private List<CubridCollation> collations = new ArrayList<CubridCollation>();

    protected CubridCharset(@NotNull CubridDataSource dataSource, @NotNull ResultSet dbResult) {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"charset_name");
        this.dataSource = dataSource;
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return this.dataSource;
    }

    public void addCollation(@NotNull CubridCollation collation) {
        this.collations.add(collation);
        Collections.sort(this.collations, DBUtils.nameComparator());
    }

    @NotNull
    public List<CubridCollation> getCollations() {
        return this.collations;
    }

    @NotNull
    public CubridCollation getDefaultCollation() {
        return this.collations.get(0);
    }

    @Nullable
    public CubridCollation getCollation(String name) {
        for (CubridCollation collation : this.collations) {
            if (!collation.getName().equals(name)) continue;
            return collation;
        }
        return null;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource;
    }
}

