/*
 * Generated with the genpubsuffix tool.
 *  From file public_suffix_list.dat
 *  Converted on Mon Jun 24 11:38:08 2019
 */

/**
 * Public suffix list graph node
 */
union pnode {
    struct {
        unsigned int idx:24; /**< index of domain element in string table */
        unsigned int len:6; /**< length of domain element in string table */
        unsigned int children:1; /**< has children */
    } label;
    struct {
        uint16_t index; /**< index of first child node */
        uint16_t count; /**< number of children of this node */
    } child;
};

enum stab_entities {
    STAB_WILDCARD = 0,
    STAB_EXCEPTION = 11
};

/**
 * Huffman coding node
 */
struct hnode {
    uint8_t term:1; /**< non zero if the node terminates a code */
    uint8_t value:7; /**< value in node */
};

/**
 * Huffman decoding table
 *
 * nodes are in pairs even nodes are for 0bit odd for 1
 */
static const struct hnode htable[76] = {
    { 0, 2 },
    { 0, 46 },
    { 0, 4 },
    { 0, 38 },
    { 0, 6 },
    { 0, 18 },
    { 0, 8 },
    { 1, 't' }, /* 't': 0001 */
    { 0, 10 },
    { 1, 'g' }, /* 'g': 00001 */
    { 0, 12 },
    { 1, 'w' }, /* 'w': 000001 */
    { 0, 14 },
    { 0, 16 },
    { 1, '0' }, /* '0': 00000000 */
    { 1, '2' }, /* '2': 00000001 */
    { 1, '3' }, /* '3': 00000010 */
    { 1, 'q' }, /* 'q': 00000011 */
    { 0, 20 },
    { 0, 36 },
    { 0, 22 },
    { 1, 'c' }, /* 'c': 00101 */
    { 0, 24 },
    { 1, 'v' }, /* 'v': 001001 */
    { 0, 26 },
    { 1, 'j' }, /* 'j': 0010001 */
    { 0, 28 },
    { 0, 30 },
    { 1, '8' }, /* '8': 001000000 */
    { 1, '6' }, /* '6': 001000001 */
    { 0, 32 },
    { 1, '7' }, /* '7': 001000011 */
    { 0, 34 },
    { 1, '9' }, /* '9': 0010000101 */
    { 1, '*' }, /* '*': 00100001000 */
    { 1, '!' }, /* '!': 00100001001 */
    { 1, 'h' }, /* 'h': 00110 */
    { 1, 'd' }, /* 'd': 00111 */
    { 0, 40 },
    { 1, 'a' }, /* 'a': 011 */
    { 1, 'r' }, /* 'r': 0100 */
    { 0, 42 },
    { 0, 44 },
    { 1, 'k' }, /* 'k': 01011 */
    { 1, 'f' }, /* 'f': 010100 */
    { 1, 'x' }, /* 'x': 010101 */
    { 0, 48 },
    { 0, 64 },
    { 0, 50 },
    { 0, 62 },
    { 1, 's' }, /* 's': 1000 */
    { 0, 52 },
    { 0, 54 },
    { 1, 'm' }, /* 'm': 10011 */
    { 0, 56 },
    { 1, 'p' }, /* 'p': 100101 */
    { 0, 58 },
    { 1, 'z' }, /* 'z': 1001001 */
    { 1, '1' }, /* '1': 10010000 */
    { 0, 60 },
    { 1, '5' }, /* '5': 100100010 */
    { 1, '4' }, /* '4': 100100011 */
    { 1, 'o' }, /* 'o': 1010 */
    { 1, 'e' }, /* 'e': 1011 */
    { 0, 66 },
    { 0, 70 },
    { 1, 'n' }, /* 'n': 1100 */
    { 0, 68 },
    { 1, 'u' }, /* 'u': 11010 */
    { 1, 'l' }, /* 'l': 11011 */
    { 1, 'i' }, /* 'i': 1110 */
    { 0, 72 },
    { 0, 74 },
    { 1, '-' }, /* '-': 11111 */
    { 1, 'y' }, /* 'y': 111100 */
    { 1, 'b' }, /* 'b': 111101 */
};

/**
 * Domain label string table huffman encoded.
 * 6284 labels(365064 bits) reduced to 4394 labels(171904 bits)
 */
static const uint32_t stab[5372] = {
    0x3AA42084, 0xE912D3FF, 0xB1FDF8AB, 0x6BCAD377, 0x43E3BA8E, 0x35090146,
    0xE04B2765, 0x3DE7C4F5, 0xBF1D8178, 0xA1E22BE7, 0x7C60569D, 0xBBD8FF0F,
    0xE6BCE569, 0x426AF1A8, 0x7A51FF9D, 0xF07EA6F0, 0x3FB5278F, 0xC87B7A05,
    0x83DC9A93, 0x5A26B4DE, 0x04D5E348, 0x8DFB07D0, 0xFF4EFEC3, 0x076B2094,
    0xFA0084FE, 0xD871BF60, 0x5A8FE9DF, 0x3F81DAC8, 0xD83E8021, 0x77F61C6F,
    0xB216A3FA, 0x5407E076, 0x1E947FE7, 0x3FC1F9BC, 0x92FED49E, 0x1FF9D57C,
    0xEA6F07A5, 0xDA93C707, 0x3AAF923F, 0xE0F4A3FF, 0x78FF054D, 0xF24BFB52,
    0xB27FE755, 0x789EC325, 0xE06B8C5B, 0x9537C14F, 0x6C978D23, 0x6EC8DED6,
    0xB6878962, 0xF4A3FF3A, 0x8E0FCDE0, 0x613FB527, 0x7FE755F2, 0xA9BC1E94,
    0xFB5278E0, 0x755F2613, 0xC1E947FE, 0x4F1FE09B, 0xE4827F6A, 0x64FFCEAB,
    0xF13D864B, 0x3E5B18B6, 0x1E94D7C5, 0x437FC1EF, 0xE341E076, 0x3FF3A8D5,
    0x04DE0F4A, 0x7FDA93C7, 0xFFE755E2, 0x3F3C3BD7, 0xFED49E38, 0xFF3AAF13,
    0xE7876BBF, 0xDA93C707, 0xE755E27F, 0x70A240FF, 0xD1DE60EF, 0x55F803F3,
    0xFD2CFFE7, 0x1CA97E0B, 0x0303FBDC, 0x4FFCEABF, 0xA0146537, 0x4202F00D,
    0x290A1340, 0x03D11D4F, 0x8A23BE5B, 0x146AF19E, 0x93EFB5B9, 0x7F3C9D3D,
    0xD59F6B78, 0xDEF49FF9, 0x0577F9FD, 0x7AF66FF6, 0x6BFF9CB8, 0x8FE88DD9,
    0x970F39E2, 0xDCF147F3, 0x11BB2D7F, 0x23765AFD, 0xEE78A3FA, 0xD59CB87B,
    0x64ADFFF9, 0x278E0FCF, 0xBD603FB5, 0xDFE926B9, 0xFEDEF79F, 0x69279CAF,
    0x0F7DCF14, 0x2D7FF397, 0xE28D11BB, 0x765AFFB9, 0xB87BFA23, 0xDFF9D59C,
    0xFC17424B, 0x27F87B6C, 0xFFCEABCE, 0x4D883B93, 0x1FD7CEAE, 0xFA00EBE9,
    0x57F1A5CA, 0x07E4587C, 0x5C27F03B, 0xC6E57F7C, 0x9CDBCF43, 0xE45128BC,
    0xF64FBED6, 0x6F0CF274, 0xB722B3ED, 0x9D3D91F6, 0x6B787F3C, 0x9AED699F,
    0xEF6F06F3, 0x09778E73, 0x5A7FE754, 0x7751CD79, 0x01A0927C, 0xBC4B8C6B,
    0x3C9605D9, 0xACAF4579, 0xA04FFFCE, 0x5C7D8FF4, 0xABE22FFA, 0xD119FFCE,
    0xD122149F, 0x2B6135F8, 0x260FFCEA, 0x7A890216, 0x4AD85013, 0x401C47C4,
    0x0E37EC1F, 0xEDF8AFFB, 0x40109FC0, 0x0E37EC1F, 0x60F8AFFB, 0x0084FE07,
    0x71BF60FA, 0x07C57FD8, 0x0603F03B, 0x8DFB07D0, 0x3EBDFEC3, 0x213F81D8,
    0x6FD83E80, 0xFF0FF61C, 0x784FE076, 0xFF7BD22D, 0x029EBE52, 0x17D87377,
    0x896D3FDF, 0xDF146F1A, 0xB533C4B4, 0x5F9F3E0B, 0xD5E340E8, 0x3DE3D298,
    0xB26953F8, 0x27C6AF07, 0x728AC51F, 0x941AD3F4, 0xDADC8ADA, 0xF274F647,
    0x33ED6F0C, 0xD4DE0F4A, 0xE6FAC6F7, 0x07A51B07, 0x6AC7EA6F, 0xB6A4F1FE,
    0xDE93FF3A, 0xB02BBFBB, 0x3AAFBF7F, 0xBBDE93FF, 0x7FB02BB9, 0xCB87AFBF,
    0x46ECB5F9, 0x3CE78A34, 0x9E28CE5C, 0x11BB2D7B, 0xB4FFCEAD, 0x295FC7A3,
    0x57D33FD9, 0x9295FF9D, 0x8F4769FD, 0x145F42BF, 0x9CB879CF, 0x446ECB5F,
    0xB5EE78A3, 0x87B446EC, 0xBF3739CB, 0xC0BB0DE4, 0x3ACA0B92, 0x8096B8C6,
    0x99413D8D, 0x9D47B4D3, 0xA7C3C3FF, 0xBF3D8823, 0xFFCEABE0, 0xE4D4A32F,
    0x4D7F1C2A, 0x0FFCEAD8, 0xED3BC9A1, 0x6271E04F, 0xFF9D4CC2, 0xB4A2CE59,
    0xB123FD03, 0xEBFF3AA9, 0xFA34ABDA, 0x889C7E13, 0x7FE75330, 0xDA62C42D,
    0x137E819F, 0xE7544A13, 0x5A4F90FF, 0x43E5B03C, 0x3FF3AAF8, 0x76AB1DA3,
    0x818FC27D, 0xFCEABD12, 0x92DBE19F, 0x9E227626, 0x430804D8, 0xF0CFFE75,
    0x610FDE05, 0x8482600A, 0x16BE9795, 0xF94BFDE9, 0xCDDC0A7A, 0xB69AB761,
    0x395A7C60, 0x03BBBF45, 0x7E6F07A5, 0x4F1FE6AC, 0xE0F4A36A, 0x2C6F7D4D,
    0xD28D83F3, 0x63F53783, 0xB5278FF1, 0xA6F07A51, 0x78E6AC7E, 0x07A51B52,
    0xEB1BCA6F, 0x946C1F9B, 0x58A9BC1E, 0xD49E3FCD, 0xD27FE756, 0xB02BB77B,
    0x3AB6137F, 0x1E8ED3FF, 0x1FFB252B, 0xBFF3AB01, 0x4769B252, 0xE0253F8F,
    0xF374935C, 0x9CAFDBDE, 0x21666927, 0xEEF6903B, 0x13578C57, 0x7B687AF4,
    0x815F0DF8, 0x1EBD04F2, 0x25C631DA, 0x3A8777BD, 0xF332BFFF, 0x33FE1AC4,
    0xFE755301, 0x4DE2DB7F, 0x49FF7D32, 0x7FFE756C, 0x0AB93519, 0x5B123FC7,
    0x6985FF9D, 0xD71242DD, 0xA2B04807, 0x0DBBFFCE, 0xFF69DE4D, 0x3AAF8044,
    0x246DE7FF, 0x7EF9A557, 0xFF3AB624, 0x0F649373, 0x93FFA051, 0x1FFCEAD8,
    0xB0B1FD28, 0xABE927E7, 0x5C31FFCE, 0xFF0F6FFA, 0xE755F400, 0x1F5F0CFF,
    0xA4D44EA1, 0x29DE0001, 0x60760641, 0xCB85E4CB, 0xEF64C51B, 0x2589B896,
    0x6D6FDA1E, 0x37581FBE, 0x2D640A70, 0xE9FDF17D, 0xFEEE8F7A, 0x6A764DB1,
    0xF37691D8, 0x4BEDEF5C, 0xD90B44B6, 0x4B60D6B4, 0x946E9CA0, 0xB1F9BC1E,
    0xDA93C7F8, 0xF3783D28, 0x93C73563, 0x783D28DA, 0xC7163F53, 0x3D28DA93,
    0x58DE5378, 0xA51B07E6, 0x162A6F07, 0x1B5278FF, 0x2A6F07A5, 0xA93C7356,
    0x3783D28D, 0x3C7F9AB1, 0x4ED6FDA9, 0x637BEA7A, 0x6A6C1F99, 0xFFCE6B79,
    0xC738EEE0, 0x8E71DDC1, 0xCD6F2D4F, 0xB0741D99, 0xC158C6CB, 0x605D9B2E,
    0x28EF51C9, 0x18CF8D7A, 0x2C0BB097, 0x23ACA0B9, 0xF6D0F5E8, 0x25817670,
    0x5D6EF60F, 0x6D39AF39, 0xFE751ABC, 0x3EE7B26F, 0x1201B000, 0x9FF9D5A0,
    0xD02B7EC1, 0xAB2043FC, 0x1E16BFF3, 0x67FCC5AC, 0x7FE75602, 0xE9F7FA52,
    0x5809AF96, 0x92D3FF9D, 0x1A07EB80, 0xCEA2A090, 0x4BDF21FF, 0x04DFF7B8,
    0x64FFCEAC, 0xF9F09207, 0xA9609AA7, 0x29AABFF3, 0x4E40DF20, 0xD4C00DD4,
    0xD7C33FF9, 0x1093A847, 0x54482538, 0xDF0CFFE7, 0x13B13496, 0x7516C4F1,
    0xE02A07FE, 0x26E40204, 0x41100E90, 0xA27FF3AB, 0x89894058, 0x7C110284,
    0xFE754061, 0x784EA97F, 0x2E227509, 0xD006989D, 0x04A7FA77, 0x27F03B59,
    0xFA77D004, 0x3B5904A7, 0xD00603F0, 0x16A3FA77, 0x4FE076B2, 0xF4EFA008,
    0xED642D47, 0x4AF80FC0, 0x5612D181, 0xD16C9F1A, 0xD69FDF17, 0x3C690B44,
    0x7FBE2FB2, 0x8A0B0ACA, 0xF172D653, 0x5B07BF3D, 0xF02D37D0, 0x4577AD90,
    0x1EC1AD0B, 0xEC8DED64, 0x2B4B4B53, 0xA63F3925, 0x93F36478, 0x78F258A6,
    0x3F3FCCA7, 0xEE94E3C0, 0x54D03C5A, 0xD3FA96B3, 0x9F689608, 0xF64258FC,
    0xCDA1EDED, 0xCB5C45D6, 0xA3C0AE27, 0x7DADC8AD, 0x6F0FEC9F, 0x0F4A33ED,
    0x1C58FCDE, 0xF4A36A4F, 0x7F7D4DE0, 0xD28D83F3, 0xE3F53783, 0x946D49E3,
    0x58A9BC1E, 0xA36A4F1C, 0x2C4DE0F4, 0x36A4F1FE, 0xC4DE0F4A, 0xB5278E6A,
    0xFCF0EF5F, 0xA4F1CD58, 0x7876BBF6, 0x78E6AC7E, 0xDE5A9B52, 0xDDC1F39A,
    0xBB838E71, 0xF2D41CE3, 0x41D99CD6, 0x2760BB07, 0x0ECD06D6, 0x93B1D83A,
    0xECD9760A, 0xAC5D83A0, 0x3B054F7C, 0x2EC1D076, 0xCE3D631B, 0xEA396E76,
    0xAF01E0F1, 0xFC3C578E, 0xF49A6F01, 0x0BB0FDDE, 0x094A792C, 0xF3B43D7A,
    0x6C995E8A, 0x037839E9, 0xDE3578C7, 0x725B49CA, 0xBC6AF18C, 0x61A1CB59,
    0x79B6ECA7, 0x2D9D94EF, 0x69BC15ED, 0xB6C8F189, 0x3FF3A860, 0x1EDED251,
    0xB62513FE, 0xE267FF3A, 0x4F9EEF70, 0xF9D5B130, 0x39B59B7F, 0x8FC27D71,
    0xC5FFF9D5, 0xFC258850, 0x3AB49A13, 0xBCDBC3FF, 0x010FEF43, 0x5AFFCEAC,
    0xFEE9903C, 0xF9D5802F, 0xC3DB3D9F, 0xC4A27F1B, 0x4D7FE756, 0x7CF6078E,
    0xFE75600D, 0xC2AE4787, 0x58F027F1, 0xF4B7FF9D, 0x13F82E84, 0xFF3AB625,
    0x58250D93, 0x5600A7DF, 0x53557FE7, 0xF6206F40, 0xF9D5A034, 0x7817C33F,
    0x6929843F, 0x3FF9D445, 0x00169001, 0x37137A05, 0x57FE7569, 0xE0104F92,
    0x245D0904, 0x9FFCEACC, 0x14C26BE1, 0xC0077DE0, 0xF4781DBD, 0xB7A04F6D,
    0xE2BFA00E, 0xD83F22C3, 0x87A13F81, 0x6FAC8297, 0x3B1A65B0, 0xFF9AE7F0,
    0x97AB82EE, 0x667F7C5C, 0xD12C1FE1, 0x7FDF172D, 0x9682DBDF, 0xCF7C5CF3,
    0x06B5A537, 0x6FF1783D, 0x60B53EB0, 0x9FC5C4D5, 0xF05B4FC2, 0x117E6B94,
    0xC82D82D9, 0x30AD4F3C, 0xF591F1D9, 0xC7779907, 0xDAFB2094, 0xE8166B49,
    0x9FB81C51, 0xB9622D8F, 0x25E69595, 0x74C451BE, 0x16B4E2D7, 0xB1A16965,
    0xFC8EB914, 0x8725D344, 0xB16E750F, 0xF7A0D272, 0xA0D8D0FE, 0x3EE9A71F,
    0xBA1ABC6A, 0x702C716B, 0x81F8C1A6, 0x9D503786, 0x96952DFF, 0xC31F7FE0,
    0xFD28DCAE, 0x505B4D5B, 0x7C33FF9D, 0x4AC4E40D, 0x722B4102, 0x3F27DF6B,
    0x8ACFB5BC, 0xC9F7DADC, 0x59F6B786, 0xC8FB5B91, 0x3ED6F0FE, 0x4DE0F4A3,
    0x6C1F9B7D, 0xA9BC1E94, 0x1B52781F, 0xCA6F07A5, 0xA360FCDF, 0xC54DE0F4,
    0x28DA93C7, 0x8B13783D, 0xD7ED49E3, 0x163F3C3B, 0x6FDA93C7, 0xAC7E7B25,
    0xFB5278E6, 0x3F3C3B5D, 0xDA93C716, 0xEE3D39D4, 0x5F9B9FA9, 0x9F57E6E5,
    0x3DC7A73A, 0xD5E10D25, 0xE57EDEA7, 0xC1FFCEAC, 0x1FF6A4F1, 0x2BA53F40,
    0xA766BDD8, 0x3A0EC72D, 0x631A19D8, 0xE71BE765, 0xEC1D9C7B, 0x0741D8A4,
    0x4178A7BB, 0x1D076683, 0xCA3B28EC, 0xA0EC5DEE, 0xE25E5D83, 0x8579D9C7,
    0xE25E5D83, 0x22CAD9C7, 0xB868369E, 0x6F5D3B28, 0x37A8E7A1, 0x579EF0B4,
    0xAD182F0E, 0xA67BF2BD, 0x9E9736EC, 0x43DE1680, 0x5798976B, 0x45ED8DBA,
    0x5B0BA72B, 0x3C9605D8, 0xA73B06B4, 0x82C79625, 0x40FBF3AC, 0xBBC94A1E,
    0x89718F86, 0xA1EBD077, 0x53DB451D, 0x03B29C50, 0x7AF41D5E, 0x28E57F68,
    0xB1A04D5E, 0x0DBDE14B, 0xAD057A5A, 0x074F2835, 0x3EC57B1A, 0x0BB206F2,
    0x2340792C, 0x3FC3DF65, 0x3AB545DD, 0xE6696BFF, 0x56AB9F3C, 0xAD367FE7,
    0x4E07C454, 0x6FFF3AB0, 0x7E126C0F, 0x6240EAA2, 0xE60EF709, 0xFCEA3D1D,
    0x26ECB6FF, 0x56AA27E1, 0x7397FFE7, 0xFC59FC4E, 0xFD8926F2, 0x32567E0B,
    0xFA4B91D3, 0x3952FC17, 0xFF3AB7B8, 0x7BB8DAB3, 0xCEAD533E, 0xC0F1ECFF,
    0x609C0F96, 0xA4D7FE75, 0x7FE12C42, 0xFFF3AB54, 0xFC70AB90, 0xFE756819,
    0xF606FCDF, 0xAB04E07C, 0xB620FFF3, 0xDC7DFF3C, 0x695FFCEA, 0x3FF850DA,
    0xFFFCEAD5, 0xF9EF0B40, 0xF9D58269, 0xE3A67A5F, 0xD58264F9, 0x0DF65FF9,
    0xB559F9EC, 0x2687FF3A, 0x27CF90B6, 0xFFCEAC13, 0xF87B67A1, 0xF3AB5457,
    0xB851207F, 0xAB048FF7, 0x57C87FF3, 0x2703E6A4, 0x43FF9D58, 0x0FEF717E,
    0xFE75609C, 0xF0BE910F, 0x3AB04E07, 0x40C0A3FF, 0x56092FF3, 0x789C7FE7,
    0x4E07E05B, 0xF2F276B0, 0xAF3F24B5, 0x9CAE8F3D, 0x252B78D7, 0xA47E1AEF,
    0x1E22BEA7, 0x7568647D, 0x7DF0DFFE, 0x04E6098D, 0x9FFCEA88, 0x4C014BE1,
    0xAA1493A8, 0x20027FF3, 0xA9C08E55, 0xDCED812F, 0x6AD3D472, 0x5BA11D2A,
    0xD2A549E4, 0xF08EBC16, 0x2D34F270, 0x7541ECA9, 0x9784BFFE, 0x82609BE0,
    0xFE756C06, 0xC25454D7, 0x9A827984, 0x9FFCEAD8, 0x4A6B6BE1, 0x3A8A9398,
    0x49300FFF, 0x80000958, 0x4FA00ECE, 0x8A0F69FD, 0xA0084FF7, 0x1ED3EBDF,
    0x409FEF14, 0x6B4E2D77, 0xE6EF6A50, 0xB4E2D774, 0xD3B6A506, 0x0DE05594,
    0xC0AF74FC, 0xF38CFE16, 0x9F1D6505, 0xF7E0744F, 0x17D9FEDF, 0xFDF81D35,
    0x5C767FB7, 0xB11AB28D, 0x1A63B905, 0xFFDF1793, 0x3BBAD2AD, 0xFEF8B96D,
    0x0D1E37B4, 0xFDF173C5, 0x750787B7, 0xFDF172DA, 0xFF52CDF7, 0xEF8B968A,
    0x77AE9D2F, 0x7C5CF51F, 0x2858F7CF, 0x0F8BC0BB, 0xAC8FB21E, 0x076F0F5F,
    0x35A4ED7E, 0xF3A8F40B, 0xA6FAD33F, 0xCD0227E7, 0x5D34772A, 0xD364F872,
    0xF0E4BA68, 0x1A3C5341, 0xC09E30B5, 0x2D7741CE, 0xF9FC9BCE, 0x74A71E01,
    0xD83DE2D7, 0xD345CA92, 0xA9438B5D, 0xF8799C35, 0xFCEA81BE, 0x206BE19F,
    0x9DC45627, 0x54BF9F6F, 0x722B1C36, 0xE127DF6B, 0xE4567DAD, 0xC3F23ED6,
    0xC8ACFB5B, 0xC3647DAD, 0xD28CFB5B, 0xF3653783, 0x83D28D83, 0x52781537,
    0xDDDEF49B, 0x60577F9F, 0xF9EC95BF, 0xD49E38B1, 0x71E9CEA6, 0x57E6E54F,
    0x05FEF7BC, 0x9C5039F7, 0xE7515F9B, 0xA4A7B8F4, 0xDEA2BC21, 0xCEACE57E,
    0x41289CFF, 0x5C139018, 0x0FFF3A8F, 0xB01C0146, 0xFE75640A, 0x498089E7,
    0x840249C2, 0xE37CD209, 0xD0760E7C, 0xC1D07662, 0x3760A9EE, 0x4B1B38F5,
    0x6CE3DC97, 0x36B1E87D, 0xA2F4B15C, 0x5B1F98EC, 0x947DAC3B, 0x7CE8369D,
    0x650B2C61, 0x8F05DAEE, 0x7987537A, 0xE69AE76F, 0xF02E4CA6, 0x812EF13C,
    0xCDE81CB4, 0x4DA1E95B, 0xDE25C6D7, 0x585B07B4, 0xE1AE365F, 0xBB0F498B,
    0xACA392C0, 0x35E87456, 0xEF386B81, 0x3C633838, 0x8E5B9DB2, 0x0F5E827A,
    0x2D83DA6D, 0x687AF411, 0x792C0BB3, 0x0F70D6A2, 0x46AE2F27, 0xE509FF9D,
    0x24377B2F, 0xFF9D4FC8, 0xE7B10573, 0xFE7563F7, 0xF86B1DDF, 0x125ECB67,
    0xB567E0BA, 0xFF9D5C3D, 0x96E7225F, 0xF9D5A29F, 0xF45A25FF, 0xEAC795F3,
    0xCCCAFFFC, 0xAA65C1F3, 0xBC37FFCE, 0x63CAF9E5, 0xEE27FE75, 0x3EFF96C0,
    0x2D7FE756, 0x3E1F2D86, 0x4D7FE756, 0x95F3C61E, 0xAFFCEAC7, 0xFF096215,
    0xFFCEACB7, 0x7CB745B9, 0xFFCEACBD, 0x7F75A4B9, 0x8E3E72E2, 0x6D7A1FD2,
    0xFFCEADEE, 0xF26F4779, 0xB9D8F2DF, 0xEAE4D883, 0xFFCEAD7C, 0xFD02886B,
    0xFFCEAD05, 0x7CF2D815, 0xFF3AB1E5, 0xF05D0E4B, 0xF9D58FBF, 0x4F211E5F,
    0x3AB1F7FF, 0x16BE87FF, 0x3AB42FF2, 0xB52887FF, 0xAB1F7FF9, 0x10293FF3,
    0xCD8157E2, 0x849FF9D5, 0x32E07CF1, 0xFF9D5100, 0xFCDA9503, 0x8C7AAA13,
    0x3A595E4B, 0x4F8793E0, 0xA36952A7, 0xCF9A1914, 0xA36952A5, 0x9D5A1914,
    0xED7C33FF, 0x9804D84C, 0x4A27FF3A, 0xD05612FC, 0xF3AA9400, 0xA57C033F,
    0xAD935021, 0xD242FFCE, 0x06700684, 0xCFFE756A, 0x82597DF0, 0x3AB42709,
    0xFAF867FF, 0x6A618461, 0xF0CFFE75, 0x0E531355, 0xF38AD7E0, 0x4E5687ED,
    0xCB738F3D, 0x7CE28F51, 0x1E3D79FB, 0xDDEBA74B, 0xB687A947, 0x285B4748,
    0x06FA55A3, 0xDE99E652, 0x5D9E45BA, 0x068F02F0, 0x42D646D8, 0xAB7A6799,
    0x60413FF3, 0x10094260, 0xADD4817C, 0x0004FFCE, 0x4B94DC0C, 0xFFF9D582,
    0x04120C4D, 0x70B4A448, 0x0E57FE75, 0x00901018, 0x9D42C44D, 0x981B89FF,
    0x1422C260, 0xF3AAFC24, 0x81AF867F, 0x5444D40C, 0xDF0CFFE7, 0x4DE55097,
    0xFFE755EB, 0xC26A5F0C, 0x9D4BC93C, 0x2F7C33FF, 0x5356D371, 0x904A7F3A,
    0x13F81D81, 0x4129FE9C, 0x40FC0ED6, 0x3F8F77AF, 0x0768F26F, 0x7BAB8279,
    0xC37DCAF3, 0xDF13E19F, 0xE6E559F8, 0x6F89F0CF, 0xBE8960FC, 0x0B1EFEF8,
    0xF1781765, 0x37595FFD, 0xBE2E78A1, 0x8EF6BBFF, 0xBE2E78AF, 0xE3F0F53F,
    0xFEF8BEC6, 0xC516A0E3, 0xA3FDF173, 0xE05F79E8, 0xD647F7C5, 0x2F02F4E2,
    0xC0F7E7BE, 0xDE896E9B, 0xF252BE3B, 0x72804777, 0xE2EC81D8, 0xE55905DD,
    0xD1BF60FE, 0x0E28B642, 0xD1F8D324, 0x5DD0B642, 0x286B2B8B, 0x1BEC4D5E,
    0xA7F858FD, 0x727716BB, 0xF41AD349, 0xCB9BCB4D, 0xF72CA688, 0x06F1B460,
    0x39E812FE, 0x34772ACA, 0xA4F8725D, 0xCEC85A34, 0x0AC54D37, 0xE53C16D2,
    0xE86AF1A8, 0x9E4DB791, 0xB07A6AF1, 0x7B937D05, 0x6E4BDD30, 0x9BC6AF4C,
    0x8637A73A, 0xF9DDE1E2, 0x1B2A59F6, 0xB5B9158E, 0xF6B7848F, 0xFDDEF499,
    0xDA0577F9, 0x4FDF6B41, 0xF514F68F, 0x3445CF46, 0x2C45A9A2, 0xE611D9FE,
    0x7DC177BD, 0x4767140E, 0x588B53F8, 0xFE926B9C, 0xE9279CAF, 0xBF74935C,
    0xD3A49E72, 0x25FD4B0E, 0x43494DEF, 0xDF3BF578, 0x6F792F3E, 0x961DA7EA,
    0x4FADEF22, 0x59E0F77A, 0x5001FF9D, 0x84A70980, 0x0741D867, 0xE8ACB1BB,
    0x2760BE72, 0x1BE5630E, 0x2ECA6BE7, 0xE6EC13D9, 0x958760A9, 0xA05C97CF,
    0x5631B3B5, 0xE769F585, 0x3B365E23, 0x0DA760E8, 0x9A1F5897, 0xCBB0549D,
    0xD92BD396, 0xB346D683, 0xDA760E83, 0x18C3A0D0, 0xB87A3B2B, 0x5F38DF2F,
    0x0AF4E478, 0x769D9476, 0xBE97A5B0, 0x15E96528, 0x5D83B2EC, 0xC7E87D2E,
    0x29A0DAD9, 0x14F431BB, 0xA760E83B, 0xECDCAC97, 0xE3DD83A0, 0x6531AC6C,
    0x96B18DA7, 0xE1E182D8, 0x3860AC54, 0xC63711C2, 0x37BB79AB, 0xD7BD81EF,
    0x73D0B7F1, 0x0F785A14, 0xDB4E1D65, 0x8A3F5FBA, 0xBAF03725, 0x65E0F734,
    0xA8F0F6C3, 0x09AF5C35, 0xD7BCE70C, 0x29EDA2C0, 0xD1D94E28, 0x5A8C85A8,
    0x3418DF6A, 0x74E1E652, 0xFCEAD517, 0x9FF0A1BF, 0xFF3AA996, 0x3FAD7973,
    0xFFCEACB8, 0x07D48F15, 0x5FF9D597, 0x59FC6D58, 0xE479BA1C, 0xA8D125D2,
    0xB10AFFCE, 0x562DFF84, 0xF168FFE7, 0xCEAC5BFE, 0x9E5B26FF, 0xF3AB2CFF,
    0x7E5C7BFF, 0xE75531A2, 0xC49AF7FF, 0x756C000F, 0xE66E57FE, 0x3AB2CFF9,
    0x792243FF, 0xEACB83FA, 0xDCDECFFC, 0xAB6055F2, 0xF34B3FF3, 0xAD8157C9,
    0x92DAFFCE, 0xC32CFF9F, 0x6C372455, 0xAF059F1F, 0x655C9A19, 0xFFF3AB1C,
    0x01F8BF2E, 0xFFCEAD80, 0x4FC786FB, 0xBFFCEAC5, 0x57DE9A59, 0xFFCEAD81,
    0x0FF7B85B, 0xE7FF3AB1, 0x06DAFE78, 0x9FFCEA60, 0x007E0557, 0xFF494F60,
    0xDC917F82, 0x47FF9D5B, 0x276CFF9E, 0xAFFCEA82, 0x5AFE3A63, 0xD97FE756,
    0xB2D7FE1E, 0xE84BFF3A, 0xD72D7F82, 0x63FD2813, 0xE756971F, 0xCF74797F,
    0xF9D59727, 0xF9FC3C3F, 0xFF3AB2CF, 0xFFC39E87, 0xFF9D5B00, 0x47FD1C63,
    0x4FE88D9C, 0x2344885A, 0x7B9CDEBF, 0x3A9C8956, 0x9E78A3FF, 0xF3AB2CFF,
    0xF8E54A3F, 0x247E65C9, 0x855C83A2, 0xC7FE7563, 0xA4F94827, 0xE940EC98,
    0xB4B8FB1F, 0xF293FF3A, 0x113B67FC, 0x94596B9C, 0xA7A0AE55, 0xF00CFFCE,
    0x94A12215, 0x7FE75500, 0x2442A525, 0x75710294, 0x149257FE, 0x80DA1290,
    0x1FFF9D54, 0x73A01EF8, 0xFFF9D556, 0x1F12A451, 0xCEA5C241, 0x348009FF,
    0x57806941, 0x019FF9D4, 0x09D495D1, 0x65B06EFC, 0xBDE3578C, 0x589BE94F,
    0xA91DA1E2, 0x88DBF9B4, 0x64C51037, 0xD33CCA6F, 0x2D8DAC1B, 0x5B02F7A1,
    0xA9BFF9D4, 0x42523926, 0xE3FF3AB9, 0x54262701, 0x01887E05, 0xA8FE9DF4,
    0x0427EC85, 0x5B156FD0, 0xA827FBC6, 0x1AD34E3D, 0xA0749727, 0xA537E8F1,
    0xE19FC11D, 0xE514BF13, 0xF867F368, 0x85CE97C4, 0x13E19FCD, 0x96C85A3F,
    0x0DCA5E1E, 0x07634CB6, 0x353FDDFE, 0xE96B0D4A, 0x5CFC94AF, 0x9FDF17D2,
    0xC62A2E77, 0x3BCFEF8B, 0xC5CB4E0E, 0x8E2BCFF7, 0xFBE2E79E, 0x681D514B,
    0x6F9EF8B9, 0x1711D28A, 0x7BEB06FF, 0xBFC5F72E, 0xB9D0FAC1, 0x2D93E2E3,
    0x1BB00FCF, 0x5159FC2F, 0x2C2CCFDD, 0xBFDA3945, 0xA0EB23E6, 0xF96D34E2,
    0x7BD1D871, 0x584B53C7, 0xB4D48EE5, 0x1E97D63F, 0x8CAF7144, 0xF3BCC5B0,
    0x8FF72AC3, 0x6945B216, 0x8A54E25E, 0x859514D8, 0xE0559A4B, 0x2E16540D,
    0x37DBECE9, 0x5A2BA770, 0xA0F60D68, 0xEC1A4B93, 0x143B0E37, 0xDD9E3A0F,
    0x85A3AB86, 0xF32956EC, 0x62B35EC0, 0x512DA779, 0x33642D13, 0xD29F656F,
    0x0FE2D774, 0x05B02BDD, 0xBEDFBDEC, 0x469AC981, 0x0AF90376, 0x279346E4,
    0x85A3BCB8, 0x39CCA16C, 0x97609ABD, 0x06FA2582, 0xBA95A942, 0xEF49FD02,
    0xBDE90FDD, 0xA05773FB, 0xFCDDEF49, 0x7A4D02BB, 0x0AEFEEEF, 0x777BD26C,
    0x3B605773, 0x8F4BED68, 0x88B514F6, 0xA611D9C5, 0x4AFE3D1D, 0x64A53EC9,
    0x3D1DA7DF, 0xB5308ECE, 0x26B9C588, 0x93CE57E9, 0xFCF7ED74, 0x957A73B1,
    0xC96A5876, 0x10D2537B, 0x7DBE755E, 0xD5E9CEC6, 0x979EFDAF, 0x769537BC,
    0xB7BC8A58, 0x3C1EEF48, 0x613FF3AB, 0xC1203004, 0x3A1F54C4, 0xB16BD5D8,
    0x683E76B6, 0x26F13166, 0xD82E9F5A, 0x358D9CC3, 0xED2C636F, 0xD0C6B17C,
    0xCA92F5A0, 0xCBE358C6, 0x2CA7CE37, 0x3B58D4F1, 0x37C6B18C, 0x6FCAC6D6,
    0x3760AC63, 0x630A6EC1, 0x765343B1, 0x5CF1EF95, 0x5CAA9BB0, 0x83A0ECD8,
    0xCA9AC61D, 0x6F97CE37, 0x1BB0740A, 0x7653654F, 0xF3B46EC1, 0xCED2C2C1,
    0x38FD0FA7, 0x163671FB, 0xDF3B9B5A, 0x59AADF38, 0xCEC173D9, 0xB312F5A0,
    0x15760E83, 0xEE1AC6D6, 0x1D838FD7, 0x1D0592C6, 0x41D9B2EC, 0xAE4BBB07,
    0x6EC1735C, 0x8F65D82A, 0x7ABB0563, 0x8D95D62D, 0xF65D82B1, 0xC6D3B05C,
    0x320F6258, 0xC176B4A9, 0x61D942C7, 0x16D25C53, 0x71DE70F4, 0x7CD82C70,
    0x50D5E351, 0x98A95276, 0xE47A51E2, 0xD5E30BED, 0x5F6F23D0, 0x3D3578D2,
    0xD2BBA1F4, 0x129547E6, 0x6B5117CC, 0xF24F115B, 0x6E5A7B42, 0xC62815EF,
    0xE7E1B9AB, 0xE2FB5A71, 0x5B279F86, 0xF60DE374, 0x687B07DE, 0xECDEA2EF,
    0xBC9E4B02, 0x3DA657A2, 0x320D32D8, 0x49D834E7, 0x42D1D2A7, 0xAE46AF1A,
    0x7D3D1378, 0x9A4DE152, 0x0BEF7097, 0x7A1E228F, 0xE83C2B41, 0x1C5AF2D7,
    0xACA46D0E, 0xB6504F41, 0xEB282E3B, 0x5B1B4C08, 0x63025DE2, 0x609AEC09,
    0xB0741BDE, 0x9C35881B, 0xB2BFF3AA, 0xAC513E4B, 0x79A074A5, 0x51D3D26F,
    0xF607A39C, 0x474F8784, 0x9D47AB10, 0xF9FC3DFF, 0x7FE75627, 0x2D3FDEE1,
    0x43BFF3AB, 0xEAC4FF3F, 0xF1D31FFC, 0xFF3AB2D3, 0x6F7F1BBF, 0xA519AFBF,
    0x58E15726, 0x595FFF9D, 0x756593F9, 0xAEF37FFE, 0xFCEAC50F, 0xFE791FCF,
    0x9FF9D589, 0xB143F8CF, 0x322BFF3A, 0x9D5960FE, 0xFC7915FF, 0xFF9D5899,
    0xA1FDE115, 0x8B673998, 0x33340ED2, 0xBDEC42A2, 0xFF3AB7B9, 0x9FE796B3,
    0x59FF9D58, 0x589FFBBD, 0x8EE1FF9D, 0x9D54DBDF, 0xD77EF5FF, 0x2E5ACB07,
    0xE1E13CF0, 0x3CF02E5A, 0xF3AB86B1, 0xFCF25EFF, 0xFFF3AB13, 0xC50F9EC6,
    0x7B9FFCEA, 0xDBC4FF3F, 0xEAE41DD6, 0xFFCEAD7C, 0x689FE172, 0x12FFCEAC,
    0xD588AFE8, 0x9FCC5FF9, 0xFE75627F, 0x27F90B97, 0xE17FE756, 0xBF1807CF,
    0x522FFCEA, 0x9D58A1F1, 0xEFE363FF, 0xFF9D57ED, 0xA27F1B63, 0x87FF3AB1,
    0x651FEA26, 0xBC8FFE75, 0x9D5899FD, 0x5FC263FF, 0x1FFCEACA, 0xB143FA70,
    0x1E47FF3A, 0x928E287F, 0xB03C5A4F, 0x43FF9D45, 0xAC50FE56, 0xCC48FFCE,
    0x9D5899FD, 0x1FC651FF, 0xD123F32C, 0x63E2AE41, 0xCD27FE75, 0xEAC513E3,
    0xF85A4FFC, 0x0EC98A27, 0xD858FE94, 0x24FFCEA3, 0xB2E07CF4, 0xBB93FF3A,
    0xD59703E5, 0xDC973FF9, 0x7B130E07, 0x2C3F9CF7, 0x8177A071, 0x076D60FE,
    0x81594C5A, 0xFF9D5B47, 0x8B800A93, 0x966B6260, 0xE861CF7B, 0xBDCB347B,
    0xCFD0C1E7, 0x5C969D25, 0x59D92592, 0x2713FF9D, 0x7D11257A, 0x67FF3AB6,
    0x0045C2F8, 0x0FFCEAD0, 0x612F00D4, 0xCEADC200, 0x84BE19FF, 0x75157C1A,
    0x4DF0CFFE, 0xD4C2A037, 0x9BE0BFF9, 0xAD94042A, 0xBE19FFCE, 0xB65010A8,
    0x2067FF3A, 0x408800CA, 0x0CFFE756, 0x3BCE405F, 0x2CA04D68, 0xD3B3578A,
    0xE878DCAD, 0xB5650779, 0x0D2EC12D, 0xB28E25B2, 0x9D503596, 0x980009FF,
    0x3A874CAB, 0x700013FF, 0x3AAFE334, 0x007813FF, 0xC810400C, 0xA90FFCEA,
    0x40052016, 0x0CFFE751, 0x2F80BF5F, 0x0CFFE757, 0x8CE2045F, 0xD67FF3AB,
    0x9C4AEF09, 0xFFF3AA98, 0x722697C0, 0xFFF3AB92, 0x6D09B7C0, 0x3FF3AB00,
    0x484ED530, 0xDFA00D33, 0xF81D83EB, 0xF7E80213, 0x7E0760FA, 0xBDFA00C0,
    0x1F81D83E, 0xF87E8028, 0x427F03B7, 0xBF15FD00, 0x0301F81D, 0x60F8AFE8,
    0x0084FE07, 0xD83E2BFA, 0x4C101F81, 0xC340E569, 0xEA9AF81B, 0x69DA7B74,
    0xFD536EFA, 0x87CA717A, 0xF84C21F2, 0x7D25D347, 0xF8D32D83, 0x769704F9,
    0x12D81566, 0xF87AFFC6, 0x7329CEA7, 0xF57E62FE, 0xFEF8BD2B, 0x5B082EEF,
    0x353FBE2E, 0x7C5CB4B6, 0x8B6F7DFF, 0x4FF7C5F7, 0x172D837D, 0x86353FDF,
    0xFEF8B9E2, 0xE0F78B81, 0x36C7F7C5, 0xDF172D65, 0x81782DF3, 0xE0B69F17,
    0xE2FCD729, 0x6A7D60DF, 0xB64F8B89, 0xDBC9BF3C, 0x796C9F17, 0x17E2AC3E,
    0xFE796C9F, 0xA5C0ED1C, 0x0FF13F28, 0x6536C6EF, 0x6829FF1D, 0xD38979A5,
    0xB2B774AE, 0x8156199F, 0xEF5D3037, 0x94A960BE, 0xDEBA6CFA, 0xB642D1FE,
    0xBD7EF14C, 0xC9C5B43D, 0xBD73FD25, 0x9176FBB7, 0x86EF6B4D, 0x87642D1D,
    0x58323A85, 0x92DE2FA2, 0xB61A981B, 0x34E83522, 0xBAC83D4D, 0x26FB0E26,
    0xD77483D0, 0xD2EBC0E2, 0x307B9DDE, 0xD026E3A4, 0x27E606F0, 0x2EEFA558,
    0x6ED223AA, 0x5A705A9E, 0xDE5C13C8, 0xF30B457F, 0xDF8FB840, 0xEC1BECC0,
    0x2D4ED0F1, 0x0DE16CA6, 0xFB862D4C, 0x55A40DF8, 0x48F18B69, 0xC74A52A7,
    0xEB8778D5, 0x2F0B196D, 0xC6E5B1B2, 0xFFCEAD27, 0x10032520, 0xFFF3AB90,
    0x0100A4A6, 0x87FE7572, 0x11201819, 0x7FF3A9C0, 0x03030071, 0xBFFCEABD,
    0xC49F8028, 0xF49A0576, 0xDE90FDDE, 0xA0577F9F, 0xDFDDEF49, 0x7BD26815,
    0x9A057737, 0xAEDDDEF4, 0x08EEF6C0, 0xED33970F, 0xB252B1E8, 0x47D9294F,
    0xFB5C7A3B, 0xF4E7633D, 0x57A73B0A, 0x3AB3DFB5, 0x257093FF, 0xEAA40006,
    0x0410AFFC, 0x59011356, 0x05D7FF9D, 0x75320202, 0x565ACFFE, 0xCEA744E2,
    0x0A3604FF, 0xCEAD4041, 0xB13980FF, 0x3AB51213, 0x920103FF, 0x53001029,
    0x87C4FFE7, 0xAC250984, 0x613FF9D5, 0x04E10703, 0x89FFCEAE, 0x84C4D304,
    0x4FFE7552, 0xC4800C44, 0xFF3AB889, 0x264E0337, 0xFCEA3822, 0x0381B09F,
    0xF9D46800, 0x1818181F, 0x3AB21213, 0x0B11A7FF, 0xF3AB6808, 0x270060FF,
    0xFCEA8610, 0x8080873F, 0xFF3AB489, 0x44AE05AF, 0xFFCEAC04, 0x000557C9,
    0xF9D5C44C, 0x703037BF, 0xCEA64102, 0x130F89FF, 0xEAE01208, 0x1237AFFC,
    0xAB984026, 0x41227FF3, 0x5AC4A060, 0xE135FF9D, 0xD44D0867, 0x258FFCEA,
    0xC5094009, 0x4149D94C, 0x2E9D83A3, 0x355B28BD, 0xD058C6D6, 0xAFD8D1A0,
    0x663B071F, 0x947DA58C, 0xA697651D, 0xC58C6DEB, 0x69D83A0E, 0x17CED683,
    0xCD4958EC, 0x95D2BB05, 0x96F53DA6, 0x4B18DBDC, 0x29C9D82E, 0xC6F9788B,
    0x789A0CF9, 0x2A6EC173, 0x687663DF, 0xADAC6ECA, 0xF41F2B1D, 0x31B3A312,
    0xC1725E96, 0xBAF4B92E, 0x0E158760, 0x4B92F976, 0xF5B39F3B, 0xE71BE70A,
    0x94E6B82B, 0xF76517A5, 0x692A7B38, 0xA3D135D0, 0x2740EC1D, 0x035DEFAD,
    0x9DCDAD0B, 0xFB8F9C6F, 0x1DAC2AB0, 0xEC1D9C7E, 0x8D063588, 0x9BB054FD,
    0x7CAB9682, 0xF65D94CC, 0xDF2FB584, 0x3DAC6B18, 0x83A0DA77, 0x68A9AE5D,
    0xDE22CA7D, 0x3B8EC153, 0xF7DF38DF, 0x9665234E, 0x613D7A6C, 0xC6D74728,
    0x72DCED25, 0x0B4163D4, 0x05DAEE65, 0xE88CCA1F, 0x25A682A9, 0x6AF18969,
    0xC3DCEF78, 0x2F9B024A, 0x6F1ABC6A, 0xA3B3BA45, 0xB9D81E46, 0xDEA3C176,
    0x9C5C3C50, 0x6C1B8F1E, 0x9B23C531, 0x2D03F8B8, 0xF9D5C3DB, 0xE07C4F7F,
    0x45E0DDED, 0xF25BBDBE, 0xE0F6E371, 0x358692D1, 0x7A9DBE28, 0x06E548E7,
    0x0B0ACA46, 0xA4F6538A, 0xB968D3DB, 0xEAB28395, 0x04CD6579, 0x9B6BA565,
    0xD6E5E0F7, 0x240DE9DD, 0xBD1EEB6B, 0x352BF786, 0xE1AC4F53, 0xD397348A,
    0x4564E681, 0x3D81E934, 0xF1BFFCEA, 0xE75533EF, 0xE3EFBCFF, 0xE7FF3AB6,
    0x6FDB8FC2, 0x3349BC5B, 0xFFFCEA7D, 0xE380FF16, 0x5C9A8CD7, 0xB7656385,
    0x4B10ADD6, 0x3B9DAB38, 0xD75C3C50, 0x606F20C0, 0xDD69988B, 0x76B89262,
    0x3BC9A07B, 0x377B7DED, 0xD92DCE73, 0x4AAE48DB, 0xE9734DF3, 0xA65BA7DF,
    0xE12F7F84, 0xD924DCDE, 0x4F40B443, 0xDBFE9709, 0xFA502BC3, 0x3A8F6163,
    0x3F2D3FFF, 0x7FE75639, 0x6300FC09, 0xDE17FE75, 0x96076D7F, 0xF724DEFC,
    0xFD2E1A8E, 0xD92387B7, 0xC3C503BC, 0x849FF9D5, 0x6FBF39FF, 0xF06D8EED,
    0x5378069A, 0x5AF4188B, 0x5269FF9D, 0x6F024040, 0x25C969D2, 0x3AB59259,
    0x820913FF, 0x41028409, 0x0C07FE75, 0xA942442A, 0x3103FF3A, 0xA942442A,
    0xA6C3FF3A, 0xAA942442, 0xFA107FF3, 0xAA50910A, 0x1389FFCE, 0x942442BD,
    0x867FF3AA, 0xAF80AA2F, 0x0013FF3A, 0x58260170, 0xA9F3FF9D, 0x504D0804,
    0x9F3FF9D4, 0x5000400A, 0x02FFE751, 0x680A8FA2, 0xE14FFE75, 0xA99C001B,
    0xE54EBFF3, 0xAB984449, 0x054EBFF3, 0xEAE2004C, 0x02A33FFC, 0x53602011,
    0x83D06B5A, 0xF6E85AF1, 0xDDFC2D43, 0xE3915AA6, 0x545DDE7E, 0xE5B02BBF,
    0x03B0E395, 0x937A9A6B, 0x0DF77A37, 0xC53141AD, 0xFCD2A092, 0xF4D5CD70,
    0xB96E9BC0, 0x92D83D81, 0x528745CA, 0x2C11A7C5, 0x076437D1, 0xDD0C1EE6,
    0xEC2B0F22, 0x2DF9DB1D, 0x72E6EC81, 0xE87D0961, 0xC7EDA8EE, 0x9A56A503,
    0xC6813F6E, 0xF8A549AB, 0x913578A2, 0x88E9414A, 0xAF9A5B23, 0x6DEF4AFC,
    0xC8D0C839, 0x7B78372A, 0xBDBB339F, 0x213FF9D5, 0x814C4DE1, 0x27FF3AB8,
    0x09D80D50, 0x27FF3AAF, 0x80830300, 0x7FE75640, 0x001037A0, 0x3FF3AB20,
    0x89C48F10, 0xFF3AA081, 0x80A40627, 0xF3AB509C, 0xC044A27F, 0xA8406260,
    0x1504FFCE, 0x84001249, 0xA84FFCEA, 0xB0000416, 0xAA53FF3A, 0x57A05F01,
    0x5269FF9D, 0xF89A1208, 0x9E7FE755, 0x7A044A60, 0x15BFF9D5, 0x804021F2,
    0x077FF3A9, 0x41138492, 0x2857FE75, 0x54240626, 0x42BFF3AB, 0x080C2604,
    0x57FE7560, 0x28940836, 0x1FF9D5A1, 0x626AAA02, 0xFF9D5402, 0x263206A1,
    0x33FF3AB4, 0x24240915, 0xBFFE756E, 0x8012892C, 0x89FF9D46, 0x201024A4,
    0xBFF3AB34, 0x04E1174E, 0xFF3A8A82, 0x00FC03CF, 0xFF3AB412, 0x84C22E17,
    0xFCEAE412, 0x2848BE9F, 0x9D54C261, 0x250981FF, 0xAA626F3E, 0x80C2FFCE,
    0x42094249, 0x2297FE75, 0xAF020117, 0x4747FF3A, 0xA18944A2, 0x4123FF3A,
    0x41113780, 0xB93FF3AB, 0x4C100980, 0x1FF9D578, 0x18912C4C, 0xBFF3AB60,
    0x011380CA, 0xFCEABC26, 0x8124549F, 0xC037E260, 0x4D3B4C6E, 0xD24F5E5B,
    0x4E2D7747, 0x4A6E2D77, 0xE33F823B, 0x09F3F47C, 0x358A4F2A, 0x67F28F95,
    0x777FC4F8, 0x9F0CFE41, 0xF3748AF8, 0x67C4F867, 0xC33F9B95, 0x6DF67E27,
    0xF89F0CFE, 0xCFE0D1E9, 0x9E0F89F0, 0x9F0CFE3E, 0x7E8960F8, 0x23E5B11B,
    0x18EAF0F3, 0xA102F56C, 0x2168FF73, 0xB23E6E5B, 0x5F87AFFE, 0x145E7F7C,
    0x3FBE2E4B, 0x172D835B, 0x41CF5FDF, 0x7FDF1786, 0x2E5A7C1B, 0xFDBA7FBE,
    0xFF7C5CB4, 0x5CF15528, 0xCA6C7F7C, 0xE7BE2FAE, 0xC5C9629B, 0xEECB6F5F,
    0xB64F8BC6, 0xDF35FF3C, 0xFF13FE1E, 0x417CEEF0, 0xCD15946B, 0xAF8EF7A3,
    0xF605FC94, 0x9A4FCD2B, 0x4FCDB922, 0x5A4ED49B, 0xDEC0F334, 0xDF7A31A1,
    0xCA731414, 0x383BD33C, 0x86EDCA29, 0xCA5EF96D, 0xF96D86ED, 0x0DDB95BC,
    0xABE1F2DB, 0x96D86EDC, 0x6EDCAD7F, 0x4C4F96D8, 0xDB0DDB95, 0x272A03F2,
    0x69DA3AFD, 0xEF3748AA, 0x782958D0, 0xB85A9EC8, 0xF64DE6DE, 0xA0F734AE,
    0xD30C839E, 0x12D7C1BA, 0xE9BECD4F, 0xED0F12D7, 0xD86C96C1, 0x9D871583,
    0x507B4D1B, 0xBC95CE56, 0x90AFFDBD, 0x73FDDDFA, 0x90FCCEF1, 0x5C96A7B2,
    0xB3642D1A, 0xE0496B95, 0x692C1452, 0x952702F3, 0xC0B78F22, 0xAC83D4C2,
    0x91CDA46B, 0xD21A2F35, 0x3C9BC371, 0xCAF9F9DA, 0xFBDE8349, 0x7CF835AD,
    0x628DED65, 0xEE9A3945, 0xDA99E356, 0x83CF9F05, 0xBDE5C13C, 0x1C75E5A2,
    0xC5B2168D, 0x94562827, 0xAEF7AFA3, 0x6B481B9A, 0xDA1E9694, 0x46D626B4,
    0x589AD20F, 0xD2A06F1B, 0x3578C5BC, 0xC996C8B0, 0x25AC483D, 0xF9817DE3,
    0xC83ED4A8, 0x341E4C70, 0x95348D5E, 0x148D5E36, 0x82B15096, 0x315173BC,
    0x2F22E73D, 0x36160F5F, 0xCF05DA9D, 0x4B489E28, 0xCE83C3B0, 0xB0787396,
    0x9D5A5C3C, 0x022513FF, 0x75711356, 0x3002BFFE, 0xFFE753E1, 0x30DE00E2,
    0xEE73ECB5, 0xCFFE7541, 0x6427022A, 0x1987FE75, 0x75644C18, 0x002A4FFE,
    0xFE755526, 0xEAC01ACF, 0xA2FFF3A9, 0x75F24600, 0x346A3EDC, 0x2BB9FDE9,
    0xFF37A4D0, 0xDE9340AE, 0xA6815DBB, 0x8EBD69CE, 0xA7FE7528, 0x38909140,
    0x813FF3AB, 0x4BC49494, 0x215BFF9D, 0xE750D087, 0x300AFD7F, 0xFFE752E1,
    0x82049175, 0xF04FFCEA, 0xD5913045, 0x89609FF9, 0xFCEA280A, 0x26090C2F,
    0x0BFF3AB4, 0x49C24043, 0x44E7FE75, 0x756B127C, 0x9F1BD7FE, 0xFF3AAA44,
    0xA12A8DEB, 0xBD7FE756, 0xD5CC2531, 0x01E65FF9, 0xD0FA604A, 0x16C159FA,
    0xB760E83B, 0x4DD947C4, 0xA05C7BE5, 0x37661CE5, 0x2D95E6D6, 0xBB28EC17,
    0xE3CCD629, 0xF3A0D07C, 0x15BDF38D, 0x7E968635, 0xF694FD9C, 0x9FAF7651,
    0xC7DA58C2, 0x346831EB, 0xA7653673, 0xF29BB057, 0x30BE5725, 0x07418DD6,
    0xE86D293B, 0xA2EC177C, 0x8B3341F5, 0xCC53D0C7, 0xCA7CED62, 0xB5A14F12,
    0xCDA5C9C5, 0x15D94D0E, 0x1897AC3A, 0xCBB0741A, 0x8FB2B185, 0xD68A9BB2,
    0x1D0D3DA7, 0x97AD97D6, 0xF97D6938, 0xD3D0F9C6, 0xCC7CE861, 0x78A7B9E2,
    0x8C7E8341, 0xD49D82B1, 0xF5B4BA18, 0xA6EC1753, 0x8369F5B2, 0x97CE37CE,
    0x29AEB1EF, 0xE71BE562, 0x37CBE9F3, 0xEFAD97CE, 0xA2D4F671, 0xECA2F4EC,
    0x1A1630A6, 0x161738B4, 0x62B83E56, 0xEC1735E9, 0xC6CE872C, 0x760AEF58,
    0x92A4BA58, 0x3A0ECD06, 0xD2BE55D8, 0xB2EC1537, 0xA9BC4595, 0xF5B38F7C,
    0xB58B314D, 0x83694DF3, 0x7AC716D6, 0x72EC1D9C, 0x68DD2C61, 0x41A4E9ED,
    0x95358C2F, 0xC63671EF, 0xB5B0760A, 0xD3B05631, 0x2B92B5D6, 0x738F65D8,
    0xD68369CB, 0x38F537CE, 0x292F3B3B, 0xB38FD068, 0x2CBADAC7, 0xCB77BD08,
    0x0B9585E3, 0x04F7EC8F, 0x9B4DBA59, 0x32529F7A, 0x5FB4EA67, 0x16A1AC69,
    0x520B1AAC, 0x987B1BD6, 0x37A1BD33, 0x7B5A3C63, 0xA1ABC537, 0xC330F695,
    0x15A0769E, 0x64DEEA39, 0xBBDE970F, 0xBC752BF3, 0xCAC1E9E5, 0xAD3E0BB5,
    0xAF0F7BB2, 0xDC35A946, 0x7BCC3578, 0x3738A297, 0x7873D95B, 0x325AC41D,
    0xB89917DE, 0xD6505F9A, 0x1EDFABA1, 0x87B67266, 0xEF49D83A, 0xDDEC0F0A,
    0xF9DA97B1, 0x7B3025AD, 0x96C0EB28, 0x5B36796C, 0xF06B9812, 0xE95DEF68,
    0x04BBC621, 0xD07B74B2, 0x09693578, 0x28D07DEE, 0xA1E8171D, 0x5DC1BE1D,
    0x7A4C22EB, 0x1A3A0CC6, 0xC1EE7771, 0x54AF2D60, 0x6BEC0EE9, 0x4D8D16C9,
    0xF82ED4D9, 0x2F26EF60, 0x91CD66AE, 0xACF8712D, 0xAF01E0F0, 0x7C25B20E,
    0xDB90777B, 0x93D2DE1E, 0x8F05DAAC, 0x3FF3AB7A, 0xA643704B, 0xBC775B3C,
    0x5657EEF7, 0x77B9C35E, 0xDADEC4A4, 0xBBD7E9E4, 0xD5C3C503, 0x3FD95FF9,
    0x681E8679, 0x399B4EF2, 0x03A516E7, 0x2AF6A7AD, 0xDEC4668D, 0x3387B7B9,
    0xD02B7EC3, 0xC41C5B5C, 0x0BDADA62, 0x694DF74B, 0xC5AC1E29, 0xC337935C,
    0x49B9CC5A, 0x3B8EE3B2, 0x0962143B, 0xEE6719EF, 0x9C7C7D1D, 0x4F417423,
    0x4FBFD291, 0xB78784B7, 0x31E12C42, 0x2C42B7B7, 0xE41D95E1, 0xC9471C2A,
    0xBDEE12F7, 0xEB09EEF6, 0x4F77B596, 0xCD481E90, 0x5DAAC768, 0x42B70DE4,
    0xDED2E12C, 0xD7EC681D, 0x12C3F9EF, 0xE05DE7BF, 0x75EFD275, 0xFCD26924,
    0x4B5EF5D1, 0x6BADA1F2, 0xDB581742, 0xDAD2BBD9, 0x52815DA1, 0x9A75B820,
    0xE056514A, 0xFAF00ED1, 0x41BC9E2D, 0xC92BD4CB, 0xCCB59486, 0x59471891,
    0xF18914CB, 0x0B2293E8, 0xEBF4798A, 0x476B4AC0, 0xB4AC0E93, 0x3FFF3AB6,
    0xC0C81A84, 0x1CAFFCEA, 0x75081070, 0x380E57FE, 0xF3A86849, 0x965F083F,
    0x9FF9D540, 0x99030050, 0x083FF3AA, 0xEAD04DDF, 0x14405FFC, 0x5A9CCC4C,
    0x3860F730, 0x3B19E8A2, 0x7C6E875E, 0x693BF7BD, 0xF1D7B96A, 0x81B93356,
    0xA1E9D42D, 0x69534D77, 0x9C2D487E, 0xDE9B8BAE, 0xC8A4BDDB, 0x1569AB8B,
    0x369A91C5, 0xD4646F6B, 0xBD7397D2, 0x86E7AFB7, 0x8EB940AF, 0xDCEC31EC,
    0xD630F983, 0x8C6EC17B, 0xEF1E0357, 0xDED59069, 0x22AD3E1E, 0x358A693F,
    0xE3892D4F, 0x53614A9D, 0x16549ABC, 0x96F3C1EF, 0x0F12F40E, 0x456E6506,
    0x9E012DD9, 0x16C8B482, 0x96173A34, 0xA56EF604, 0x0BC9A8E6, 0x48372A74,
    0x1A01D6D6, 0x3FF3A8F6, 0xE1088010, 0x81FF9D47, 0xD0117552, 0x389FFCEA,
    0x02427011, 0xC4FFE755, 0xEACB95F0, 0x93089FFC, 0xE7541139, 0x0E00027F,
    0x3FF3AA10, 0x0605FCA1, 0x13FF3AB4, 0x700898DA, 0x053FF3A9, 0x5430857C,
    0x130A7FE7, 0xF9D4FABF, 0x0025269F, 0x69FF9D50, 0x57201652, 0x80E57FE7,
    0xD57E2609, 0x0BA75FF9, 0xFF9D4E81, 0x700788D3, 0x9AFFF3A9, 0xBC7E2695,
    0x8DC13F41, 0x5716BBA6, 0xFCE906A4, 0x13F64129, 0xBC53BE6A, 0xE8DBF777,
    0xD2A5BF1B, 0xD38B64DD, 0x3794C034, 0x0E2D7749, 0xF02ACBF6, 0x9589F206,
    0x1E8B6372, 0xD90B47F5, 0xBB588DC2, 0x623737A8, 0xFC3F6F49, 0xC1F13E19,
    0x04F5DF7E, 0xFC1D15AB, 0xBC3F5F99, 0x6FF92944, 0x2940B623, 0x05D91F1D,
    0x7E7DF7AB, 0xF7C5F61C, 0x173DD287, 0x676F7FDF, 0x59FF7C5F, 0x7D817D12,
    0x9EB5BB03, 0x7BD0E302, 0xF2F17EEF, 0x1F772634, 0xB3D181AE, 0x0F50774F,
    0xB23E6A7F, 0xD2BF60FE, 0x7779F9E6, 0xEE9CB8C1, 0x58364BFE, 0x7991FD12,
    0xB53F4576, 0x31F4D2E4, 0x6D092C1E, 0x6F7ACF8D, 0xF2D93B42, 0xEC9E88FA,
    0x6DB04F81, 0x5BF748AD, 0x9560AFEA, 0x68E514BB, 0xDBB82AC3, 0x82AC05E9,
    0x06F169BB, 0x82AC190F, 0x896399BB, 0x3F94D3BF, 0x7D96DFF3, 0x5FE6FB93,
    0x81D890B4, 0xD485A2FF, 0x765364FD, 0x1F46FBD3, 0x37C8ED56, 0xCB642D17,
    0xEF7AF87B, 0xB417A1AA, 0x5A6B6914, 0xC56C377B, 0x5A279DC3, 0x713E16C8,
    0x03F46FA1, 0xB6F435BB, 0x57E34CFA, 0xAD23ADA4, 0x7644041B, 0xEA8EBC01,
    0xDA43B078, 0x3A55BFFC, 0x3EDE1680, 0x7E690EBC, 0x477314D2, 0xCBC0D90B,
    0xF16D2BBA, 0xB74EC39A, 0xC1C92951, 0x7425A748, 0x5F35E2D7, 0x04B5943C,
    0xB74BA565, 0x687CFC8E, 0x7E4FD06C, 0xBD069394, 0x55C4F477, 0x1FAE761C,
    0xC827B9D7, 0x4EC6E34B, 0x6B29F453, 0x7DC89F3E, 0x2583C9F3, 0x376515A0,
    0x52DDBDED, 0x5BA8F1AF, 0x76E54B8A, 0xD0F6D77E, 0xB9D15E76, 0xC0B73B07,
    0xCAB0FA1E, 0x98DBAEFD, 0x37DEF78B, 0xE0F5E830, 0xF87E8605, 0x86F03791,
    0x3B3940AF, 0x6E3D34B5, 0xB790DD62, 0x2BD5CB77, 0x39945A1E, 0xEA7286BF,
    0x380F4FFC, 0xC7FE751D, 0x95DC3001, 0x933F0B5F, 0x6815DCDE, 0x83D83943,
    0xD934F6F5, 0x9E8D4583, 0xA914A5A4, 0xEDE9A9B8, 0xCF27691F, 0xA9EF0969,
    0xC1586D69, 0xAF4B1B2E, 0x38FD9760, 0xEECA2E1B, 0xD838F671, 0xE27FF3A9,
    0x9D435494, 0x822813FF, 0xC2FFCEA5, 0xBB078810, 0x58527609, 0x6CBB05EF,
    0x8398A7AC, 0x5D3E769D, 0xB687D39E, 0xB92E743E, 0xB3DD82A7, 0xB10D58E4,
    0x29BB2998, 0x3C7E87D6, 0xF1ACA786, 0x179760EB, 0xF41A4AC6, 0xA6EC1C58,
    0x652E5D82, 0x4378A385, 0xCA63F12F, 0x57AD1B2E, 0xA3D82EB6, 0x671EB18D,
    0x8B3B29A3, 0x317A59EF, 0x725F3B07, 0x97D81EBD, 0xD692F95C, 0x7CEC1737,
    0x1B38F5C9, 0x8769C963, 0x369631B3, 0x838DD83A, 0x41B4BBDD, 0x735CBB07,
    0xEFA58C68, 0xF38729A9, 0x8B45F38D, 0xC39D82E7, 0x3B41B4EC, 0xB18DBDD8,
    0x8F694958, 0x4BE740EF, 0x5CBEB41A, 0x5D2C636F, 0x725F2EC1, 0xA74DD615,
    0xEBD392E9, 0x96158C6D, 0x158C2CA5, 0xF5B3B2EC, 0xDA5CBB05, 0x789D83A0,
    0x93B07696, 0x761D945B, 0xC686D3B0, 0x7D95D6CA, 0x341F4B18, 0xDD83A17A,
    0x1D0D9CF8, 0x7A0DA7D6, 0x05CDD82E, 0x82FAD03B, 0x8F44D4DD, 0xEC1788B2,
    0xD059E4A4, 0x2EC17D61, 0xB0763717, 0x61630A93, 0x896ECA2C, 0xB92F89D9,
    0xAC6365F2, 0x1D94585C, 0x3B1F5874, 0x9ED2C631, 0xE158760B, 0x2CC760B9,
    0xC7A14FD6, 0xECE3D76F, 0xE22DF5A4, 0x1F8B41A1, 0x71BB0767, 0x6B0AC636,
    0xBBE71BE7, 0xF6B4A7E8, 0x4EC17651, 0xAE9D82EA, 0x5D838FD7, 0xA58C292E,
    0x72EC173D, 0xBD3B298B, 0x2DA5E958, 0x9D0692EB, 0x41B4B18D, 0x92ECA2E7,
    0xCBB05F4B, 0x1A340B15, 0xB18DD83B, 0x760AF5A0, 0xB5FB2EC1, 0x31D83B58,
    0x9631B58B, 0xCBB05E18, 0x25DD9475, 0xF5A4AE57, 0x53676961, 0x0772EC76,
    0xC7E66CBB, 0x2F5B2EC1, 0x87D3B071, 0x760E66D6, 0xED3B0570, 0xDCD0FA7C,
    0x1DA58587, 0x8B29F4EC, 0x7C5BC778, 0x30AF95C9, 0xBE5725D6, 0xB07694F0,
    0x17D62D03, 0x677340EC, 0xE2D7AC63, 0x5170725C, 0x3B2EC176, 0x1B5A1617,
    0xCED3E963, 0x4F95C977, 0x7E83B057, 0xB071EF9C, 0xD82A7A93, 0x0B9E8369,
    0xD0FA4E76, 0x9B2EC1DA, 0x631B3B39, 0xE94D725D, 0x7A0DA735, 0x6364D59A,
    0xE5F5A4AC, 0xE4BBE71B, 0x4D9725CA, 0x3B05CDD9, 0x0C78746D, 0x760BB28B,
    0x73AF4EC1, 0x6CBB0741, 0x6BBD7A5D, 0x1CD7A788, 0x2BCBB29A, 0x0AA6EC1C,
    0x1C5A0C3A, 0xA0D0C6EC, 0x369D94D1, 0x95E96568, 0x6B29630F, 0x2CEC1CCC,
    0x9A0D0DC7, 0xC2E5D839, 0x3587CED2, 0xBB057ADC, 0x4EC1585C, 0x0ECD9CCC,
    0xCF4DD83A, 0xD06D3B05, 0x349C7AF5, 0x462760E8, 0x9DC5EB6B, 0xDAC6B18D,
    0xF83B28F9, 0x977C0D74, 0xC0D74F86, 0x6C0E7671, 0x699ECEE1, 0xF2DA3C45,
    0x6CAE3496, 0x2D83DA41, 0xCA9A940E, 0x78A0578F, 0xBC6F5F9F, 0x85AFD25C,
    0xDBF1AEF6, 0xE305AA5E, 0x0EA73295, 0xBDA9657C, 0x7E750777, 0xCA6C38E5,
    0x3636D68A, 0x1CD79CAD, 0xAF3C543E, 0x417E6954, 0xDA796C8B, 0xD81CB481,
    0xD9AF3D17, 0x5DA9B234, 0x392C51F0, 0xDB95CDB0, 0xA567DEC6, 0x6412C104,
    0x2FA8788A, 0x568F115A, 0x64B2A096, 0xEC34970E, 0xD50DE4DE, 0xC94BBB17,
    0x4A2B621E, 0x5B10D44B, 0x26777856, 0x2CC17836, 0x8DA72DA8, 0xC987724B,
    0x66F9DE16, 0x0D3D0A3A, 0x9FA25B12, 0x7AB73069, 0x48C1A6B4, 0x6ACCB69D,
    0xCE05B799, 0x0B6FCE92, 0xDE5BCD4C, 0x6DD94992, 0x8A47EF63, 0x096C0EB2,
    0x4ACA9A0F, 0x60642D46, 0xE65A0607, 0x4581816D, 0x039DAB35, 0xE0B42217,
    0x2E36BA0A, 0x02EC15E9, 0x03B01E4B, 0xA79EEF15, 0x693B0744, 0xF7EEB6A5,
    0xFCF44DDE, 0x5887A7EC, 0xF0F6F692, 0xDEE1AC4C, 0x7DFEB93D, 0xC8D038F1,
    0xE756EF7A, 0x1413FDFF, 0x799A077B, 0x36B36F41, 0x770F2E27, 0xCEA5DAAC,
    0x1413F1FF, 0xEE69F17B, 0x4D815E3D, 0x815EDED6, 0xEBF2FAC2, 0xE7B03DBD,
    0x58850EF5, 0x8B625FC2, 0x4AFCBE96, 0x516C0F67, 0x27F7FFE7, 0xA18D7E82,
    0x17384B10, 0xDDEE6C0F, 0x0D625B07, 0x03D1B657, 0xDE6DE05B, 0x18A1BDA1,
    0x8B47B03D, 0x66E9903D, 0x0D63B05E, 0xC3732567, 0x77B3D9BD, 0x7AB39A07,
    0xAA3787B6, 0x80FB3FF3, 0x8C0D758A, 0xF26A05B7, 0x6B7B83A6, 0x8FA3B0F2,
    0x81E3D26B, 0xAE47D03D, 0xD3EEF1C2, 0xFBB2D81E, 0xF0962144, 0x78777B7D,
    0x1DE1BEF8, 0x7A4BB1D3, 0x96CC1742, 0xF1EF70B1, 0x4F9A074C, 0xD48AFF09,
    0xC5FF094C, 0x4B84A7BD, 0x7095985F, 0xB22F0F6F, 0xA76F7985, 0x2D81E125,
    0x59404969, 0x3BAD6233, 0xDC3C5CD0, 0x1B940B6F, 0xE5BA72D8, 0x4B758606,
    0xB6078F38, 0xB78D2584, 0xE40D4604, 0x3E913DDE, 0x1816DFBC, 0x5B03D268,
    0x1346FB02, 0x144B025B, 0x478F0962, 0x3D9367EB, 0x63CDEC48, 0xE1A9470D,
    0x0D932FAC, 0xC8FAC12D, 0xEB0D240E, 0x1DEC9B21, 0x9E4B8E68, 0xD03B47C0,
    0xBD608152, 0x9604FDE7, 0x2B0E1F7E, 0xF7C93492, 0x5B5BB582, 0x9257AED7,
    0x6A502B0D, 0x4A0576B7, 0xAD34D781, 0xDA3C0BAD, 0xD092E569, 0x1B24A9D7,
    0x151D092C, 0x0535E053, 0x3E495FBD, 0xE8BB8194, 0x2C1AD836, 0x06D8BC9E,
    0xAD2CA693, 0x2584925C, 0x694DDEC9, 0x5E6DAC4D, 0x6A9F5F9D, 0xB45ACA6E,
    0x5ACA1E23, 0x949160E6, 0x23B1CCB5, 0x30799BC9, 0x96F99ECE, 0x307404B7,
    0xCEA831EC, 0xF80284FF, 0x3BFF9D42, 0x3AA989C1, 0x6F04F3FF, 0x77FF9D45,
    0xE7552982, 0x12609A7F, 0xA13FF3AA, 0x75324E00, 0x5304AFFE, 0xC4FFCEA6,
    0x4A666704, 0x7B49707B, 0x5DCA962B, 0xF1B95BDE, 0x0FDE3D24, 0x2F030D1E,
    0xEFDDEF4B, 0x0B6FCAAE, 0x302E4CA4, 0x809F143B, 0x93943C37, 0x4569AC0E,
    0x856E7A3A, 0xABC83522, 0x53C45944, 0xB5854A5B, 0xC8375A79, 0x630F9C2E,
    0x3BCDCAB1, 0x1B95642D, 0x9560F156, 0x59A27A3B, 0xEF603F4D, 0xB878137D,
    0x0D2AF5B0, 0xCDBA56A5, 0xB1DD295F, 0x2D81D43D, 0xC8A5C3DB, 0x074A7D96,
    0x45B3BB3E, 0x6CC0DE37, 0x23BDE609, 0xC96B7EF7, 0x152A3E74, 0x71EA60A5,
    0x1D4D1CD4, 0xA913D861, 0xB51CB738, 0xBE16651C, 0xD8B1282F, 0x0F304D44,
    0xDA8EDB94, 0x0226AF0B, 0x747AFD8D, 0x4B15B1A0, 0x578D4D26, 0xAFFCEA13,
    0x9D4FB7B0, 0x6E0989FF, 0x07FF9D45, 0xF3AAA2BE, 0xAA609A7F, 0x523FF3A8,
    0xFF3AB60D, 0x91780C93, 0x1D7AF14F, 0xAC9D9CEC, 0x72B41831, 0x027FB0BA,
    0xA681DE5F, 0x158E3F3A, 0x682FC258, 0xF226892D, 0xC5AEE926, 0x84C21F29,
    0xBBA6C47F, 0x67C3EF16, 0xDFF0FAFF, 0x9BD45D9F, 0x867F2055, 0x794BFC4F,
    0x817AB60D, 0xAB2319FC, 0xA6A60ADC, 0x73A023B4, 0x5081567F, 0xD647C74A,
    0x9BEF72AC, 0xF7B39EA5, 0xF7C5F676, 0x8B95ACA7, 0xF5BB0FEF, 0x4B87F7C5,
    0xE3AA3E96, 0xEE9F623B, 0x5075E9F8, 0xC0DE9A71, 0x3A1B2168, 0x4B06B237,
    0x694D4A74, 0xD7E75047, 0x59C9F4C1, 0xDC3D0C5B, 0xE23B599A, 0xC531C5AC,
    0x9F70582D, 0x60714F11, 0x48ADE9EA, 0x856A5BF7, 0xD34970B2, 0xE2D7741C,
    0x2D60D34E, 0x94D397A5, 0x115E94B5, 0xB2623F3B, 0x6AB9BF87, 0xCDF77A82,
    0xCDF65B7F, 0x62177FCD, 0xD2FC3C0B, 0xF3904569, 0xDD8AD3A5, 0xC761A9E6,
    0x6FB3782E, 0x6339AD3A, 0x5D8DCE81, 0x5A8D34E2, 0xF303A9C3, 0x07A22FC3,
    0x9F9B93F3, 0xAC835A53, 0x5A2E53C1, 0x25BB7EC8, 0x777EC85A, 0x9B2168C1,
    0x42D1A621, 0x2A347A76, 0x0562A1ED, 0x0D4FE1E1, 0xA5F3F23B, 0x3B04B616,
    0xEE1F9B05, 0xF0F4FECB, 0xCE2AA5C1, 0xB6F59FB7, 0x64DA6A44, 0x5B4AEC95,
    0xAF7452DC, 0xAC5427D7, 0xDCB63520, 0x1A8BE6C0, 0x93A1B24B, 0xE42D1D37,
    0x05288ED1, 0x9A9B4B41, 0xAD373E77, 0xB4DCF05D, 0x86F9F2A6, 0x6E71EC1F,
    0x53C6F47E, 0x691CF478, 0x7EA3C3ED, 0x9A05E4CB, 0x0E37A73A, 0x9D86835A,
    0x7BC392E9, 0xDCB86BBD, 0x13EDEE58, 0xD2A55C97, 0x3582E158, 0xD45251D4,
    0x6952DDAF, 0x4FA14E09, 0x71A06E3A, 0x43CD747B, 0x9CEA2EF6, 0xF2BBCE7A,
    0x7A4FE16B, 0xA60D73CD, 0x3B06B9D7, 0x38E1BC2C, 0x6CE6FC2C, 0xA9BEF7B2,
    0xC5F86E57, 0x967DC351, 0x0F497653, 0xD115286D, 0x7691DB58, 0x5B4D9CF2,
    0x40B92E8C, 0xDA67A54F, 0x989C7493, 0xF2D930AE, 0x0B64CE7A, 0x958FBDED,
    0xDA5E3ED6, 0x7AD06863, 0xCAC2E765, 0x7D6938F7, 0xBEB0E863, 0xA55C9760,
    0x71FB5A0D, 0x686CE3F6, 0xB0E836B4, 0x3174A7BE, 0xC3674367, 0x336B4392,
    0x1AE96367, 0x4A7AC6E7, 0x88B2B41B, 0x46D2C617, 0x2763E743, 0x97A7D615,
    0x293B05D4, 0x1F58A6BD, 0xD62CC765, 0xAC7E86CE, 0xB41A0B9D, 0xB938B0BE,
    0xBD2E22F4, 0x8FD8D0E4, 0x54D8B1B3, 0x17CAC2B0, 0xD3E71AC6, 0x7A765346,
    0x49D87B25, 0x17668369, 0x637D9C7E, 0xDF2FA58C, 0xF9DAD063, 0x5F5B2B92,
    0xF46D635E, 0x741A1B58, 0xDC970C38, 0x683431E3, 0x35E2C965, 0x38FD3DA5,
    0x36741B5B, 0x1B5A1F5A, 0x0D0DCE1D, 0x3436963A, 0x36B67468, 0x2E18F468,
    0x599876B1, 0x8D0D0FAC, 0x9DA537CE, 0x8D725F2B, 0x59B585F3, 0xB53D03C1,
    0x7EECBB28, 0x8DF2EC1D, 0xB58DF3B5, 0xD68588A7, 0x6743EB0E, 0x58C625E7,
    0xA9EEB0D9, 0xCADA5760, 0x7671EBD2, 0xECA3E54D, 0x651CDD82, 0x2CCDD687,
    0x2760EBF6, 0x4B189EF7, 0xD0DA594E, 0xEB2595A0, 0x2EB3313D, 0xF3566C6E,
    0x2562C636, 0x05F6F535, 0xED396D3B, 0xB5A0DA7C, 0x74F8F573, 0x765177E7,
    0x630A9EFA, 0x69D335E9, 0x7B92F4BA, 0xB18D9D9C, 0x7E573BB2, 0x8AE5631B,
    0xEE6EC15E, 0x8974D3B4, 0x0BB05747, 0x09E85D66, 0xE6536F76, 0x7A583760,
    0x8369F5A1, 0x5A9BEB46, 0x5614F58D, 0x36F58C3E, 0xB5AD02C6, 0xBD2CA7C7,
    0x75B4FAC2, 0xCED68341, 0x1C2E4B07, 0xD68D9C7E, 0xECA2C30E, 0x1BBE8AF4,
    0xE37D3B07, 0xB468D0DC, 0x45BC3336, 0xB58B31D9, 0xD68349C7, 0x3D0FAD06,
    0x9AC29ED6, 0x6ECA3A9A, 0x6E637651, 0x0C2F1165, 0xAD9C799A, 0x725F40EF,
    0xBECED3E5, 0xAD0FA760, 0xE4AF4F9D, 0x2F97D6CA, 0xD1A0C2B9, 0x5D68CC53,
    0xD9C4EC58, 0x8F73A0B2, 0x2F65D82B, 0x5F2A6ECA, 0x116307B2, 0xF8F41B4F,
    0x7A36B1ED, 0x5F2B2D1A, 0xEB676972, 0x94F7D625, 0xA9B9E836, 0x79C38F7C,
    0x4A7E8369, 0x67ED2C57, 0xEB168341, 0xCE834343, 0x7B38F585, 0xF8979DAC,
    0xC598B159, 0x68D9C6F9, 0x392E76B4, 0xCE3DF2BD, 0xF3A14FD6, 0x7A14FD6B,
    0x7EE76960, 0x2A2FAD9C, 0x07496FAC, 0xC96529BB, 0x2D9D06D2, 0xB05C972B,
    0xC7ECE82B, 0xB4B0B9D9, 0xD6834179, 0xDF2B0E6B, 0x9E37651C, 0xF9583760,
    0xB2CCDAD0, 0xB7E3DAD0, 0xEB49DAD1, 0x8C6CEC33, 0xD3ED0FA5, 0x7A1B2BA7,
    0xF115D83A, 0xD631B2E4, 0x8525EB12, 0x0D1537D6, 0x8DAD1A0D, 0x07587725,
    0xB12F3A0D, 0x7D68BE76, 0x35DFA0DA, 0x3B4A6AB0, 0xBD6AC61F, 0x1CFAC2E6,
    0xD3B28BD6, 0xA537CE86, 0x56CA3DEF, 0xCA2D6345, 0xB41D82EE, 0x1372BD3E,
    0x39AF5B2F, 0xDD687CE8, 0x1A9EF958, 0xD4F596BF, 0xE639AE18, 0xB14DF4F7,
    0xF5A36B13, 0x9B92C6CA, 0x1A0D0C7E, 0x0EC17DAD, 0xB6B1A9EB, 0x95E2F4B2,
    0x9D1B398F, 0xDF2F9DAD, 0x33343EB4, 0xCBC4595A, 0x058CC537, 0xEB1998FD,
    0xC681F671, 0xF3B4FA58, 0x63B4B185, 0x0DADBF69, 0xFAD9789A, 0xF4B0B9D0,
    0x9C7E86CA, 0xF671EA4B, 0x6A4B1A18, 0x741A1B9C, 0x369713B0, 0xD0683E96,
    0x671EE4B9, 0xB399A18F, 0x41A0B0A7, 0xE5D98963, 0x8C2A7AC6, 0x4A6FADA5,
    0xC975E95F, 0x375B4B95, 0x7A7D6834, 0x0B9E8341, 0x955C9776, 0x2BEB49DD,
    0xB62D0686, 0xCD9760BE, 0xF115D94C, 0x8B314DD8, 0xD83AFD0F, 0x1FA1A345,
    0x2E21BB07, 0x1BC162BD, 0xCD06D3E7, 0x77CED62C, 0x293B1D94, 0xA6FAD068,
    0x4AEB41B4, 0x5EB41A1A, 0x2B671EBC, 0x1E8D0C6B, 0x0ECE3F6B, 0x8D0686EB,
    0x634666D6, 0xFDA5592C, 0xEDEA7B38, 0x0693A6A7, 0xE3D7A58D, 0xDAC7E66C,
    0xC2B2C7A0, 0x61C4E7A0, 0x8FD7E87D, 0x314F57B3, 0x035B298B, 0x5B29A5DF,
    0x3E19C703, 0xF9E1035D, 0x370B2E04, 0xCADCB2F0, 0xE0B46C8E, 0x7BD7E8EB,
    0x9377BDBF, 0xDD16DFAB, 0x56579FBB, 0xD778EF44, 0xA9037E6D, 0x075781B9,
    0x6836F23D, 0x7E57B5A1, 0xB212D057, 0xFD1B9B11, 0x54DF9A3A, 0xA9AF0978,
    0x27C373C0, 0x7A74F3C5, 0x9478D3BB, 0x43A5AB83, 0x860B69B9, 0x25BC3DB2,
    0x977BE914, 0xADEE4540, 0xC3595025, 0x6AE0AF4D, 0xF587E899, 0xEC7D1B8E,
    0x59A4EB02, 0xCF82ED49, 0x02FBC7AE, 0xA12EF7B3, 0x9AB89ECE, 0xCBC396C8,
    0x97872D9D, 0xED9E5B2B, 0xC973B9E1, 0xECA3E779, 0x3EDF27A0, 0x26B93CB4,
    0x6B9642D7, 0xAF3BDA50, 0xF27ACA1E, 0xC96C09EA, 0xD15AB36B, 0x25DF95E3,
    0x8715FA70, 0xEF30EA76, 0xD92CCA71, 0x704B49F4, 0x1D2A787B, 0xB7C4AFC7,
    0x3BC3CCA5, 0xE1812EF9, 0x82B0D7E1, 0x8F0F6E16, 0x112DDC46, 0x227AFDE8,
    0x5B264BC8, 0x2ED6958C, 0x2DE1ACF8, 0x2D015ED1, 0x813C87BC, 0x7BD06737,
    0xB7835CD7, 0xC1A53EF9, 0x6F6F9E1B, 0xAB0744B0, 0x7CE8A9F4, 0xBF7A41D8,
    0xCD2D6E16, 0x4B61A79C, 0xB4ACE1AC, 0xD59C358E, 0xC41152B4, 0x597D608E,
    0x0E9EE89F, 0x790B695D, 0x93607B7A, 0x03DA2586, 0x81E3D05B, 0x6ECB6F2D,
    0xD13DF0D2, 0xB9AF1D3D, 0x7B1A2739, 0x29E8B677, 0xFBC3DBE1, 0xE12C42B8,
    0x16DE3C7D, 0xAC83C7D8, 0x0B607BBD, 0xC7B26EF7, 0xEB6CA711, 0x77657340,
    0x79502DBC, 0x437B83A4, 0x95970B62, 0xD025B121, 0x40E5CA1C, 0x12DE5B73,
    0x9A39D66C, 0x05A2337B, 0x8DAB37B9, 0x1EAC3DDE, 0x36216C0F, 0xDA2DD639,
    0xD69620E2, 0xE1AC77A4, 0x2C42B49A, 0x157263E1, 0x0F49B78E, 0x7A4DD9EC,
    0x7E2ECB60, 0x85727B03, 0x0B18E9EE, 0x5E3DA779, 0xBADBDC81, 0x778AD825,
    0x7C596E85, 0x9EF38A3A, 0xDEE688B9, 0xBDCD8873, 0xA76B84A7, 0xE71614E9,
    0x2D88533D, 0x369A54F5, 0xA07AF0B4, 0x25A4F785, 0x7A4B81E1, 0xF48F77B8,
    0xE23D474C, 0xC27B037D, 0xC87B03DB, 0xF36A540E, 0xE62D62F0, 0xB2452FA1,
    0x85B13431, 0x67B427AC, 0xE094787B, 0x3258F0F6, 0xF251DEE6, 0x9289A915,
    0x4A3BDC5F, 0x378C2FA4, 0x51BDAC90, 0x506FC3CA, 0xE39A060A, 0x84B10A13,
    0x2DBC4D63, 0x9B3CF490, 0xA67B21EC, 0xC4D75B63, 0xB82F46DA, 0x1A240B02,
    0x694E492C, 0x7B478163, 0xE814F65F, 0x918164EC, 0xB2D029EC, 0xDBE2D3B8,
    0x8ACA9D71, 0x0C502EA4, 0x032767FA, 0x03C2D02D, 0x1D473E3C, 0x7A6C9A49,
    0x7C9A4913, 0x44B40A70, 0xB953A0D2, 0x653697A1, 0xE4F1DA2D, 0x91F6D747,
    0x9BB6BA73, 0xF4A996C4, 0x58324AF6, 0x0EC93C52, 0xD9249F2B, 0x511F9583,
    0x01427FE7, 0x3FFCEADC, 0xFF9D5BC5, 0x75675581, 0x4609E7FE, 0x0027FE75,
    0xFFCEA5E0, 0xEFCF8269, 0xF9EFCCE2, 0xEDA12944, 0x6D8D03BD, 0xE7E992C4,
    0x27EDD0B5, 0x552B4B5E, 0x6FA05AF8, 0x0785ADE2, 0xF315FABC, 0x94AF5A0E,
    0x5DE7E839, 0xBE0769DC, 0x896F36EB, 0x474DC577, 0x058DA750, 0xDAB2350E,
    0x27932947, 0x54BD0B76, 0xF0F473CE, 0xDDD06369, 0xF7481B9E, 0xA6AF01CD,
    0x40DD90BB, 0x1EBF395A, 0xD91F7BCD, 0x75DEF0F2, 0xB9CFCD88, 0xA0BF0786,
    0x817906B5, 0xE5BCCBB3, 0xC74D4468, 0xC6ED0F12, 0x93636F0B, 0x2B47AF2D,
    0xD535FCDD, 0x87DEF1CA, 0xB992728F, 0xF8552B77, 0x6A456F7A, 0x15605AF0,
    0xC502DA7F, 0x2E05B037, 0xE30F3F0B, 0x9A3D7D0A, 0x3037E6D5, 0xE87A4558,
    0x1CDCA37D, 0x1E27A5DE, 0xBCF40BE8, 0x5CD3136B, 0x20FB3D02, 0xD7B81BC3,
    0xCEA9B7F0, 0xCC42B916, 0x65E3168E, 0x9FA26FAA, 0x0E7542DC, 0x1A104B9E,
    0x02F22E76, 0x0B46F52D, 0x705A92D9, 0x8A3D225A, 0xBDD23A4B, 0x53037BF2,
    0x1F05B4A9, 0xD3581E69, 0xB43CFBD2, 0xE1ED96C3, 0xAF741CE1, 0xE9A55837,
    0x20560C0D, 0x0528EE5E, 0xA40E8F5F, 0xB1A56A50, 0x475F74D2, 0x4D83D93C,
    0x03737C51, 0xA699AD17, 0xB2E07A48, 0x9707B270, 0x172D9074, 0xE2AC0707,
    0x6811BC71, 0x8200A503, 0x41EBE5E9, 0xB6760FBF, 0xE3BA4568, 0xC5AEE9B0,
    0x6074AC5B, 0x11B94BFF, 0x8B97EC0B, 0xDE27CE1F, 0xFB0E305D, 0x0FFDD295,
    0x39F784F9, 0xE7DE33F8, 0x547E4A50, 0xD7B9566E, 0xFDF17A9C, 0xAF8BEA69,
    0xF17E1AD4, 0x8BF364C3, 0xBEA8FB1F, 0x3ADD87F0, 0x74DF44B7, 0x5856527E,
    0x4BFC6D31, 0xF1DEF476, 0xEC85A30F, 0x21688DF7, 0x9834C15B, 0x64469EA9,
    0xF34B58B2, 0x80A5FE67, 0x372B7989, 0x5027CD97, 0x09F39B4C, 0x9F39BA45,
    0x3F3ADD80, 0xA53B76B8, 0x4B72B02B, 0xBC533D93, 0xBB7D93F3, 0xA0761B85,
    0x47E77B47, 0xF40AF59F, 0x2F0972F8, 0xF36E4CF2, 0x357E27CB, 0x60ECF273,
    0xEBF9AFD0, 0x524560ED, 0x60F75976, 0xA13D925E, 0x6452D2D3, 0xDD307468,
    0xF7038A83, 0xF0FCDFB3, 0xD9422F7A, 0x6F5B0CCF, 0x528DC609, 0x69182EEF,
    0x91DE2D21, 0x7B073216, 0xAA75903D, 0x4F4EC094, 0x91537DAD, 0x59594536,
    0x815640DF, 0x2C16BD7B, 0x4E51FB30, 0xD89F3902, 0x2E7E7647, 0xC5481565,
    0x77C0DE0A, 0xFB078C17, 0x73EDC715, 0x9A515A7E, 0x9D90B462, 0xAD6FA602,
    0xF39B9DA1, 0xA3037D09, 0x1A13EC85, 0x14E7642D, 0xA95D6928, 0xAC2953A7,
    0x9D531469, 0xE91AEC9D, 0xE1E12DE1, 0x534E18D4, 0x4E792ECA, 0xBC937DD3,
    0x56DDEC38, 0x7D6D3522, 0xCFD39D88, 0xBA19E227, 0xF9C5716B, 0xEC03C3F6,
    0x46D35237, 0xCD92C4F1, 0x13E7CFC5, 0xC1E4F9F9, 0xA779B012, 0x5CE91EBB,
    0x805F20D8, 0x2EF5177F, 0xDE7A3945, 0x61C76D4F, 0x6FBDCAB3, 0x4DF64FB4,
    0x412D24FB, 0x42D82CCA, 0xADBD0D6B, 0xB8641F48, 0xA50371DB, 0x83F8B7D3,
    0x69037E62, 0x6FA6BCE5, 0xD79739BE, 0xD6F5ED22, 0xAF4CF23E, 0xA7799E87,
    0x539DD825, 0x7934B0E9, 0xAB2D7E81, 0x725D94E5, 0xE79D61A9, 0xD0372D9C,
    0xD752D873, 0xC8EC177A, 0xB4DE9BCD, 0x4B751E14, 0x95FB69E1, 0x3ED64C95,
    0x17BCE4B8, 0xE8E39CF5, 0x505633ED, 0xF505718F, 0xBDEF6F3C, 0xE816DEA6,
    0x82ED6F5C, 0xE83A57E3, 0xD05A3A99, 0xD339E8D4, 0xA9A49E8A, 0xD2B1AE74,
    0x272B1622, 0x2586C93D, 0x4E5F3C97, 0x2D17CE5B, 0x5E06DE73, 0x2C8FBDB7,
    0x2C1ECA99, 0x6E23B9D2, 0xE4B77A9C, 0x3C165B4A, 0xE2D41DA7, 0x9CEB02F4,
    0x2D24F616, 0xE1C67B26, 0x8E1532DD, 0x70D45CB0, 0x078B42B9, 0xE7A9C50B,
    0x28BC9A50, 0x26C0EB94, 0x4D24F68F, 0xA5BCB61E, 0xFB4ABD2C, 0xCDF58B5E,
    0xF4BA341D, 0x0F87418D, 0xB2EC1D9D, 0x3B28B1A7, 0x25885878, 0x92D34E17,
    0x3C6FAD62, 0xF41A4E37, 0x7D9C7ACD, 0x1DF4EC11, 0xDAC4BD68, 0x2E6FA0B1,
    0x7694DD82, 0x1D82FAD2, 0x94F58C5A, 0x2BE76B75, 0x2760A9ED, 0xD2DF9D15,
    0x7C789D8B, 0x8D6299E1, 0x6165A0B1, 0x7D68592C, 0x365630F9, 0xF955E2C6,
    0x3B0741A0, 0x7E25AEB1, 0x6531EB1C, 0xBF65D4F7, 0x58C6CB96, 0x9CC77353,
    0x2F1340BD, 0x11F58FBB, 0x0BD3B28F, 0x17A76516, 0x3E93B8B1, 0xB4369565,
    0x8341F0BE, 0x630A7AC6, 0x3A0DAC39, 0x9ECBB05F, 0x2AB0760B, 0x60AC3617,
    0xFA160B97, 0x1E3CDD82, 0x5279725F, 0xC1CC7653, 0x651D9B2E, 0x41EF7517,
    0x9EECA683, 0xF11656E2, 0xC3A2FB4A, 0x97AD0EFA, 0xC630AF58, 0xBD2E4F1A,
    0x7695F2B0, 0x1D9789A3, 0x7D8B5EAC, 0x6B2C636F, 0xD6B627BF, 0x3B28EC1D,
    0x6FCEE8AC, 0x7A562C63, 0x5B2EB3C9, 0xAE9F5A7B, 0xEC15E9F1, 0xCA42F4A4,
    0x4EC1D93C, 0xE2525E77, 0x525A4F19, 0xA93B1EF5, 0xEE9652C2, 0x76FDA760,
    0x0BAED3B0, 0xA8BAE276, 0xD61631B7, 0xC4BC4B53, 0x4741A0DA, 0xC1582F38,
    0x631A1F4E, 0x553D614D, 0x9D0F95DA, 0x7AF4B18D, 0xE4BE71ED, 0x3C2BD662,
    0x1A35EB18, 0xA782C963, 0x72FB2B2D, 0x297695C9, 0x3DA58C6B, 0xF343C435,
    0x535858C2, 0x7AD74AC1, 0xCCD17D9C, 0xC58C6CE2, 0xC5A0DC5D, 0x17A5D1E3,
    0x2C2F4A7C, 0x76517A7D, 0x9F4EC1D9, 0xCED2EE76, 0x3592E4BE, 0x694F86D6,
    0xA0D58683, 0xD03BE2D1, 0xDD83B2B3, 0xD3B0746B, 0x5E87D6CE, 0x4BB7A9E2,
    0x6F95C9DB, 0x2BD3B28A, 0x6B0AF4FB, 0xED3B0557, 0x9B4AB1C7, 0xE81E23B2,
    0xC63F330B, 0x4EB18782, 0xF6B4165B, 0x0ED3EB64, 0x7AC3AF76, 0xB47B0F89,
    0x4ECE3F41, 0x58C3E756, 0xEBD631BA, 0x4D74BADC, 0x2BD2C635, 0xB4B8769F,
    0x9E3DCAF5, 0x82B05630, 0x987A0537, 0xB1ACB5FB, 0xB04DE23E, 0xA7BC45CB,
    0xFB47A1F2, 0xCD1B4B92, 0x93DADA5D, 0x316D3EB4, 0x58B5D2C6, 0x259FA5E9,
    0x36B16786, 0x2A6B5D68, 0x0686E956, 0xE7694F2D, 0xE5D82A7B, 0x62D7BECB,
    0xEA7A058C, 0x56D2C631, 0x5B9AF116, 0x1D497A59, 0x9AFCEC2C, 0xB58B5EF9,
    0xD82F9C67, 0x651F7365, 0x5A077DA7, 0x497AD359, 0xB076545D, 0xB27D65D3,
    0x3B2998A6, 0x3EE2E962, 0xE9E82EB1, 0xB8ECA6CB, 0x76742F4B, 0x63D77BB0,
    0x8C4B585D, 0x35ED2ED6, 0x757D2E4E, 0x40FB8EC1, 0xACA735EB, 0xEE3E9656,
    0xF40D7626, 0x8206B040, 0x375C481E, 0xB10D7594, 0x89A5DE6B, 0xA6CE335D,
    0x6F1F9DE6, 0x20B6CEBF, 0xEDC65A6F, 0x26E6BF41, 0x6435F256, 0x816DFCDC,
    0xC27BD7AF, 0x05CAF82D, 0x40977ED6, 0xC8B50A56, 0x4A0750B5, 0x0D476507,
    0xAC1BEE8B, 0x6839B5A1, 0x0F6435A1, 0xB95C0AD2, 0x68B64F79, 0xD87528DE,
    0x2B87B703, 0xCA12DC96, 0x6570F6CD, 0xEC371C97, 0xD81F05DA, 0xAF0CF025,
    0xF3987A23, 0x0F3204BB, 0xF3A21A8F, 0xC1B10D45, 0x1710F2DE, 0x136F51F7,
    0x4B6F6F6B, 0xA1BECD44, 0xDA2F67B5, 0xEF2D9D32, 0x1F9B9812, 0x7117CEF5,
    0xB4C1A7BB, 0xA7C1A704, 0x52894F44, 0xE5A0D75B, 0x9F1ED2AA, 0x1CA7A6A4,
    0x9CF5594D, 0xFA0DBE2A, 0x82DAA291, 0x1D2B41E1, 0xC97D8194, 0x1825A768,
    0x8E9CF6F7, 0xB1A705DA, 0xC8DDBC55, 0x5282D8DA, 0xB283F77B, 0xB057BB02,
    0x7B7933E5, 0x8279361B, 0xBCC837AB, 0x6AB2606F, 0xE5747C17, 0xC695A6BC,
    0x9F77C358, 0x0573A790, 0x1B627AB1, 0x9340E571, 0x7BC8632D, 0xD63BBC3A,
    0x8B674B70, 0x6F70F4B6, 0x6F6B2687, 0xFE1ED92F, 0xE5B9C89A, 0x3D745A25,
    0x244DE2EF, 0xDB81F7AE, 0xE738B9C3, 0xBA1E3E9E, 0x65B26F60, 0xAD7E9EE5,
    0xF734E375, 0x86B12C56, 0x7422AB2B, 0xF42EAB29, 0xEE6F6A52, 0x878494AD,
    0xC3DB522B, 0x6F7057A1, 0x1D3CEC48, 0xBDC1D890, 0xED34AEE1, 0x6F21E281,
    0x1EA5B398, 0xBF340966, 0x6FCD03B7, 0x473D4B78, 0x6270F6F6, 0x6D16C0ED,
    0x168F51D9, 0xE4D296C3, 0xADA3D461, 0x36F84B10, 0xFBB17869, 0xDD9F78ED,
    0xFBD3C83A, 0x73BDC819, 0x2E4B758B, 0xC7CEEB4B, 0xC5CF0D63, 0x77B27BBD,
    0x23A726F4, 0x10D67DFA, 0xC253D02D, 0x9E6B37B9, 0x5B02BA2D, 0xE99E91EA,
    0xEC0DC977, 0xD0E54977, 0x211EA505, 0xDEF5C74F, 0xDC8DE1D6, 0x4B137A3B,
    0x216BE878, 0x7B87051D, 0xDEE1E947, 0x27B07D81, 0x077B84B0, 0xD63B878A,
    0xB20EF70C, 0x4A3A7937, 0x4B1CDA94, 0xD690F742, 0x0B49BDC1, 0x4ED24684,
    0xC0EC9B03, 0xA540A8E9, 0x725AC736, 0x7D0EDF91, 0xB7AF79FC, 0x48EBD341,
    0xBD93433E, 0xAE7093CD, 0x64B05393, 0x26286D1F, 0x92DA5836, 0x05B5269A,
    0x8ED1F257, 0xDD1F7AE4, 0xF467C928, 0xB5D49E2E, 0xEF51CE1B, 0x3A189A4E,
    0x3A25BF7B, 0x5581618B, 0x4CF8923B, 0x539345A5, 0x9DC52815, 0x9DDE6716,
    0xB6492E56, 0x05923B24, 0x2C9A2E86, 0xADE81630, 0xF95DAC0F, 0xDBA29406,
    0x94ACAEA0, 0xCAC2E1BC, 0x8D37286D, 0x689E95BC, 0x28E6F95E, 0xAD0C69AF,
    0xA91F4599, 0xA9174599, 0xECD44B59, 0xD3A13D05, 0xE4D268DA, 0x94351CCD,
    0x5BF16E1A, 0xAD0CBCD0, 0x5EFBC799, 0xA970F6BF, 0x1BB646E3, 0x6AF145ED,
    0xBBBDF8BC, 0x40AD22BD, 0x7EA1E793, 0xBEADCE3D, 0xDE2BCC5E, 0xBCFDDC1E,
    0xE7AEF81D, 0xF037D2AD, 0xF2D64295, 0xA3C4682E, 0x6A1E9316, 0x16A096E9,
    0x2CCA16BC, 0x37650F87, 0xE687A3E8, 0x6F5EE9BD, 0x176B4E6E, 0xA995A69C,
    0xD4E56903, 0x4D06B4D2, 0x51C49691, 0x4D695AD3, 0x1D125AD0, 0x46EA8E54,
    0x83A2EB2A, 0xE6F43C1F, 0xAD137D95, 0x15CD15A6, 0xA51ABB07, 0xB4A72C45,
    0x37294B48, 0x05CADA1E, 0xE1CA81BB, 0x0FB28474, 0x97650C32, 0x0BB2A05C,
    0x24A5096C, 0x82915BBC, 0xF116509E, 0xC1EC1630, 0x9B8B081B, 0xD14A07F3,
    0x43AE0796, 0xAC0F304B, 0x71F6AC85, 0x77B0AC3F, 0xBECC2B07, 0xDC359ECD,
    0x29BBD177, 0x3EDF645E, 0x5B4B9AE2, 0x3D6521F4, 0x7AA7D4DB, 0xDEE5687B,
    0xB623B51E, 0x36F77BC3, 0x9BBDBD4A, 0xCFBA16EE, 0xF2FB3517, 0xD16CF361,
    0xF71B918D, 0x026B9D29, 0xF5F1A65B, 0xF65469E8, 0xD02BD3A9, 0xC98F9B52,
    0x4DE0E4A7, 0xA5F6ECA4, 0xB74D5E91, 0xAF0FB5A4, 0x44B1BDA5, 0x21DA5E9A,
    0xD21DE83D, 0xD21835E4, 0x70B214AA, 0x2830358E, 0x2831C7CB, 0x60C92D03,
    0x983983A7, 0x0DC7389C, 0x4E811DDC, 0x85A04777, 0xC4B037AD, 0x69A563B0,
    0xD812C609, 0x476760F2, 0x946D646B, 0x31BAA3C6, 0xF3C514F0, 0xD7BB0560,
    0x20B677A0, 0x16B081E8, 0x03ACA468, 0x206FCE6C, 0x56402AC8, 0x302F0DE0,
    0x09699BC0, 0x7C39B955, 0x6BAB671E, 0x28E5AB92, 0xA948EB4B, 0x5B0D0B49,
    0x61C8A3F2, 0x59552DF2, 0x2CBC01D1, 0xB74DF84D, 0x82DA7369, 0xB5DD0A19,
    0x60824138, 0xBA096E89, 0x5A09F16B, 0xAE827C71, 0x7E775A94, 0x4F8B11B8,
    0x1F9DCAB0, 0x5F16F52E, 0x7789F354, 0xB413E417, 0x3E693B29, 0xBC588BC1,
    0xAF21FE3A, 0x29427CCA, 0x2944B5F9, 0x915AC8F9, 0x915ADFCA, 0x915BDFCA,
    0x48A2DFCA, 0x22A4EFE5, 0x22B53F95, 0x452D3F95, 0x8A8A7F2A, 0x2A9CFE54,
    0x56F3F952, 0xB657F2A4, 0xB43F9522, 0x3B3F9522, 0xB3FF2A45, 0x71FF9522,
    0xDBFF2A45, 0x37FE548A, 0x3AFE548A, 0xF5FCA914, 0xBFE548A3, 0x9FE548AD,
    0x9FE548AD, 0x7F9522B9, 0xFF2A456E, 0xFE548A7C, 0xFCA91479, 0xF9522973,
    0xF2A450E7, 0xE548A8CF, 0xCA91543F, 0x9522B87F, 0x9522B4FF, 0x2A4530FF,
    0x522A21FF, 0xA4564FF9, 0x91521FF2, 0x451E7FCA, 0x8A62FF2A, 0x15A5FE54,
    0x144BFCA9, 0x2B53FCA9, 0xA2A7F952, 0xA72FE548, 0x541FE548, 0xB83FCA91,
    0x8E3F9522, 0xAA3F9522, 0x0BFE548A, 0x49FCA915, 0x93F9522B, 0x0FE548A8,
    0x1FCA915A, 0x7F2A453C, 0xF2A45490, 0x98D81F07, 0x63614B9F, 0xB95643FC,
    0x87C5C4F9, 0x77F17D35, 0x5DFC5E37, 0xFB981781, 0xAC9E2D26, 0x9F0CFE69,
    0x530EA048, 0xF607F367, 0xECA6F1E3, 0x9CF725B4, 0xA13C795F, 0xC599A5DF,
    0x2C8A7A47, 0xADAD316D, 0xF5CFBD2D, 0x94684DCE, 0xD64D0C3A, 0x48ADC82E,
    0x3408EE37, 0x69A70D1E, 0x9E9785A4, 0x0F6CF352, 0xF3B981BF, 0x1C5A12DB,
    0xE3C03A73, 0x9E6E9A73, 0xF71A7B7D, 0x1FB0CF29, 0xC128E42D, 0xFC0A702A,
    0x133F827C, 0xF0B4E42D, 0xADAC36B4, 0xF05D9E28, 0x1BAD2B06, 0x6DE29AC4,
    0x3C0FB841, 0xAEE8C2DA, 0x13CA83C5, 0x3D82174D, 0xAEE83CD8, 0x67E479C5,
    0xE93A641C, 0xFBBD815E, 0x71E0843D, 0xF03B1BBE, 0x79793A06, 0xA9777B21,
    0x3F170734, 0xF33F827C, 0x99E274C9, 0xACC03CFA, 0x2F41BF6C, 0x7B0C6A50,
    0x9590BC30, 0x05BA52BC, 0xAF25BCC5, 0xFCA9EA38, 0x3946A74A, 0x5DDFABA7,
    0xBA65C284, 0xD073D5A8, 0x94AD7E75, 0x753677A0, 0x57DA6CEA, 0xB915E3D9,
    0x0E15C7A4, 0x7677A95A, 0x3A53D348, 0x93688E95, 0x6B268D45, 0x4DC75075,
    0x923A0B11, 0x633B7AD2, 0x42F78325, 0x4D691D27, 0x942D91DA, 0xD17DAE75,
    0x1CFB82E9, 0x2B3F6F47, 0x7B2672BF, 0x6B43CB1A, 0xB264E96C, 0x4DBDEBDE,
    0x529E35D9, 0x4F619E10, 0x1BC6DE91, 0xF38B6367, 0xE2E54F6D, 0xBBA71E3D,
    0x38B48A63, 0x62D22F35, 0xF972C2B8, 0x83C8A4E6, 0x8C6B2615, 0x2585CE2D,
    0x83D28537, 0x9A3A5A45, 0x64DA39EC, 0x3DF38D4B, 0xF5863786, 0x6793B298,
    0xD63DCB69, 0x5D2C54F7, 0x2E0AFAD9, 0xA9EB0ECA, 0xD0A7AC69, 0x71F2B18F,
    0x22C0F45F, 0x34E66E56, 0x886AC5AD, 0xD727694F, 0xF6B0AE94, 0xA7AB369C,
    0x9AC36174, 0x0C2F9D62, 0xF1358A7A, 0xC1D1C4EA, 0x8161606E, 0xC6ACA6E6,
    0x1F455943, 0x94EC1565, 0x574B1885, 0x53F4FAD2, 0x4BC7C9E3, 0xF16BD72E,
    0x963C5A18, 0x9710D743, 0xD62EC15E, 0xEB4F4161, 0x7657A563, 0xED681F58,
    0xFA36B330, 0xB5B4B92E, 0x06D63D63, 0xD17DD62D, 0x5B1897A3, 0x6378292F,
    0x6829ECED, 0xB81BB074, 0x30F8D582, 0x9C7BE9D6, 0xB87AFDCD, 0xD7E8594F,
    0xECD063CC, 0xD0EEA6A4, 0xE5CD7AD8, 0xEB2CC7CB, 0x69F4BBF1, 0x0B9D5E83,
    0x789A162B, 0x69F2B0F9, 0xE58C2E3F, 0x836B6B19, 0x1B2B3D7E, 0x94F657AD,
    0x23949583, 0x94F7AEFC, 0x2B1EFDA5, 0x631B7EA9, 0x31D83875, 0x8EC525BF,
    0x5E959B5B, 0x7C7A0758, 0xD6DF8FDA, 0x7E37CE87, 0x2F3A6A4A, 0x3654B0A9,
    0x56163B5A, 0x63D61CB6, 0x62BC4B5D, 0xD72BD63D, 0xB9D94753, 0xCB31F5A0,
    0x4DCBB365, 0x078CF0BC, 0x58DBD72B, 0xB057BC72, 0x6831EBD3, 0x22DEB131,
    0xEB14DCDE, 0x8FD0F958, 0xC3E75F99, 0x4B3C2A7A, 0x63D4F69F, 0xCC782C63,
    0xBACC53DC, 0xFA2FB5A6, 0x075E9630, 0x2F2FA2FB, 0xB331AC29, 0x7D2C615C,
    0x15CAF4B1, 0x71EFAC2B, 0xCA7CEE2C, 0xC7431E9A, 0xB938F7CA, 0xD01E83C6,
    0x2BADA5C9, 0xA05E94D7, 0xC162F9C7, 0x8B96BF1B, 0xE8DA5C95, 0x89797D6C,
    0xA6F9D1D1, 0x02C4D0D1, 0xD063D7AD, 0xDA583968, 0xD1B2F9D1, 0x335EEEC1,
    0x9D9AF5EB, 0xF11DF1F8, 0x671EEFB2, 0x58D725DF, 0x7CA92E57, 0x3DF3B98F,
    0x8BC31E85, 0x740BD2AA, 0x585F5B58, 0x92B1562F, 0xC36B46D6, 0xFC4B82C3,
    0x1CCDAC38, 0xCC4EC7CE, 0x17DA7C2B, 0x358B7E8E, 0x1EF9725C, 0x43760EEB,
    0xC635622C, 0x1D0396D2, 0x7D0B527D, 0xECA2C3E3, 0x5D3B31EA, 0x341A4ACF,
    0xAD1B3873, 0x03ED6D1B, 0x3A073D9D, 0x3A1F585F, 0x36B1EA7B, 0x4953786C,
    0x0F8B13B3, 0x79B47B2B, 0xBD61738F, 0xC6CE2D0B, 0xE25BEB1A, 0x3B3A4EA8,
    0x478CF31F, 0x3D153D1B, 0x8C4689E3, 0x1C9E2685, 0x965353D6, 0xA3D86EB3,
    0x7ED2CA7D, 0x3B8B1CCC, 0x3C4A78DF, 0x9B584F49, 0x58782C57, 0x3DEFC5A0,
    0x94F5760E, 0xD3B364AE, 0xCD9CCD35, 0xBE5F4ECD, 0xD9DC58EC, 0xD9D1AB18,
    0x0B1C7ACF, 0xE4E8369E, 0x5C9D959A, 0xB4A6A2B1, 0xC2E76567, 0xEAEC1786,
    0x678DF6B1, 0x340B0B2C, 0x9B99F4F1, 0xE8D77BB2, 0x12F398A7, 0xADE29BB3,
    0xDCE8A9EF, 0x4BE54970, 0x72D3562E, 0xE1C2F9D9, 0x88B0C6A7, 0x4BD63CC5,
    0x5679EDEA, 0xBE5F47B2, 0x897A62A9, 0x60E8DAC3, 0x77E83C6B, 0x058AEB45,
    0xBBD4DF3B, 0x8EDA1DBC, 0xC0AF38B8, 0x65ABD79B, 0xEBAFDBDE, 0xB79AC0AD,
    0xB2BCF3D0, 0x82BBF7A6, 0xE63D43F5, 0x4DDC0EA6, 0x9E9B3A6F, 0xD6B415D0,
    0xB7BDC3E0, 0xCE612F83, 0xB025DFBD, 0x6616C6D5, 0xF7AC77D0, 0xB18B6876,
    0xB25ADFB7, 0xD763BC3D, 0x8B5D9AF0, 0xD92BDE94, 0x8E5CD932, 0xC8E96EE7,
    0x6F912D37, 0xDE2E606E, 0x1682B932, 0xEBD0D798, 0xE71BA2BC, 0xAA5DA53A,
    0x6F53C252, 0x176F4ED3, 0x183DBA46, 0x037A0969, 0xCA9B7EAF, 0x6507388A,
    0x58903B55, 0x445D626C, 0x27E912C7, 0xF13DE6C0, 0x8567E9F0, 0xA0F48305,
    0x81BE9E4D, 0xB911A5C7, 0x515D6BD4, 0xD598948F, 0xFBCF1446, 0xCBBF7878,
    0xB26DE2D1, 0xF9D79EA5, 0x85B6FDDD, 0x32CFB7AF, 0xDE5B8FAF, 0xDEF3D816,
    0x9AF7EF70, 0xD3D93634, 0x6E8578A1, 0x51EA66E5, 0x8516890E, 0x54A2DDE8,
    0x1522874C, 0x9E4CE868, 0x02DB5E86, 0x669E4589, 0x799BD1E6, 0x37E61EF3,
    0xF9A730B7, 0x38FA5984, 0x59A79073, 0x2560E9E7, 0x7096C3D8, 0xB77A466F,
    0x67AE4B68, 0xBBD3C85B, 0x0F771AFC, 0xCB5F7A79, 0x8EE1BEF4, 0xB7A6966D,
    0x7ECB4CD7, 0x0B6CF606, 0xDC2DDEF7, 0x630AAF3B, 0x6CEF70F6, 0x37B92DD1,
    0xD9BDCEF7, 0x9E415C8A, 0x7AE51376, 0x2C62A39C, 0x88E9E9E4, 0x1D31D2C6,
    0xBBDCA695, 0x596F7344, 0x86E51A45, 0x6DED4B7B, 0x9EE8F528, 0xE27AF0F0,
    0xDB8EF720, 0x709C4F44, 0x89C5D0EF, 0x1873DA1D, 0xD8C70E53, 0x0D7B51D1,
    0x0EC0F40F, 0xD63BAD2C, 0x8DBCDEE6, 0xF53C50B3, 0x428E54A0, 0x79461CA9,
    0x133E36E2, 0x74C4F88D, 0x65A413E0, 0x6C989C61, 0x8B64DEE1, 0x7C0EC878,
    0x8D0CB21F, 0x93D461A4, 0x0B4E81CF, 0x7524633C, 0x7CC9836D, 0x279B7C0B,
    0xDBBF7A6F, 0x0582EE10, 0xE48BEF6A, 0xEF44B7EE, 0xB3268F02, 0x7C9E4B93,
    0xEBE69BBD, 0xA9BB553D, 0x457ADAAE, 0xE0DB5D32, 0xA73BCF23, 0x3434AF63,
    0xB067C968, 0x5E0814A1, 0x32BA35EF, 0x79EDD4B9, 0xA6BE6DEF, 0xCAD0DF31,
    0x8BB72E54, 0xDAD38477, 0x14B53B47, 0xC82D7E65, 0xE885BEFC, 0x0DAF25F7,
    0x93E3E87B, 0xB04F8577, 0x7EA5F7B7, 0xBDB4C3BC, 0x807B2B03, 0x4CE2C797,
    0x32D3F5EB, 0xF3E17B6F, 0x5BDE0B32, 0xA3A9A781, 0xE9E6518F, 0x6E54994D,
    0x465096CA, 0xBA6EE84F, 0xBEE8397D, 0x514B4A39, 0x68E569BA, 0x05786B4A,
    0x6E40DE37, 0xA1BC358C, 0xF41EF374, 0xA5766BE6, 0xC835A57C, 0xCE9EBC97,
    0xB4F7542D, 0x1EC9A7C0, 0xD51F650C, 0x6B7C2CA2, 0x52BDEF43, 0xE1B025D8,
    0xEE103791, 0x18A1BD7A, 0xEE4B582F, 0x4AB29760, 0xE3AC82D9, 0x26F1B3B2,
    0xAE0DF496, 0xB2E1A243, 0x025DEB10, 0x8561AB89, 0xF47A52F6, 0x37D16F0D,
    0x60AEB77C, 0xCF43DB2D, 0xBB5378DB, 0x45DEB115, 0xEA5ECB75, 0xF75B2792,
    0x7B11B34A, 0x3F6F7AE7, 0x72C1C6B9, 0x8B99AE49, 0xF845CCF0, 0x99AC1299,
    0x4B256502, 0x7897774C, 0x25CAA760, 0xC4F6525B, 0x8D867A55, 0x146C51E9,
    0xED281BD3, 0x45F48F8D, 0x13EA748F, 0xA504B4E9, 0x82916B28, 0xD2CF212D,
    0x294F0ACF, 0xDDAD9417, 0x2F116AC1, 0x4096D28A, 0xC5C0E769, 0xE9A562AF,
    0x9725627E, 0x948D00BE, 0x43ED2FA1, 0x0B42EBD7, 0x5623446C, 0xE05CCF61,
    0x312370F5, 0x6751555B, 0xA39AEAAB, 0xB133C995, 0x1DBDBC83, 0x240DE164,
    0x726C31EB, 0xBD00AEF5, 0x64B405B1, 0x752FD80F, 0xCF2D8F56, 0x1E30CA63,
    0xE9356F0F, 0x7A70AD34, 0x27D61BB0, 0x373F7D2F, 0xDBCAADFA, 0xE6BEE9DC,
    0x93879EFD, 0x129427C2, 0xF90B0858, 0x97DCAB04, 0x8C6D27E6, 0x0A5CADE8,
    0x852ACBF6, 0xD4D93BBB, 0x1F929399, 0xC3F3A4F0, 0xCD4F44F9, 0x6FB30451,
    0x3CE4A943, 0x44D372D9, 0xDAD9F7E7, 0x25EB417B, 0xB92D83D0, 0xFEABCA93,
    0xF786BD0A, 0x032766C0, 0xB85FB70F, 0xF9BB290F, 0x9F37BCAF, 0x64F9BEC7,
    0xDE21F93A, 0x0D61CA14, 0xD41E9EB1, 0xF67EDD2C, 0x4DDEF14D, 0xDEBDE393,
    0x5EF4B37D, 0x68E77230, 0x00480004, 0x59295041, 0xC3A64939, 0xD4293827,
    0xF157EF39, 0x33C56CE4, 0xC33C56CA, 0xA149E2B6, 0xA852CF15, 0x5D62D1E2,
    0xF1C95A60, 0xDFB07CD4, 0x29572F9A, 0x2EC57BA6, 0xD6069758, 0xFBE408AE,
    0xA13DC85E, 0xDCE67F21, 0x7E43C17C, 0xFF394D21, 0x433F827C, 0x0F9F93A6,
    0xA37FC87A, 0xBD891A94, 0x40AB14F7, 0x5815816A, 0x38BDE1D2, 0xBDBE30EA,
    0x627D2B3B, 0x70EA73A2, 0xD1A50D4E, 0xA1A36BE6, 0x83B5B658, 0x9DB5DE3C,
    0xBA6BA2BC, 0xB05C9694, 0xA517BCA7, 0xA952559E, 0xC96A72F9, 0x539E4D4E,
    0x8F5C5631, 0x970E65B1, 0xD37E2CDC, 0xE0EBD2CA, 0x14F66C9A, 0x9D945D2C,
    0x4B0B0A7E, 0xBA58E53F, 0x7B5B8799, 0xA78D75AE, 0xA7E96598, 0x39E81740,
    0xF7E5D6B4, 0x7D24DD74, 0x1F0EED61, 0xA9EFA2B1, 0xAF5DCDD3, 0xFBAFC3B3,
    0x829EC95D, 0xA1795725, 0xE97B9AA3, 0x7255D663, 0xAC1581E3, 0x1F4F6340,
    0x65A0F1BC, 0xF588F69D, 0x1F72B3C9, 0xB6516568, 0x42AC0D58, 0xF5EF7EEB,
    0xD2AE5CB5, 0x5968558D, 0x7A76F585, 0xDFA4BA69, 0x872CC135, 0x2C587D3E,
    0xC1DC3C3B, 0xF0F5EA2E, 0x87583EE2, 0x94EB15D6, 0x8DD7ACC5, 0xEE2CA5C7,
    0x0B7D06D3, 0x6BD65C9D, 0xD3E95D9A, 0x159EBA37, 0xBA38FCEB, 0x5BE71BDF,
    0x3C4D95E2, 0xB0A9EACA, 0xB4FA2A7E, 0xFA36FC6F, 0x537BF740, 0xE1D059EC,
    0x70E7CAC3, 0x2F2AE5A1, 0x8F649AF1, 0x9EAA792E, 0x581E15E2, 0x2B0723D8,
    0xED3AF27A, 0x22AE94FC, 0x10F0E3DE, 0xBF43A9EB, 0x7C2BA69D, 0x7D2C56FA,
    0xE67B25EF, 0x7EB1DF2E, 0x8F1EC97C, 0x2F055887, 0xFD9592DF, 0xF6FDA3B8,
    0x6278F694, 0xA6799A1D, 0x2759E798, 0x92EE7B2B, 0x61D1582E, 0xD0625EC4,
    0x2F9DC94F, 0x3E8AE958, 0x6792C439, 0xB1858315, 0x40E78CD6, 0xAEB4E7A3,
    0xC7EBBC45, 0x14F43E87, 0x652CA565, 0xF0C6F845, 0x78F76574, 0xDF8F55DE,
    0x7D189F46, 0xC3967BC4, 0xCF1BE863, 0xC6E86153, 0xB0F95E1E, 0xA760AF16,
    0x6EE2D82B, 0xED6BA2B8, 0x35FBD1D7, 0xDDEF78B2, 0x85B79F4D, 0xAF16593E,
    0x5A23A3BD, 0x8737AE55, 0x04B011DB, 0xB3DEAEB6, 0x9AE496FD, 0xF7A4C67E,
    0x6CA8EAF4, 0x4AC342E6, 0x76E9172D, 0x6B7AE9D2, 0x43BDEB07, 0xD56C6ED7,
    0x3C777A01, 0xF2BD90B5, 0xA4BB2B4C, 0xA1C5BA1C, 0x3D743B2F, 0x5AFC5A5E,
    0x0B897AF8, 0xDDE8FBCE, 0xB7E565AF, 0xA45E2EF2, 0x1EA47F34, 0x9A56335E,
    0x25D95B13, 0x28E0A456, 0x12958F52, 0x3742F0DE, 0xA9434F14, 0x1EED7081,
    0x2D661DE6, 0x6B7AB0F5, 0x432B25B3, 0x9DDEB0EF, 0x5DFB7AA6, 0x5DE883BB,
    0xA4BDEA69, 0x93D85D9E, 0x8B93D77B, 0xF36B9CAF, 0x2C785F16, 0x5A0494F5,
    0x8B91EBCC, 0xC8945CB0, 0xF14B6103, 0x22A4A47A, 0x7A2BBF7A, 0xD7B43B13,
    0x475A2684, 0x8718EDAE, 0x2099E503, 0x4E0A2AFB, 0x9471E547, 0xCAC48CAC,
    0x6931E28D, 0x12B6451E, 0x931E9E43, 0x4B49B9B5, 0x07A1A43D, 0xDE871BE6,
    0x9E05A29D, 0x3AA469CE, 0x60D5234D, 0x60FBE91A, 0xC0EC9A65, 0x844D06DB,
    0x4E9DD625, 0xBD1B9AE9, 0x4E576A70, 0x66F7AF7A, 0x6D605D2F, 0x76B4AE83,
    0x68E5798B, 0x1DB13CE2, 0x83C9611A, 0x43E35A4B, 0xB502B3D9, 0xA49E8693,
    0x2C24C0A5, 0xF86534B1, 0x2D4AF6F6, 0xE8617B78, 0x23961DE2, 0x29C8A5A7,
    0x8F33F6B2, 0x638DDA37, 0xF9D9C567, 0xBBA69DA8, 0x1795F8BD, 0xBE3EBC56,
    0x7BC636DE, 0x632DEB03, 0x519415BC, 0xF0B50D4F, 0x94D1CCA0, 0x787A53B5,
    0x9AA3EE94, 0x52A32996, 0x4BBF70E0, 0x6F3687B8, 0xD1BDE0EF, 0xBE6C8E5C,
    0x905B5F5E, 0x4EED6F35, 0x21F146A3, 0xAAB79A53, 0x252B78DC, 0x3053C2AD,
    0x701D91E0, 0xF5DC379B, 0x1B4B9416, 0xAE0F4A2E, 0xB86ACDE3, 0x7B344959,
    0xC172788C, 0xC45A6C8E, 0x76EE24C6, 0xBDE86EF4, 0x6FB15D5B, 0x1A5F67EF,
    0xF6F53ECF, 0xA2EC4F2E, 0xD621762B, 0x364DE95E, 0x607B227D, 0x5CBE73E5,
    0x791725A9, 0x4EADE63D, 0x74E62BAB, 0x3D10DCCD, 0x2053CFA5, 0x2305A992,
    0xB293E0B5, 0x992F4E9A, 0x25BA5A74, 0x4A97AB15, 0x1D5E02E5, 0xCAFCCD28,
    0xBC5262D1, 0x9F7C164B, 0x9E89AEF0, 0x34966096, 0x7E847558, 0x037D8ED2,
    0xA8EEDF23, 0xFC5C096D, 0x04754589, 0xD2781178, 0x60FDC581, 0xF42C1F89,
    0xB8125AC6, 0xB05703A6, 0x268F5EB5, 0xE2C83A1B, 0xB26D64DA, 0xC05B7EC0,
    0x92C0B7BE, 0x2AB31FCD, 0x9061DA6F, 0xC22D4937, 0x791569C1, 0xFE2E67F3,
    0x113E70FB, 0xBAD92EF0, 0xC1560592, 0x4867F0F5, 0x5CD23582, 0xF355E379,
    0x4EAD1783, 0x7059EEE3, 0x5145D64C, 0x9A730A76, 0x315AAF2A, 0xA3B34A50,
    0xA5CE05CE, 0xA4EF7C83, 0xCCFE2C53, 0x2B14AB04, 0x53A8693F, 0x28FCD2FF,
    0x1C87E698, 0x53D8681A, 0x2A14E57C, 0x7693F305, 0x04499FCA, 0x92CC0A94,
    0x489F490A, 0x768244F9, 0x1096069A, 0xA34D3A83, 0xFBC4C2D2, 0xFD79D5B2,
    0x4F35CEF0, 0x34A8B7E5, 0xB2B521C8, 0xC102777A, 0x8916B0C4, 0x05DC8F56,
    0x02034EE5, 0xB5BC0000, 0x12AD9231, 0x45650DEB, 0x56172731, 0x582C161F,
    0x9622E0BC, 0xF2B5D25E, 0x3E545622, 0x2F117A56, 0x88FA5D2F, 0x2CF5E615,
    0x0D114565, 0xB276B75A, 0x4333718A, 0x14D77BE7, 0xADE0BCBC, 0x13622E4A,
    0xBDE62397, 0xA19ADFBD, 0x4E281FC5, 0xB898189E, 0x751EC94E, 0xA8C2799E,
    0xD0BD6DC6, 0xDF47916C, 0xB76AC5E2, 0x848F9D26, 0x3D44572B, 0xD448B02D,
    0x5A181E07, 0xD2BCBC16, 0x9688D302, 0x3BC10424, 0xE0BCDE96, 0x10394055,
    0x93AC955C, 0xE93E9DBC, 0x4917A76D, 0x0B0A8A53, 0xEFD8232D, 0xA935F525,
    0x7937239F, 0xDE286524, 0x3EFD79FB, 0x3DFA4BEF, 0xFD5EEFDD, 0x86B7E296,
    0xA4992BBF, 0x6D569BDE, 0x74E2D4FA, 0x38C17E6B, 0xB618A869, 0x78E54672,
    0xBE04FB29, 0x1BB08497, 0x05C197E6, 0x194EF59B, 0x4BC59244, 0xBAF4BE8F,
    0x897F32FB, 0x953129DD, 0x4E9F9CD0, 0xC5F0DC33, 0x6EE77C7D, 0xDF3B9DCC,
    0x295DED60, 0xA37A60A5, 0x2D3B62D3, 0x46B4E019, 0xECB09316, 0xADD15AB0,
    0x9827D5A3, 0x44AA18C1, 0x4F3515B1, 0xD2F0512C, 0x3C827AC0, 0x4591E4D2,
    0x58593616, 0x6FA89F60, 0x3241EFA9, 0x3A17943F, 0xF43E93A5, 0x38B2E1A9,
    0x99FCD1AE, 0xF427EBD5, 0x3EBD80FA, 0x789FAF50, 0xF1584FC5, 0xA07C5701,
    0xAE313F15, 0xAFA45C6D, 0x25CD77DE, 0x70CD39DA, 0x3CD6982F, 0x27E57143,
    0xFF8204BD, 0x2FFC0205, 0x45FFC4C1, 0x1356269A, 0xBA9A0627, 0xA47A7DF4,
    0x95421DD3, 0x9C4A0403, 0x80091E1F, 0x02004D2C, 0x00080C22, 0x8252E044,
    0x00986016, 0xE442A108, 0x94C29A4A, 0x83B1C064, 0x10C36348, 0x2A002752,
    0x5A2A2424, 0xAAAAA461, 0x066F852F, 0x490EE795, 0x9CC4DEE2, 0xD3A88712,
    0x26071949, 0xA2019229, 0xA5C93EA2, 0x82412801, 0xFC09326F, 0xD811893D,
    0x01E89180, 0x0000153C,
};

/**
 * PSL represented as a directed acyclic graph
 * There are 8927 labels in 9548 nodes
 */
static const union pnode pnodes[9548] = {
    /* root entry */
    { .label = { 0, 0, 1 } }, { .child = { 2, 1539 } },
    /* entries 2 to 1840 */
    { .label = {    103,  2, 1 } }, { .child = { 1841, 6 } }, /* ac */
    { .label = {    124,  2, 1 } }, { .child = { 1847, 1 } }, /* ad */
    { .label = {     99,  2, 1 } }, { .child = { 1848, 9 } }, /* ae */
    { .label = {  81233,  4, 1 } }, { .child = { 1857, 87 } }, /* aero */
    { .label = {    109,  2, 1 } }, { .child = { 1944, 6 } }, /* af */
    { .label = {   1383,  2, 1 } }, { .child = { 1950, 5 } }, /* ag */
    { .label = {     60,  2, 1 } }, { .child = { 1955, 6 } }, /* ai */
    { .label = {     94,  2, 1 } }, { .child = { 1961, 8 } }, /* al */
    { .label = {     26,  2, 1 } }, { .child = { 1969, 6 } }, /* am */
    { .label = {   1422,  2, 1 } }, { .child = { 1975, 6 } }, /* ao */
    { .label = {   1428,  2, 0 } }, /* aq */
    { .label = {     45,  2, 1 } }, { .child = { 1981, 10 } }, /* ar */
    { .label = { 106447,  4, 1 } }, { .child = { 1993, 6 } }, /* arpa */
    { .label = {    128,  2, 1 } }, { .child = { 1999, 1 } }, /* as */
    { .label = {  10956,  4, 1 } }, { .child = { 2000, 1 } }, /* asia */
    { .label = {    160,  2, 1 } }, { .child = { 2001, 15 } }, /* at */
    { .label = {    117,  2, 1 } }, { .child = { 2033, 18 } }, /* au */
    { .label = {   4232,  2, 1 } }, { .child = { 2068, 1 } }, /* aw */
    { .label = {   1563,  2, 0 } }, /* ax */
    { .label = {    199,  2, 1 } }, { .child = { 2069, 12 } }, /* az */
    { .label = {    118,  2, 1 } }, { .child = { 2081, 7 } }, /* ba */
    { .label = {   6026,  2, 1 } }, { .child = { 2088, 10 } }, /* bb */
    { .label = {  21007,  2, 1 } }, { .child = { 2098, 1 } }, /* bd */
    { .label = {    555,  2, 1 } }, { .child = { 2099, 4 } }, /* be */
    { .label = {     62,  2, 1 } }, { .child = { 2105, 1 } }, /* bf */
    { .label = {   5497,  2, 1 } }, { .child = { 2106, 38 } }, /* bg */
    { .label = {   6880,  2, 1 } }, { .child = { 2144, 5 } }, /* bh */
    { .label = {    245,  2, 1 } }, { .child = { 2149, 5 } }, /* bi */
    { .label = {   3641,  3, 1 } }, { .child = { 2154, 14 } }, /* biz */
    { .label = {  17557,  2, 1 } }, { .child = { 2168, 4 } }, /* bj */
    { .label = {   1058,  2, 1 } }, { .child = { 2172, 5 } }, /* bm */
    { .label = {    716,  2, 1 } }, { .child = { 2177, 6 } }, /* bn */
    { .label = {   2883,  2, 1 } }, { .child = { 2183, 41 } }, /* bo */
    { .label = {    294,  2, 1 } }, { .child = { 2224, 129 } }, /* br */
    { .label = {    693,  2, 1 } }, { .child = { 2413, 6 } }, /* bs */
    { .label = {   4002,  2, 1 } }, { .child = { 2419, 5 } }, /* bt */
    { .label = {   1108,  2, 0 } }, /* bv */
    { .label = {   2526,  2, 1 } }, { .child = { 2424, 2 } }, /* bw */
    { .label = {   2832,  2, 1 } }, { .child = { 2426, 5 } }, /* by */
    { .label = {   9077,  2, 1 } }, { .child = { 2433, 7 } }, /* bz */
    { .label = {    133,  2, 1 } }, { .child = { 2440, 20 } }, /* ca */
    { .label = {    417,  3, 0 } }, /* cat */
    { .label = {    466,  2, 1 } }, { .child = { 2462, 7 } }, /* cc */
    { .label = {   2713,  2, 1 } }, { .child = { 2469, 1 } }, /* cd */
    { .label = {  22910,  2, 1 } }, { .child = { 2470, 1 } }, /* cf */
    { .label = {   2419,  2, 0 } }, /* cg */
    { .label = {    190,  2, 1 } }, { .child = { 2471, 9 } }, /* ch */
    { .label = {    471,  2, 1 } }, { .child = { 2480, 16 } }, /* ci */
    { .label = {     19,  2, 1 } }, { .child = { 2496, 2 } }, /* ck */
    { .label = {   2620,  2, 1 } }, { .child = { 2500, 6 } }, /* cl */
    { .label = {   8713,  2, 1 } }, { .child = { 2506, 4 } }, /* cm */
    { .label = {   2854,  2, 1 } }, { .child = { 2510, 45 } }, /* cn */
    { .label = {     42,  2, 1 } }, { .child = { 2571, 23 } }, /* co */
    { .label = {    106,  3, 1 } }, { .child = { 2598, 315 } }, /* com */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {   1284,  2, 1 } }, { .child = { 3084, 7 } }, /* cr */
    { .label = {   3660,  2, 1 } }, { .child = { 3091, 6 } }, /* cu */
    { .label = {   6329,  2, 1 } }, { .child = { 3097, 1 } }, /* cv */
    { .label = {   1444,  2, 1 } }, { .child = { 3098, 4 } }, /* cw */
    { .label = {   7137,  2, 1 } }, { .child = { 3102, 3 } }, /* cx */
    { .label = {    674,  2, 1 } }, { .child = { 3105, 13 } }, /* cy */
    { .label = {   5585,  2, 1 } }, { .child = { 3120, 6 } }, /* cz */
    { .label = {    243,  2, 1 } }, { .child = { 3134, 60 } }, /* de */
    { .label = {   7026,  2, 0 } }, /* dj */
    { .label = {   1421,  2, 1 } }, { .child = { 3205, 6 } }, /* dk */
    { .label = {   2224,  2, 1 } }, { .child = { 3211, 5 } }, /* dm */
    { .label = {    116,  2, 1 } }, { .child = { 3216, 10 } }, /* do */
    { .label = {    517,  2, 1 } }, { .child = { 3226, 8 } }, /* dz */
    { .label = {    102,  2, 1 } }, { .child = { 3234, 12 } }, /* ec */
    { .label = {  43572,  3, 1 } }, { .child = { 3246, 1 } }, /* edu */
    { .label = {     98,  2, 1 } }, { .child = { 3249, 10 } }, /* ee */
    { .label = {   2038,  2, 1 } }, { .child = { 3261, 9 } }, /* eg */
    { .label = {     44,  2, 1 } }, { .child = { 3272, 1 } }, /* er */
    { .label = {    141,  2, 1 } }, { .child = { 3273, 5 } }, /* es */
    { .label = {    421,  2, 1 } }, { .child = { 3280, 8 } }, /* et */
    { .label = {   2994,  2, 1 } }, { .child = { 3288, 7 } }, /* eu */
    { .label = {    391,  2, 1 } }, { .child = { 3297, 5 } }, /* fi */
    { .label = {   4617,  2, 1 } }, { .child = { 3302, 1 } }, /* fj */
    { .label = {   2776,  2, 1 } }, { .child = { 3303, 1 } }, /* fk */
    { .label = {   3284,  2, 0 } }, /* fm */
    { .label = {   5689,  2, 0 } }, /* fo */
    { .label = {    298,  2, 1 } }, { .child = { 3304, 28 } }, /* fr */
    { .label = {    313,  2, 0 } }, /* ga */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {    567,  2, 1 } }, { .child = { 3332, 1 } }, /* gd */
    { .label = {    267,  2, 1 } }, { .child = { 3333, 8 } }, /* ge */
    { .label = {  11817,  2, 0 } }, /* gf */
    { .label = {      9,  2, 1 } }, { .child = { 3341, 5 } }, /* gg */
    { .label = {    154,  2, 1 } }, { .child = { 3346, 5 } }, /* gh */
    { .label = {    217,  2, 1 } }, { .child = { 3351, 6 } }, /* gi */
    { .label = {   2424,  2, 1 } }, { .child = { 3357, 7 } }, /* gl */
    { .label = {   2441,  2, 0 } }, /* gm */
    { .label = {   1188,  2, 1 } }, { .child = { 3364, 6 } }, /* gn */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   7705,  2, 1 } }, { .child = { 3370, 6 } }, /* gp */
    { .label = {  12152,  2, 0 } }, /* gq */
    { .label = {   2701,  2, 1 } }, { .child = { 3376, 7 } }, /* gr */
    { .label = {    337,  2, 0 } }, /* gs */
    { .label = {   3759,  2, 1 } }, { .child = { 3383, 8 } }, /* gt */
    { .label = {   3007,  2, 1 } }, { .child = { 3391, 8 } }, /* gu */
    { .label = {      3,  2, 0 } }, /* gw */
    { .label = {   5477,  2, 1 } }, { .child = { 3399, 7 } }, /* gy */
    { .label = {   4197,  2, 1 } }, { .child = { 3406, 24 } }, /* hk */
    { .label = {   7073,  2, 0 } }, /* hm */
    { .label = {   1496,  2, 1 } }, { .child = { 3430, 7 } }, /* hn */
    { .label = {   1659,  2, 1 } }, { .child = { 3437, 6 } }, /* hr */
    { .label = {   1382,  2, 1 } }, { .child = { 3443, 17 } }, /* ht */
    { .label = {   1370,  2, 1 } }, { .child = { 3460, 32 } }, /* hu */
    { .label = {    143,  2, 1 } }, { .child = { 3492, 13 } }, /* id */
    { .label = {    119,  2, 1 } }, { .child = { 3507, 3 } }, /* ie */
    { .label = {    556,  2, 1 } }, { .child = { 3510, 8 } }, /* il */
    { .label = {   3011,  2, 1 } }, { .child = { 3520, 9 } }, /* im */
    { .label = {    100,  2, 1 } }, { .child = { 3532, 15 } }, /* in */
    { .label = { 112595,  4, 1 } }, { .child = { 3547, 20 } }, /* info */
    { .label = {   4229,  3, 1 } }, { .child = { 3567, 1 } }, /* int */
    { .label = {     63,  2, 1 } }, { .child = { 3568, 49 } }, /* io */
    { .label = {   3339,  2, 1 } }, { .child = { 3650, 6 } }, /* iq */
    { .label = {    200,  2, 1 } }, { .child = { 3656, 9 } }, /* ir */
    { .label = {    260,  2, 1 } }, { .child = { 3665, 8 } }, /* is */
    { .label = {    151,  2, 1 } }, { .child = { 3673, 411 } }, /* it */
    { .label = {   3761,  2, 1 } }, { .child = { 4084, 3 } }, /* je */
    { .label = {  19917,  2, 1 } }, { .child = { 4087, 1 } }, /* jm */
    { .label = {   1535,  2, 1 } }, { .child = { 4088, 8 } }, /* jo */
    { .label = { 167898,  4, 0 } }, /* jobs */
    { .label = {  12581,  2, 1 } }, { .child = { 4096, 112 } }, /* jp */
    { .label = {    136,  2, 1 } }, { .child = { 5965, 10 } }, /* ke */
    { .label = {   9000,  2, 1 } }, { .child = { 5977, 6 } }, /* kg */
    { .label = {   8714,  2, 1 } }, { .child = { 5983, 1 } }, /* kh */
    { .label = {     58,  2, 1 } }, { .child = { 5984, 7 } }, /* ki */
    { .label = {     24,  2, 1 } }, { .child = { 5991, 17 } }, /* km */
    { .label = {    225,  2, 1 } }, { .child = { 6008, 4 } }, /* kn */
    { .label = {  24281,  2, 1 } }, { .child = { 6012, 6 } }, /* kp */
    { .label = {     43,  2, 1 } }, { .child = { 6018, 30 } }, /* kr */
    { .label = {   5680,  2, 1 } }, { .child = { 6048, 7 } }, /* kw */
    { .label = {    494,  2, 1 } }, { .child = { 6055, 5 } }, /* ky */
    { .label = {   2855,  2, 1 } }, { .child = { 6060, 7 } }, /* kz */
    { .label = {    557,  2, 1 } }, { .child = { 6067, 11 } }, /* la */
    { .label = {    688,  2, 1 } }, { .child = { 6078, 5 } }, /* lb */
    { .label = {    101,  2, 1 } }, { .child = { 6083, 8 } }, /* lc */
    { .label = {   2828,  2, 1 } }, { .child = { 6091, 4 } }, /* li */
    { .label = {   2820,  2, 1 } }, { .child = { 6095, 15 } }, /* lk */
    { .label = {   1372,  2, 1 } }, { .child = { 6110, 5 } }, /* lr */
    { .label = {    140,  2, 1 } }, { .child = { 6115, 9 } }, /* ls */
    { .label = {    695,  2, 1 } }, { .child = { 6124, 3 } }, /* lt */
    { .label = {   2993,  2, 1 } }, { .child = { 6127, 2 } }, /* lu */
    { .label = {   3767,  2, 1 } }, { .child = { 6129, 9 } }, /* lv */
    { .label = {   7691,  2, 1 } }, { .child = { 6138, 9 } }, /* ly */
    { .label = {    194,  2, 1 } }, { .child = { 6147, 6 } }, /* ma */
    { .label = {   4196,  2, 1 } }, { .child = { 6153, 2 } }, /* mc */
    { .label = {   6744,  2, 1 } }, { .child = { 6155, 1 } }, /* md */
    { .label = {    591,  2, 1 } }, { .child = { 6156, 39 } }, /* me */
    { .label = {   1381,  2, 1 } }, { .child = { 6197, 9 } }, /* mg */
    { .label = {   8718,  2, 0 } }, /* mh */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    749,  2, 1 } }, { .child = { 6206, 9 } }, /* mk */
    { .label = {    242,  2, 1 } }, { .child = { 6215, 7 } }, /* ml */
    { .label = {    394,  2, 1 } }, { .child = { 6222, 1 } }, /* mm */
    { .label = {    571,  2, 1 } }, { .child = { 6223, 5 } }, /* mn */
    { .label = {   3360,  2, 1 } }, { .child = { 6228, 5 } }, /* mo */
    { .label = {  10207,  4, 1 } }, { .child = { 6233, 2 } }, /* mobi */
    { .label = {   6748,  2, 0 } }, /* mp */
    { .label = {   9862,  2, 0 } }, /* mq */
    { .label = {    205,  2, 1 } }, { .child = { 6235, 2 } }, /* mr */
    { .label = {    126,  2, 1 } }, { .child = { 6237, 6 } }, /* ms */
    { .label = {    158,  2, 1 } }, { .child = { 6243, 4 } }, /* mt */
    { .label = {    115,  2, 1 } }, { .child = { 6249, 7 } }, /* mu */
    { .label = {   4448,  6, 1 } }, { .child = { 6256, 548 } }, /* museum */
    { .label = {   9891,  2, 1 } }, { .child = { 6804, 14 } }, /* mv */
    { .label = {  11516,  2, 1 } }, { .child = { 6818, 11 } }, /* mw */
    { .label = {   2900,  2, 1 } }, { .child = { 6829, 7 } }, /* mx */
    { .label = {   1064,  2, 1 } }, { .child = { 6836, 8 } }, /* my */
    { .label = {   3991,  2, 1 } }, { .child = { 6844, 8 } }, /* mz */
    { .label = {     87,  2, 1 } }, { .child = { 6852, 17 } }, /* na */
    { .label = {  29770,  4, 1 } }, { .child = { 6869, 2 } }, /* name */
    { .label = {    311,  2, 1 } }, { .child = { 6875, 2 } }, /* nc */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {  13560,  3, 1 } }, { .child = { 6877, 114 } }, /* net */
    { .label = {    161,  2, 1 } }, { .child = { 7012, 10 } }, /* nf */
    { .label = {    761,  2, 1 } }, { .child = { 7022, 13 } }, /* ng */
    { .label = {    125,  2, 1 } }, { .child = { 7037, 14 } }, /* ni */
    { .label = {   2989,  2, 1 } }, { .child = { 7051, 8 } }, /* nl */
    { .label = {    188,  2, 1 } }, { .child = { 7061, 726 } }, /* no */
    { .label = {    521,  2, 1 } }, { .child = { 7859, 1 } }, /* np */
    { .label = {   1220,  2, 1 } }, { .child = { 7860, 7 } }, /* nr */
    { .label = {   1501,  2, 1 } }, { .child = { 7867, 6 } }, /* nu */
    { .label = {   3369,  2, 1 } }, { .child = { 7875, 17 } }, /* nz */
    { .label = {    111,  2, 1 } }, { .child = { 7894, 9 } }, /* om */
    { .label = {  60646,  5, 0 } }, /* onion */
    { .label = {    209,  3, 1 } }, { .child = { 7903, 109 } }, /* org */
    { .label = {    490,  2, 1 } }, { .child = { 8090, 11 } }, /* pa */
    { .label = {   5389,  2, 1 } }, { .child = { 8101, 9 } }, /* pe */
    { .label = {  22909,  2, 1 } }, { .child = { 8110, 3 } }, /* pf */
    { .label = {   4615,  2, 1 } }, { .child = { 8113, 1 } }, /* pg */
    { .label = {    189,  2, 1 } }, { .child = { 8114, 8 } }, /* ph */
    { .label = {     18,  2, 1 } }, { .child = { 8122, 14 } }, /* pk */
    { .label = {   2619,  2, 1 } }, { .child = { 8136, 172 } }, /* pl */
    { .label = {   8712,  2, 1 } }, { .child = { 8356, 1 } }, /* pm */
    { .label = {   2853,  2, 1 } }, { .child = { 8357, 5 } }, /* pn */
    { .label = {    324,  4, 0 } }, /* post */
    { .label = {   1283,  2, 1 } }, { .child = { 8362, 13 } }, /* pr */
    { .label = {  23051,  3, 1 } }, { .child = { 8375, 14 } }, /* pro */
    { .label = {    643,  2, 1 } }, { .child = { 8391, 7 } }, /* ps */
    { .label = {   1981,  2, 1 } }, { .child = { 8398, 10 } }, /* pt */
    { .label = {   1443,  2, 1 } }, { .child = { 8408, 9 } }, /* pw */
    { .label = {  34341,  2, 1 } }, { .child = { 8417, 7 } }, /* py */
    { .label = {    265,  2, 1 } }, { .child = { 8424, 10 } }, /* qa */
    { .label = {     55,  2, 1 } }, { .child = { 8434, 4 } }, /* re */
    { .label = {     17,  2, 1 } }, { .child = { 8438, 14 } }, /* ro */
    { .label = {     48,  2, 1 } }, { .child = { 8452, 10 } }, /* rs */
    { .label = {    204,  2, 1 } }, { .child = { 8462, 32 } }, /* ru */
    { .label = {    167,  2, 1 } }, { .child = { 8509, 7 } }, /* rw */
    { .label = {    355,  2, 1 } }, { .child = { 8516, 8 } }, /* sa */
    { .label = {    424,  2, 1 } }, { .child = { 8524, 5 } }, /* sb */
    { .label = {    601,  2, 1 } }, { .child = { 8529, 5 } }, /* sc */
    { .label = {    253,  2, 1 } }, { .child = { 8534, 8 } }, /* sd */
    { .label = {    629,  2, 1 } }, { .child = { 8542, 42 } }, /* se */
    { .label = {    168,  2, 1 } }, { .child = { 8584, 7 } }, /* sg */
    { .label = {    682,  2, 1 } }, { .child = { 8591, 9 } }, /* sh */
    { .label = {    699,  2, 1 } }, { .child = { 8602, 2 } }, /* si */
    { .label = {   3757,  2, 0 } }, /* sj */
    { .label = {    312,  2, 1 } }, { .child = { 8604, 2 } }, /* sk */
    { .label = {     88,  2, 1 } }, { .child = { 8606, 5 } }, /* sl */
    { .label = {   1519,  2, 0 } }, /* sm */
    { .label = {   1414,  2, 1 } }, { .child = { 8611, 8 } }, /* sn */
    { .label = {    131,  2, 1 } }, { .child = { 8619, 4 } }, /* so */
    { .label = {      2,  2, 0 } }, /* sr */
    { .label = {    214,  2, 1 } }, { .child = { 8623, 14 } }, /* st */
    { .label = {   1537,  2, 1 } }, { .child = { 8637, 53 } }, /* su */
    { .label = {    743,  2, 1 } }, { .child = { 8690, 5 } }, /* sv */
    { .label = {    179,  2, 1 } }, { .child = { 8695, 2 } }, /* sx */
    { .label = {    305,  2, 1 } }, { .child = { 8697, 6 } }, /* sy */
    { .label = {   1221,  2, 1 } }, { .child = { 8703, 3 } }, /* sz */
    { .label = {     15,  2, 0 } }, /* tc */
    { .label = {    568,  2, 1 } }, { .child = { 8706, 1 } }, /* td */
    { .label = {     89,  3, 0 } }, /* tel */
    { .label = {  11818,  2, 0 } }, /* tf */
    { .label = {     10,  2, 0 } }, /* tg */
    { .label = {    155,  2, 1 } }, { .child = { 8707, 9 } }, /* th */
    { .label = {   2411,  2, 1 } }, { .child = { 8716, 16 } }, /* tj */
    { .label = {    132,  2, 0 } }, /* tk */
    { .label = {   2425,  2, 1 } }, { .child = { 8732, 1 } }, /* tl */
    { .label = {   2442,  2, 1 } }, { .child = { 8733, 8 } }, /* tm */
    { .label = {    700,  2, 1 } }, { .child = { 8741, 20 } }, /* tn */
    { .label = {   1538,  2, 1 } }, { .child = { 8761, 7 } }, /* to */
    { .label = {    163,  2, 1 } }, { .child = { 8768, 22 } }, /* tr */
    { .label = {    302,  2, 1 } }, { .child = { 8794, 17 } }, /* tt */
    { .label = {   1222,  2, 1 } }, { .child = { 8811, 4 } }, /* tv */
    { .label = {      4,  2, 1 } }, { .child = { 8815, 16 } }, /* tw */
    { .label = {   1658,  2, 1 } }, { .child = { 8833, 12 } }, /* tz */
    { .label = {   1971,  2, 1 } }, { .child = { 8845, 82 } }, /* ua */
    { .label = {   2528,  2, 1 } }, { .child = { 8927, 10 } }, /* ug */
    { .label = {   2514,  2, 1 } }, { .child = { 8937, 12 } }, /* uk */
    { .label = {    296,  2, 1 } }, { .child = { 8970, 69 } }, /* us */
    { .label = {    223,  2, 1 } }, { .child = { 9266, 7 } }, /* uy */
    { .label = {   3282,  2, 1 } }, { .child = { 9275, 4 } }, /* uz */
    { .label = {     54,  2, 0 } }, /* va */
    { .label = {   3371,  2, 1 } }, { .child = { 9279, 7 } }, /* vc */
    { .label = {   1367,  2, 1 } }, { .child = { 9286, 17 } }, /* ve */
    { .label = {    174,  2, 1 } }, { .child = { 9303, 1 } }, /* vg */
    { .label = {    569,  2, 1 } }, { .child = { 9304, 5 } }, /* vi */
    { .label = {  11137,  2, 1 } }, { .child = { 9309, 13 } }, /* vn */
    { .label = {   3772,  2, 1 } }, { .child = { 9322, 4 } }, /* vu */
    { .label = {  11816,  2, 0 } }, /* wf */
    { .label = {    336,  2, 1 } }, { .child = { 9326, 9 } }, /* ws */
    { .label = {    250,  2, 0 } }, /* yt */
    { .label = {  29173, 14, 0 } }, /* xn--mgbaam7a8h */
    { .label = {  75430, 10, 0 } }, /* xn--y9a3aq */
    { .label = {  29246, 14, 0 } }, /* xn--54b7fta0cc */
    { .label = { 113659,  8, 0 } }, /* xn--90ae */
    { .label = {  93524,  9, 0 } }, /* xn--90ais */
    { .label = {  75488, 10, 0 } }, /* xn--fiqs8s */
    { .label = {  75543, 10, 0 } }, /* xn--fiqz9s */
    { .label = {  22711, 15, 0 } }, /* xn--lgbbat1ad8j */
    { .label = {  75602, 10, 0 } }, /* xn--wgbh1c */
    { .label = {  93573,  9, 0 } }, /* xn--e1a4c */
    { .label = { 113704,  8, 0 } }, /* xn--node */
    { .label = { 113741,  8, 0 } }, /* xn--qxam */
    { .label = {  59318, 11, 1 } }, { .child = { 9337, 6 } }, /* xn--j6w193g */
    { .label = {  59391, 11, 0 } }, /* xn--2scrj9c */
    { .label = {  59454, 11, 0 } }, /* xn--3hcrj9c */
    { .label = {  48093, 12, 0 } }, /* xn--45br5cyl */
    { .label = {  29330, 14, 0 } }, /* xn--h2breg3eve */
    { .label = {  37788, 13, 0 } }, /* xn--h2brj9c8c */
    { .label = {  48166, 12, 0 } }, /* xn--mgbgu82a */
    { .label = {  29404, 14, 0 } }, /* xn--rvc1e0am3e */
    { .label = {  37788, 11, 0 } }, /* xn--h2brj9c */
    { .label = {  29479, 11, 0 } }, /* xn--mgbbh1a */
    { .label = {  29479, 14, 0 } }, /* xn--mgbbh1a71e */
    { .label = {  37867, 13, 0 } }, /* xn--fpcrj9c3d */
    { .label = {  59518, 11, 0 } }, /* xn--gecrj9c */
    { .label = {  59578, 11, 0 } }, /* xn--s9brj9c */
    { .label = {  59644, 11, 0 } }, /* xn--45brj9c */
    { .label = {  11994, 17, 0 } }, /* xn--xkc2dl3a5ee0h */
    { .label = {  18109, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  25104, 14, 0 } }, /* xn--mgba3a4fra */
    { .label = {  59714, 11, 0 } }, /* xn--mgbtx2b */
    { .label = {  29558, 14, 0 } }, /* xn--mgbayh7gpa */
    { .label = {  48232, 12, 0 } }, /* xn--3e0b707e */
    { .label = {  59774, 11, 0 } }, /* xn--80ao21a */
    { .label = {  37943, 13, 0 } }, /* xn--fzc2c9e2c */
    { .label = {  16187, 16, 0 } }, /* xn--xkc2al3hye2a */
    { .label = {  22792, 15, 0 } }, /* xn--mgbc0a9azcg */
    { .label = {  93622,  9, 0 } }, /* xn--d1alf */
    { .label = {  93669,  9, 0 } }, /* xn--l1acc */
    { .label = {  59837, 11, 0 } }, /* xn--mix891f */
    { .label = {  59905, 11, 0 } }, /* xn--mix082f */
    { .label = {  29631, 14, 0 } }, /* xn--mgbx4cd0ab */
    { .label = {  48308, 12, 0 } }, /* xn--mgb9awbf */
    { .label = {  12089, 17, 0 } }, /* xn--mgbai9azgqp6j */
    { .label = {   9747, 18, 0 } }, /* xn--mgbai9a5eva00b */
    { .label = {  38021, 13, 0 } }, /* xn--ygbi2ammx */
    { .label = {  75657, 10, 1 } }, { .child = { 9343, 6 } }, /* xn--90a3ac */
    { .label = { 113868,  8, 0 } }, /* xn--p1ai */
    { .label = {  75714, 10, 0 } }, /* xn--wgbl6a */
    { .label = {  12187, 17, 0 } }, /* xn--mgberp4a5d4ar */
    { .label = {   7536, 19, 0 } }, /* xn--mgberp4a5d4a87g */
    { .label = {   7647, 19, 0 } }, /* xn--mgbqly7c0a67fbc */
    { .label = {  16273, 16, 0 } }, /* xn--mgbqly7cvafr */
    { .label = {  48375, 12, 0 } }, /* xn--mgbpl2fh */
    { .label = {  38089, 13, 0 } }, /* xn--yfro4i67o */
    { .label = {   2600, 22, 0 } }, /* xn--clchc0ea0b2g2a9gcd */
    { .label = {  48441, 12, 0 } }, /* xn--ogbpf8fl */
    { .label = {  48508, 12, 0 } }, /* xn--mgbtf8fl */
    { .label = {  75768, 10, 1 } }, { .child = { 9349, 6 } }, /* xn--o3cw4h */
    { .label = {  60031, 11, 0 } }, /* xn--pgbs0dh */
    { .label = {  60090, 11, 0 } }, /* xn--kpry57d */
    { .label = {  60154, 11, 0 } }, /* xn--kprw13d */
    { .label = {  60216, 11, 0 } }, /* xn--nnx388a */
    { .label = {  93860,  9, 0 } }, /* xn--j1amh */
    { .label = {  48643, 12, 0 } }, /* xn--mgb2ddes */
    { .label = { 171502,  3, 0 } }, /* xxx */
    { .label = {     38,  2, 1 } }, { .child = { 9355, 1 } }, /* ye */
    { .label = {   2924,  2, 1 } }, { .child = { 9356, 17 } }, /* za */
    { .label = {  21110,  2, 1 } }, { .child = { 9375, 11 } }, /* zm */
    { .label = {   4361,  2, 1 } }, { .child = { 9386, 5 } }, /* zw */
    { .label = {   3681,  3, 0 } }, /* aaa */
    { .label = {   7570,  4, 0 } }, /* aarp */
    { .label = { 152744,  6, 0 } }, /* abarth */
    { .label = {   6023,  3, 0 } }, /* abb */
    { .label = { 152769,  6, 0 } }, /* abbott */
    { .label = { 152796,  6, 0 } }, /* abbvie */
    { .label = {   2536,  3, 0 } }, /* abc */
    { .label = {   7911,  4, 0 } }, /* able */
    { .label = { 133075,  7, 0 } }, /* abogado */
    { .label = { 113909,  8, 0 } }, /* abudhabi */
    { .label = { 127480,  7, 1 } }, { .child = { 9391, 1 } }, /* academy */
    { .label = {  93908,  9, 0 } }, /* accenture */
    { .label = {  17091, 10, 0 } }, /* accountant */
    { .label = {  60279, 11, 0 } }, /* accountants */
    { .label = {    103,  3, 0 } }, /* aco */
    { .label = {  13408,  5, 0 } }, /* actor */
    { .label = {  26616,  4, 0 } }, /* adac */
    { .label = {  25070,  3, 0 } }, /* ads */
    { .label = { 157920,  5, 0 } }, /* adult */
    { .label = {  27279,  3, 0 } }, /* aeg */
    { .label = { 164205,  5, 0 } }, /* aetna */
    { .label = {  29709, 14, 0 } }, /* afamilycompany */
    { .label = {  19292,  3, 0 } }, /* afl */
    { .label = {  72022,  6, 0 } }, /* africa */
    { .label = { 133105,  7, 0 } }, /* agakhan */
    { .label = { 152825,  6, 0 } }, /* agency */
    { .label = {    677,  3, 0 } }, /* aig */
    { .label = {  42779,  4, 0 } }, /* aigo */
    { .label = { 152852,  6, 0 } }, /* airbus */
    { .label = { 113946,  8, 0 } }, /* airforce */
    { .label = { 152878,  6, 0 } }, /* airtel */
    { .label = {  81111,  4, 0 } }, /* akdn */
    { .label = {  93946,  9, 0 } }, /* alfaromeo */
    { .label = { 133133,  7, 0 } }, /* alibaba */
    { .label = { 152902,  6, 0 } }, /* alipay */
    { .label = {  93984,  9, 0 } }, /* allfinanz */
    { .label = { 113980,  8, 0 } }, /* allstate */
    { .label = { 169208,  4, 0 } }, /* ally */
    { .label = { 152929,  6, 0 } }, /* alsace */
    { .label = { 152953,  6, 0 } }, /* alstom */
    { .label = {  22964, 15, 0 } }, /* americanexpress */
    { .label = {  29774, 14, 0 } }, /* americanfamily */
    { .label = { 133352,  4, 0 } }, /* amex */
    { .label = { 164223,  5, 0 } }, /* amfam */
    { .label = { 164245,  5, 0 } }, /* amica */
    { .label = {  87851,  9, 0 } }, /* amsterdam */
    { .label = {  94025,  9, 0 } }, /* analytics */
    { .label = { 133163,  7, 0 } }, /* android */
    { .label = { 152978,  6, 0 } }, /* anquan */
    { .label = {   3438,  3, 0 } }, /* anz */
    { .label = {   2310,  3, 0 } }, /* aol */
    { .label = {  75825, 10, 0 } }, /* apartments */
    { .label = {   6750,  3, 1 } }, { .child = { 9392, 6 } }, /* app */
    { .label = { 164265,  5, 0 } }, /* apple */
    { .label = {  94063,  9, 0 } }, /* aquarelle */
    { .label = {  21042,  4, 0 } }, /* arab */
    { .label = { 153005,  6, 0 } }, /* aramco */
    { .label = {  24466,  5, 0 } }, /* archi */
    { .label = {  36117,  4, 0 } }, /* army */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {  17285,  4, 0 } }, /* arte */
    { .label = {   2553,  4, 0 } }, /* asda */
    { .label = {  75866, 10, 0 } }, /* associates */
    { .label = { 133192,  7, 0 } }, /* athleta */
    { .label = { 114012,  8, 0 } }, /* attorney */
    { .label = { 133220,  7, 0 } }, /* auction */
    { .label = { 133249,  4, 0 } }, /* audi */
    { .label = { 133249,  7, 0 } }, /* audible */
    { .label = { 164289,  5, 0 } }, /* audio */
    { .label = { 133281,  7, 0 } }, /* auspost */
    { .label = { 140745,  6, 0 } }, /* author */
    { .label = {  71620,  4, 0 } }, /* auto */
    { .label = { 164310,  5, 0 } }, /* autos */
    { .label = { 133311,  7, 0 } }, /* avianca */
    { .label = {  17926,  3, 0 } }, /* aws */
    { .label = {   7471,  3, 0 } }, /* axa */
    { .label = {  32115,  5, 0 } }, /* azure */
    { .label = { 169227,  4, 0 } }, /* baby */
    { .label = { 164330,  5, 0 } }, /* baidu */
    { .label = { 133339,  7, 0 } }, /* banamex */
    { .label = {  29835, 14, 0 } }, /* bananarepublic */
    { .label = {   2996,  4, 0 } }, /* band */
    { .label = {  95308,  4, 0 } }, /* bank */
    { .label = {   3030,  3, 0 } }, /* bar */
    { .label = {  88112,  9, 0 } }, /* barcelona */
    { .label = {  60324, 11, 0 } }, /* barclaycard */
    { .label = { 114045,  8, 0 } }, /* barclays */
    { .label = { 114081,  8, 0 } }, /* barefoot */
    { .label = { 114116,  8, 0 } }, /* bargains */
    { .label = { 108062,  8, 0 } }, /* baseball */
    { .label = {  75905, 10, 0 } }, /* basketball */
    { .label = { 133370,  7, 0 } }, /* bauhaus */
    { .label = { 153029,  6, 0 } }, /* bayern */
    { .label = { 152903,  3, 0 } }, /* bbc */
    { .label = {  50591,  3, 0 } }, /* bbt */
    { .label = { 169248,  4, 0 } }, /* bbva */
    { .label = { 171520,  3, 0 } }, /* bcg */
    { .label = {  24384,  3, 0 } }, /* bcn */
    { .label = { 164353,  5, 0 } }, /* beats */
    { .label = { 153056,  6, 0 } }, /* beauty */
    { .label = {  81226,  4, 0 } }, /* beer */
    { .label = { 133401,  7, 0 } }, /* bentley */
    { .label = {  79817,  6, 0 } }, /* berlin */
    { .label = {   4853,  4, 0 } }, /* best */
    { .label = { 133434,  7, 0 } }, /* bestbuy */
    { .label = {   9421,  3, 0 } }, /* bet */
    { .label = { 153084,  6, 0 } }, /* bharti */
    { .label = { 161387,  5, 0 } }, /* bible */
    { .label = {  19326,  3, 0 } }, /* bid */
    { .label = { 169269,  4, 0 } }, /* bike */
    { .label = {  54562,  4, 0 } }, /* bing */
    { .label = { 164374,  5, 0 } }, /* bingo */
    { .label = {  43936,  3, 0 } }, /* bio */
    { .label = {  50116,  5, 0 } }, /* black */
    { .label = {  60373, 11, 0 } }, /* blackfriday */
    { .label = {  60425, 11, 0 } }, /* blockbuster */
    { .label = {  16892,  4, 0 } }, /* blog */
    { .label = {  94104,  9, 0 } }, /* bloomberg */
    { .label = { 169288,  4, 0 } }, /* blue */
    { .label = { 104761,  3, 0 } }, /* bms */
    { .label = { 171536,  3, 0 } }, /* bmw */
    { .label = { 136135,  3, 0 } }, /* bnl */
    { .label = {  75950, 10, 0 } }, /* bnpparibas */
    { .label = { 164397,  5, 0 } }, /* boats */
    { .label = {  75996, 10, 0 } }, /* boehringer */
    { .label = { 169308,  4, 0 } }, /* bofa */
    { .label = {  15065,  3, 0 } }, /* bom */
    { .label = { 169327,  4, 0 } }, /* bond */
    { .label = {  24125,  3, 0 } }, /* boo */
    { .label = {  24125,  4, 0 } }, /* book */
    { .label = { 133469,  7, 0 } }, /* booking */
    { .label = { 164418,  5, 0 } }, /* bosch */
    { .label = { 153110,  6, 0 } }, /* bostik */
    { .label = { 148381,  6, 0 } }, /* boston */
    { .label = {  19704,  3, 0 } }, /* bot */
    { .label = { 114149,  8, 0 } }, /* boutique */
    { .label = {  17989,  3, 0 } }, /* box */
    { .label = { 114189,  8, 0 } }, /* bradesco */
    { .label = {  60477, 11, 0 } }, /* bridgestone */
    { .label = { 114224,  8, 0 } }, /* broadway */
    { .label = { 140770,  6, 0 } }, /* broker */
    { .label = { 133501,  7, 0 } }, /* brother */
    { .label = { 108175,  8, 0 } }, /* brussels */
    { .label = { 114261,  8, 0 } }, /* budapest */
    { .label = { 133532,  7, 0 } }, /* bugatti */
    { .label = { 108211,  5, 0 } }, /* build */
    { .label = { 114298,  8, 0 } }, /* builders */
    { .label = { 114335,  8, 1 } }, { .child = { 9400, 1 } }, /* business */
    { .label = {  78537,  3, 0 } }, /* buy */
    { .label = { 169346,  4, 0 } }, /* buzz */
    { .label = {   9077,  3, 0 } }, /* bzh */
    { .label = {  66141,  3, 0 } }, /* cab */
    { .label = {  61035,  4, 0 } }, /* cafe */
    { .label = {   4725,  3, 0 } }, /* cal */
    { .label = { 169371,  4, 0 } }, /* call */
    { .label = {  60525, 11, 0 } }, /* calvinklein */
    { .label = {    444,  3, 0 } }, /* cam */
    { .label = {  17734,  6, 0 } }, /* camera */
    { .label = {  18912,  4, 0 } }, /* camp */
    { .label = {  29897, 14, 0 } }, /* cancerresearch */
    { .label = { 164442,  5, 0 } }, /* canon */
    { .label = { 114370,  8, 0 } }, /* capetown */
    { .label = {  76040,  7, 0 } }, /* capital */
    { .label = {  76040, 10, 0 } }, /* capitalone */
    { .label = {    853,  3, 0 } }, /* car */
    { .label = { 133563,  7, 0 } }, /* caravan */
    { .label = { 164462,  5, 0 } }, /* cards */
    { .label = {  13314,  4, 0 } }, /* care */
    { .label = { 133591,  6, 0 } }, /* career */
    { .label = { 133591,  7, 0 } }, /* careers */
    { .label = {  39978,  4, 0 } }, /* cars */
    { .label = { 133619,  7, 0 } }, /* cartier */
    { .label = {  26570,  4, 1 } }, { .child = { 9401, 1 } }, /* casa */
    { .label = { 121029,  4, 0 } }, /* case */
    { .label = { 153137,  6, 0 } }, /* caseih */
    { .label = {  72509,  4, 0 } }, /* cash */
    { .label = { 141290,  6, 0 } }, /* casino */
    { .label = {  98374,  8, 0 } }, /* catering */
    { .label = { 114406,  8, 0 } }, /* catholic */
    { .label = {   3809,  3, 0 } }, /* cba */
    { .label = {  12602,  3, 0 } }, /* cbn */
    { .label = { 106748,  4, 0 } }, /* cbre */
    { .label = {  29967,  3, 0 } }, /* cbs */
    { .label = {   9991,  3, 0 } }, /* ceb */
    { .label = {  26784,  6, 0 } }, /* center */
    { .label = {  51258,  3, 0 } }, /* ceo */
    { .label = {  89253,  4, 0 } }, /* cern */
    { .label = {  60762,  3, 0 } }, /* cfa */
    { .label = { 114102,  3, 0 } }, /* cfd */
    { .label = { 153162,  6, 0 } }, /* chanel */
    { .label = {  29986,  7, 0 } }, /* channel */
    { .label = { 133647,  7, 0 } }, /* charity */
    { .label = { 164483,  5, 0 } }, /* chase */
    { .label = {  56743,  4, 0 } }, /* chat */
    { .label = { 164504,  5, 0 } }, /* cheap */
    { .label = { 133678,  7, 0 } }, /* chintai */
    { .label = {  94147,  9, 0 } }, /* christmas */
    { .label = { 153188,  6, 0 } }, /* chrome */
    { .label = { 114441,  8, 0 } }, /* chrysler */
    { .label = { 153215,  6, 0 } }, /* church */
    { .label = { 114478,  8, 0 } }, /* cipriani */
    { .label = { 153244,  6, 0 } }, /* circle */
    { .label = {  44471,  5, 0 } }, /* cisco */
    { .label = { 133707,  7, 0 } }, /* citadel */
    { .label = {  16787,  4, 0 } }, /* citi */
    { .label = { 164527,  5, 0 } }, /* citic */
    { .label = {  98160,  4, 1 } }, { .child = { 9404, 1 } }, /* city */
    { .label = { 114512,  8, 0 } }, /* cityeats */
    { .label = { 153271,  6, 0 } }, /* claims */
    { .label = { 114546,  8, 0 } }, /* cleaning */
    { .label = { 164549,  5, 0 } }, /* click */
    { .label = { 153297,  6, 0 } }, /* clinic */
    { .label = { 114580,  8, 0 } }, /* clinique */
    { .label = { 114619,  8, 0 } }, /* clothing */
    { .label = {  13493,  5, 1 } }, { .child = { 9405, 8 } }, /* cloud */
    { .label = {  98320,  4, 1 } }, { .child = { 9421, 3 } }, /* club */
    { .label = { 133737,  7, 0 } }, /* clubmed */
    { .label = { 164573,  5, 0 } }, /* coach */
    { .label = { 118470,  5, 0 } }, /* codes */
    { .label = { 153324,  6, 0 } }, /* coffee */
    { .label = {  51588,  7, 0 } }, /* college */
    { .label = { 133772,  7, 0 } }, /* cologne */
    { .label = { 133803,  7, 0 } }, /* comcast */
    { .label = { 114655,  8, 0 } }, /* commbank */
    { .label = {  88350,  9, 1 } }, { .child = { 9424, 1 } }, /* community */
    { .label = {  29741,  7, 0 } }, /* company */
    { .label = { 133833,  7, 0 } }, /* compare */
    { .label = {  19964,  8, 0 } }, /* computer */
    { .label = { 153353,  6, 0 } }, /* comsec */
    { .label = { 153380,  6, 0 } }, /* condos */
    { .label = {  48705, 12, 0 } }, /* construction */
    { .label = {  67018, 10, 0 } }, /* consulting */
    { .label = { 133864,  7, 0 } }, /* contact */
    { .label = {  60574, 11, 0 } }, /* contractors */
    { .label = {  29955,  7, 0 } }, /* cooking */
    { .label = {  29955, 14, 0 } }, /* cookingchannel */
    { .label = { 169389,  4, 1 } }, { .child = { 9425, 1 } }, /* cool */
    { .label = { 133893,  7, 0 } }, /* corsica */
    { .label = {  20438,  7, 0 } }, /* country */
    { .label = { 133922,  6, 0 } }, /* coupon */
    { .label = { 133922,  7, 0 } }, /* coupons */
    { .label = { 133954,  7, 0 } }, /* courses */
    { .label = {  60619,  6, 0 } }, /* credit */
    { .label = {  76082, 10, 0 } }, /* creditcard */
    { .label = {  60619, 11, 0 } }, /* creditunion */
    { .label = { 133984,  7, 0 } }, /* cricket */
    { .label = { 164595,  5, 0 } }, /* crown */
    { .label = {  23280,  3, 0 } }, /* crs */
    { .label = { 134015,  6, 0 } }, /* cruise */
    { .label = { 134015,  7, 0 } }, /* cruises */
    { .label = {  17770,  3, 0 } }, /* csc */
    { .label = {  76125, 10, 0 } }, /* cuisinella */
    { .label = { 161437,  5, 0 } }, /* cymru */
    { .label = { 169407,  4, 0 } }, /* cyou */
    { .label = { 164618,  5, 0 } }, /* dabur */
    { .label = {   6606,  3, 0 } }, /* dad */
    { .label = { 164641,  5, 0 } }, /* dance */
    { .label = {  40867,  4, 0 } }, /* data */
    { .label = {  31483,  4, 0 } }, /* date */
    { .label = { 153406,  6, 0 } }, /* dating */
    { .label = { 153431,  6, 0 } }, /* datsun */
    { .label = {  17489,  3, 0 } }, /* day */
    { .label = { 169427,  4, 0 } }, /* dclk */
    { .label = {   3081,  3, 0 } }, /* dds */
    { .label = {   4238,  4, 0 } }, /* deal */
    { .label = {  81685,  6, 0 } }, /* dealer */
    { .label = { 164662,  5, 0 } }, /* deals */
    { .label = { 153456,  6, 0 } }, /* degree */
    { .label = { 114692,  8, 0 } }, /* delivery */
    { .label = {   3397,  4, 0 } }, /* dell */
    { .label = { 114730,  8, 0 } }, /* deloitte */
    { .label = { 164683,  5, 0 } }, /* delta */
    { .label = {  39357,  8, 0 } }, /* democrat */
    { .label = { 153482,  6, 0 } }, /* dental */
    { .label = {    243,  7, 0 } }, /* dentist */
    { .label = {  26966,  4, 0 } }, /* desi */
    { .label = {  26966,  6, 1 } }, { .child = { 9426, 1 } }, /* design */
    { .label = {   9075,  3, 1 } }, { .child = { 9427, 4 } }, /* dev */
    { .label = {  14743,  3, 0 } }, /* dhl */
    { .label = { 114764,  8, 0 } }, /* diamonds */
    { .label = { 150592,  4, 0 } }, /* diet */
    { .label = { 134045,  7, 1 } }, { .child = { 9435, 1 } }, /* digital */
    { .label = {  13394,  6, 1 } }, { .child = { 9438, 1 } }, /* direct */
    { .label = {  13394,  9, 0 } }, /* directory */
    { .label = { 114798,  8, 0 } }, /* discount */
    { .label = {  88431,  8, 0 } }, /* discover */
    { .label = { 169447,  4, 0 } }, /* dish */
    { .label = {    278,  3, 0 } }, /* diy */
    { .label = {   7373,  3, 0 } }, /* dnp */
    { .label = {  66470,  4, 0 } }, /* docs */
    { .label = {  64495,  6, 0 } }, /* doctor */
    { .label = { 119416,  5, 0 } }, /* dodge */
    { .label = {  19409,  3, 0 } }, /* dog */
    { .label = { 134075,  7, 0 } }, /* domains */
    { .label = {   9899,  3, 0 } }, /* dot */
    { .label = { 114833,  8, 0 } }, /* download */
    { .label = { 164704,  5, 0 } }, /* drive */
    { .label = {  58989,  3, 0 } }, /* dtv */
    { .label = { 164727,  5, 0 } }, /* dubai */
    { .label = { 136950,  4, 0 } }, /* duck */
    { .label = { 153507,  6, 0 } }, /* dunlop */
    { .label = {  11717,  4, 0 } }, /* duns */
    { .label = { 153536,  6, 0 } }, /* dupont */
    { .label = { 153564,  6, 0 } }, /* durban */
    { .label = { 169465,  4, 0 } }, /* dvag */
    { .label = {  65337,  3, 0 } }, /* dvr */
    { .label = { 164750,  5, 1 } }, { .child = { 9439, 1 } }, /* earth */
    { .label = {   8003,  3, 0 } }, /* eat */
    { .label = {    102,  3, 0 } }, /* eco */
    { .label = { 164770,  5, 0 } }, /* edeka */
    { .label = {  43572,  9, 1 } }, { .child = { 9445, 1 } }, /* education */
    { .label = {  40323,  5, 0 } }, /* email */
    { .label = { 153591,  6, 0 } }, /* emerck */
    { .label = { 153618,  6, 0 } }, /* energy */
    { .label = {  31698,  8, 0 } }, /* engineer */
    { .label = {  60666, 11, 0 } }, /* engineering */
    { .label = {  60712, 11, 0 } }, /* enterprises */
    { .label = { 164791,  5, 0 } }, /* epson */
    { .label = {  34890,  9, 0 } }, /* equipment */
    { .label = { 114869,  8, 0 } }, /* ericsson */
    { .label = {  75218,  4, 0 } }, /* erni */
    { .label = { 136580,  3, 0 } }, /* esq */
    { .label = {  20470,  6, 1 } }, { .child = { 9446, 1 } }, /* estate */
    { .label = { 114902,  8, 0 } }, /* esurance */
    { .label = { 114935,  8, 0 } }, /* etisalat */
    { .label = {  76168, 10, 0 } }, /* eurovision */
    { .label = {  15235,  3, 1 } }, { .child = { 9449, 1 } }, /* eus */
    { .label = { 153645,  6, 1 } }, { .child = { 9452, 1 } }, /* events */
    { .label = { 114966,  8, 0 } }, /* everbank */
    { .label = {  40551,  8, 0 } }, /* exchange */
    { .label = {   7850,  6, 0 } }, /* expert */
    { .label = { 134104,  7, 0 } }, /* exposed */
    { .label = {  22996,  7, 0 } }, /* express */
    { .label = {  76211, 10, 0 } }, /* extraspace */
    { .label = { 169484,  4, 0 } }, /* fage */
    { .label = {  57346,  4, 0 } }, /* fail */
    { .label = {  94185,  9, 0 } }, /* fairwinds */
    { .label = { 164813,  5, 1 } }, { .child = { 9453, 1 } }, /* faith */
    { .label = {  29712,  6, 0 } }, /* family */
    { .label = {   3070,  3, 0 } }, /* fan */
    { .label = {  67490,  4, 0 } }, /* fans */
    { .label = {  13412,  4, 1 } }, { .child = { 9454, 1 } }, /* farm */
    { .label = { 128090,  7, 0 } }, /* farmers */
    { .label = { 134137,  7, 1 } }, { .child = { 9455, 2 } }, /* fashion */
    { .label = {  17475,  4, 0 } }, /* fast */
    { .label = { 164835,  5, 0 } }, /* fedex */
    { .label = { 115002,  8, 0 } }, /* feedback */
    { .label = { 134167,  7, 0 } }, /* ferrari */
    { .label = { 134196,  7, 0 } }, /* ferrero */
    { .label = { 169502,  4, 0 } }, /* fiat */
    { .label = { 115040,  8, 0 } }, /* fidelity */
    { .label = { 169519,  4, 0 } }, /* fido */
    { .label = {  81295,  4, 0 } }, /* film */
    { .label = { 164860,  5, 0 } }, /* final */
    { .label = { 134226,  7, 0 } }, /* finance */
    { .label = {   3951,  9, 1 } }, { .child = { 9457, 1 } }, /* financial */
    { .label = {  15072,  4, 0 } }, /* fire */
    { .label = {  94225,  9, 0 } }, /* firestone */
    { .label = { 115078,  8, 0 } }, /* firmdale */
    { .label = { 134256,  4, 0 } }, /* fish */
    { .label = { 134256,  7, 0 } }, /* fishing */
    { .label = {  19771,  3, 1 } }, { .child = { 9458, 1 } }, /* fit */
    { .label = { 134288,  7, 0 } }, /* fitness */
    { .label = { 153671,  6, 0 } }, /* flickr */
    { .label = { 134318,  7, 0 } }, /* flights */
    { .label = { 169538,  4, 0 } }, /* flir */
    { .label = { 134351,  7, 0 } }, /* florist */
    { .label = { 134382,  7, 0 } }, /* flowers */
    { .label = {  51286,  3, 0 } }, /* fly */
    { .label = {  29321,  3, 0 } }, /* foo */
    { .label = {  60758,  4, 0 } }, /* food */
    { .label = {  60758, 11, 0 } }, /* foodnetwork */
    { .label = { 115114,  8, 1 } }, { .child = { 9459, 1 } }, /* football */
    { .label = { 149182,  4, 0 } }, /* ford */
    { .label = { 164882,  5, 0 } }, /* forex */
    { .label = { 134415,  7, 0 } }, /* forsale */
    { .label = { 156973,  5, 0 } }, /* forum */
    { .label = {  72229, 10, 0 } }, /* foundation */
    { .label = {  51380,  3, 0 } }, /* fox */
    { .label = {  56927,  4, 0 } }, /* free */
    { .label = {  94263,  9, 0 } }, /* fresenius */
    { .label = {  94804,  3, 0 } }, /* frl */
    { .label = { 134445,  7, 0 } }, /* frogans */
    { .label = {  94302,  9, 0 } }, /* frontdoor */
    { .label = { 115151,  8, 0 } }, /* frontier */
    { .label = {  20251,  3, 0 } }, /* ftr */
    { .label = { 134475,  7, 0 } }, /* fujitsu */
    { .label = {  94341,  9, 0 } }, /* fujixerox */
    { .label = {  32010,  3, 0 } }, /* fun */
    { .label = { 108749,  4, 0 } }, /* fund */
    { .label = {  88782,  9, 0 } }, /* furniture */
    { .label = { 153700,  6, 0 } }, /* futbol */
    { .label = { 171553,  3, 0 } }, /* fyi */
    { .label = {    549,  3, 0 } }, /* gal */
    { .label = {  71588,  7, 0 } }, /* gallery */
    { .label = { 110000,  5, 0 } }, /* gallo */
    { .label = { 153730,  6, 0 } }, /* gallup */
    { .label = {  39696,  4, 0 } }, /* game */
    { .label = {  39696,  5, 0 } }, /* games */
    { .label = {  51759,  3, 0 } }, /* gap */
    { .label = {  19742,  6, 0 } }, /* garden */
    { .label = { 169557,  4, 0 } }, /* gbiz */
    { .label = {   7368,  3, 1 } }, { .child = { 9460, 1 } }, /* gdn */
    { .label = {  22955,  3, 0 } }, /* gea */
    { .label = {  13266,  4, 0 } }, /* gent */
    { .label = { 134510,  7, 0 } }, /* genting */
    { .label = { 153759,  6, 0 } }, /* george */
    { .label = { 169579,  4, 0 } }, /* ggee */
    { .label = {  76821,  4, 0 } }, /* gift */
    { .label = { 164906,  5, 0 } }, /* gifts */
    { .label = { 164929,  5, 0 } }, /* gives */
    { .label = { 153785,  6, 0 } }, /* giving */
    { .label = { 164952,  5, 0 } }, /* glade */
    { .label = { 161531,  5, 0 } }, /* glass */
    { .label = {   5340,  3, 0 } }, /* gle */
    { .label = { 153813,  6, 0 } }, /* global */
    { .label = { 164974,  5, 0 } }, /* globo */
    { .label = { 134734,  5, 0 } }, /* gmail */
    { .label = { 169597,  4, 0 } }, /* gmbh */
    { .label = {  48951,  3, 0 } }, /* gmo */
    { .label = {  16542,  3, 0 } }, /* gmx */
    { .label = { 134540,  7, 0 } }, /* godaddy */
    { .label = {  94387,  4, 0 } }, /* gold */
    { .label = {  94387,  9, 0 } }, /* goldpoint */
    { .label = { 140046,  4, 0 } }, /* golf */
    { .label = {  17177,  3, 0 } }, /* goo */
    { .label = { 115185,  8, 0 } }, /* goodyear */
    { .label = {  79618,  4, 1 } }, { .child = { 9461, 1 } }, /* goog */
    { .label = {  79618,  6, 0 } }, /* google */
    { .label = {  12949,  3, 0 } }, /* gop */
    { .label = {  42786,  3, 0 } }, /* got */
    { .label = { 115220,  8, 0 } }, /* grainger */
    { .label = {  35071,  8, 0 } }, /* graphics */
    { .label = { 153841,  6, 0 } }, /* gratis */
    { .label = {  78787,  5, 0 } }, /* green */
    { .label = { 164998,  5, 0 } }, /* gripe */
    { .label = { 134573,  7, 0 } }, /* grocery */
    { .label = {  41026,  5, 1 } }, { .child = { 9462, 1 } }, /* group */
    { .label = { 115253,  8, 0 } }, /* guardian */
    { .label = { 165021,  5, 0 } }, /* gucci */
    { .label = { 169618,  4, 0 } }, /* guge */
    { .label = { 165045,  5, 0 } }, /* guide */
    { .label = { 134605,  7, 0 } }, /* guitars */
    { .label = {  96563,  4, 0 } }, /* guru */
    { .label = { 137124,  4, 0 } }, /* hair */
    { .label = { 128273,  7, 0 } }, /* hamburg */
    { .label = { 134634,  7, 0 } }, /* hangout */
    { .label = { 133384,  4, 0 } }, /* haus */
    { .label = {  73612,  3, 0 } }, /* hbo */
    { .label = { 115286,  4, 0 } }, /* hdfc */
    { .label = { 115286,  8, 0 } }, /* hdfcbank */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {  76254, 10, 0 } }, /* healthcare */
    { .label = { 169637,  4, 0 } }, /* help */
    { .label = { 108821,  8, 0 } }, /* helsinki */
    { .label = {  10067,  4, 0 } }, /* here */
    { .label = { 153865,  6, 0 } }, /* hermes */
    { .label = { 169657,  4, 0 } }, /* hgtv */
    { .label = { 153891,  6, 0 } }, /* hiphop */
    { .label = {  94428,  9, 0 } }, /* hisamitsu */
    { .label = {  42498,  7, 0 } }, /* hitachi */
    { .label = {  10177,  3, 0 } }, /* hiv */
    { .label = {  16843,  3, 0 } }, /* hkt */
    { .label = {  39793,  6, 0 } }, /* hockey */
    { .label = { 115325,  8, 0 } }, /* holdings */
    { .label = { 134664,  7, 0 } }, /* holiday */
    { .label = {  94466,  9, 0 } }, /* homedepot */
    { .label = {  94507,  9, 0 } }, /* homegoods */
    { .label = {  24700,  5, 0 } }, /* homes */
    { .label = {  94547,  9, 0 } }, /* homesense */
    { .label = { 165068,  5, 0 } }, /* honda */
    { .label = {  94585,  9, 0 } }, /* honeywell */
    { .label = { 165089,  5, 0 } }, /* horse */
    { .label = { 115361,  8, 0 } }, /* hospital */
    { .label = {  23781,  4, 1 } }, { .child = { 9463, 4 } }, /* host */
    { .label = {  23781,  7, 1 } }, { .child = { 9467, 1 } }, /* hosting */
    { .label = {  13092,  3, 0 } }, /* hot */
    { .label = { 134696,  7, 0 } }, /* hoteles */
    { .label = {  60878,  6, 0 } }, /* hotels */
    { .label = { 134726,  7, 0 } }, /* hotmail */
    { .label = {  26904,  5, 0 } }, /* house */
    { .label = {  47825,  3, 0 } }, /* how */
    { .label = { 169677,  4, 0 } }, /* hsbc */
    { .label = { 153921,  6, 0 } }, /* hughes */
    { .label = { 165110,  5, 0 } }, /* hyatt */
    { .label = { 134756,  7, 0 } }, /* hyundai */
    { .label = {  31095,  3, 0 } }, /* ibm */
    { .label = { 169697,  4, 0 } }, /* icbc */
    { .label = {  13719,  3, 0 } }, /* ice */
    { .label = {  22569,  3, 0 } }, /* icu */
    { .label = { 169717,  4, 0 } }, /* ieee */
    { .label = { 135360,  3, 0 } }, /* ifm */
    { .label = { 144898,  5, 0 } }, /* ikano */
    { .label = { 153949,  6, 0 } }, /* imamat */
    { .label = { 169733,  4, 0 } }, /* imdb */
    { .label = {  76296,  4, 0 } }, /* immo */
    { .label = {  76296, 10, 0 } }, /* immobilien */
    { .label = {  19736,  3, 0 } }, /* inc */
    { .label = {  76341, 10, 0 } }, /* industries */
    { .label = { 115396,  8, 0 } }, /* infiniti */
    { .label = {  10040,  3, 0 } }, /* ing */
    { .label = {  31891,  3, 1 } }, { .child = { 9468, 1 } }, /* ink */
    { .label = {  94628,  9, 0 } }, /* institute */
    { .label = {   1529,  9, 0 } }, /* insurance */
    { .label = { 153973,  6, 0 } }, /* insure */
    { .label = {  44078,  5, 0 } }, /* intel */
    { .label = {  38313, 13, 0 } }, /* international */
    { .label = { 153998,  6, 0 } }, /* intuit */
    { .label = {  60808, 11, 0 } }, /* investments */
    { .label = { 115430,  8, 0 } }, /* ipiranga */
    { .label = { 165132,  5, 0 } }, /* irish */
    { .label = { 134788,  7, 0 } }, /* iselect */
    { .label = { 134818,  7, 0 } }, /* ismaili */
    { .label = {    260,  3, 0 } }, /* ist */
    { .label = { 115463,  8, 0 } }, /* istanbul */
    { .label = {  26924,  4, 0 } }, /* itau */
    { .label = { 171569,  3, 0 } }, /* itv */
    { .label = { 165153,  5, 0 } }, /* iveco */
    { .label = { 154023,  6, 0 } }, /* jaguar */
    { .label = {  57820,  4, 0 } }, /* java */
    { .label = {     50,  3, 0 } }, /* jcb */
    { .label = { 135512,  3, 0 } }, /* jcp */
    { .label = { 169753,  4, 0 } }, /* jeep */
    { .label = { 165176,  5, 0 } }, /* jetzt */
    { .label = { 128366,  7, 0 } }, /* jewelry */
    { .label = {   2175,  3, 0 } }, /* jio */
    { .label = { 171583,  3, 0 } }, /* jll */
    { .label = { 171600,  3, 0 } }, /* jmp */
    { .label = { 171618,  3, 0 } }, /* jnj */
    { .label = { 154050,  6, 0 } }, /* joburg */
    { .label = {   4699,  3, 0 } }, /* jot */
    { .label = { 156734,  3, 0 } }, /* joy */
    { .label = { 115498,  8, 0 } }, /* jpmorgan */
    { .label = { 169774,  4, 0 } }, /* jprs */
    { .label = { 154081,  6, 0 } }, /* juegos */
    { .label = { 134847,  7, 0 } }, /* juniper */
    { .label = { 154110,  6, 0 } }, /* kaufen */
    { .label = { 169795,  4, 0 } }, /* kddi */
    { .label = {  60855, 11, 0 } }, /* kerryhotels */
    { .label = {  30016, 14, 0 } }, /* kerrylogistics */
    { .label = {  23028, 15, 0 } }, /* kerryproperties */
    { .label = {  17327,  3, 0 } }, /* kfh */
    { .label = {  48151,  3, 0 } }, /* kia */
    { .label = {  26813,  3, 0 } }, /* kim */
    { .label = { 154137,  6, 0 } }, /* kinder */
    { .label = { 154163,  6, 0 } }, /* kindle */
    { .label = { 134881,  7, 0 } }, /* kitchen */
    { .label = { 168763,  4, 0 } }, /* kiwi */
    { .label = { 161574,  5, 0 } }, /* koeln */
    { .label = {  43307,  7, 0 } }, /* komatsu */
    { .label = { 154190,  6, 0 } }, /* kosher */
    { .label = { 169814,  4, 0 } }, /* kpmg */
    { .label = { 171636,  3, 0 } }, /* kpn */
    { .label = {  11598,  3, 1 } }, { .child = { 9469, 2 } }, /* krd */
    { .label = { 117517,  4, 0 } }, /* kred */
    { .label = {  94665,  9, 0 } }, /* kuokgroup */
    { .label = { 158398,  5, 0 } }, /* kyoto */
    { .label = { 134912,  7, 0 } }, /* lacaixa */
    { .label = {  94708,  9, 0 } }, /* ladbrokes */
    { .label = {  60904, 11, 0 } }, /* lamborghini */
    { .label = {  14750,  5, 0 } }, /* lamer */
    { .label = {  94748,  9, 0 } }, /* lancaster */
    { .label = { 154216,  6, 0 } }, /* lancia */
    { .label = { 134941,  7, 0 } }, /* lancome */
    { .label = {   3685,  4, 1 } }, { .child = { 9471, 1 } }, /* land */
    { .label = {  94784,  9, 0 } }, /* landrover */
    { .label = { 134971,  7, 0 } }, /* lanxess */
    { .label = { 135001,  7, 0 } }, /* lasalle */
    { .label = {   9423,  3, 0 } }, /* lat */
    { .label = { 154240,  6, 0 } }, /* latino */
    { .label = { 135030,  7, 0 } }, /* latrobe */
    { .label = {  20404,  3, 0 } }, /* law */
    { .label = {  64637,  6, 0 } }, /* lawyer */
    { .label = {  35468,  3, 0 } }, /* lds */
    { .label = { 165202,  5, 0 } }, /* lease */
    { .label = { 135060,  7, 0 } }, /* leclerc */
    { .label = { 154264,  6, 0 } }, /* lefrak */
    { .label = { 165222,  5, 0 } }, /* legal */
    { .label = { 155780,  4, 0 } }, /* lego */
    { .label = { 165244,  5, 0 } }, /* lexus */
    { .label = { 169835,  4, 0 } }, /* lgbt */
    { .label = { 135092,  7, 0 } }, /* liaison */
    { .label = { 169855,  4, 0 } }, /* lidl */
    { .label = {  38364,  4, 0 } }, /* life */
    { .label = {  38364, 13, 0 } }, /* lifeinsurance */
    { .label = {  94823,  9, 0 } }, /* lifestyle */
    { .label = { 115536,  8, 0 } }, /* lighting */
    { .label = {  11697,  4, 0 } }, /* like */
    { .label = { 165268,  5, 0 } }, /* lilly */
    { .label = { 135120,  7, 0 } }, /* limited */
    { .label = { 124688,  4, 0 } }, /* limo */
    { .label = { 128494,  7, 0 } }, /* lincoln */
    { .label = {  91398,  5, 0 } }, /* linde */
    { .label = {  32050,  4, 1 } }, { .child = { 9475, 3 } }, /* link */
    { .label = { 165293,  5, 0 } }, /* lipsy */
    { .label = {   4129,  4, 0 } }, /* live */
    { .label = {  20502,  6, 0 } }, /* living */
    { .label = { 165318,  5, 0 } }, /* lixil */
    { .label = {  33282,  3, 0 } }, /* llc */
    { .label = { 165342,  4, 0 } }, /* loan */
    { .label = { 165342,  5, 0 } }, /* loans */
    { .label = { 154291,  6, 0 } }, /* locker */
    { .label = { 165362,  5, 0 } }, /* locus */
    { .label = {  40981,  4, 0 } }, /* loft */
    { .label = {   2308,  3, 0 } }, /* lol */
    { .label = { 148853,  6, 1 } }, { .child = { 9480, 2 } }, /* london */
    { .label = {  97389,  5, 0 } }, /* lotte */
    { .label = { 165385,  5, 0 } }, /* lotto */
    { .label = {  51569,  4, 0 } }, /* love */
    { .label = {  48756,  3, 0 } }, /* lpl */
    { .label = {  48756, 12, 0 } }, /* lplfinancial */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = { 131279,  4, 0 } }, /* ltda */
    { .label = { 115572,  8, 0 } }, /* lundbeck */
    { .label = { 165406,  5, 0 } }, /* lupin */
    { .label = {  72580,  4, 0 } }, /* luxe */
    { .label = { 154318,  6, 0 } }, /* luxury */
    { .label = { 165430,  5, 0 } }, /* macys */
    { .label = { 148936,  6, 0 } }, /* madrid */
    { .label = {  40682,  4, 0 } }, /* maif */
    { .label = {  23952,  6, 0 } }, /* maison */
    { .label = { 154349,  6, 0 } }, /* makeup */
    { .label = {   2844,  3, 0 } }, /* man */
    { .label = {  76383, 10, 1 } }, { .child = { 9482, 1 } }, /* management */
    { .label = { 165453,  5, 0 } }, /* mango */
    { .label = {  10158,  3, 0 } }, /* map */
    { .label = {  44053,  6, 0 } }, /* market */
    { .label = {  94865,  9, 0 } }, /* marketing */
    { .label = { 135151,  7, 0 } }, /* markets */
    { .label = { 115611,  8, 0 } }, /* marriott */
    { .label = {  94903,  9, 0 } }, /* marshalls */
    { .label = { 115643,  8, 0 } }, /* maserati */
    { .label = { 154377,  6, 0 } }, /* mattel */
    { .label = {   6144,  3, 0 } }, /* mba */
    { .label = { 115674,  8, 0 } }, /* mckinsey */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  97740,  5, 0 } }, /* media */
    { .label = { 169874,  4, 0 } }, /* meet */
    { .label = {  94941,  9, 0 } }, /* melbourne */
    { .label = { 169891,  4, 0 } }, /* meme */
    { .label = { 109128,  8, 0 } }, /* memorial */
    { .label = {    591,  3, 1 } }, { .child = { 9483, 1 } }, /* men */
    { .label = {  37332,  4, 1 } }, { .child = { 9484, 1 } }, /* menu */
    { .label = { 115711,  8, 0 } }, /* merckmsd */
    { .label = { 135180,  7, 0 } }, /* metlife */
    { .label = { 165474,  5, 0 } }, /* miami */
    { .label = {  94982,  9, 0 } }, /* microsoft */
    { .label = {  80019,  4, 0 } }, /* mini */
    { .label = { 169909,  4, 0 } }, /* mint */
    { .label = {   7410,  3, 0 } }, /* mit */
    { .label = {  76424, 10, 0 } }, /* mitsubishi */
    { .label = { 155898,  3, 0 } }, /* mlb */
    { .label = {   2446,  3, 0 } }, /* mls */
    { .label = {  42151,  3, 0 } }, /* mma */
    { .label = {  51537,  6, 0 } }, /* mobile */
    { .label = { 154402,  6, 0 } }, /* mobily */
    { .label = {  84541,  4, 0 } }, /* moda */
    { .label = {   3774,  3, 0 } }, /* moe */
    { .label = {  17672,  3, 0 } }, /* moi */
    { .label = {  43190,  3, 1 } }, { .child = { 9485, 2 } }, /* mom */
    { .label = { 154432,  6, 0 } }, /* monash */
    { .label = { 161618,  5, 0 } }, /* money */
    { .label = { 135212,  7, 0 } }, /* monster */
    { .label = { 165495,  5, 0 } }, /* mopar */
    { .label = { 154457,  6, 0 } }, /* mormon */
    { .label = { 115748,  8, 0 } }, /* mortgage */
    { .label = { 149064,  6, 0 } }, /* moscow */
    { .label = {  60953,  4, 0 } }, /* moto */
    { .label = {  60953, 11, 0 } }, /* motorcycles */
    { .label = {  67402,  3, 0 } }, /* mov */
    { .label = { 165517,  5, 0 } }, /* movie */
    { .label = { 115782,  8, 0 } }, /* movistar */
    { .label = {   2551,  3, 0 } }, /* msd */
    { .label = {  23855,  3, 0 } }, /* mtn */
    { .label = {    158,  3, 0 } }, /* mtr */
    { .label = {   9898,  6, 0 } }, /* mutual */
    { .label = {    275,  3, 0 } }, /* nab */
    { .label = { 165540,  5, 0 } }, /* nadex */
    { .label = { 142220,  6, 0 } }, /* nagoya */
    { .label = {  76469, 10, 0 } }, /* nationwide */
    { .label = {   4389,  6, 0 } }, /* natura */
    { .label = { 135346,  4, 0 } }, /* navy */
    { .label = {    398,  3, 0 } }, /* nba */
    { .label = {   6752,  3, 0 } }, /* nec */
    { .label = { 135241,  7, 0 } }, /* netbank */
    { .label = { 135271,  7, 0 } }, /* netflix */
    { .label = {  13560,  7, 1 } }, { .child = { 9487, 4 } }, /* network */
    { .label = { 135304,  7, 0 } }, /* neustar */
    { .label = {  17921,  3, 0 } }, /* new */
    { .label = {  76511, 10, 0 } }, /* newholland */
    { .label = {  17921,  4, 0 } }, /* news */
    { .label = {  76207,  4, 0 } }, /* next */
    { .label = {  76556, 10, 0 } }, /* nextdirect */
    { .label = { 165562,  5, 0 } }, /* nexus */
    { .label = {  19462,  3, 0 } }, /* nfl */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {  65874,  3, 0 } }, /* nhk */
    { .label = { 155411,  4, 0 } }, /* nico */
    { .label = {  23705,  4, 0 } }, /* nike */
    { .label = { 165585,  5, 0 } }, /* nikon */
    { .label = { 165606,  5, 0 } }, /* ninja */
    { .label = { 154483,  6, 0 } }, /* nissan */
    { .label = { 154506,  6, 0 } }, /* nissay */
    { .label = { 165628,  5, 0 } }, /* nokia */
    { .label = {   9847, 18, 0 } }, /* northwesternmutual */
    { .label = { 154531,  6, 0 } }, /* norton */
    { .label = {    540,  3, 0 } }, /* now */
    { .label = { 154555,  6, 0 } }, /* nowruz */
    { .label = { 165648,  5, 0 } }, /* nowtv */
    { .label = {   4777,  3, 0 } }, /* nra */
    { .label = {   8539,  3, 0 } }, /* nrw */
    { .label = {   3756,  3, 0 } }, /* ntt */
    { .label = { 112281,  3, 0 } }, /* nyc */
    { .label = {  10111,  3, 0 } }, /* obi */
    { .label = { 115816,  8, 0 } }, /* observer */
    { .label = {  39021,  3, 0 } }, /* off */
    { .label = {  39021,  6, 0 } }, /* office */
    { .label = { 121941,  7, 0 } }, /* okinawa */
    { .label = {  61003,  6, 0 } }, /* olayan */
    { .label = {  61003, 11, 0 } }, /* olayangroup */
    { .label = { 135332,  7, 0 } }, /* oldnavy */
    { .label = { 169926,  4, 0 } }, /* ollo */
    { .label = { 113364,  5, 0 } }, /* omega */
    { .label = {   7855,  3, 1 } }, { .child = { 9493, 3 } }, /* one */
    { .label = {   1425,  3, 0 } }, /* ong */
    { .label = {  19213,  3, 0 } }, /* onl */
    { .label = {  65926,  6, 1 } }, { .child = { 9498, 1 } }, /* online */
    { .label = {  76600, 10, 0 } }, /* onyourside */
    { .label = {  38082,  3, 0 } }, /* ooo */
    { .label = {  71968,  4, 0 } }, /* open */
    { .label = { 154585,  6, 0 } }, /* oracle */
    { .label = { 154610,  6, 0 } }, /* orange */
    { .label = {  32263,  7, 0 } }, /* organic */
    { .label = { 135365,  7, 0 } }, /* origins */
    { .label = {  43032,  5, 0 } }, /* osaka */
    { .label = {  69503,  6, 0 } }, /* otsuka */
    { .label = {   4618,  3, 0 } }, /* ott */
    { .label = { 112304,  3, 1 } }, { .child = { 9499, 1 } }, /* ovh */
    { .label = {  10166,  4, 1 } }, { .child = { 9500, 1 } }, /* page */
    { .label = {  95022,  9, 0 } }, /* panasonic */
    { .label = { 161723,  5, 0 } }, /* paris */
    { .label = {  39977,  4, 0 } }, /* pars */
    { .label = { 115852,  8, 0 } }, /* partners */
    { .label = { 165672,  5, 0 } }, /* parts */
    { .label = { 165693,  5, 1 } }, { .child = { 9501, 1 } }, /* party */
    { .label = {  95059,  9, 0 } }, /* passagens */
    { .label = {    490,  3, 0 } }, /* pay */
    { .label = { 169944,  4, 0 } }, /* pccw */
    { .label = {  11381,  3, 0 } }, /* pet */
    { .label = { 154634,  6, 0 } }, /* pfizer */
    { .label = { 109510,  8, 0 } }, /* pharmacy */
    { .label = { 171651,  3, 0 } }, /* phd */
    { .label = { 135394,  7, 0 } }, /* philips */
    { .label = { 165716,  5, 0 } }, /* phone */
    { .label = {  13086,  5, 0 } }, /* photo */
    { .label = {  57414, 11, 0 } }, /* photography */
    { .label = { 117289,  6, 0 } }, /* photos */
    { .label = { 154665,  6, 0 } }, /* physio */
    { .label = { 154694,  6, 0 } }, /* piaget */
    { .label = {  64160,  4, 0 } }, /* pics */
    { .label = { 154720,  6, 0 } }, /* pictet */
    { .label = { 115885,  8, 1 } }, { .child = { 9502, 1 } }, /* pictures */
    { .label = {   2004,  3, 0 } }, /* pid */
    { .label = {  32650,  3, 0 } }, /* pin */
    { .label = {  57640,  4, 0 } }, /* ping */
    { .label = { 169966,  4, 0 } }, /* pink */
    { .label = { 135428,  7, 0 } }, /* pioneer */
    { .label = { 165739,  5, 0 } }, /* pizza */
    { .label = {  71686,  5, 1 } }, { .child = { 9503, 1 } }, /* place */
    { .label = {  61052,  4, 0 } }, /* play */
    { .label = {  61052, 11, 0 } }, /* playstation */
    { .label = { 115921,  8, 0 } }, /* plumbing */
    { .label = {  23815,  4, 0 } }, /* plus */
    { .label = {  48971,  3, 0 } }, /* pnc */
    { .label = { 169985,  4, 0 } }, /* pohl */
    { .label = { 165766,  5, 0 } }, /* poker */
    { .label = { 135458,  7, 0 } }, /* politie */
    { .label = { 170005,  4, 0 } }, /* porn */
    { .label = {  95096,  9, 0 } }, /* pramerica */
    { .label = { 165789,  5, 0 } }, /* praxi */
    { .label = {  23006,  5, 0 } }, /* press */
    { .label = { 152639,  5, 0 } }, /* prime */
    { .label = {  61099,  4, 0 } }, /* prod */
    { .label = {  61099, 11, 0 } }, /* productions */
    { .label = {  52386,  4, 0 } }, /* prof */
    { .label = {  61148, 11, 0 } }, /* progressive */
    { .label = { 165812,  5, 0 } }, /* promo */
    { .label = {  23051, 10, 0 } }, /* properties */
    { .label = { 115961,  8, 0 } }, /* property */
    { .label = {  76644, 10, 0 } }, /* protection */
    { .label = {  76687,  3, 0 } }, /* pru */
    { .label = {  76687, 10, 0 } }, /* prudential */
    { .label = {  10104,  3, 1 } }, { .child = { 9504, 1 } }, /* pub */
    { .label = {  76828,  3, 0 } }, /* pwc */
    { .label = { 170023,  4, 0 } }, /* qpon */
    { .label = { 149306,  6, 0 } }, /* quebec */
    { .label = { 165835,  5, 0 } }, /* quest */
    { .label = { 171667,  3, 0 } }, /* qvc */
    { .label = { 154747,  6, 0 } }, /* racing */
    { .label = {  50408,  5, 0 } }, /* radio */
    { .label = {  18617,  4, 0 } }, /* raid */
    { .label = {  38430,  4, 0 } }, /* read */
    { .label = {  74704, 10, 0 } }, /* realestate */
    { .label = { 135489,  7, 0 } }, /* realtor */
    { .label = { 154772,  6, 0 } }, /* realty */
    { .label = { 135517,  7, 0 } }, /* recipes */
    { .label = {   9449,  3, 0 } }, /* red */
    { .label = { 115999,  8, 0 } }, /* redstone */
    { .label = {  61197, 11, 0 } }, /* redumbrella */
    { .label = { 165860,  5, 0 } }, /* rehab */
    { .label = { 154798,  5, 0 } }, /* reise */
    { .label = { 154798,  6, 0 } }, /* reisen */
    { .label = {  34340,  4, 0 } }, /* reit */
    { .label = { 116032,  8, 0 } }, /* reliance */
    { .label = {    469,  3, 0 } }, /* ren */
    { .label = {    469,  4, 0 } }, /* rent */
    { .label = { 135548,  7, 0 } }, /* rentals */
    { .label = { 154822,  6, 0 } }, /* repair */
    { .label = { 154847,  6, 0 } }, /* report */
    { .label = {  24388, 10, 0 } }, /* republican */
    { .label = {  38926,  4, 0 } }, /* rest */
    { .label = {  76731, 10, 0 } }, /* restaurant */
    { .label = { 135576,  6, 1 } }, { .child = { 9505, 1 } }, /* review */
    { .label = { 135576,  7, 0 } }, /* reviews */
    { .label = { 135608,  7, 0 } }, /* rexroth */
    { .label = {  26891,  4, 0 } }, /* rich */
    { .label = {  95134,  9, 0 } }, /* richardli */
    { .label = { 165882,  5, 0 } }, /* ricoh */
    { .label = {  61247, 11, 0 } }, /* rightathome */
    { .label = {  43925,  3, 0 } }, /* ril */
    { .label = {   3773,  3, 0 } }, /* rio */
    { .label = {   3842,  3, 1 } }, { .child = { 9506, 1 } }, /* rip */
    { .label = {  74909,  4, 0 } }, /* rmit */
    { .label = { 154873,  6, 0 } }, /* rocher */
    { .label = {  39522,  5, 1 } }, { .child = { 9507, 3 } }, /* rocks */
    { .label = { 165904,  5, 0 } }, /* rodeo */
    { .label = { 154899,  6, 0 } }, /* rogers */
    { .label = { 136556,  4, 0 } }, /* room */
    { .label = {  88688,  4, 0 } }, /* rsvp */
    { .label = { 165925,  5, 0 } }, /* rugby */
    { .label = { 170045,  4, 0 } }, /* ruhr */
    { .label = {  32012,  3, 1 } }, { .child = { 9510, 3 } }, /* run */
    { .label = {   6710,  3, 0 } }, /* rwe */
    { .label = { 154924,  6, 0 } }, /* ryukyu */
    { .label = { 116065,  8, 0 } }, /* saarland */
    { .label = {  12948,  4, 0 } }, /* safe */
    { .label = {  12948,  6, 0 } }, /* safety */
    { .label = {  69957,  6, 0 } }, /* sakura */
    { .label = {  32680,  4, 1 } }, { .child = { 9513, 1 } }, /* sale */
    { .label = { 165951,  5, 0 } }, /* salon */
    { .label = { 116096,  8, 0 } }, /* samsclub */
    { .label = { 135639,  7, 0 } }, /* samsung */
    { .label = {  23095,  7, 0 } }, /* sandvik */
    { .label = {  23095, 15, 0 } }, /* sandvikcoromant */
    { .label = { 154955,  6, 0 } }, /* sanofi */
    { .label = {  33515,  3, 0 } }, /* sap */
    { .label = { 170063,  4, 0 } }, /* sarl */
    { .label = {   6917,  3, 0 } }, /* sas */
    { .label = {  17335,  4, 0 } }, /* save */
    { .label = { 170079,  4, 0 } }, /* saxo */
    { .label = {   2012,  3, 0 } }, /* sbi */
    { .label = {   5412,  3, 0 } }, /* sbs */
    { .label = {  14444,  3, 0 } }, /* sca */
    { .label = {  13182,  3, 0 } }, /* scb */
    { .label = {  76770, 10, 0 } }, /* schaeffler */
    { .label = { 135669,  7, 0 } }, /* schmidt */
    { .label = {  48810, 12, 0 } }, /* scholarships */
    { .label = { 149362,  6, 0 } }, /* school */
    { .label = { 154980,  6, 0 } }, /* schule */
    { .label = { 135701,  7, 0 } }, /* schwarz */
    { .label = {   8796,  7, 1 } }, { .child = { 9514, 1 } }, /* science */
    { .label = {  95173,  9, 0 } }, /* scjohnson */
    { .label = { 108358,  4, 0 } }, /* scor */
    { .label = {  56688,  4, 0 } }, /* scot */
    { .label = {  29930,  6, 0 } }, /* search */
    { .label = {  32230,  4, 0 } }, /* seat */
    { .label = {  50210,  6, 0 } }, /* secure */
    { .label = {  17698,  8, 0 } }, /* security */
    { .label = { 170096,  4, 0 } }, /* seek */
    { .label = { 134792,  6, 0 } }, /* select */
    { .label = { 165971,  5, 0 } }, /* sener */
    { .label = {  98476,  8, 1 } }, { .child = { 9515, 1 } }, /* services */
    { .label = {  23910,  3, 0 } }, /* ses */
    { .label = { 142133,  5, 0 } }, /* seven */
    { .label = {  64168,  3, 0 } }, /* sew */
    { .label = {   6268,  3, 0 } }, /* sex */
    { .label = { 170113,  4, 0 } }, /* sexy */
    { .label = {  94298,  3, 0 } }, /* sfr */
    { .label = {  95214,  9, 0 } }, /* shangrila */
    { .label = { 165991,  5, 0 } }, /* sharp */
    { .label = { 170133,  4, 0 } }, /* shaw */
    { .label = { 161794,  5, 0 } }, /* shell */
    { .label = {  19261,  4, 0 } }, /* shia */
    { .label = { 135735,  7, 0 } }, /* shiksha */
    { .label = { 166013,  5, 0 } }, /* shoes */
    { .label = {  51997,  4, 1 } }, { .child = { 9516, 1 } }, /* shop */
    { .label = { 116133,  8, 0 } }, /* shopping */
    { .label = { 155008,  6, 0 } }, /* shouji */
    { .label = { 116171,  4, 0 } }, /* show */
    { .label = { 116171,  8, 0 } }, /* showtime */
    { .label = { 135765,  7, 0 } }, /* shriram */
    { .label = { 168578,  4, 0 } }, /* silk */
    { .label = {  31481,  4, 0 } }, /* sina */
    { .label = { 135794,  7, 0 } }, /* singles */
    { .label = {    699,  4, 1 } }, { .child = { 9517, 6 } }, /* site */
    { .label = {   6441,  3, 0 } }, /* ski */
    { .label = {  80256,  4, 0 } }, /* skin */
    { .label = {  34350,  3, 0 } }, /* sky */
    { .label = { 166034,  5, 0 } }, /* skype */
    { .label = { 166059,  5, 0 } }, /* sling */
    { .label = {  17276,  5, 0 } }, /* smart */
    { .label = { 166081,  5, 0 } }, /* smile */
    { .label = { 170151,  4, 0 } }, /* sncf */
    { .label = { 155037,  6, 0 } }, /* soccer */
    { .label = {  31577,  6, 0 } }, /* social */
    { .label = { 116207,  8, 0 } }, /* softbank */
    { .label = {  98511,  8, 0 } }, /* software */
    { .label = { 170170,  4, 0 } }, /* sohu */
    { .label = { 166103,  5, 0 } }, /* solar */
    { .label = {  95251,  9, 0 } }, /* solutions */
    { .label = {  92042,  4, 0 } }, /* song */
    { .label = { 170188,  4, 0 } }, /* sony */
    { .label = {  14773,  3, 0 } }, /* soy */
    { .label = {  40011,  5, 1 } }, { .child = { 9525, 3 } }, /* space */
    { .label = {  67503,  5, 0 } }, /* sport */
    { .label = { 118452,  4, 0 } }, /* spot */
    { .label = {  38420, 13, 0 } }, /* spreadbetting */
    { .label = {   2041,  3, 0 } }, /* srl */
    { .label = {      2,  3, 0 } }, /* srt */
    { .label = {  86247,  5, 0 } }, /* stada */
    { .label = { 135824,  7, 0 } }, /* staples */
    { .label = {  21727,  4, 0 } }, /* star */
    { .label = { 135854,  7, 0 } }, /* starhub */
    { .label = {  95289,  9, 0 } }, /* statebank */
    { .label = {  95326,  9, 0 } }, /* statefarm */
    { .label = {   8741,  3, 0 } }, /* stc */
    { .label = { 116243,  8, 0 } }, /* stcgroup */
    { .label = {  89584,  9, 0 } }, /* stockholm */
    { .label = { 135885,  7, 0 } }, /* storage */
    { .label = { 157748,  5, 0 } }, /* store */
    { .label = { 155063,  6, 0 } }, /* stream */
    { .label = { 155087,  6, 0 } }, /* studio */
    { .label = { 166123,  5, 0 } }, /* study */
    { .label = {  94842,  5, 0 } }, /* style */
    { .label = { 166147,  5, 0 } }, /* sucks */
    { .label = { 116280,  8, 0 } }, /* supplies */
    { .label = { 155113,  6, 0 } }, /* supply */
    { .label = { 135913,  7, 1 } }, { .child = { 9528, 1 } }, /* support */
    { .label = { 170206,  4, 0 } }, /* surf */
    { .label = { 135946,  7, 0 } }, /* surgery */
    { .label = { 155145,  6, 0 } }, /* suzuki */
    { .label = { 155175,  6, 0 } }, /* swatch */
    { .label = {  76816, 10, 0 } }, /* swiftcover */
    { .label = { 166170,  5, 0 } }, /* swiss */
    { .label = { 149496,  6, 0 } }, /* sydney */
    { .label = { 116318,  8, 0 } }, /* symantec */
    { .label = {  24845,  7, 1 } }, { .child = { 9529, 1 } }, /* systems */
    { .label = {   3165,  3, 0 } }, /* tab */
    { .label = { 155202,  6, 0 } }, /* taipei */
    { .label = {  16690,  4, 0 } }, /* talk */
    { .label = { 155227,  6, 0 } }, /* taobao */
    { .label = { 155251,  6, 0 } }, /* target */
    { .label = {  76863, 10, 0 } }, /* tatamotors */
    { .label = {  66813,  5, 0 } }, /* tatar */
    { .label = { 155275,  6, 0 } }, /* tattoo */
    { .label = {   6269,  3, 0 } }, /* tax */
    { .label = { 167772,  4, 0 } }, /* taxi */
    { .label = {   5286,  3, 0 } }, /* tci */
    { .label = {  17669,  3, 0 } }, /* tdk */
    { .label = {  22956,  4, 0 } }, /* team */
    { .label = {  64783,  4, 0 } }, /* tech */
    { .label = {  73140, 10, 1 } }, { .child = { 9530, 1 } }, /* technology */
    { .label = {  76902, 10, 0 } }, /* telefonica */
    { .label = { 135978,  7, 0 } }, /* temasek */
    { .label = { 155298,  6, 0 } }, /* tennis */
    { .label = {  41247,  4, 0 } }, /* teva */
    { .label = {  45590,  3, 0 } }, /* thd */
    { .label = { 129112,  7, 0 } }, /* theater */
    { .label = { 136007,  7, 0 } }, /* theatre */
    { .label = {  40494,  4, 0 } }, /* tiaa */
    { .label = { 136035,  7, 0 } }, /* tickets */
    { .label = { 155322,  6, 0 } }, /* tienda */
    { .label = { 136065,  7, 0 } }, /* tiffany */
    { .label = { 170225,  4, 0 } }, /* tips */
    { .label = { 166192,  5, 0 } }, /* tires */
    { .label = {    516,  5, 0 } }, /* tirol */
    { .label = { 155346,  6, 0 } }, /* tjmaxx */
    { .label = {  12176,  3, 0 } }, /* tjx */
    { .label = { 155377,  6, 0 } }, /* tkmaxx */
    { .label = { 108957,  5, 0 } }, /* tmall */
    { .label = { 166212,  5, 0 } }, /* today */
    { .label = { 158421,  5, 0 } }, /* tokyo */
    { .label = {  79998,  5, 0 } }, /* tools */
    { .label = {   8509,  3, 1 } }, { .child = { 9531, 2 } }, /* top */
    { .label = { 166234,  5, 0 } }, /* toray */
    { .label = { 136098,  7, 0 } }, /* toshiba */
    { .label = { 166255,  5, 0 } }, /* total */
    { .label = { 166275,  5, 0 } }, /* tours */
    { .label = {  17903,  4, 0 } }, /* town */
    { .label = { 142407,  6, 0 } }, /* toyota */
    { .label = { 170243,  4, 0 } }, /* toys */
    { .label = { 140797,  5, 1 } }, { .child = { 9533, 1 } }, /* trade */
    { .label = { 120188,  7, 0 } }, /* trading */
    { .label = { 116353,  8, 0 } }, /* training */
    { .label = {   9925,  6, 0 } }, /* travel */
    { .label = {  38477, 13, 0 } }, /* travelchannel */
    { .label = {   9925,  9, 0 } }, /* travelers */
    { .label = {   9925, 18, 0 } }, /* travelersinsurance */
    { .label = {  75081,  5, 0 } }, /* trust */
    { .label = {   2702,  3, 0 } }, /* trv */
    { .label = {  52436,  4, 0 } }, /* tube */
    { .label = {  58255,  3, 0 } }, /* tui */
    { .label = { 166296,  5, 0 } }, /* tunes */
    { .label = { 166317,  5, 0 } }, /* tushu */
    { .label = { 171686,  3, 0 } }, /* tvs */
    { .label = { 166340,  5, 0 } }, /* ubank */
    { .label = {  54698,  3, 0 } }, /* ubs */
    { .label = { 116385,  8, 0 } }, /* uconnect */
    { .label = { 155406,  6, 0 } }, /* unicom */
    { .label = {  73229, 10, 0 } }, /* university */
    { .label = {   1993,  3, 0 } }, /* uno */
    { .label = {   7472,  3, 0 } }, /* uol */
    { .label = {  12953,  3, 0 } }, /* ups */
    { .label = {  95363,  9, 0 } }, /* vacations */
    { .label = {  91207,  4, 0 } }, /* vana */
    { .label = { 116420,  8, 0 } }, /* vanguard */
    { .label = { 166363,  5, 0 } }, /* vegas */
    { .label = { 116455,  8, 0 } }, /* ventures */
    { .label = { 116490,  8, 0 } }, /* verisign */
    { .label = {  48863, 12, 0 } }, /* versicherung */
    { .label = {  52479,  3, 0 } }, /* vet */
    { .label = { 155433,  6, 0 } }, /* viajes */
    { .label = { 157981,  5, 0 } }, /* video */
    { .label = {  11323,  3, 0 } }, /* vig */
    { .label = { 149572,  6, 0 } }, /* viking */
    { .label = { 155461,  6, 0 } }, /* villas */
    { .label = {   6624,  3, 0 } }, /* vin */
    { .label = {  30793,  3, 0 } }, /* vip */
    { .label = { 109965,  6, 0 } }, /* virgin */
    { .label = {   9896,  4, 0 } }, /* visa */
    { .label = {  27203,  6, 0 } }, /* vision */
    { .label = {  76945, 10, 0 } }, /* vistaprint */
    { .label = { 170261,  4, 0 } }, /* viva */
    { .label = { 170280,  4, 0 } }, /* vivo */
    { .label = {  73362, 10, 0 } }, /* vlaanderen */
    { .label = { 166385,  5, 0 } }, /* vodka */
    { .label = {  76988, 10, 0 } }, /* volkswagen */
    { .label = { 166408,  5, 0 } }, /* volvo */
    { .label = { 170300,  4, 0 } }, /* vote */
    { .label = { 155488,  6, 0 } }, /* voting */
    { .label = { 170318,  4, 0 } }, /* voto */
    { .label = { 155515,  6, 0 } }, /* voyage */
    { .label = { 155543,  6, 0 } }, /* vuelos */
    { .label = { 161860,  5, 0 } }, /* wales */
    { .label = { 136128,  7, 0 } }, /* walmart */
    { .label = { 155571,  6, 0 } }, /* walter */
    { .label = { 127317,  4, 0 } }, /* wang */
    { .label = { 136158,  7, 0 } }, /* wanggou */
    { .label = { 155597,  6, 0 } }, /* warman */
    { .label = {  20561,  5, 0 } }, /* watch */
    { .label = { 136190,  7, 0 } }, /* watches */
    { .label = {  30078,  7, 0 } }, /* weather */
    { .label = {  30078, 14, 0 } }, /* weatherchannel */
    { .label = { 155622,  6, 0 } }, /* webcam */
    { .label = { 166433,  5, 0 } }, /* weber */
    { .label = {    683,  7, 0 } }, /* website */
    { .label = {  28818,  3, 0 } }, /* wed */
    { .label = { 136221,  7, 0 } }, /* wedding */
    { .label = { 166457,  5, 0 } }, /* weibo */
    { .label = { 170336,  4, 0 } }, /* weir */
    { .label = { 136254,  7, 0 } }, /* whoswho */
    { .label = {    216,  4, 0 } }, /* wien */
    { .label = {  64212,  4, 0 } }, /* wiki */
    { .label = {  61294, 11, 0 } }, /* williamhill */
    { .label = {    479,  3, 0 } }, /* win */
    { .label = { 136288,  7, 0 } }, /* windows */
    { .label = {  14851,  4, 0 } }, /* wine */
    { .label = { 136321,  7, 0 } }, /* winners */
    { .label = {  60828,  3, 0 } }, /* wme */
    { .label = {  38533, 13, 0 } }, /* wolterskluwer */
    { .label = { 116525,  8, 0 } }, /* woodside */
    { .label = {  13572,  4, 1 } }, { .child = { 9534, 2 } }, /* work */
    { .label = { 110111,  5, 0 } }, /* works */
    { .label = { 166481,  5, 0 } }, /* world */
    { .label = { 112867,  3, 0 } }, /* wow */
    { .label = { 171386,  3, 0 } }, /* wtc */
    { .label = { 171700,  3, 0 } }, /* wtf */
    { .label = { 170354,  4, 0 } }, /* xbox */
    { .label = {  94363,  5, 0 } }, /* xerox */
    { .label = { 136351,  7, 0 } }, /* xfinity */
    { .label = { 155651,  6, 0 } }, /* xihuan */
    { .label = {   4726,  3, 0 } }, /* xin */
    { .label = {  61345, 11, 0 } }, /* xn--11b4c3d */
    { .label = {  61414, 11, 0 } }, /* xn--1ck2e1b */
    { .label = {  61478, 11, 0 } }, /* xn--1qqw23a */
    { .label = {  77034, 10, 0 } }, /* xn--30rr7y */
    { .label = {  61547, 11, 0 } }, /* xn--3bst00m */
    { .label = {  61610, 11, 0 } }, /* xn--3ds443g */
    { .label = {  12279, 17, 0 } }, /* xn--3oq18vl8pn36a */
    { .label = {  77093, 10, 0 } }, /* xn--3pxu8k */
    { .label = {  61678, 11, 0 } }, /* xn--42c2d9a */
    { .label = {  77152, 10, 0 } }, /* xn--45q11c */
    { .label = {  77219, 10, 0 } }, /* xn--4gbrim */
    { .label = {  61746, 11, 0 } }, /* xn--55qw42g */
    { .label = {  67605, 10, 0 } }, /* xn--55qx5d */
    { .label = {  12386, 17, 0 } }, /* xn--5su34j936bgsg */
    { .label = {  77272, 10, 0 } }, /* xn--5tzm5g */
    { .label = {  61820, 11, 0 } }, /* xn--6frz82g */
    { .label = {  30138, 14, 0 } }, /* xn--6qq986b3xl */
    { .label = {  48917, 12, 0 } }, /* xn--80adxhks */
    { .label = {  30236, 14, 0 } }, /* xn--80aqecdr1a */
    { .label = {  48982, 12, 0 } }, /* xn--80asehdb */
    { .label = {  77331, 10, 0 } }, /* xn--80aswg */
    { .label = {  49046, 12, 0 } }, /* xn--8y0a063a */
    { .label = {  77386, 10, 0 } }, /* xn--9dbq2a */
    { .label = {  77446, 10, 0 } }, /* xn--9et52u */
    { .label = {  61888, 11, 0 } }, /* xn--9krt00a */
    { .label = {  30313, 14, 0 } }, /* xn--b4w605ferd */
    { .label = {  12495, 17, 0 } }, /* xn--bck1b9a5dre4c */
    { .label = {  93715,  9, 0 } }, /* xn--c1avg */
    { .label = {  77506, 10, 0 } }, /* xn--c2br7g */
    { .label = {  61950, 11, 0 } }, /* xn--cck2b3b */
    { .label = {  77563, 10, 0 } }, /* xn--cg4bki */
    { .label = {  62013, 11, 0 } }, /* xn--czr694b */
    { .label = {  77617, 10, 0 } }, /* xn--czrs0t */
    { .label = {  77669, 10, 0 } }, /* xn--czru2d */
    { .label = {  62083, 11, 0 } }, /* xn--d1acj3b */
    { .label = {  38593, 13, 0 } }, /* xn--eckvdtc9d */
    { .label = {  62145, 11, 0 } }, /* xn--efvy88h */
    { .label = {  62210, 11, 0 } }, /* xn--estv75g */
    { .label = {  62271, 11, 0 } }, /* xn--fct429k */
    { .label = {  95400,  9, 0 } }, /* xn--fhbei */
    { .label = {  30399, 14, 0 } }, /* xn--fiq228c5hs */
    { .label = {  77723, 10, 0 } }, /* xn--fiq64b */
    { .label = {  62338, 11, 0 } }, /* xn--fjq720a */
    { .label = {  62407, 11, 0 } }, /* xn--flw351e */
    { .label = {  16455, 16, 0 } }, /* xn--fzys8d69uvgm */
    { .label = {  62473, 11, 0 } }, /* xn--g2xx48c */
    { .label = {  49120, 12, 0 } }, /* xn--gckr3f0f */
    { .label = {  62541, 11, 0 } }, /* xn--gk3at1e */
    { .label = {  62598, 11, 0 } }, /* xn--hxt814e */
    { .label = {  23159, 15, 0 } }, /* xn--i1b6b1a6a2e */
    { .label = {  62663, 11, 0 } }, /* xn--imr513n */
    { .label = {  67671, 10, 0 } }, /* xn--io0a7i */
    { .label = {  95445,  9, 0 } }, /* xn--j1aef */
    { .label = {  30485, 14, 0 } }, /* xn--jlq61u9w7b */
    { .label = {  62725, 11, 0 } }, /* xn--jvr189m */
    { .label = {  23247, 15, 0 } }, /* xn--kcrx77d1x4a */
    { .label = {  62794, 11, 0 } }, /* xn--kpu716f */
    { .label = {  77785, 10, 0 } }, /* xn--kput3i */
    { .label = {  30578, 14, 0 } }, /* xn--mgba3a3ejt */
    { .label = {  16552, 16, 0 } }, /* xn--mgba7c0bbn0a */
    { .label = {  23336, 15, 0 } }, /* xn--mgbaakc7dvf */
    { .label = {  49187, 12, 0 } }, /* xn--mgbab2bd */
    { .label = {  30651, 14, 0 } }, /* xn--mgbb9fbpob */
    { .label = {  30731, 14, 0 } }, /* xn--mgbca7dzdo */
    { .label = {  30805, 14, 0 } }, /* xn--mgbi4ecexp */
    { .label = {  49251, 12, 0 } }, /* xn--mgbt3dhd */
    { .label = {  49314, 12, 0 } }, /* xn--mk1bu44c */
    { .label = {  67815, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  49386, 12, 0 } }, /* xn--ngbc5azd */
    { .label = {  49450, 12, 0 } }, /* xn--ngbe9e0a */
    { .label = {  95493,  9, 0 } }, /* xn--ngbrx */
    { .label = {  23414,  9, 0 } }, /* xn--nqv7f */
    { .label = {  23414, 15, 0 } }, /* xn--nqv7fs00ema */
    { .label = {  62862, 11, 0 } }, /* xn--nyqy26a */
    { .label = {  62926, 11, 0 } }, /* xn--otu796d */
    { .label = {  95538,  9, 0 } }, /* xn--p1acf */
    { .label = {  62992, 11, 0 } }, /* xn--pbt977c */
    { .label = {  77837, 10, 0 } }, /* xn--pssy2u */
    { .label = {  63061, 11, 0 } }, /* xn--q9jyb4c */
    { .label = {  49514, 12, 0 } }, /* xn--qcka1pmc */
    { .label = {  63132, 11, 0 } }, /* xn--rhqv96g */
    { .label = {  63199, 11, 0 } }, /* xn--rovu88b */
    { .label = {  63262, 11, 0 } }, /* xn--ses554g */
    { .label = {  63326, 11, 0 } }, /* xn--t60b56a */
    { .label = {  95586,  9, 0 } }, /* xn--tckwe */
    { .label = {  38662, 13, 0 } }, /* xn--tiq49xqyj */
    { .label = {  77890, 10, 0 } }, /* xn--unup4y */
    { .label = {   1892, 23, 0 } }, /* xn--vermgensberater-ctb */
    { .label = {   1347, 24, 0 } }, /* xn--vermgensberatung-pwb */
    { .label = {  95630,  9, 0 } }, /* xn--vhquv */
    { .label = {  63394, 11, 0 } }, /* xn--vuq861b */
    { .label = {   4672, 20, 0 } }, /* xn--w4r85el8fhu5dnra */
    { .label = {  63465, 11, 0 } }, /* xn--w4rs40l */
    { .label = {  63530, 11, 0 } }, /* xn--xhq521b */
    { .label = {  63600, 11, 0 } }, /* xn--zfr164b */
    { .label = { 171716,  3, 1 } }, { .child = { 9536, 5 } }, /* xyz */
    { .label = { 155678,  6, 0 } }, /* yachts */
    { .label = { 166505,  5, 0 } }, /* yahoo */
    { .label = { 136385,  7, 0 } }, /* yamaxun */
    { .label = { 155705,  6, 0 } }, /* yandex */
    { .label = {  95680,  9, 0 } }, /* yodobashi */
    { .label = {  51213,  4, 0 } }, /* yoga */
    { .label = { 100135,  8, 0 } }, /* yokohama */
    { .label = {  11008,  3, 0 } }, /* you */
    { .label = {  65769,  7, 0 } }, /* youtube */
    { .label = {  68000,  3, 0 } }, /* yun */
    { .label = { 155733,  6, 0 } }, /* zappos */
    { .label = {   7379,  4, 0 } }, /* zara */
    { .label = { 142167,  4, 0 } }, /* zero */
    { .label = {  30792,  3, 0 } }, /* zip */
    { .label = {  40808,  4, 1 } }, { .child = { 9543, 3 } }, /* zone */
    { .label = { 136417,  7, 0 } }, /* zuerich */

    /* entries 1841 to 1846 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 1847 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1848 to 1856 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1857 to 1943 */
    { .label = {   1997, 22, 0 } }, /* accident-investigation */
    { .label = {   5538, 19, 0 } }, /* accident-prevention */
    { .label = {  81233,  9, 0 } }, /* aerobatic */
    { .label = {  98305,  8, 0 } }, /* aeroclub */
    { .label = {  81270,  9, 0 } }, /* aerodrome */
    { .label = { 140721,  6, 0 } }, /* agents */
    { .label = {  98341,  8, 0 } }, /* aircraft */
    { .label = { 119974,  7, 0 } }, /* airline */
    { .label = { 120002,  7, 0 } }, /* airport */
    { .label = {  13591, 16, 0 } }, /* air-surveillance */
    { .label = {  66845, 10, 0 } }, /* airtraffic */
    { .label = {   5621, 19, 0 } }, /* air-traffic-control */
    { .label = {  81307,  9, 0 } }, /* ambulance */
    { .label = {  81347,  9, 0 } }, /* amusement */
    { .label = {   2766, 11, 0 } }, /* association */
    { .label = { 140745,  6, 0 } }, /* author */
    { .label = {  66888, 10, 0 } }, /* ballooning */
    { .label = { 140770,  6, 0 } }, /* broker */
    { .label = {    526,  3, 0 } }, /* caa */
    { .label = { 157727,  5, 0 } }, /* cargo */
    { .label = {  98374,  8, 0 } }, /* catering */
    { .label = {  32418, 13, 0 } }, /* certification */
    { .label = {  40939, 12, 0 } }, /* championship */
    { .label = { 120031,  7, 0 } }, /* charter */
    { .label = {  32473, 13, 0 } }, /* civilaviation */
    { .label = {  98320,  4, 0 } }, /* club */
    { .label = {  66932, 10, 0 } }, /* conference */
    { .label = {  66976, 10, 0 } }, /* consultant */
    { .label = {  67018, 10, 0 } }, /* consulting */
    { .label = {   5674,  7, 0 } }, /* control */
    { .label = { 120060,  7, 0 } }, /* council */
    { .label = { 167665,  4, 0 } }, /* crew */
    { .label = {  26966,  6, 0 } }, /* design */
    { .label = { 167684,  4, 0 } }, /* dgca */
    { .label = {  98407,  8, 0 } }, /* educator */
    { .label = {  81385,  9, 0 } }, /* emergency */
    { .label = {  31698,  6, 0 } }, /* engine */
    { .label = {  31698,  8, 0 } }, /* engineer */
    { .label = {  32529, 13, 0 } }, /* entertainment */
    { .label = {  34890,  9, 0 } }, /* equipment */
    { .label = {  40551,  8, 0 } }, /* exchange */
    { .label = {  22996,  7, 0 } }, /* express */
    { .label = {  67062, 10, 0 } }, /* federation */
    { .label = { 134318,  6, 0 } }, /* flight */
    { .label = { 120092,  7, 0 } }, /* freight */
    { .label = { 167702,  4, 0 } }, /* fuel */
    { .label = {  52167,  7, 0 } }, /* gliding */
    { .label = {  67104, 10, 0 } }, /* government */
    { .label = {  25042, 14, 0 } }, /* groundhandling */
    { .label = {  41026,  5, 0 } }, /* group */
    { .label = {  52150, 11, 0 } }, /* hanggliding */
    { .label = {  81426,  9, 0 } }, /* homebuilt */
    { .label = {   1529,  9, 0 } }, /* insurance */
    { .label = {  67148,  7, 0 } }, /* journal */
    { .label = {  67148, 10, 0 } }, /* journalist */
    { .label = { 120124,  7, 0 } }, /* leasing */
    { .label = {  30039,  9, 0 } }, /* logistics */
    { .label = {  98441,  8, 0 } }, /* magazine */
    { .label = {  52199, 11, 0 } }, /* maintenance */
    { .label = {  97740,  5, 0 } }, /* media */
    { .label = {  67192, 10, 0 } }, /* microlight */
    { .label = {  81468,  9, 0 } }, /* modelling */
    { .label = {  67237, 10, 0 } }, /* navigation */
    { .label = {  52243, 11, 0 } }, /* parachuting */
    { .label = {  52291, 11, 0 } }, /* paragliding */
    { .label = {   2723, 21, 0 } }, /* passenger-association */
    { .label = { 149227,  5, 0 } }, /* pilot */
    { .label = {  23006,  5, 0 } }, /* press */
    { .label = {  61099, 10, 0 } }, /* production */
    { .label = {  67278, 10, 0 } }, /* recreation */
    { .label = { 120153,  7, 0 } }, /* repbody */
    { .label = {  12355,  3, 0 } }, /* res */
    { .label = {  29922,  8, 0 } }, /* research */
    { .label = {  67318, 10, 0 } }, /* rotorcraft */
    { .label = {  12948,  6, 0 } }, /* safety */
    { .label = {  81509,  9, 0 } }, /* scientist */
    { .label = {  98476,  8, 0 } }, /* services */
    { .label = { 116171,  4, 0 } }, /* show */
    { .label = {  81546,  9, 0 } }, /* skydiving */
    { .label = {  98511,  8, 0 } }, /* software */
    { .label = {  50720,  7, 0 } }, /* student */
    { .label = { 140797,  6, 0 } }, /* trader */
    { .label = { 120188,  7, 0 } }, /* trading */
    { .label = {   5423,  7, 0 } }, /* trainer */
    { .label = {  60645,  5, 0 } }, /* union */
    { .label = {  40994, 12, 0 } }, /* workinggroup */
    { .label = { 110111,  5, 0 } }, /* works */

    /* entries 1944 to 1949 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1950 to 1954 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1955 to 1960 */
    { .label = {  39021,  3, 0 } }, /* off */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  54439,  3, 0 } }, /* uwu */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1961 to 1968 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 1969 to 1974 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 120217,  7, 0 } }, /* commune */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 1975 to 1980 */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {   1875,  2, 0 } }, /* gv */
    { .label = {   1288,  2, 0 } }, /* og */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     56,  2, 0 } }, /* pb */
    { .label = {    151,  2, 0 } }, /* it */

    /* entries 1981 to 1991 */
    { .label = {    106,  3, 1 } }, { .child = { 1992, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 140821,  6, 0 } }, /* musica */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4396,  3, 0 } }, /* tur */

    /* entry 1992 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 1993 to 1998 */
    { .label = { 167722,  4, 0 } }, /* e164 */
    { .label = { 120249,  7, 0 } }, /* in-addr */
    { .label = { 171245,  3, 0 } }, /* ip6 */
    { .label = {  63411,  4, 0 } }, /* iris */
    { .label = {   6654,  3, 0 } }, /* uri */
    { .label = {   1375,  3, 0 } }, /* urn */

    /* entry 1999 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 2000 */
    { .label = { 136759,  7, 0 } }, /* cloudns */

    /* entries 2001 to 2018 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 2019, 1 } }, /* co */
    { .label = {   1875,  2, 0 } }, /* gv */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  97086,  9, 1 } }, { .child = { 2020, 3 } }, /* futurecms */
    { .label = {  40241, 13, 0 } }, /* futurehosting */
    { .label = {  40299, 13, 0 } }, /* futuremailing */
    { .label = { 118398,  8, 1 } }, { .child = { 2027, 2 } }, /* ortsinfo */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = { 171152,  4, 0 } }, /* 12hp */
    { .label = { 171867,  3, 0 } }, /* 2ix */
    { .label = { 167567,  5, 0 } }, /* 4lima */
    { .label = {  98138,  9, 0 } }, /* lima-city */

    /* entry 2019 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2020 to 2024 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {   1562,  2, 1 } }, { .child = { 2025, 1 } }, /* ex */
    { .label = {    100,  2, 1 } }, { .child = { 2026, 1 } }, /* in */

    /* entry 2025 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2026 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2027 to 2030 */
    { .label = {   1562,  2, 1 } }, { .child = { 2031, 1 } }, /* ex */
    { .label = { 156487,  6, 1 } }, { .child = { 2032, 1 } }, /* kunden */

    /* entry 2031 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2032 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2033 to 2053 */
    { .label = {    106,  3, 1 } }, { .child = { 2054, 1 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 1 } }, { .child = { 2055, 8 } }, /* edu */
    { .label = {   3879,  3, 1 } }, { .child = { 2063, 5 } }, /* gov */
    { .label = {   6682,  3, 0 } }, /* asn */
    { .label = {    143,  2, 0 } }, /* id */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  65020,  4, 0 } }, /* conf */
    { .label = {   3283,  2, 0 } }, /* oz */
    { .label = {  13368,  3, 0 } }, /* act */
    { .label = {   7622,  3, 0 } }, /* nsw */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = { 109977,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   5504,  3, 0 } }, /* tas */
    { .label = {  31047,  3, 0 } }, /* vic */
    { .label = {    548,  2, 0 } }, /* wa */

    /* entry 2054 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2055 to 2062 */
    { .label = {  13368,  3, 0 } }, /* act */
    { .label = {   7622,  3, 0 } }, /* nsw */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = { 109977,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   5504,  3, 0 } }, /* tas */
    { .label = {  31047,  3, 0 } }, /* vic */
    { .label = {    548,  2, 0 } }, /* wa */

    /* entries 2063 to 2067 */
    { .label = { 109977,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   5504,  3, 0 } }, /* tas */
    { .label = {  31047,  3, 0 } }, /* vic */
    { .label = {    548,  2, 0 } }, /* wa */

    /* entry 2068 */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 2069 to 2080 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   6753,  2, 0 } }, /* pp */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {   3641,  3, 0 } }, /* biz */

    /* entries 2081 to 2087 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2088 to 2097 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 157748,  5, 0 } }, /* store */
    { .label = {   1222,  2, 0 } }, /* tv */

    /* entry 2098 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2099 to 2103 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  78268, 10, 0 } }, /* webhosting */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 119643,  8, 1 } }, { .child = { 2104, 1 } }, /* transurl */

    /* entry 2104 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2105 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 2106 to 2143 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {     30,  1, 0 } }, /* d */
    { .label = {     25,  1, 0 } }, /* e */
    { .label = {     68,  1, 0 } }, /* f */
    { .label = {      3,  1, 0 } }, /* g */
    { .label = {     90,  1, 0 } }, /* h */
    { .label = {     27,  1, 0 } }, /* i */
    { .label = {     50,  1, 0 } }, /* j */
    { .label = {     24,  1, 0 } }, /* k */
    { .label = {     79,  1, 0 } }, /* l */
    { .label = {     29,  1, 0 } }, /* m */
    { .label = {     28,  1, 0 } }, /* n */
    { .label = {     21,  1, 0 } }, /* o */
    { .label = {     18,  1, 0 } }, /* p */
    { .label = {    215,  1, 0 } }, /* q */
    { .label = {      1,  1, 0 } }, /* r */
    { .label = {      2,  1, 0 } }, /* s */
    { .label = {      4,  1, 0 } }, /* t */
    { .label = {     46,  1, 0 } }, /* u */
    { .label = {     16,  1, 0 } }, /* v */
    { .label = {      8,  1, 0 } }, /* w */
    { .label = {     20,  1, 0 } }, /* x */
    { .label = {     38,  1, 0 } }, /* y */
    { .label = {    202,  1, 0 } }, /* z */
    { .label = {    667,  1, 0 } }, /* 0 */
    { .label = {    176,  1, 0 } }, /* 1 */
    { .label = {    169,  1, 0 } }, /* 2 */
    { .label = {    170,  1, 0 } }, /* 3 */
    { .label = {    231,  1, 0 } }, /* 4 */
    { .label = {     49,  1, 0 } }, /* 5 */
    { .label = {      5,  1, 0 } }, /* 6 */
    { .label = {   1654,  1, 0 } }, /* 7 */
    { .label = {    212,  1, 0 } }, /* 8 */
    { .label = {    177,  1, 0 } }, /* 9 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entries 2144 to 2148 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 2149 to 2153 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2154 to 2167 */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = {  31132,  6, 0 } }, /* dyndns */
    { .label = {  78629, 10, 0 } }, /* for-better */
    { .label = {  39300,  8, 0 } }, /* for-more */
    { .label = { 116995,  8, 0 } }, /* for-some */
    { .label = { 137173,  7, 0 } }, /* for-the */
    { .label = { 156063,  6, 0 } }, /* selfip */
    { .label = { 156092,  6, 0 } }, /* webhop */
    { .label = {  31710,  3, 0 } }, /* bpl */
    { .label = {   5398,  3, 0 } }, /* orx */
    { .label = { 157090,  6, 0 } }, /* mmafan */
    { .label = { 167215,  5, 0 } }, /* myftp */
    { .label = { 167192,  5, 0 } }, /* no-ip */
    { .label = { 140296,  7, 0 } }, /* dscloud */

    /* entries 2168 to 2171 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = { 120279,  7, 0 } }, /* barreau */
    { .label = { 167752,  4, 0 } }, /* gouv */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2172 to 2176 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2177 to 2182 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 2183 to 2223 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  98546,  8, 0 } }, /* academia */
    { .label = {  94681,  4, 0 } }, /* agro */
    { .label = {  17285,  4, 0 } }, /* arte */
    { .label = {  16892,  4, 0 } }, /* blog */
    { .label = { 120308,  7, 0 } }, /* bolivia */
    { .label = { 120340,  7, 0 } }, /* ciencia */
    { .label = {  52339, 11, 0 } }, /* cooperativa */
    { .label = {  67360, 10, 0 } }, /* democracia */
    { .label = { 120369,  7, 0 } }, /* deporte */
    { .label = {  98578,  8, 0 } }, /* ecologia */
    { .label = {  98612,  8, 0 } }, /* economia */
    { .label = { 120400,  7, 0 } }, /* empresa */
    { .label = {  98645,  8, 0 } }, /* indigena */
    { .label = {  81589,  9, 0 } }, /* industria */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  98678,  8, 0 } }, /* medicina */
    { .label = {  67402, 10, 0 } }, /* movimiento */
    { .label = { 140821,  6, 0 } }, /* musica */
    { .label = {   4389,  7, 0 } }, /* natural */
    { .label = { 140847,  6, 0 } }, /* nombre */
    { .label = {  98712,  8, 0 } }, /* noticias */
    { .label = { 140874,  6, 0 } }, /* patria */
    { .label = {  98744,  8, 0 } }, /* politica */
    { .label = {  52386, 11, 0 } }, /* profesional */
    { .label = {  32581, 13, 0 } }, /* plurinacional */
    { .label = { 140898,  6, 0 } }, /* pueblo */
    { .label = { 120430,  7, 0 } }, /* revista */
    { .label = { 157768,  5, 0 } }, /* salud */
    { .label = {  67446, 10, 0 } }, /* tecnologia */
    { .label = { 157790,  5, 0 } }, /* tksat */
    { .label = {  67488, 10, 0 } }, /* transporte */
    { .label = {  64212,  4, 0 } }, /* wiki */

    /* entries 2224 to 2356 */
    { .label = { 140928,  6, 0 } }, /* 9guacu */
    { .label = {   2536,  3, 0 } }, /* abc */
    { .label = {  10199,  3, 0 } }, /* adm */
    { .label = {   3989,  3, 0 } }, /* adv */
    { .label = {  15581,  3, 0 } }, /* agr */
    { .label = {  17189,  3, 0 } }, /* aju */
    { .label = {     26,  2, 0 } }, /* am */
    { .label = {  42540,  5, 0 } }, /* anani */
    { .label = {  81626,  9, 0 } }, /* aparecida */
    { .label = { 171264,  3, 0 } }, /* arq */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {   5832,  3, 0 } }, /* ato */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = { 120459,  7, 0 } }, /* barueri */
    { .label = { 157810,  5, 0 } }, /* belem */
    { .label = {  62682,  3, 0 } }, /* bhz */
    { .label = {  43936,  3, 0 } }, /* bio */
    { .label = {  16892,  4, 0 } }, /* blog */
    { .label = {  93414,  3, 0 } }, /* bmd */
    { .label = {  98779,  8, 0 } }, /* boavista */
    { .label = {  88080,  3, 0 } }, /* bsb */
    { .label = {  32637, 13, 0 } }, /* campinagrande */
    { .label = {  98813,  8, 0 } }, /* campinas */
    { .label = { 140961,  6, 0 } }, /* caxias */
    { .label = {  97187,  3, 0 } }, /* cim */
    { .label = {   5505,  3, 0 } }, /* cng */
    { .label = {  11056,  3, 0 } }, /* cnt */
    { .label = {    106,  3, 1 } }, { .child = { 2357, 1 } }, /* com */
    { .label = {  98847,  8, 0 } }, /* contagem */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {   1462,  3, 0 } }, /* cri */
    { .label = { 140986,  6, 0 } }, /* cuiaba */
    { .label = {  98881,  8, 0 } }, /* curitiba */
    { .label = {  15063,  3, 0 } }, /* def */
    { .label = {  23970,  3, 0 } }, /* ecn */
    { .label = {    102,  3, 0 } }, /* eco */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  18916,  3, 0 } }, /* emp */
    { .label = {   2740,  3, 0 } }, /* eng */
    { .label = {  10180,  3, 0 } }, /* esp */
    { .label = {  20566,  3, 0 } }, /* etc */
    { .label = {    421,  3, 0 } }, /* eti */
    { .label = {  10642,  3, 0 } }, /* far */
    { .label = { 157834,  5, 0 } }, /* feira */
    { .label = {  42739,  4, 0 } }, /* flog */
    { .label = { 120489,  7, 0 } }, /* floripa */
    { .label = {   3284,  2, 0 } }, /* fm */
    { .label = { 164015,  3, 0 } }, /* fnd */
    { .label = { 141012,  6, 0 } }, /* fortal */
    { .label = {  76648,  3, 0 } }, /* fot */
    { .label = { 156293,  3, 0 } }, /* foz */
    { .label = {  69056,  3, 0 } }, /* fst */
    { .label = { 171279,  3, 0 } }, /* g12 */
    { .label = { 171300,  3, 0 } }, /* ggf */
    { .label = { 120521,  7, 0 } }, /* goiania */
    { .label = {   3879,  3, 1 } }, { .child = { 2358, 27 } }, /* gov */
    { .label = {   6669,  3, 0 } }, /* gru */
    { .label = {  36289,  3, 0 } }, /* imb */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {   5417,  3, 0 } }, /* inf */
    { .label = {   3162,  3, 0 } }, /* jab */
    { .label = { 157855,  5, 0 } }, /* jampa */
    { .label = { 171316,  3, 0 } }, /* jdf */
    { .label = {  81663,  9, 0 } }, /* joinville */
    { .label = {   1535,  3, 0 } }, /* jor */
    { .label = {  13699,  3, 0 } }, /* jus */
    { .label = {  27277,  3, 1 } }, { .child = { 2385, 27 } }, /* leg */
    { .label = {  19486,  3, 0 } }, /* lel */
    { .label = {  98916,  8, 0 } }, /* londrina */
    { .label = { 141038,  6, 0 } }, /* macapa */
    { .label = { 141063,  6, 0 } }, /* maceio */
    { .label = { 141088,  6, 0 } }, /* manaus */
    { .label = { 120548,  7, 0 } }, /* maringa */
    { .label = {  11075,  3, 0 } }, /* mat */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 141112,  6, 0 } }, /* morena */
    { .label = {   6748,  2, 0 } }, /* mp */
    { .label = {   4448,  3, 0 } }, /* mus */
    { .label = {  65255,  5, 0 } }, /* natal */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = { 120576,  7, 0 } }, /* niteroi */
    { .label = {   1460,  3, 1 } }, { .child = { 2412, 1 } }, /* nom */
    { .label = {  17211,  3, 0 } }, /* not */
    { .label = {   5683,  3, 0 } }, /* ntr */
    { .label = {  19405,  3, 0 } }, /* odo */
    { .label = {   1425,  3, 0 } }, /* ong */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 141136,  6, 0 } }, /* osasco */
    { .label = { 141160,  6, 0 } }, /* palmas */
    { .label = {  26687,  3, 0 } }, /* poa */
    { .label = { 171334,  3, 0 } }, /* ppg */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {  17769,  3, 0 } }, /* psc */
    { .label = {  81059,  3, 0 } }, /* psi */
    { .label = { 171351,  3, 0 } }, /* pvh */
    { .label = { 171368,  3, 0 } }, /* qsl */
    { .label = {  50408,  5, 0 } }, /* radio */
    { .label = {  13403,  3, 0 } }, /* rec */
    { .label = { 141186,  6, 0 } }, /* recife */
    { .label = {  98949,  8, 0 } }, /* ribeirao */
    { .label = {   3773,  3, 0 } }, /* rio */
    { .label = {  81706,  9, 0 } }, /* riobranco */
    { .label = {  98982,  8, 0 } }, /* riopreto */
    { .label = {  44392,  8, 0 } }, /* salvador */
    { .label = { 157879,  5, 0 } }, /* sampa */
    { .label = {  67529, 10, 0 } }, /* santamaria */
    { .label = {  67566, 10, 0 } }, /* santoandre */
    { .label = {  52434, 11, 0 } }, /* saobernardo */
    { .label = {  99016,  8, 0 } }, /* saogonca */
    { .label = { 171385,  3, 0 } }, /* sjc */
    { .label = { 171401,  3, 0 } }, /* slg */
    { .label = {  14576,  3, 0 } }, /* slz */
    { .label = {  99048,  8, 0 } }, /* sorocaba */
    { .label = { 171415,  3, 0 } }, /* srv */
    { .label = { 167772,  4, 0 } }, /* taxi */
    { .label = {     15,  2, 0 } }, /* tc */
    { .label = {   6637,  3, 0 } }, /* teo */
    { .label = {    746,  3, 0 } }, /* the */
    { .label = {  65293,  3, 0 } }, /* tmp */
    { .label = {   2418,  3, 0 } }, /* trd */
    { .label = {   4396,  3, 0 } }, /* tur */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {  21043,  3, 0 } }, /* udi */
    { .label = {  52479,  3, 0 } }, /* vet */
    { .label = { 160038,  3, 0 } }, /* vix */
    { .label = { 167789,  4, 0 } }, /* vlog */
    { .label = {  64212,  4, 0 } }, /* wiki */
    { .label = {  36170,  3, 0 } }, /* zlg */

    /* entry 2357 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2358 to 2384 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {     26,  2, 0 } }, /* am */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {    315,  2, 0 } }, /* ce */
    { .label = {  13703,  2, 0 } }, /* df */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    194,  2, 0 } }, /* ma */
    { .label = {   1381,  2, 0 } }, /* mg */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = {     56,  2, 0 } }, /* pb */
    { .label = {   5389,  2, 0 } }, /* pe */
    { .label = {    470,  2, 0 } }, /* pi */
    { .label = {   1283,  2, 0 } }, /* pr */
    { .label = {   4619,  2, 0 } }, /* rj */
    { .label = {    157,  2, 0 } }, /* rn */
    { .label = {     17,  2, 0 } }, /* ro */
    { .label = {     51,  2, 0 } }, /* rr */
    { .label = {     48,  2, 0 } }, /* rs */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {     52,  2, 0 } }, /* sp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 2385 to 2411 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {     26,  2, 0 } }, /* am */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {    315,  2, 0 } }, /* ce */
    { .label = {  13703,  2, 0 } }, /* df */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    194,  2, 0 } }, /* ma */
    { .label = {   1381,  2, 0 } }, /* mg */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = {     56,  2, 0 } }, /* pb */
    { .label = {   5389,  2, 0 } }, /* pe */
    { .label = {    470,  2, 0 } }, /* pi */
    { .label = {   1283,  2, 0 } }, /* pr */
    { .label = {   4619,  2, 0 } }, /* rj */
    { .label = {    157,  2, 0 } }, /* rn */
    { .label = {     17,  2, 0 } }, /* ro */
    { .label = {     51,  2, 0 } }, /* rr */
    { .label = {     48,  2, 0 } }, /* rs */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {     52,  2, 0 } }, /* sp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entry 2412 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2413 to 2418 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    266,  2, 0 } }, /* we */

    /* entries 2419 to 2423 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2424 to 2425 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2426 to 2431 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    106,  3, 1 } }, { .child = { 2432, 1 } }, /* com */
    { .label = {   5311,  2, 0 } }, /* of */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entry 2432 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2433 to 2439 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   2924,  2, 0 } }, /* za */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 2440 to 2460 */
    { .label = {     74,  2, 0 } }, /* ab */
    { .label = {   2539,  2, 0 } }, /* bc */
    { .label = {   5492,  2, 0 } }, /* mb */
    { .label = {    241,  2, 0 } }, /* nb */
    { .label = {    161,  2, 0 } }, /* nf */
    { .label = {   2989,  2, 0 } }, /* nl */
    { .label = {    230,  2, 0 } }, /* ns */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = {   1501,  2, 0 } }, /* nu */
    { .label = {    121,  2, 0 } }, /* on */
    { .label = {   5389,  2, 0 } }, /* pe */
    { .label = {   9026,  2, 0 } }, /* qc */
    { .label = {    312,  2, 0 } }, /* sk */
    { .label = {  10120,  2, 0 } }, /* yk */
    { .label = {     14,  2, 0 } }, /* gc */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 166548,  5, 1 } }, { .child = { 2461, 1 } }, /* awdev */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 167192,  5, 0 } }, /* no-ip */

    /* entry 2461 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2462 to 2468 */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = {  96264,  9, 0 } }, /* ftpaccess */
    { .label = {  64377, 11, 0 } }, /* game-server */
    { .label = { 117278,  8, 0 } }, /* myphotos */
    { .label = {  96662,  9, 0 } }, /* scrapping */
    { .label = { 156263,  6, 0 } }, /* twmail */
    { .label = {  40473, 13, 0 } }, /* fantasyleague */

    /* entry 2469 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 2470 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 2471 to 2479 */
    { .label = { 136584,  7, 0 } }, /* square7 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  32050, 14, 0 } }, /* linkyard-cloud */
    { .label = { 119066,  7, 0 } }, /* dnsking */
    { .label = { 155980,  6, 0 } }, /* gotdns */
    { .label = { 171152,  4, 0 } }, /* 12hp */
    { .label = { 171867,  3, 0 } }, /* 2ix */
    { .label = { 167567,  5, 0 } }, /* 4lima */
    { .label = {  98138,  9, 0 } }, /* lima-city */

    /* entries 2480 to 2495 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  17973, 15, 0 } }, /* xn--aroport-bya */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = { 141213,  6, 0 } }, /* presse */
    { .label = {   6744,  2, 0 } }, /* md */
    { .label = { 167752,  4, 0 } }, /* gouv */
    { .label = {   3951,  3, 0 } }, /* fin */

    /* entries 2496 to 2498 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 156955,  3, 1 } }, { .child = { 2499, 1 } }, /* www */

    /* entry 2499 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 2500 to 2505 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 2506 to 2509 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 2510 to 2555 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 1 } }, { .child = { 2556, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  67605, 10, 0 } }, /* xn--55qx5d */
    { .label = {  67671, 10, 0 } }, /* xn--io0a7i */
    { .label = {  67723, 10, 0 } }, /* xn--od0alg */
    { .label = {   1500,  2, 0 } }, /* ah */
    { .label = {  17557,  2, 0 } }, /* bj */
    { .label = {   5333,  2, 0 } }, /* cq */
    { .label = {   4617,  2, 0 } }, /* fj */
    { .label = {    567,  2, 0 } }, /* gd */
    { .label = {    337,  2, 0 } }, /* gs */
    { .label = {   1657,  2, 0 } }, /* gz */
    { .label = {   1014,  2, 0 } }, /* gx */
    { .label = {   2443,  2, 0 } }, /* ha */
    { .label = {     90,  2, 0 } }, /* hb */
    { .label = {    750,  2, 0 } }, /* he */
    { .label = {    195,  2, 0 } }, /* hi */
    { .label = {   3680,  2, 0 } }, /* hl */
    { .label = {   1496,  2, 0 } }, /* hn */
    { .label = {   9957,  2, 0 } }, /* jl */
    { .label = {  15265,  2, 0 } }, /* js */
    { .label = {   7340,  2, 0 } }, /* jx */
    { .label = {    247,  2, 0 } }, /* ln */
    { .label = {    201,  2, 0 } }, /* nm */
    { .label = {    130,  2, 0 } }, /* nx */
    { .label = {  52192,  2, 0 } }, /* qh */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {    253,  2, 0 } }, /* sd */
    { .label = {    682,  2, 0 } }, /* sh */
    { .label = {   1414,  2, 0 } }, /* sn */
    { .label = {    179,  2, 0 } }, /* sx */
    { .label = {   2411,  2, 0 } }, /* tj */
    { .label = {  37347,  2, 0 } }, /* xj */
    { .label = {    582,  2, 0 } }, /* xz */
    { .label = {   2785,  2, 0 } }, /* yn */
    { .label = {  21066,  2, 0 } }, /* zj */
    { .label = {   4197,  2, 0 } }, /* hk */
    { .label = {   3360,  2, 0 } }, /* mo */
    { .label = {      4,  2, 0 } }, /* tw */
    { .label = {  51829, 12, 0 } }, /* instantcloud */

    /* entries 2556 to 2557 */
    { .label = {  95721,  9, 1 } }, { .child = { 2558, 4 } }, /* amazonaws */

    /* entries 2558 to 2565 */
    { .label = {  19964,  7, 1 } }, { .child = { 2566, 1 } }, /* compute */
    { .label = {    689,  2, 1 } }, { .child = { 2567, 2 } }, /* eb */
    { .label = {  40776,  3, 1 } }, { .child = { 2569, 1 } }, /* elb */
    { .label = {  78033, 10, 1 } }, { .child = { 2570, 1 } }, /* cn-north-1 */

    /* entry 2566 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2567 to 2568 */
    { .label = {  78033, 10, 0 } }, /* cn-north-1 */
    { .label = {  30879, 14, 0 } }, /* cn-northwest-1 */

    /* entry 2569 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2570 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2571 to 2595 */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {    106,  3, 1 } }, { .child = { 2596, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13403,  3, 0 } }, /* rec */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = { 155789,  6, 0 } }, /* go-vip */
    { .label = { 166572,  5, 0 } }, /* carrd */
    { .label = {  44386,  3, 0 } }, /* crd */
    { .label = { 170418,  4, 1 } }, { .child = { 2597, 1 } }, /* otap */
    { .label = {  97495,  9, 0 } }, /* leadpages */
    { .label = {  10161,  6, 0 } }, /* lpages */
    { .label = { 170866,  4, 0 } }, /* mypi */
    { .label = { 171812,  3, 0 } }, /* n4t */
    { .label = { 167288,  5, 0 } }, /* nodum */
    { .label = { 171065,  4, 0 } }, /* repl */

    /* entry 2596 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entry 2597 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2598 to 2927 */
    { .label = {  95721,  9, 1 } }, { .child = { 2928, 42 } }, /* amazonaws */
    { .label = {  16640, 16, 1 } }, { .child = { 3042, 17 } }, /* elasticbeanstalk */
    { .label = {  78081, 10, 0 } }, /* on-aptible */
    { .label = {  95845,  9, 0 } }, /* myasustor */
    { .label = {  50005, 12, 0 } }, /* wpcomstaging */
    { .label = {  31008, 14, 0 } }, /* balena-devices */
    { .label = {  78126, 10, 0 } }, /* betainabox */
    { .label = { 136621,  7, 0 } }, /* bplaced */
    { .label = {     45,  2, 0 } }, /* ar */
    { .label = {    294,  2, 0 } }, /* br */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {   2994,  2, 0 } }, /* eu */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {   1370,  2, 0 } }, /* hu */
    { .label = { 151728,  3, 0 } }, /* jpn */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = {  89197,  3, 0 } }, /* mex */
    { .label = {    188,  2, 0 } }, /* no */
    { .label = {   9026,  2, 0 } }, /* qc */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {    223,  2, 0 } }, /* uy */
    { .label = {   2924,  2, 0 } }, /* za */
    { .label = {  72022,  6, 0 } }, /* africa */
    { .label = {   2701,  2, 0 } }, /* gr */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  38874, 13, 0 } }, /* xenapponazure */
    { .label = {  95923,  9, 0 } }, /* jdevcloud */
    { .label = {  78217, 10, 0 } }, /* wpdevcloud */
    { .label = {  23644, 15, 0 } }, /* cloudcontrolled */
    { .label = {  23712, 15, 0 } }, /* cloudcontrolapp */
    { .label = {  78404, 10, 0 } }, /* dattolocal */
    { .label = {  78446, 10, 0 } }, /* dattorelay */
    { .label = { 116785,  8, 0 } }, /* dattoweb */
    { .label = { 136854,  7, 0 } }, /* mydatto */
    { .label = { 116821,  8, 0 } }, /* drayddns */
    { .label = {  50286, 12, 0 } }, /* dreamhosters */
    { .label = { 136916,  7, 0 } }, /* mydrobo */
    { .label = {  31132, 14, 0 } }, /* dyndns-at-home */
    { .label = {  31195, 14, 0 } }, /* dyndns-at-work */
    { .label = {  63922, 11, 0 } }, /* dyndns-blog */
    { .label = {  63975, 11, 0 } }, /* dyndns-free */
    { .label = {  64026, 11, 0 } }, /* dyndns-home */
    { .label = {  96142,  9, 0 } }, /* dyndns-ip */
    { .label = {  64077, 11, 0 } }, /* dyndns-mail */
    { .label = {  38988, 13, 0 } }, /* dyndns-office */
    { .label = {  64127, 11, 0 } }, /* dyndns-pics */
    { .label = {  39050, 13, 0 } }, /* dyndns-remote */
    { .label = {  39108, 13, 0 } }, /* dyndns-server */
    { .label = {  78488, 10, 0 } }, /* dyndns-web */
    { .label = {  64179, 11, 0 } }, /* dyndns-wiki */
    { .label = {  64231, 11, 0 } }, /* dyndns-work */
    { .label = { 136983,  7, 0 } }, /* blogdns */
    { .label = { 137016,  7, 0 } }, /* cechire */
    { .label = { 116929,  8, 0 } }, /* dnsalias */
    { .label = { 137047,  7, 0 } }, /* dnsdojo */
    { .label = {  64330, 11, 0 } }, /* doesntexist */
    { .label = {  96185,  9, 0 } }, /* dontexist */
    { .label = { 137110,  7, 0 } }, /* doomdns */
    { .label = {  78584, 10, 0 } }, /* dyn-o-saur */
    { .label = { 116961,  8, 0 } }, /* dynalias */
    { .label = {  23914, 15, 0 } }, /* est-a-la-maison */
    { .label = {  23976, 15, 0 } }, /* est-a-la-masion */
    { .label = {  39222, 13, 0 } }, /* est-le-patron */
    { .label = {  16857, 16, 0 } }, /* est-mon-blogueur */
    { .label = { 137205,  7, 0 } }, /* from-ak */
    { .label = { 137237,  7, 0 } }, /* from-al */
    { .label = { 137269,  7, 0 } }, /* from-ar */
    { .label = { 137334,  7, 0 } }, /* from-ca */
    { .label = { 137399,  7, 0 } }, /* from-ct */
    { .label = { 137432,  7, 0 } }, /* from-dc */
    { .label = { 137466,  7, 0 } }, /* from-de */
    { .label = { 137499,  7, 0 } }, /* from-fl */
    { .label = { 137534,  7, 0 } }, /* from-ga */
    { .label = { 137566,  7, 0 } }, /* from-hi */
    { .label = { 137599,  7, 0 } }, /* from-ia */
    { .label = { 137630,  7, 0 } }, /* from-id */
    { .label = { 137663,  7, 0 } }, /* from-il */
    { .label = { 137696,  7, 0 } }, /* from-in */
    { .label = { 137728,  7, 0 } }, /* from-ks */
    { .label = { 137761,  7, 0 } }, /* from-ky */
    { .label = { 137828,  7, 0 } }, /* from-ma */
    { .label = { 137860,  7, 0 } }, /* from-md */
    { .label = { 137927,  7, 0 } }, /* from-mi */
    { .label = { 137960,  7, 0 } }, /* from-mn */
    { .label = { 137993,  7, 0 } }, /* from-mo */
    { .label = { 138026,  7, 0 } }, /* from-ms */
    { .label = { 138059,  7, 0 } }, /* from-mt */
    { .label = { 138092,  7, 0 } }, /* from-nc */
    { .label = { 138125,  7, 0 } }, /* from-nd */
    { .label = { 138158,  7, 0 } }, /* from-ne */
    { .label = { 138190,  7, 0 } }, /* from-nh */
    { .label = { 138223,  7, 0 } }, /* from-nj */
    { .label = { 138258,  7, 0 } }, /* from-nm */
    { .label = { 138291,  7, 0 } }, /* from-nv */
    { .label = { 138359,  7, 0 } }, /* from-oh */
    { .label = { 138392,  7, 0 } }, /* from-ok */
    { .label = { 138425,  7, 0 } }, /* from-or */
    { .label = { 138457,  7, 0 } }, /* from-pa */
    { .label = { 138490,  7, 0 } }, /* from-pr */
    { .label = { 138524,  7, 0 } }, /* from-ri */
    { .label = { 138556,  7, 0 } }, /* from-sc */
    { .label = { 138589,  7, 0 } }, /* from-sd */
    { .label = { 138622,  7, 0 } }, /* from-tn */
    { .label = { 138654,  7, 0 } }, /* from-tx */
    { .label = { 138688,  7, 0 } }, /* from-ut */
    { .label = { 138721,  7, 0 } }, /* from-va */
    { .label = { 138754,  7, 0 } }, /* from-vt */
    { .label = { 138788,  7, 0 } }, /* from-wa */
    { .label = { 138821,  7, 0 } }, /* from-wi */
    { .label = { 138855,  7, 0 } }, /* from-wv */
    { .label = { 138891,  7, 0 } }, /* from-wy */
    { .label = { 138927,  7, 0 } }, /* getmyip */
    { .label = { 155980,  6, 0 } }, /* gotdns */
    { .label = {  78718, 10, 0 } }, /* hobby-site */
    { .label = {  96384,  9, 0 } }, /* homelinux */
    { .label = { 117031,  8, 0 } }, /* homeunix */
    { .label = {  96426,  9, 0 } }, /* iamallama */
    { .label = {  31259, 14, 0 } }, /* is-a-anarchist */
    { .label = {  50443, 12, 0 } }, /* is-a-blogger */
    { .label = {  24104, 15, 0 } }, /* is-a-bookkeeper */
    { .label = {  31377, 14, 0 } }, /* is-a-bulls-fan */
    { .label = {  50497, 12, 0 } }, /* is-a-caterer */
    { .label = {  96462,  9, 0 } }, /* is-a-chef */
    { .label = {  12992, 17, 0 } }, /* is-a-conservative */
    { .label = { 117068,  8, 0 } }, /* is-a-cpa */
    { .label = {  10084, 18, 0 } }, /* is-a-cubicle-slave */
    { .label = {  39336, 13, 0 } }, /* is-a-democrat */
    { .label = {  39391, 13, 0 } }, /* is-a-designer */
    { .label = {  64474, 11, 0 } }, /* is-a-doctor */
    { .label = {   3930, 21, 0 } }, /* is-a-financialadvisor */
    { .label = {  96503,  9, 0 } }, /* is-a-geek */
    { .label = {  78766, 10, 0 } }, /* is-a-green */
    { .label = {  96542,  9, 0 } }, /* is-a-guru */
    { .label = {  16930, 16, 0 } }, /* is-a-hard-worker */
    { .label = {  64521, 11, 0 } }, /* is-a-hunter */
    { .label = {  24236, 15, 0 } }, /* is-a-landscaper */
    { .label = {  64616, 11, 0 } }, /* is-a-lawyer */
    { .label = {  50546, 12, 0 } }, /* is-a-liberal */
    { .label = {  17000, 16, 0 } }, /* is-a-libertarian */
    { .label = {  78808, 10, 0 } }, /* is-a-llama */
    { .label = {  39446, 13, 0 } }, /* is-a-musician */
    { .label = {  31499, 14, 0 } }, /* is-a-nascarfan */
    { .label = {  78850, 10, 0 } }, /* is-a-nurse */
    { .label = {  50598, 12, 0 } }, /* is-a-painter */
    { .label = {   5368, 20, 0 } }, /* is-a-personaltrainer */
    { .label = {  13065, 17, 0 } }, /* is-a-photographer */
    { .label = {  64665, 11, 0 } }, /* is-a-player */
    { .label = {  24367, 15, 0 } }, /* is-a-republican */
    { .label = {  39501, 13, 0 } }, /* is-a-rockstar */
    { .label = {  31556, 14, 0 } }, /* is-a-socialist */
    { .label = {  50699, 12, 0 } }, /* is-a-student */
    { .label = {  50750, 12, 0 } }, /* is-a-teacher */
    { .label = {  64762, 11, 0 } }, /* is-a-techie */
    { .label = {  31614, 14, 0 } }, /* is-a-therapist */
    { .label = {  17066, 16, 0 } }, /* is-an-accountant */
    { .label = {  64809, 11, 0 } }, /* is-an-actor */
    { .label = {  39555, 13, 0 } }, /* is-an-actress */
    { .label = {  24434, 15, 0 } }, /* is-an-anarchist */
    { .label = {  50800, 12, 0 } }, /* is-an-artist */
    { .label = {  31673, 14, 0 } }, /* is-an-engineer */
    { .label = {  13140, 17, 0 } }, /* is-an-entertainer */
    { .label = {  50848, 12, 0 } }, /* is-certified */
    { .label = { 139022,  7, 0 } }, /* is-gone */
    { .label = {  39608, 13, 0 } }, /* is-into-anime */
    { .label = {  50901, 12, 0 } }, /* is-into-cars */
    { .label = {  17132, 16, 0 } }, /* is-into-cartoons */
    { .label = {  39662, 13, 0 } }, /* is-into-games */
    { .label = { 139052,  7, 0 } }, /* is-leet */
    { .label = {  17198, 16, 0 } }, /* is-not-certified */
    { .label = { 117175,  8, 0 } }, /* is-slick */
    { .label = {  64854, 11, 0 } }, /* is-uberleet */
    { .label = {  24495, 15, 0 } }, /* is-with-theband */
    { .label = { 117211,  8, 0 } }, /* isa-geek */
    { .label = {  39777, 13, 0 } }, /* isa-hockeynut */
    { .label = {  17268, 16, 0 } }, /* issmarterthanyou */
    { .label = {  96621,  9, 0 } }, /* likes-pie */
    { .label = {  79068, 10, 0 } }, /* likescandy */
    { .label = { 117316,  8, 0 } }, /* neat-url */
    { .label = {  17335, 16, 0 } }, /* saves-the-whales */
    { .label = { 156063,  6, 0 } }, /* selfip */
    { .label = {  31731, 14, 0 } }, /* sells-for-less */
    { .label = {  65057, 11, 0 } }, /* sells-for-u */
    { .label = { 117385,  8, 0 } }, /* servebbs */
    { .label = {  79207, 10, 0 } }, /* simple-url */
    { .label = {  40011, 13, 0 } }, /* space-to-rent */
    { .label = {  51179, 12, 0 } }, /* teaches-yoga */
    { .label = {  31794, 14, 0 } }, /* writesthisblog */
    { .label = { 117645,  8, 0 } }, /* ddnsfree */
    { .label = { 117681,  8, 0 } }, /* ddnsgeek */
    { .label = { 166688,  5, 0 } }, /* giize */
    { .label = { 156123,  6, 0 } }, /* gleeze */
    { .label = { 166712,  5, 0 } }, /* kozow */
    { .label = {  79297, 10, 0 } }, /* loseyourip */
    { .label = { 166738,  5, 0 } }, /* ooguy */
    { .label = {  96742,  9, 0 } }, /* theworkpc */
    { .label = { 117717,  8, 0 } }, /* mytuleap */
    { .label = { 117790,  8, 1 } }, { .child = { 3059, 8 } }, /* evennode */
    { .label = { 166813,  5, 1 } }, { .child = { 3067, 1 } }, /* fbsbx */
    { .label = {  17475, 16, 0 } }, /* fastly-terrarium */
    { .label = {  31922, 14, 0 } }, /* fastvps-server */
    { .label = { 118319,  8, 0 } }, /* mydobiss */
    { .label = {  65650, 11, 0 } }, /* firebaseapp */
    { .label = { 118357,  8, 0 } }, /* flynnhub */
    { .label = {  79524, 10, 0 } }, /* freebox-os */
    { .label = {  97044,  9, 0 } }, /* freeboxos */
    { .label = {  13208, 17, 0 } }, /* githubusercontent */
    { .label = {  38061,  4, 1 } }, { .child = { 3068, 1 } }, /* 0emm */
    { .label = { 139631,  7, 0 } }, /* appspot */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 118470,  8, 0 } }, /* codespot */
    { .label = {  79618, 10, 0 } }, /* googleapis */
    { .label = {  79662, 10, 0 } }, /* googlecode */
    { .label = {  10166, 18, 0 } }, /* pagespeedmobilizer */
    { .label = {  51341, 12, 0 } }, /* publishproxy */
    { .label = {  79707, 10, 0 } }, /* withgoogle */
    { .label = {  65750, 11, 0 } }, /* withyoutube */
    { .label = {  97171,  9, 0 } }, /* herokuapp */
    { .label = {  97213,  9, 0 } }, /* herokussl */
    { .label = {  97253,  9, 0 } }, /* myravendb */
    { .label = { 118579,  8, 0 } }, /* pixolino */
    { .label = { 156734,  6, 1 } }, { .child = { 3069, 1 } }, /* joyent */
    { .label = {  40357, 13, 0 } }, /* lpusercontent */
    { .label = { 170787,  4, 1 } }, { .child = { 3072, 1 } }, /* lmpm */
    { .label = { 156793,  6, 1 } }, { .child = { 3073, 2 } }, /* linode */
    { .label = {  65951, 11, 0 } }, /* barsycenter */
    { .label = {  65903, 11, 0 } }, /* barsyonline */
    { .label = {  80019, 10, 0 } }, /* miniserver */
    { .label = {  97611,  9, 1 } }, { .child = { 3075, 1 } }, /* meteorapp */
    { .label = {  80062, 10, 0 } }, /* bitballoon */
    { .label = { 139853,  7, 0 } }, /* netlify */
    { .label = {   2174,  2, 0 } }, /* 4u */
    { .label = { 139918,  7, 0 } }, /* nfshost */
    { .label = { 156931,  6, 0 } }, /* 001www */
    { .label = { 118761,  8, 0 } }, /* ddnslive */
    { .label = { 118798,  8, 0 } }, /* myiphost */
    { .label = { 118871,  8, 0 } }, /* blogsyte */
    { .label = {  80107, 10, 0 } }, /* ciscofreak */
    { .label = {  80196, 10, 0 } }, /* damnserver */
    { .label = {  66192, 11, 0 } }, /* ditchyourip */
    { .label = {  80239, 10, 0 } }, /* dnsiskinky */
    { .label = { 167119,  5, 0 } }, /* dynns */
    { .label = {  80284, 10, 0 } }, /* geekgalaxy */
    { .label = {  13283, 17, 0 } }, /* health-carereform */
    { .label = {  24700, 15, 0 } }, /* homesecuritymac */
    { .label = {  32292, 14, 0 } }, /* homesecuritypc */
    { .label = {  13357, 17, 0 } }, /* myactivedirectory */
    { .label = {  17687, 16, 0 } }, /* mysecuritycamera */
    { .label = {  80330, 10, 0 } }, /* net-freaks */
    { .label = {  97772,  9, 0 } }, /* onthewifi */
    { .label = {  80373, 10, 0 } }, /* point2this */
    { .label = {  80420, 10, 0 } }, /* quicksytes */
    { .label = {  24767, 15, 0 } }, /* securitytactics */
    { .label = {  40529, 13, 0 } }, /* serveexchange */
    { .label = {  66244, 11, 0 } }, /* servehumour */
    { .label = { 118982,  8, 0 } }, /* servep2p */
    { .label = {  51620, 12, 0 } }, /* servesarcasm */
    { .label = {  66294, 11, 0 } }, /* stufftoread */
    { .label = {  40587, 13, 0 } }, /* unusualperson */
    { .label = {  51670, 12, 0 } }, /* workisboring */
    { .label = {  80513, 10, 0 } }, /* 3utilities */
    { .label = { 119061,  8, 0 } }, /* ddnsking */
    { .label = { 167242,  5, 0 } }, /* myvnc */
    { .label = {  97813,  9, 0 } }, /* servebeer */
    { .label = {  10250, 18, 0 } }, /* servecounterstrike */
    { .label = { 117423,  8, 0 } }, /* serveftp */
    { .label = {  96703,  9, 0 } }, /* servegame */
    { .label = {  40644, 13, 0 } }, /* servehalflife */
    { .label = {  97895,  9, 0 } }, /* servehttp */
    { .label = { 119097,  8, 0 } }, /* serveirc */
    { .label = { 119132,  8, 0 } }, /* servemp3 */
    { .label = {  97936,  9, 0 } }, /* servepics */
    { .label = {  80602, 10, 0 } }, /* servequake */
    { .label = {  80649, 10, 0 } }, /* operaunite */
    { .label = {  24832, 15, 0 } }, /* outsystemscloud */
    { .label = {  66343, 11, 0 } }, /* ownprovider */
    { .label = { 167311,  5, 0 } }, /* pgfog */
    { .label = {  51724, 12, 0 } }, /* pagefrontapp */
    { .label = {  66394, 11, 0 } }, /* gotpantheon */
    { .label = { 167396,  5, 1 } }, { .child = { 3076, 1 } }, /* prgmr */
    { .label = { 171829,  3, 0 } }, /* qa2 */
    { .label = {  24900, 15, 0 } }, /* dev-myqnapcloud */
    { .label = {  13434, 17, 0 } }, /* alpha-myqnapcloud */
    { .label = {  13461, 11, 0 } }, /* myqnapcloud */
    { .label = {  51880, 12, 1 } }, { .child = { 3077, 1 } }, /* quipelements */
    { .label = { 119243,  8, 0 } }, /* rackmaze */
    { .label = { 140200,  7, 0 } }, /* rhcloud */
    { .label = { 119287,  6, 1 } }, { .child = { 3078, 1 } }, /* render */
    { .label = { 119279,  8, 0 } }, /* onrender */
    { .label = { 157366,  6, 0 } }, /* logoip */
    { .label = { 140233,  7, 0 } }, /* scrysec */
    { .label = {  17758, 16, 0 } }, /* firewall-gateway */
    { .label = {  51986, 12, 0 } }, /* myshopblocks */
    { .label = { 167470,  5, 0 } }, /* 1kapp */
    { .label = { 119344,  8, 0 } }, /* appchizi */
    { .label = { 119384,  8, 0 } }, /* applinzi */
    { .label = {  81065,  7, 0 } }, /* sinaapp */
    { .label = {  81049, 10, 0 } }, /* vipsinaapp */
    { .label = {  66589, 11, 1 } }, { .child = { 3079, 2 } }, /* bounty-full */
    { .label = {  13517, 17, 0 } }, /* stackhero-network */
    { .label = { 157419,  6, 1 } }, { .child = { 3081, 1 } }, /* stdlib */
    { .label = { 119492,  8, 0 } }, /* temp-dns */
    { .label = { 140329,  7, 0 } }, /* dsmynas */
    { .label = { 119567,  8, 0 } }, /* familyds */
    { .label = {  40827, 13, 0 } }, /* thingdustdata */
    { .label = { 140523,  7, 0 } }, /* bloxcms */
    { .label = {  17903, 16, 0 } }, /* townnews-staging */
    { .label = {   4197,  2, 0 } }, /* hk */
    { .label = {  81184, 10, 0 } }, /* wafflecell */
    { .label = { 119791,  8, 0 } }, /* remotewd */
    { .label = { 167593,  5, 1 } }, { .child = { 3082, 2 } }, /* xnbay */
    { .label = { 119904,  8, 0 } }, /* yolasite */

    /* entries 2928 to 2985 */
    { .label = {  19964,  7, 1 } }, { .child = { 2986, 1 } }, /* compute */
    { .label = {  95760,  9, 1 } }, { .child = { 2987, 1 } }, /* compute-1 */
    { .label = {   4842,  9, 1 } }, { .child = { 2988, 1 } }, /* us-east-1 */
    { .label = {  40776,  3, 1 } }, { .child = { 2991, 1 } }, /* elb */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  12594, 17, 0 } }, /* s3-ap-northeast-1 */
    { .label = {  12674, 17, 0 } }, /* s3-ap-northeast-2 */
    { .label = {  38744, 13, 0 } }, /* s3-ap-south-1 */
    { .label = {  12754, 17, 0 } }, /* s3-ap-southeast-1 */
    { .label = {  12835, 17, 0 } }, /* s3-ap-southeast-2 */
    { .label = {  23499, 15, 0 } }, /* s3-ca-central-1 */
    { .label = {  23571, 15, 0 } }, /* s3-eu-central-1 */
    { .label = {  49579, 12, 0 } }, /* s3-eu-west-1 */
    { .label = {  49641, 12, 0 } }, /* s3-eu-west-2 */
    { .label = {  49703, 12, 0 } }, /* s3-eu-west-3 */
    { .label = {  38810, 13, 0 } }, /* s3-external-1 */
    { .label = {   3823, 21, 0 } }, /* s3-fips-us-gov-west-1 */
    { .label = {  49765, 12, 0 } }, /* s3-sa-east-1 */
    { .label = {  16707, 16, 0 } }, /* s3-us-gov-west-1 */
    { .label = {  49822, 12, 0 } }, /* s3-us-east-2 */
    { .label = {  49881, 12, 0 } }, /* s3-us-west-1 */
    { .label = {  49943, 12, 0 } }, /* s3-us-west-2 */
    { .label = {  12691, 14, 1 } }, { .child = { 2992, 3 } }, /* ap-northeast-2 */
    { .label = {  38761, 10, 1 } }, { .child = { 2997, 3 } }, /* ap-south-1 */
    { .label = {  23516, 12, 1 } }, { .child = { 3002, 3 } }, /* ca-central-1 */
    { .label = {  23588, 12, 1 } }, { .child = { 3007, 3 } }, /* eu-central-1 */
    { .label = {  49658,  9, 1 } }, { .child = { 3012, 3 } }, /* eu-west-2 */
    { .label = {  49720,  9, 1 } }, { .child = { 3017, 3 } }, /* eu-west-3 */
    { .label = {  49839,  9, 1 } }, { .child = { 3022, 3 } }, /* us-east-2 */
    { .label = {    720, 14, 1 } }, { .child = { 3027, 1 } }, /* ap-northeast-1 */
    { .label = {    837, 14, 1 } }, { .child = { 3030, 1 } }, /* ap-southeast-1 */
    { .label = {    955, 14, 1 } }, { .child = { 3033, 1 } }, /* ap-southeast-2 */
    { .label = {   5136,  9, 1 } }, { .child = { 3036, 1 } }, /* eu-west-1 */
    { .label = {   5235,  9, 1 } }, { .child = { 3039, 1 } }, /* sa-east-1 */
    { .label = {   4788, 20, 0 } }, /* s3-website-us-east-1 */
    { .label = {   4884, 20, 0 } }, /* s3-website-us-west-1 */
    { .label = {   4983, 20, 0 } }, /* s3-website-us-west-2 */
    { .label = {    666, 25, 0 } }, /* s3-website-ap-northeast-1 */
    { .label = {    783, 25, 0 } }, /* s3-website-ap-southeast-1 */
    { .label = {    901, 25, 0 } }, /* s3-website-ap-southeast-2 */
    { .label = {   5082, 20, 0 } }, /* s3-website-eu-west-1 */
    { .label = {   5181, 20, 0 } }, /* s3-website-sa-east-1 */

    /* entry 2986 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2987 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2988 to 2989 */
    { .label = {  95806,  9, 1 } }, { .child = { 2990, 1 } }, /* dualstack */

    /* entry 2990 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entry 2991 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2992 to 2995 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 2996, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2996 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2997 to 3000 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 3001, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3001 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3002 to 3005 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 3006, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3006 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3007 to 3010 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 3011, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3011 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3012 to 3015 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 3016, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3016 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3017 to 3020 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 3021, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3021 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3022 to 3025 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  95806,  9, 1 } }, { .child = { 3026, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 3026 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3027 to 3028 */
    { .label = {  95806,  9, 1 } }, { .child = { 3029, 1 } }, /* dualstack */

    /* entry 3029 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3030 to 3031 */
    { .label = {  95806,  9, 1 } }, { .child = { 3032, 1 } }, /* dualstack */

    /* entry 3032 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3033 to 3034 */
    { .label = {  95806,  9, 1 } }, { .child = { 3035, 1 } }, /* dualstack */

    /* entry 3035 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3036 to 3037 */
    { .label = {  95806,  9, 1 } }, { .child = { 3038, 1 } }, /* dualstack */

    /* entry 3038 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3039 to 3040 */
    { .label = {  95806,  9, 1 } }, { .child = { 3041, 1 } }, /* dualstack */

    /* entry 3041 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 3042 to 3058 */
    { .label = {    720, 14, 0 } }, /* ap-northeast-1 */
    { .label = {  12691, 14, 0 } }, /* ap-northeast-2 */
    { .label = {  30945, 14, 0 } }, /* ap-northeast-3 */
    { .label = {  38761, 10, 0 } }, /* ap-south-1 */
    { .label = {    837, 14, 0 } }, /* ap-southeast-1 */
    { .label = {    955, 14, 0 } }, /* ap-southeast-2 */
    { .label = {  23516, 12, 0 } }, /* ca-central-1 */
    { .label = {  23588, 12, 0 } }, /* eu-central-1 */
    { .label = {   5136,  9, 0 } }, /* eu-west-1 */
    { .label = {  49658,  9, 0 } }, /* eu-west-2 */
    { .label = {  49720,  9, 0 } }, /* eu-west-3 */
    { .label = {   5235,  9, 0 } }, /* sa-east-1 */
    { .label = {   4842,  9, 0 } }, /* us-east-1 */
    { .label = {  49839,  9, 0 } }, /* us-east-2 */
    { .label = {   3865, 13, 0 } }, /* us-gov-west-1 */
    { .label = {   4938,  9, 0 } }, /* us-west-1 */
    { .label = {   5037,  9, 0 } }, /* us-west-2 */

    /* entries 3059 to 3066 */
    { .label = { 170532,  4, 0 } }, /* eu-1 */
    { .label = { 170554,  4, 0 } }, /* eu-2 */
    { .label = { 170576,  4, 0 } }, /* eu-3 */
    { .label = { 170598,  4, 0 } }, /* eu-4 */
    { .label = { 170621,  4, 0 } }, /* us-1 */
    { .label = { 170643,  4, 0 } }, /* us-2 */
    { .label = { 170665,  4, 0 } }, /* us-3 */
    { .label = { 170687,  4, 0 } }, /* us-4 */

    /* entry 3067 */
    { .label = {  78198,  4, 0 } }, /* apps */

    /* entry 3068 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3069 to 3070 */
    { .label = {  12574,  3, 1 } }, { .child = { 3071, 1 } }, /* cns */

    /* entry 3071 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3072 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entries 3073 to 3074 */
    { .label = { 139728,  7, 0 } }, /* members */
    { .label = {  51458, 12, 0 } }, /* nodebalancer */

    /* entry 3075 */
    { .label = {   2994,  2, 0 } }, /* eu */

    /* entry 3076 */
    { .label = {  38874,  3, 0 } }, /* xen */

    /* entry 3077 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3078 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entries 3079 to 3080 */
    { .label = {  13434,  5, 0 } }, /* alpha */
    { .label = {  78126,  4, 0 } }, /* beta */

    /* entry 3081 */
    { .label = {  18922,  3, 0 } }, /* api */

    /* entries 3082 to 3083 */
    { .label = {  49153,  2, 0 } }, /* u2 */
    { .label = { 119827,  8, 0 } }, /* u2-local */

    /* entries 3084 to 3090 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    355,  2, 0 } }, /* sa */

    /* entries 3091 to 3096 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5417,  3, 0 } }, /* inf */

    /* entry 3097 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3098 to 3101 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 3102 to 3104 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   1517,  3, 0 } }, /* ath */
    { .label = { 112595,  4, 0 } }, /* info */

    /* entries 3105 to 3118 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 1 } }, { .child = { 3119, 1 } }, /* com */
    { .label = { 120604,  7, 0 } }, /* ekloges */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  67773, 10, 0 } }, /* parliament */
    { .label = {  23006,  5, 0 } }, /* press */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {   2442,  2, 0 } }, /* tm */

    /* entry 3119 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3120 to 3127 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 109285,  5, 0 } }, /* realm */
    { .label = {  12576,  2, 0 } }, /* e4 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  66044, 11, 1 } }, { .child = { 3128, 2 } }, /* metacentrum */
    { .label = {    115,  4, 1 } }, { .child = { 3130, 1 } }, /* muni */

    /* entries 3128 to 3129 */
    { .label = {  13493,  5, 0 } }, /* cloud */
    { .label = { 117755,  6, 0 } }, /* custom */

    /* entries 3130 to 3131 */
    { .label = {  13493,  5, 1 } }, { .child = { 3132, 2 } }, /* cloud */

    /* entries 3132 to 3133 */
    { .label = {  42264,  3, 0 } }, /* flt */
    { .label = {  27999,  3, 0 } }, /* usr */

    /* entries 3134 to 3198 */
    { .label = { 136621,  7, 0 } }, /* bplaced */
    { .label = { 136584,  7, 0 } }, /* square7 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 136791,  7, 1 } }, { .child = { 3199, 1 } }, /* cosidns */
    { .label = {  23847, 15, 0 } }, /* dynamisches-dns */
    { .label = {  78314, 10, 0 } }, /* dnsupdater */
    { .label = {  50236, 12, 0 } }, /* internet-dns */
    { .label = {  96061,  9, 0 } }, /* l-o-g-i-n */
    { .label = { 136885,  7, 0 } }, /* dnshome */
    { .label = {  24038, 15, 0 } }, /* fuettertdasnetz */
    { .label = {  78892, 10, 0 } }, /* isteingeek */
    { .label = { 139112,  7, 0 } }, /* istmein */
    { .label = {  78978, 10, 0 } }, /* lebtimnetz */
    { .label = {  79025, 10, 0 } }, /* leitungsen */
    { .label = {  40067, 13, 0 } }, /* traeumtgerade */
    { .label = { 166666,  5, 1 } }, { .child = { 3200, 2 } }, /* ddnss */
    { .label = { 139175,  7, 0 } }, /* dyndns1 */
    { .label = { 117530,  8, 0 } }, /* dyn-ip24 */
    { .label = {  31857, 14, 1 } }, { .child = { 3202, 1 } }, /* home-webserver */
    { .label = {  40121, 13, 0 } }, /* myhome-server */
    { .label = { 157375,  4, 0 } }, /* goip */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  79797, 10, 0 } }, /* dyn-berlin */
    { .label = {  97334,  9, 0 } }, /* in-berlin */
    { .label = { 156595,  6, 0 } }, /* in-brb */
    { .label = {  97374,  9, 0 } }, /* in-butter */
    { .label = { 156624,  6, 0 } }, /* in-dsl */
    { .label = { 156651,  6, 0 } }, /* in-vpn */
    { .label = {  79844, 10, 0 } }, /* mein-iserv */
    { .label = {  79888, 10, 0 } }, /* test-iserv */
    { .label = {  79931, 10, 0 } }, /* keymachine */
    { .label = {  97414,  9, 0 } }, /* git-repos */
    { .label = {  51402, 12, 0 } }, /* lcube-server */
    { .label = {  97454,  9, 0 } }, /* svn-repos */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 157366,  6, 0 } }, /* logoip */
    { .label = {  17758, 16, 0 } }, /* firewall-gateway */
    { .label = {  80871, 10, 0 } }, /* my-gateway */
    { .label = {  98057,  9, 0 } }, /* my-router */
    { .label = { 167447,  5, 0 } }, /* spdns */
    { .label = {  52045, 12, 1 } }, { .child = { 3203, 1 } }, /* speedpartner */
    { .label = {  81095, 10, 0 } }, /* taifun-dns */
    { .label = { 171152,  4, 0 } }, /* 12hp */
    { .label = { 171867,  3, 0 } }, /* 2ix */
    { .label = { 167567,  5, 0 } }, /* 4lima */
    { .label = {  98138,  9, 0 } }, /* lima-city */
    { .label = { 157553,  6, 0 } }, /* dd-dns */
    { .label = { 119676,  8, 0 } }, /* dray-dns */
    { .label = { 140558,  7, 0 } }, /* draydns */
    { .label = { 140589,  7, 0 } }, /* dyn-vpn */
    { .label = { 157581,  6, 0 } }, /* dynvpn */
    { .label = {  81139, 10, 0 } }, /* mein-vigor */
    { .label = { 119712,  8, 0 } }, /* my-vigor */
    { .label = { 157612,  6, 0 } }, /* my-wan */
    { .label = { 140625,  7, 0 } }, /* syno-ds */
    { .label = {   5450, 20, 0 } }, /* synology-diskstation */
    { .label = {  66697, 11, 0 } }, /* synology-ds */
    { .label = {  98223,  9, 1 } }, { .child = { 3204, 1 } }, /* uberspace */
    { .label = {  66749, 11, 0 } }, /* virtualuser */
    { .label = {  52097, 12, 0 } }, /* virtual-user */

    /* entry 3199 */
    { .label = {  21464,  3, 0 } }, /* dyn */

    /* entries 3200 to 3201 */
    { .label = {  21464,  3, 0 } }, /* dyn */
    { .label = {  31132,  6, 0 } }, /* dyndns */

    /* entry 3202 */
    { .label = {  21464,  3, 0 } }, /* dyn */

    /* entry 3203 */
    { .label = { 117755,  8, 0 } }, /* customer */

    /* entry 3204 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3205 to 3210 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = {  19044,  3, 0 } }, /* reg */
    { .label = { 157748,  5, 0 } }, /* store */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3211 to 3215 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 3216 to 3225 */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 108388,  3, 0 } }, /* sld */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 3226 to 3233 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {   4200,  3, 0 } }, /* pol */
    { .label = {   7867,  3, 0 } }, /* art */

    /* entries 3234 to 3245 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  25180,  3, 0 } }, /* mil */

    /* entries 3246 to 3247 */
    { .label = {  15146,  3, 1 } }, { .child = { 3248, 1 } }, /* rit */

    /* entry 3248 */
    { .label = {  98017,  9, 0 } }, /* git-pages */

    /* entries 3249 to 3259 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 167809,  4, 0 } }, /* riik */
    { .label = {  17021,  3, 0 } }, /* lib */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {    106,  3, 1 } }, { .child = { 3260, 1 } }, /* com */
    { .label = {   1461,  3, 0 } }, /* pri */
    { .label = {  22820,  3, 0 } }, /* aip */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  17249,  3, 0 } }, /* fie */

    /* entry 3260 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3261 to 3270 */
    { .label = {    106,  3, 1 } }, { .child = { 3271, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  11169,  3, 0 } }, /* eun */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    601,  3, 0 } }, /* sci */

    /* entry 3271 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entry 3272 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3273 to 3278 */
    { .label = {    106,  3, 1 } }, { .child = { 3279, 1 } }, /* com */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  43572,  3, 0 } }, /* edu */

    /* entry 3279 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3280 to 3287 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 3288 to 3295 */
    { .label = { 170397,  4, 0 } }, /* mycd */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = {  40765, 13, 0 } }, /* wellbeingzone */
    { .label = { 167447,  5, 0 } }, /* spdns */
    { .label = { 119643,  8, 1 } }, { .child = { 3296, 1 } }, /* transurl */
    { .label = {   5493, 11, 0 } }, /* diskstation */

    /* entry 3296 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3297 to 3301 */
    { .label = {  15344,  5, 0 } }, /* aland */
    { .label = {    767,  2, 0 } }, /* dy */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  24626, 15, 0 } }, /* xn--hkkinen-5wa */
    { .label = {  42816,  3, 0 } }, /* iki */

    /* entry 3302 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3303 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3304 to 3331 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 167752,  4, 0 } }, /* gouv */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  44385,  3, 0 } }, /* prd */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {  99081,  8, 0 } }, /* aeroport */
    { .label = { 141239,  6, 0 } }, /* avocat */
    { .label = { 141264,  6, 0 } }, /* avoues */
    { .label = {    466,  3, 0 } }, /* cci */
    { .label = {  81744,  9, 0 } }, /* chambagri */
    { .label = {    190, 21, 0 } }, /* chirurgiens-dentistes */
    { .label = {   7850, 18, 0 } }, /* experts-comptables */
    { .label = {  18042, 15, 0 } }, /* geometre-expert */
    { .label = { 157900,  5, 0 } }, /* greta */
    { .label = {  13660, 16, 0 } }, /* huissier-justice */
    { .label = { 120635,  7, 0 } }, /* medecin */
    { .label = {  99114,  8, 0 } }, /* notaires */
    { .label = {  56557, 10, 0 } }, /* pharmacien */
    { .label = {  18004,  4, 0 } }, /* port */
    { .label = {  52479, 11, 0 } }, /* veterinaire */
    { .label = { 156456,  6, 0 } }, /* fbx-os */
    { .label = { 166978,  5, 0 } }, /* fbxos */
    { .label = {  79524, 10, 0 } }, /* freebox-os */
    { .label = {  97044,  9, 0 } }, /* freeboxos */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 157282,  6, 0 } }, /* on-web */
    { .label = {    190, 31, 0 } }, /* chirurgiens-dentistes-en-france */

    /* entry 3332 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3333 to 3340 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  68391,  3, 0 } }, /* pvt */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3341 to 3345 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  47791,  4, 0 } }, /* kaas */
    { .label = {  64221,  3, 0 } }, /* cya */

    /* entries 3346 to 3350 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25180,  3, 0 } }, /* mil */

    /* entries 3351 to 3356 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13137,  3, 0 } }, /* mod */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 3357 to 3363 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3364 to 3369 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 3370 to 3375 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   2766,  4, 0 } }, /* asso */

    /* entries 3376 to 3382 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 3383 to 3390 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3391 to 3398 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3007,  4, 0 } }, /* guam */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 3399 to 3405 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 3406 to 3429 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  87628,  3, 0 } }, /* idv */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  67605, 10, 0 } }, /* xn--55qx5d */
    { .label = {  52524, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  52586, 11, 0 } }, /* xn--lcvr32d */
    { .label = {  67815, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  67871, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  81784,  9, 0 } }, /* xn--ciqpn */
    { .label = {  52647, 11, 0 } }, /* xn--gmq050i */
    { .label = {  67927, 10, 0 } }, /* xn--zf0avx */
    { .label = {  67671, 10, 0 } }, /* xn--io0a7i */
    { .label = {  67983, 10, 0 } }, /* xn--mk0axi */
    { .label = {  67723, 10, 0 } }, /* xn--od0alg */
    { .label = {  52714, 11, 0 } }, /* xn--od0aq3b */
    { .label = {  81831,  9, 0 } }, /* xn--tn0ag */
    { .label = {  68034, 10, 0 } }, /* xn--uc0atv */
    { .label = {  52776, 11, 0 } }, /* xn--uc0ay4a */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = {  19736,  3, 0 } }, /* inc */

    /* entries 3430 to 3436 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3437 to 3442 */
    { .label = {   1109,  2, 0 } }, /* iz */
    { .label = { 137205,  4, 0 } }, /* from */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  56927,  4, 0 } }, /* free */

    /* entries 3443 to 3459 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  51997,  4, 0 } }, /* shop */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = { 157920,  5, 0 } }, /* adult */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {   4200,  3, 0 } }, /* pol */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   2926,  3, 0 } }, /* rel */
    { .label = { 167752,  4, 0 } }, /* gouv */
    { .label = {   5389,  5, 0 } }, /* perso */

    /* entries 3460 to 3491 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  67503,  5, 0 } }, /* sport */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 167826,  4, 0 } }, /* 2000 */
    { .label = { 157942,  5, 0 } }, /* agrar */
    { .label = { 167858,  4, 0 } }, /* bolt */
    { .label = { 141290,  6, 0 } }, /* casino */
    { .label = {  98160,  4, 0 } }, /* city */
    { .label = { 120666,  7, 0 } }, /* erotica */
    { .label = { 120694,  7, 0 } }, /* erotika */
    { .label = {  81295,  4, 0 } }, /* film */
    { .label = { 156973,  5, 0 } }, /* forum */
    { .label = {  39696,  5, 0 } }, /* games */
    { .label = {  60878,  5, 0 } }, /* hotel */
    { .label = {  99145,  8, 0 } }, /* ingatlan */
    { .label = { 141314,  6, 0 } }, /* jogasz */
    { .label = {  99177,  8, 0 } }, /* konyvelo */
    { .label = { 157961,  5, 0 } }, /* lakas */
    { .label = {  97740,  5, 0 } }, /* media */
    { .label = {  17921,  4, 0 } }, /* news */
    { .label = { 141344,  6, 0 } }, /* reklam */
    { .label = {   6268,  3, 0 } }, /* sex */
    { .label = {  51997,  4, 0 } }, /* shop */
    { .label = { 147648,  4, 0 } }, /* suli */
    { .label = { 167877,  4, 0 } }, /* szex */
    { .label = { 141370,  6, 0 } }, /* tozsde */
    { .label = { 141398,  6, 0 } }, /* utazas */
    { .label = { 157981,  5, 0 } }, /* video */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3492 to 3505 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 1 } }, { .child = { 3506, 1 } }, /* co */
    { .label = {  52425,  4, 0 } }, /* desa */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   1064,  2, 0 } }, /* my */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = { 141424,  6, 0 } }, /* ponpes */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  40808,  4, 0 } }, /* zone */

    /* entry 3506 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3507 to 3509 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 3510 to 3518 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 3519, 1 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 103737,  3, 0 } }, /* idf */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    115,  4, 0 } }, /* muni */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 3519 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3520 to 3529 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 3530, 2 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    302,  2, 0 } }, /* tt */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {     17,  2, 0 } }, /* ro */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 3530 to 3531 */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = {   2619,  3, 0 } }, /* plc */

    /* entries 3532 to 3546 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  12355,  3, 0 } }, /* res */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entries 3547 to 3566 */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = {  63821, 11, 0 } }, /* dynamic-dns */
    { .label = {  31132,  6, 0 } }, /* dyndns */
    { .label = {   7762, 19, 0 } }, /* barrel-of-knowledge */
    { .label = {   5275, 20, 0 } }, /* barrell-of-knowledge */
    { .label = { 137141,  7, 0 } }, /* for-our */
    { .label = {  96344,  9, 0 } }, /* groks-the */
    { .label = {  78674, 10, 0 } }, /* groks-this */
    { .label = {  39278, 13, 0 } }, /* here-for-more */
    { .label = {  78934, 10, 0 } }, /* knowsitall */
    { .label = { 156063,  6, 0 } }, /* selfip */
    { .label = { 156092,  6, 0 } }, /* webhop */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 118725,  8, 0 } }, /* mayfirst */
    { .label = { 156973,  6, 0 } }, /* forumz */
    { .label = {  78319,  8, 0 } }, /* nsupdate */
    { .label = { 157033,  6, 0 } }, /* dvrcam */
    { .label = {  51565, 12, 0 } }, /* ilovecollege */
    { .label = { 167192,  5, 0 } }, /* no-ip */
    { .label = { 157641,  6, 0 } }, /* v-info */

    /* entry 3567 */
    { .label = {   2994,  2, 0 } }, /* eu */

    /* entries 3568 to 3627 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 155763,  6, 0 } }, /* apigee */
    { .label = { 155819,  6, 0 } }, /* b-data */
    { .label = {  50060, 12, 0 } }, /* backplaneapp */
    { .label = {  63721, 11, 1 } }, { .child = { 3628, 1 } }, /* banzaicloud */
    { .label = { 136549,  7, 0 } }, /* boxfuse */
    { .label = {  12916, 17, 0 } }, /* browsersafetymark */
    { .label = { 170376,  4, 1 } }, { .child = { 3629, 1 } }, /* bigv */
    { .label = {  78170, 10, 0 } }, /* cleverapps */
    { .label = { 166617,  5, 0 } }, /* dedyn */
    { .label = { 170475,  4, 0 } }, /* drud */
    { .label = { 117577,  8, 0 } }, /* definima */
    { .label = { 156238,  6, 1 } }, { .child = { 3630, 1 } }, /* enonic */
    { .label = {  13208,  6, 0 } }, /* github */
    { .label = { 156540,  6, 0 } }, /* gitlab */
    { .label = {  79753, 10, 0 } }, /* hasura-app */
    { .label = {  97296,  9, 1 } }, { .child = { 3631, 1 } }, /* moonscale */
    { .label = {  97534,  9, 0 } }, /* loginline */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = {  32115, 14, 0 } }, /* azurecontainer */
    { .label = { 167004,  5, 0 } }, /* ngrok */
    { .label = { 140139,  7, 1 } }, { .child = { 3632, 1 } }, /* nodeart */
    { .label = { 167288,  5, 0 } }, /* nodum */
    { .label = {   4261,  3, 0 } }, /* nid */
    { .label = {  51779, 12, 0 } }, /* pantheonsite */
    { .label = { 167364,  5, 0 } }, /* dyn53 */
    { .label = { 119209,  8, 0 } }, /* protonet */
    { .label = {  80737, 10, 0 } }, /* vaporcloud */
    { .label = { 157311,  6, 1 } }, { .child = { 3633, 1 } }, /* on-rio */
    { .label = {  66441, 11, 0 } }, /* readthedocs */
    { .label = {  66488, 11, 0 } }, /* resindevice */
    { .label = {  51937, 12, 1 } }, { .child = { 3634, 1 } }, /* resinstaging */
    { .label = {  89913,  3, 0 } }, /* hzc */
    { .label = { 119312,  8, 0 } }, /* sandcats */
    { .label = { 171848,  3, 1 } }, { .child = { 3635, 1 } }, /* s5y */
    { .label = {  98098,  9, 0 } }, /* shiftedit */
    { .label = {  81006, 10, 0 } }, /* mo-siemens */
    { .label = {  98959,  4, 1 } }, { .child = { 3636, 1 } }, /* lair */
    { .label = { 157394,  6, 1 } }, { .child = { 3637, 1 } }, /* stolos */
    { .label = { 119457,  8, 0 } }, /* spacekit */
    { .label = { 140265,  7, 0 } }, /* utwente */
    { .label = {  17831, 16, 0 } }, /* applicationcloud */
    { .label = { 167521,  5, 0 } }, /* scapp */
    { .label = { 140396,  7, 0 } }, /* telebit */
    { .label = {  40827,  9, 1 } }, { .child = { 3638, 4 } }, /* thingdust */
    { .label = { 171212,  4, 0 } }, /* 2038 */
    { .label = { 119751,  8, 0 } }, /* wedeploy */
    { .label = {  66797, 11, 0 } }, /* basicserver */
    { .label = {  40882, 13, 0 } }, /* virtualserver */

    /* entry 3628 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entry 3629 */
    { .label = { 171735,  3, 0 } }, /* uk0 */

    /* entry 3630 */
    { .label = { 117755,  8, 0 } }, /* customer */

    /* entry 3631 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3632 */
    { .label = { 167268,  5, 0 } }, /* stage */

    /* entry 3633 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3634 */
    { .label = {  31038,  7, 0 } }, /* devices */

    /* entry 3635 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3636 */
    { .label = {  78198,  4, 0 } }, /* apps */

    /* entry 3637 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3638 to 3645 */
    { .label = {   9075,  3, 1 } }, { .child = { 3646, 1 } }, /* dev */
    { .label = { 157527,  6, 1 } }, { .child = { 3647, 1 } }, /* disrec */
    { .label = {  61099,  4, 1 } }, { .child = { 3648, 1 } }, /* prod */
    { .label = { 140461,  7, 1 } }, { .child = { 3649, 1 } }, /* testing */

    /* entry 3646 */
    { .label = { 117755,  4, 0 } }, /* cust */

    /* entry 3647 */
    { .label = { 117755,  4, 0 } }, /* cust */

    /* entry 3648 */
    { .label = { 117755,  4, 0 } }, /* cust */

    /* entry 3649 */
    { .label = { 117755,  4, 0 } }, /* cust */

    /* entries 3650 to 3655 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 3656 to 3664 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    143,  2, 0 } }, /* id */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {  18109, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  25104, 14, 0 } }, /* xn--mgba3a4fra */

    /* entries 3665 to 3672 */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = { 136821,  7, 0 } }, /* cupcake */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 3673 to 4083 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   8685,  3, 0 } }, /* abr */
    { .label = { 120722,  7, 0 } }, /* abruzzo */
    { .label = {  41050, 12, 0 } }, /* aosta-valley */
    { .label = {  52835, 11, 0 } }, /* aostavalley */
    { .label = {   3814,  3, 0 } }, /* bas */
    { .label = {  68085, 10, 0 } }, /* basilicata */
    { .label = {   4725,  3, 0 } }, /* cal */
    { .label = {  19075,  8, 0 } }, /* calabria */
    { .label = {    444,  3, 0 } }, /* cam */
    { .label = {  99215,  8, 0 } }, /* campania */
    { .label = {  25176, 14, 0 } }, /* emilia-romagna */
    { .label = {  32692, 13, 0 } }, /* emiliaromagna */
    { .label = {  70779,  3, 0 } }, /* emr */
    { .label = {  18194, 15, 0 } }, /* friuli-v-giulia */
    { .label = {  13732, 16, 0 } }, /* friuli-ve-giulia */
    { .label = {  18264, 15, 0 } }, /* friuli-vegiulia */
    { .label = {   2809, 21, 0 } }, /* friuli-venezia-giulia */
    { .label = {   4019, 20, 0 } }, /* friuli-veneziagiulia */
    { .label = {  25234, 14, 0 } }, /* friuli-vgiulia */
    { .label = {  25299, 14, 0 } }, /* friuliv-giulia */
    { .label = {  18333, 15, 0 } }, /* friulive-giulia */
    { .label = {  25364, 14, 0 } }, /* friulivegiulia */
    { .label = {   4110, 20, 0 } }, /* friulivenezia-giulia */
    { .label = {   5704, 19, 0 } }, /* friuliveneziagiulia */
    { .label = {  32745, 13, 0 } }, /* friulivgiulia */
    { .label = { 171450,  3, 0 } }, /* fvg */
    { .label = { 125376,  3, 0 } }, /* laz */
    { .label = { 158004,  5, 0 } }, /* lazio */
    { .label = {  44099,  3, 0 } }, /* lig */
    { .label = { 120758,  7, 0 } }, /* liguria */
    { .label = {  18046,  3, 0 } }, /* lom */
    { .label = {  81875,  9, 0 } }, /* lombardia */
    { .label = {  99248,  8, 0 } }, /* lombardy */
    { .label = { 120788,  7, 0 } }, /* lucania */
    { .label = {   1369,  3, 0 } }, /* mar */
    { .label = { 141452,  6, 0 } }, /* marche */
    { .label = {  56984,  3, 0 } }, /* mol */
    { .label = { 141478,  6, 0 } }, /* molise */
    { .label = {  99286,  8, 0 } }, /* piedmont */
    { .label = {  99322,  8, 0 } }, /* piemonte */
    { .label = {  47381,  3, 0 } }, /* pmn */
    { .label = {  42124,  3, 0 } }, /* pug */
    { .label = { 141504,  6, 0 } }, /* puglia */
    { .label = {   3878,  3, 0 } }, /* sar */
    { .label = {  99357,  8, 0 } }, /* sardegna */
    { .label = {  99389,  8, 0 } }, /* sardinia */
    { .label = {  28181,  3, 0 } }, /* sic */
    { .label = { 120817,  7, 0 } }, /* sicilia */
    { .label = { 141532,  6, 0 } }, /* sicily */
    { .label = {    314,  3, 0 } }, /* taa */
    { .label = {   5643,  3, 0 } }, /* tos */
    { .label = { 120846,  7, 0 } }, /* toscana */
    { .label = {  10327, 17, 0 } }, /* trentin-sud-tirol */
    { .label = {   1019, 24, 0 } }, /* xn--trentin-sd-tirol-rzb */
    { .label = {  13806, 16, 0 } }, /* trentin-sudtirol */
    { .label = {   1566, 23, 0 } }, /* xn--trentin-sdtirol-7vb */
    { .label = {   7933, 18, 0 } }, /* trentin-sued-tirol */
    { .label = {  10400, 17, 0 } }, /* trentin-suedtirol */
    { .label = {  13874, 16, 0 } }, /* trentino-a-adige */
    { .label = {  18402, 15, 0 } }, /* trentino-aadige */
    { .label = {   5790, 19, 0 } }, /* trentino-alto-adige */
    { .label = {   8010, 18, 0 } }, /* trentino-altoadige */
    { .label = {  13940, 16, 0 } }, /* trentino-s-tirol */
    { .label = {  18463, 15, 0 } }, /* trentino-stirol */
    { .label = {   8084, 18, 0 } }, /* trentino-sud-tirol */
    { .label = {    445, 25, 0 } }, /* xn--trentino-sd-tirol-c3b */
    { .label = {  10472, 17, 0 } }, /* trentino-sudtirol */
    { .label = {   1129, 24, 0 } }, /* xn--trentino-sdtirol-szb */
    { .label = {   5869, 19, 0 } }, /* trentino-sued-tirol */
    { .label = {   8161, 18, 0 } }, /* trentino-suedtirol */
    { .label = {    465,  8, 0 } }, /* trentino */
    { .label = {  18525, 15, 0 } }, /* trentinoa-adige */
    { .label = {  25428, 14, 0 } }, /* trentinoaadige */
    { .label = {   8237, 18, 0 } }, /* trentinoalto-adige */
    { .label = {  10544, 17, 0 } }, /* trentinoaltoadige */
    { .label = {  18586, 15, 0 } }, /* trentinos-tirol */
    { .label = {  25484, 14, 0 } }, /* trentinostirol */
    { .label = {  10613, 17, 0 } }, /* trentinosud-tirol */
    { .label = {   1238, 24, 0 } }, /* xn--trentinosd-tirol-rzb */
    { .label = {  14007, 16, 0 } }, /* trentinosudtirol */
    { .label = {   1675, 23, 0 } }, /* xn--trentinosdtirol-7vb */
    { .label = {   8311, 18, 0 } }, /* trentinosued-tirol */
    { .label = {  10685, 17, 0 } }, /* trentinosuedtirol */
    { .label = {  14074, 16, 0 } }, /* trentinsud-tirol */
    { .label = {   1783, 23, 0 } }, /* xn--trentinsd-tirol-6vb */
    { .label = {  18648, 15, 0 } }, /* trentinsudtirol */
    { .label = {   2090, 22, 0 } }, /* xn--trentinsdtirol-nsb */
    { .label = {  10756, 17, 0 } }, /* trentinsued-tirol */
    { .label = {  14142, 16, 0 } }, /* trentinsuedtirol */
    { .label = { 120873,  7, 0 } }, /* tuscany */
    { .label = {  19812,  3, 0 } }, /* umb */
    { .label = { 141560,  6, 0 } }, /* umbria */
    { .label = {  52882, 11, 0 } }, /* val-d-aosta */
    { .label = {  68126, 10, 0 } }, /* val-daosta */
    { .label = {  68168, 10, 0 } }, /* vald-aosta */
    { .label = {  81914,  9, 0 } }, /* valdaosta */
    { .label = {  52929, 11, 0 } }, /* valle-aosta */
    { .label = {  32805, 13, 0 } }, /* valle-d-aosta */
    { .label = {  41102, 12, 0 } }, /* valle-daosta */
    { .label = {  68210, 10, 0 } }, /* valleaosta */
    { .label = {  41153, 12, 0 } }, /* valled-aosta */
    { .label = {  52975, 11, 0 } }, /* valledaosta */
    { .label = {  41204, 12, 0 } }, /* vallee-aoste */
    { .label = {   5950, 19, 0 } }, /* xn--valle-aoste-ebb */
    { .label = {  25541, 14, 0 } }, /* vallee-d-aoste */
    { .label = {   2905, 21, 0 } }, /* xn--valle-d-aoste-ehb */
    { .label = {  53021, 11, 0 } }, /* valleeaoste */
    { .label = {   8387, 18, 0 } }, /* xn--valleaoste-e7a */
    { .label = {  41255, 12, 0 } }, /* valleedaoste */
    { .label = {   6038, 19, 0 } }, /* xn--valledaoste-ebb */
    { .label = {  41597,  3, 0 } }, /* vao */
    { .label = {  36168,  3, 0 } }, /* vda */
    { .label = {   2842,  3, 0 } }, /* ven */
    { .label = { 141587,  6, 0 } }, /* veneto */
    { .label = {   1383,  2, 0 } }, /* ag */
    { .label = {  81951,  9, 0 } }, /* agrigento */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {  53067, 11, 0 } }, /* alessandria */
    { .label = {   5827, 10, 0 } }, /* alto-adige */
    { .label = {   8047,  9, 0 } }, /* altoadige */
    { .label = {    227,  2, 0 } }, /* an */
    { .label = { 141613,  6, 0 } }, /* ancona */
    { .label = {   3002, 21, 0 } }, /* andria-barletta-trani */
    { .label = {   3087, 21, 0 } }, /* andria-trani-barletta */
    { .label = {   6126, 19, 0 } }, /* andriabarlettatrani */
    { .label = {   6201, 19, 0 } }, /* andriatranibarletta */
    { .label = {   1422,  2, 0 } }, /* ao */
    { .label = {  32843,  5, 0 } }, /* aosta */
    { .label = {   2963,  5, 0 } }, /* aoste */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {   1428,  2, 0 } }, /* aq */
    { .label = { 121296,  6, 0 } }, /* aquila */
    { .label = {     45,  2, 0 } }, /* ar */
    { .label = { 141636,  6, 0 } }, /* arezzo */
    { .label = {  32861, 13, 0 } }, /* ascoli-piceno */
    { .label = {  41306, 12, 0 } }, /* ascolipiceno */
    { .label = {   2051,  4, 0 } }, /* asti */
    { .label = {    160,  2, 0 } }, /* at */
    { .label = {    586,  2, 0 } }, /* av */
    { .label = {  99420,  8, 0 } }, /* avellino */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {  18711, 15, 0 } }, /* balsan-sudtirol */
    { .label = {   2187, 22, 0 } }, /* xn--balsan-sdtirol-nsb */
    { .label = {  14209, 16, 0 } }, /* balsan-suedtirol */
    { .label = {   2207,  6, 0 } }, /* balsan */
    { .label = {  36939,  4, 0 } }, /* bari */
    { .label = {   3172, 21, 0 } }, /* barletta-trani-andria */
    { .label = {   6149, 19, 0 } }, /* barlettatraniandria */
    { .label = { 120904,  7, 0 } }, /* belluno */
    { .label = {  81988,  9, 0 } }, /* benevento */
    { .label = { 120937,  7, 0 } }, /* bergamo */
    { .label = {   5497,  2, 0 } }, /* bg */
    { .label = {    245,  2, 0 } }, /* bi */
    { .label = { 141665,  6, 0 } }, /* biella */
    { .label = {     95,  2, 0 } }, /* bl */
    { .label = {    716,  2, 0 } }, /* bn */
    { .label = {   2883,  2, 0 } }, /* bo */
    { .label = { 120968,  7, 0 } }, /* bologna */
    { .label = {  10828, 17, 0 } }, /* bolzano-altoadige */
    { .label = {  10828,  7, 0 } }, /* bolzano */
    { .label = {  25602, 14, 0 } }, /* bozen-sudtirol */
    { .label = {   3257, 21, 0 } }, /* xn--bozen-sdtirol-2ob */
    { .label = {  18776, 15, 0 } }, /* bozen-suedtirol */
    { .label = {   3277,  5, 0 } }, /* bozen */
    { .label = {    294,  2, 0 } }, /* br */
    { .label = { 120999,  7, 0 } }, /* brescia */
    { .label = {  99455,  8, 0 } }, /* brindisi */
    { .label = {    693,  2, 0 } }, /* bs */
    { .label = {   4002,  2, 0 } }, /* bt */
    { .label = {  18845, 15, 0 } }, /* bulsan-sudtirol */
    { .label = {   2286, 22, 0 } }, /* xn--bulsan-sdtirol-nsb */
    { .label = {  14278, 16, 0 } }, /* bulsan-suedtirol */
    { .label = {   2306,  6, 0 } }, /* bulsan */
    { .label = {   9077,  2, 0 } }, /* bz */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {  99490,  8, 0 } }, /* cagliari */
    { .label = {  32918, 13, 0 } }, /* caltanissetta */
    { .label = {  18912, 15, 0 } }, /* campidano-medio */
    { .label = {  25667, 14, 0 } }, /* campidanomedio */
    { .label = {  68251, 10, 0 } }, /* campobasso */
    { .label = {  10903, 17, 0 } }, /* carbonia-iglesias */
    { .label = {  14349, 16, 0 } }, /* carboniaiglesias */
    { .label = {  32969, 13, 0 } }, /* carrara-massa */
    { .label = {  41358, 12, 0 } }, /* carraramassa */
    { .label = { 121029,  7, 0 } }, /* caserta */
    { .label = { 121056,  7, 0 } }, /* catania */
    { .label = {  82028,  9, 0 } }, /* catanzaro */
    { .label = {     57,  2, 0 } }, /* cb */
    { .label = {    315,  2, 0 } }, /* ce */
    { .label = {  41403, 12, 0 } }, /* cesena-forli */
    { .label = {   6276, 19, 0 } }, /* xn--cesena-forl-mcb */
    { .label = {  53110, 11, 0 } }, /* cesenaforli */
    { .label = {   8470, 18, 0 } }, /* xn--cesenaforl-i8a */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = { 141692,  6, 0 } }, /* chieti */
    { .label = {    471,  2, 0 } }, /* ci */
    { .label = {   2620,  2, 0 } }, /* cl */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  92865,  4, 0 } }, /* como */
    { .label = { 121082,  7, 0 } }, /* cosenza */
    { .label = {   1284,  2, 0 } }, /* cr */
    { .label = { 121113,  7, 0 } }, /* cremona */
    { .label = { 119210,  7, 0 } }, /* crotone */
    { .label = {    644,  2, 0 } }, /* cs */
    { .label = {   1982,  2, 0 } }, /* ct */
    { .label = { 158027,  5, 0 } }, /* cuneo */
    { .label = {   5585,  2, 0 } }, /* cz */
    { .label = {  25728, 14, 0 } }, /* dell-ogliastra */
    { .label = {  33019, 13, 0 } }, /* dellogliastra */
    { .label = {    226,  2, 0 } }, /* en */
    { .label = {   2783,  4, 0 } }, /* enna */
    { .label = {   6438,  2, 0 } }, /* fc */
    { .label = {    467,  2, 0 } }, /* fe */
    { .label = { 158049,  5, 0 } }, /* fermo */
    { .label = { 121142,  7, 0 } }, /* ferrara */
    { .label = {    331,  2, 0 } }, /* fg */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = { 121170,  7, 0 } }, /* firenze */
    { .label = {  99523,  8, 0 } }, /* florence */
    { .label = {   3284,  2, 0 } }, /* fm */
    { .label = { 141718,  6, 0 } }, /* foggia */
    { .label = {  41455, 12, 0 } }, /* forli-cesena */
    { .label = {   6365, 19, 0 } }, /* xn--forl-cesena-fcb */
    { .label = {  53157, 11, 0 } }, /* forlicesena */
    { .label = {   8554, 18, 0 } }, /* xn--forlcesena-c8a */
    { .label = {    298,  2, 0 } }, /* fr */
    { .label = {  82065,  9, 0 } }, /* frosinone */
    { .label = {    267,  2, 0 } }, /* ge */
    { .label = { 158072,  5, 0 } }, /* genoa */
    { .label = { 141745,  6, 0 } }, /* genova */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 121203,  7, 0 } }, /* gorizia */
    { .label = {   2701,  2, 0 } }, /* gr */
    { .label = {  99559,  8, 0 } }, /* grosseto */
    { .label = {  10974, 17, 0 } }, /* iglesias-carbonia */
    { .label = {  14415, 16, 0 } }, /* iglesiascarbonia */
    { .label = {   3011,  2, 0 } }, /* im */
    { .label = { 121234,  7, 0 } }, /* imperia */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = { 121264,  7, 0 } }, /* isernia */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = {  82103,  9, 0 } }, /* la-spezia */
    { .label = { 121291,  7, 0 } }, /* laquila */
    { .label = {  99592,  8, 0 } }, /* laspezia */
    { .label = { 141771,  6, 0 } }, /* latina */
    { .label = {    101,  2, 0 } }, /* lc */
    { .label = {     97,  2, 0 } }, /* le */
    { .label = { 122311,  5, 0 } }, /* lecce */
    { .label = {  93195,  5, 0 } }, /* lecco */
    { .label = {   2828,  2, 0 } }, /* li */
    { .label = { 121324,  7, 0 } }, /* livorno */
    { .label = {   2308,  2, 0 } }, /* lo */
    { .label = { 111566,  4, 0 } }, /* lodi */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = {   2993,  2, 0 } }, /* lu */
    { .label = { 158092,  5, 0 } }, /* lucca */
    { .label = {  99628,  8, 0 } }, /* macerata */
    { .label = { 121355,  7, 0 } }, /* mantova */
    { .label = {  33074, 13, 0 } }, /* massa-carrara */
    { .label = {  41507, 12, 0 } }, /* massacarrara */
    { .label = { 141794,  6, 0 } }, /* matera */
    { .label = {   5492,  2, 0 } }, /* mb */
    { .label = {   4196,  2, 0 } }, /* mc */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  18978, 15, 0 } }, /* medio-campidano */
    { .label = {  25788, 14, 0 } }, /* mediocampidano */
    { .label = { 121384,  7, 0 } }, /* messina */
    { .label = {    290,  2, 0 } }, /* mi */
    { .label = { 141817,  5, 0 } }, /* milan */
    { .label = { 141817,  6, 0 } }, /* milano */
    { .label = {    571,  2, 0 } }, /* mn */
    { .label = {   3360,  2, 0 } }, /* mo */
    { .label = { 141842,  6, 0 } }, /* modena */
    { .label = {  33124, 13, 0 } }, /* monza-brianza */
    { .label = {   3360, 21, 0 } }, /* monza-e-della-brianza */
    { .label = {   3360,  5, 0 } }, /* monza */
    { .label = {  41552, 12, 0 } }, /* monzabrianza */
    { .label = {  33183, 13, 0 } }, /* monzaebrianza */
    { .label = {   8639, 18, 0 } }, /* monzaedellabrianza */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {     87,  2, 0 } }, /* na */
    { .label = { 141867,  6, 0 } }, /* naples */
    { .label = {  43999,  6, 0 } }, /* napoli */
    { .label = {    188,  2, 0 } }, /* no */
    { .label = { 141893,  6, 0 } }, /* novara */
    { .label = {   1501,  2, 0 } }, /* nu */
    { .label = { 158115,  5, 0 } }, /* nuoro */
    { .label = {   1288,  2, 0 } }, /* og */
    { .label = {  25752,  9, 0 } }, /* ogliastra */
    { .label = {  41606, 12, 0 } }, /* olbia-tempio */
    { .label = {  53204, 11, 0 } }, /* olbiatempio */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  99659,  8, 0 } }, /* oristano */
    { .label = {    636,  2, 0 } }, /* ot */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = { 141917,  6, 0 } }, /* padova */
    { .label = { 158136,  5, 0 } }, /* padua */
    { .label = { 121412,  7, 0 } }, /* palermo */
    { .label = { 158158,  5, 0 } }, /* parma */
    { .label = { 158179,  5, 0 } }, /* pavia */
    { .label = {   1999,  2, 0 } }, /* pc */
    { .label = {   2712,  2, 0 } }, /* pd */
    { .label = {   5389,  2, 0 } }, /* pe */
    { .label = { 121443,  7, 0 } }, /* perugia */
    { .label = {  33241, 13, 0 } }, /* pesaro-urbino */
    { .label = {  41660, 12, 0 } }, /* pesarourbino */
    { .label = { 121474,  7, 0 } }, /* pescara */
    { .label = {   4615,  2, 0 } }, /* pg */
    { .label = {    470,  2, 0 } }, /* pi */
    { .label = {  99690,  8, 0 } }, /* piacenza */
    { .label = { 123637,  4, 0 } }, /* pisa */
    { .label = { 121503,  7, 0 } }, /* pistoia */
    { .label = {   2853,  2, 0 } }, /* pn */
    { .label = {     41,  2, 0 } }, /* po */
    { .label = {  82144,  9, 0 } }, /* pordenone */
    { .label = { 121532,  7, 0 } }, /* potenza */
    { .label = {   1283,  2, 0 } }, /* pr */
    { .label = { 158201,  5, 0 } }, /* prato */
    { .label = {   1981,  2, 0 } }, /* pt */
    { .label = {  10104,  2, 0 } }, /* pu */
    { .label = {   6328,  2, 0 } }, /* pv */
    { .label = {   5584,  2, 0 } }, /* pz */
    { .label = {     70,  2, 0 } }, /* ra */
    { .label = { 141944,  6, 0 } }, /* ragusa */
    { .label = { 121564,  7, 0 } }, /* ravenna */
    { .label = {    178,  2, 0 } }, /* rc */
    { .label = {     55,  2, 0 } }, /* re */
    { .label = {  19044, 15, 0 } }, /* reggio-calabria */
    { .label = {  33298, 13, 0 } }, /* reggio-emilia */
    { .label = {  25849, 14, 0 } }, /* reggiocalabria */
    { .label = {  41712, 12, 0 } }, /* reggioemilia */
    { .label = {    213,  2, 0 } }, /* rg */
    { .label = {    393,  2, 0 } }, /* ri */
    { .label = { 145303,  5, 0 } }, /* rieti */
    { .label = { 141968,  6, 0 } }, /* rimini */
    { .label = {   1115,  2, 0 } }, /* rm */
    { .label = {    157,  2, 0 } }, /* rn */
    { .label = {     17,  2, 0 } }, /* ro */
    { .label = {  23135,  4, 0 } }, /* roma */
    { .label = {  57386,  4, 0 } }, /* rome */
    { .label = { 141993,  6, 0 } }, /* rovigo */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = { 121592,  7, 0 } }, /* salerno */
    { .label = { 121620,  7, 0 } }, /* sassari */
    { .label = { 142020,  6, 0 } }, /* savona */
    { .label = {    699,  2, 0 } }, /* si */
    { .label = { 158222,  5, 0 } }, /* siena */
    { .label = {  99726,  8, 0 } }, /* siracusa */
    { .label = {    131,  2, 0 } }, /* so */
    { .label = { 121646,  7, 0 } }, /* sondrio */
    { .label = {     52,  2, 0 } }, /* sp */
    { .label = {      2,  2, 0 } }, /* sr */
    { .label = {    301,  2, 0 } }, /* ss */
    { .label = {   8198,  9, 0 } }, /* suedtirol */
    { .label = {  19108, 15, 0 } }, /* xn--sdtirol-n2a */
    { .label = {    743,  2, 0 } }, /* sv */
    { .label = {    314,  2, 0 } }, /* ta */
    { .label = { 121675,  7, 0 } }, /* taranto */
    { .label = {     89,  2, 0 } }, /* te */
    { .label = {  41763, 12, 0 } }, /* tempio-olbia */
    { .label = {  53253, 11, 0 } }, /* tempioolbia */
    { .label = { 142044,  6, 0 } }, /* teramo */
    { .label = { 158241,  5, 0 } }, /* terni */
    { .label = {    700,  2, 0 } }, /* tn */
    { .label = {   1538,  2, 0 } }, /* to */
    { .label = { 142068,  6, 0 } }, /* torino */
    { .label = {   5536,  2, 0 } }, /* tp */
    { .label = {    163,  2, 0 } }, /* tr */
    { .label = {   3455, 21, 0 } }, /* trani-andria-barletta */
    { .label = {   3540, 21, 0 } }, /* trani-barletta-andria */
    { .label = {   6455, 19, 0 } }, /* traniandriabarletta */
    { .label = {   6530, 19, 0 } }, /* tranibarlettaandria */
    { .label = { 121701,  7, 0 } }, /* trapani */
    { .label = { 142092,  6, 0 } }, /* trento */
    { .label = { 121729,  7, 0 } }, /* treviso */
    { .label = { 121759,  7, 0 } }, /* trieste */
    { .label = {    338,  2, 0 } }, /* ts */
    { .label = { 158261,  5, 0 } }, /* turin */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {   3931,  2, 0 } }, /* ud */
    { .label = { 158282,  5, 0 } }, /* udine */
    { .label = {  33354, 13, 0 } }, /* urbino-pesaro */
    { .label = {  41817, 12, 0 } }, /* urbinopesaro */
    { .label = {     54,  2, 0 } }, /* va */
    { .label = { 142116,  6, 0 } }, /* varese */
    { .label = {   1117,  2, 0 } }, /* vb */
    { .label = {   3371,  2, 0 } }, /* vc */
    { .label = {   1367,  2, 0 } }, /* ve */
    { .label = {   2842,  7, 0 } }, /* venezia */
    { .label = { 142141,  6, 0 } }, /* venice */
    { .label = {  99758,  8, 0 } }, /* verbania */
    { .label = {  99792,  8, 0 } }, /* vercelli */
    { .label = { 142168,  6, 0 } }, /* verona */
    { .label = {    569,  2, 0 } }, /* vi */
    { .label = {  33411, 13, 0 } }, /* vibo-valentia */
    { .label = {  41869, 12, 0 } }, /* vibovalentia */
    { .label = { 121787,  7, 0 } }, /* vicenza */
    { .label = { 121820,  7, 0 } }, /* viterbo */
    { .label = {   2710,  2, 0 } }, /* vr */
    { .label = {    156,  2, 0 } }, /* vs */
    { .label = {   2412,  2, 0 } }, /* vt */
    { .label = {   9514,  2, 0 } }, /* vv */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 170887,  4, 0 } }, /* 16-b */
    { .label = { 170915,  4, 0 } }, /* 32-b */
    { .label = { 170942,  4, 0 } }, /* 64-b */
    { .label = { 119529,  8, 0 } }, /* syncloud */

    /* entries 4084 to 4086 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 4087 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 4088 to 4095 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  29770,  4, 0 } }, /* name */

    /* entries 4096 to 4262 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    124,  2, 0 } }, /* ad */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   2701,  2, 0 } }, /* gr */
    { .label = {   2037,  2, 0 } }, /* lg */
    { .label = {     40,  2, 1 } }, { .child = { 4263, 1 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  26449,  5, 1 } }, { .child = { 4264, 52 } }, /* aichi */
    { .label = {  26332,  5, 1 } }, { .child = { 4316, 28 } }, /* akita */
    { .label = {  86844,  6, 1 } }, { .child = { 4344, 22 } }, /* aomori */
    { .label = {  69474,  5, 1 } }, { .child = { 4366, 58 } }, /* chiba */
    { .label = { 144582,  5, 1 } }, { .child = { 4424, 22 } }, /* ehime */
    { .label = { 158304,  5, 1 } }, { .child = { 4446, 15 } }, /* fukui */
    { .label = { 121852,  7, 1 } }, { .child = { 4461, 63 } }, /* fukuoka */
    { .label = {  34279,  9, 1 } }, { .child = { 4524, 51 } }, /* fukushima */
    { .label = {  82819,  4, 1 } }, { .child = { 4575, 38 } }, /* gifu */
    { .label = { 158329,  5, 1 } }, { .child = { 4613, 36 } }, /* gunma */
    { .label = {  14578,  9, 1 } }, { .child = { 4649, 25 } }, /* hiroshima */
    { .label = {  99829,  8, 1 } }, { .child = { 4674, 142 } }, /* hokkaido */
    { .label = { 158351,  5, 1 } }, { .child = { 4816, 46 } }, /* hyogo */
    { .label = { 121885,  7, 1 } }, { .child = { 4862, 51 } }, /* ibaraki */
    { .label = {  87582,  8, 1 } }, { .child = { 4913, 19 } }, /* ishikawa */
    { .label = {  20472,  5, 1 } }, { .child = { 4932, 34 } }, /* iwate */
    { .label = {  34072,  6, 1 } }, { .child = { 4966, 15 } }, /* kagawa */
    { .label = {  82183,  9, 1 } }, { .child = { 4981, 20 } }, /* kagoshima */
    { .label = {  99864,  8, 1 } }, { .child = { 5001, 30 } }, /* kanagawa */
    { .label = { 158375,  5, 1 } }, { .child = { 5031, 31 } }, /* kochi */
    { .label = {  99896,  8, 1 } }, { .child = { 5062, 23 } }, /* kumamoto */
    { .label = { 158398,  5, 1 } }, { .child = { 5085, 31 } }, /* kyoto */
    { .label = {   3787,  3, 1 } }, { .child = { 5116, 30 } }, /* mie */
    { .label = { 142193,  6, 1 } }, { .child = { 5146, 32 } }, /* miyagi */
    { .label = {  99931,  8, 1 } }, { .child = { 5178, 27 } }, /* miyazaki */
    { .label = {  34407,  6, 1 } }, { .child = { 5205, 75 } }, /* nagano */
    { .label = {  99968,  8, 1 } }, { .child = { 5280, 22 } }, /* nagasaki */
    { .label = {   8120,  4, 1 } }, { .child = { 5302, 38 } }, /* nara */
    { .label = { 121914,  7, 1 } }, { .child = { 5340, 34 } }, /* niigata */
    { .label = {  72442,  4, 1 } }, { .child = { 5374, 19 } }, /* oita */
    { .label = { 107568,  7, 1 } }, { .child = { 5393, 26 } }, /* okayama */
    { .label = { 121941,  7, 1 } }, { .child = { 5419, 42 } }, /* okinawa */
    { .label = {  43032,  5, 1 } }, { .child = { 5461, 50 } }, /* osaka */
    { .label = {  47952,  4, 1 } }, { .child = { 5511, 26 } }, /* saga */
    { .label = { 121970,  7, 1 } }, { .child = { 5537, 69 } }, /* saitama */
    { .label = {  26187,  5, 1 } }, { .child = { 5606, 23 } }, /* shiga */
    { .label = { 121996,  7, 1 } }, { .child = { 5629, 23 } }, /* shimane */
    { .label = {  99999,  8, 1 } }, { .child = { 5652, 36 } }, /* shizuoka */
    { .label = { 122025,  7, 1 } }, { .child = { 5688, 31 } }, /* tochigi */
    { .label = {  82221,  9, 1 } }, { .child = { 5719, 17 } }, /* tokushima */
    { .label = { 158421,  5, 1 } }, { .child = { 5736, 57 } }, /* tokyo */
    { .label = { 122056,  7, 1 } }, { .child = { 5793, 13 } }, /* tottori */
    { .label = {  14730,  6, 1 } }, { .child = { 5806, 24 } }, /* toyama */
    { .label = { 100036,  8, 1 } }, { .child = { 5830, 29 } }, /* wakayama */
    { .label = { 100070,  8, 1 } }, { .child = { 5859, 34 } }, /* yamagata */
    { .label = {  82260,  9, 1 } }, { .child = { 5893, 16 } }, /* yamaguchi */
    { .label = {  82301,  9, 1 } }, { .child = { 5909, 28 } }, /* yamanashi */
    { .label = {  82338,  9, 0 } }, /* xn--4pvxs */
    { .label = {  53302, 11, 0 } }, /* xn--vgu402c */
    { .label = {  68295, 10, 0 } }, /* xn--c3s14m */
    { .label = {  53368, 11, 0 } }, /* xn--f6qx53a */
    { .label = {  68354, 10, 0 } }, /* xn--8pvr4u */
    { .label = {  53437, 11, 0 } }, /* xn--uist22h */
    { .label = {  25908, 14, 0 } }, /* xn--djrs72d6uy */
    { .label = {  53495, 11, 0 } }, /* xn--mkru45i */
    { .label = {  33469, 13, 0 } }, /* xn--0trq7p7nn */
    { .label = {  53556, 11, 0 } }, /* xn--8ltr62k */
    { .label = {  53620, 11, 0 } }, /* xn--2m4a15e */
    { .label = {  68413, 10, 0 } }, /* xn--efvn9s */
    { .label = {  53686, 11, 0 } }, /* xn--32vp30h */
    { .label = {  53755, 11, 0 } }, /* xn--4it797k */
    { .label = {  53825, 11, 0 } }, /* xn--1lqs71d */
    { .label = {  53892, 11, 0 } }, /* xn--5rtp49c */
    { .label = {  53959, 11, 0 } }, /* xn--5js045d */
    { .label = {  54030, 11, 0 } }, /* xn--ehqz56n */
    { .label = {  54096, 11, 0 } }, /* xn--1lqs03n */
    { .label = {  54161, 11, 0 } }, /* xn--qqqt11m */
    { .label = {  68467, 10, 0 } }, /* xn--kbrq7o */
    { .label = {  54230, 11, 0 } }, /* xn--pssu33l */
    { .label = {  54290, 11, 0 } }, /* xn--ntsq17g */
    { .label = {  68523, 10, 0 } }, /* xn--uisz3g */
    { .label = {  68576, 10, 0 } }, /* xn--6btw5a */
    { .label = {  82389,  9, 0 } }, /* xn--1ctwo */
    { .label = {  68633, 10, 0 } }, /* xn--6orx2r */
    { .label = {  68688, 10, 0 } }, /* xn--rht61e */
    { .label = {  68742, 10, 0 } }, /* xn--rht27z */
    { .label = {  68799, 10, 0 } }, /* xn--djty4k */
    { .label = {  54352, 11, 0 } }, /* xn--nit225k */
    { .label = {  82436,  9, 0 } }, /* xn--rht3d */
    { .label = {  68855, 10, 0 } }, /* xn--klty5x */
    { .label = {  68910, 10, 0 } }, /* xn--kltx9a */
    { .label = {  68963, 10, 0 } }, /* xn--kltp7d */
    { .label = {  54414, 11, 0 } }, /* xn--uuwu58a */
    { .label = {  54476, 11, 0 } }, /* xn--zbx025d */
    { .label = {  25990, 14, 0 } }, /* xn--ntso0iqx3a */
    { .label = {  54545, 11, 0 } }, /* xn--elqq16h */
    { .label = {  54612, 11, 0 } }, /* xn--4it168d */
    { .label = {  54680, 11, 0 } }, /* xn--klt787d */
    { .label = {  69017, 10, 0 } }, /* xn--rny31h */
    { .label = {  41922, 12, 0 } }, /* xn--7t0a264c */
    { .label = {  54746, 11, 0 } }, /* xn--5rtq34k */
    { .label = {  54813, 11, 0 } }, /* xn--k7yn95e */
    { .label = {  54880, 11, 0 } }, /* xn--tor131o */
    { .label = {  26063, 14, 0 } }, /* xn--d5qv7z876c */
    { .label = { 100102,  8, 1 } }, { .child = { 5937, 2 } }, /* kawasaki */
    { .label = {  69072, 10, 1 } }, { .child = { 5941, 2 } }, /* kitakyushu */
    { .label = {  51408,  4, 1 } }, { .child = { 5945, 2 } }, /* kobe */
    { .label = { 142220,  6, 1 } }, { .child = { 5949, 2 } }, /* nagoya */
    { .label = { 122084,  7, 1 } }, { .child = { 5953, 2 } }, /* sapporo */
    { .label = {  34125,  6, 1 } }, { .child = { 5957, 2 } }, /* sendai */
    { .label = { 100135,  8, 1 } }, { .child = { 5961, 2 } }, /* yokohama */
    { .label = {  13237, 11, 0 } }, /* usercontent */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entry 4263 */
    { .label = { 156514,  6, 0 } }, /* gehirn */

    /* entries 4264 to 4315 */
    { .label = { 123072,  5, 0 } }, /* aisai */
    { .label = {  11299,  3, 0 } }, /* ama */
    { .label = {  89902,  4, 0 } }, /* anjo */
    { .label = { 158444,  5, 0 } }, /* asuke */
    { .label = { 142245,  6, 0 } }, /* chiryu */
    { .label = { 101910,  5, 0 } }, /* chita */
    { .label = { 167919,  4, 0 } }, /* fuso */
    { .label = { 100170,  8, 0 } }, /* gamagori */
    { .label = { 158465,  5, 0 } }, /* handa */
    { .label = { 167938,  4, 0 } }, /* hazu */
    { .label = { 122115,  7, 0 } }, /* hekinan */
    { .label = {  69118, 10, 0 } }, /* higashiura */
    { .label = {  69160, 10, 0 } }, /* ichinomiya */
    { .label = { 122144,  7, 0 } }, /* inazawa */
    { .label = { 122174,  7, 0 } }, /* inuyama */
    { .label = { 122204,  7, 0 } }, /* isshiki */
    { .label = { 122234,  7, 0 } }, /* iwakura */
    { .label = { 158485,  5, 0 } }, /* kanie */
    { .label = { 142274,  6, 0 } }, /* kariya */
    { .label = { 122264,  7, 0 } }, /* kasugai */
    { .label = { 157839,  4, 0 } }, /* kira */
    { .label = { 142299,  6, 0 } }, /* kiyosu */
    { .label = { 142327,  6, 0 } }, /* komaki */
    { .label = { 158505,  5, 0 } }, /* konan */
    { .label = { 102631,  4, 0 } }, /* kota */
    { .label = { 105980,  6, 0 } }, /* mihama */
    { .label = {  14655,  7, 0 } }, /* miyoshi */
    { .label = {  55322,  6, 0 } }, /* nishio */
    { .label = { 122293,  7, 0 } }, /* nisshin */
    { .label = {  13227,  3, 0 } }, /* obu */
    { .label = { 142353,  6, 0 } }, /* oguchi */
    { .label = { 158525,  5, 0 } }, /* oharu */
    { .label = { 122322,  7, 0 } }, /* okazaki */
    { .label = {  69204, 10, 0 } }, /* owariasahi */
    { .label = {  46423,  4, 0 } }, /* seto */
    { .label = {  43366,  8, 0 } }, /* shikatsu */
    { .label = {  82482,  9, 0 } }, /* shinshiro */
    { .label = { 122353,  7, 0 } }, /* shitara */
    { .label = {  42072,  6, 0 } }, /* tahara */
    { .label = { 100203,  8, 0 } }, /* takahama */
    { .label = {  82520,  9, 0 } }, /* tobishima */
    { .label = { 167958,  4, 0 } }, /* toei */
    { .label = { 167974,  4, 0 } }, /* togo */
    { .label = {  55140,  5, 0 } }, /* tokai */
    { .label = { 100234,  8, 0 } }, /* tokoname */
    { .label = { 122380,  7, 0 } }, /* toyoake */
    { .label = {  82559,  9, 0 } }, /* toyohashi */
    { .label = { 100267,  8, 0 } }, /* toyokawa */
    { .label = { 142381,  6, 0 } }, /* toyone */
    { .label = { 142407,  6, 0 } }, /* toyota */
    { .label = {  11083,  8, 0 } }, /* tsushima */
    { .label = { 142432,  6, 0 } }, /* yatomi */

    /* entries 4316 to 4343 */
    { .label = {  26332,  5, 0 } }, /* akita */
    { .label = { 142458,  6, 0 } }, /* daisen */
    { .label = { 100302,  8, 0 } }, /* fujisato */
    { .label = { 142482,  6, 0 } }, /* gojome */
    { .label = {  54940, 11, 0 } }, /* hachirogata */
    { .label = { 142511,  6, 0 } }, /* happou */
    { .label = {  33545, 13, 0 } }, /* higashinaruse */
    { .label = {  82729,  5, 0 } }, /* honjo */
    { .label = { 142540,  6, 0 } }, /* honjyo */
    { .label = {  19650,  5, 0 } }, /* ikawa */
    { .label = {  82598,  9, 0 } }, /* kamikoani */
    { .label = { 122410,  7, 0 } }, /* kamioka */
    { .label = { 100339,  8, 0 } }, /* katagami */
    { .label = { 142570,  6, 0 } }, /* kazuno */
    { .label = {  82635,  9, 0 } }, /* kitaakita */
    { .label = { 142598,  6, 0 } }, /* kosaka */
    { .label = { 158546,  5, 0 } }, /* kyowa */
    { .label = {  26487,  6, 0 } }, /* misato */
    { .label = {  70184,  6, 0 } }, /* mitane */
    { .label = {  82670,  9, 0 } }, /* moriyoshi */
    { .label = { 142622,  6, 0 } }, /* nikaho */
    { .label = { 122439,  7, 0 } }, /* noshiro */
    { .label = {  84546,  5, 0 } }, /* odate */
    { .label = {  13180,  3, 0 } }, /* oga */
    { .label = {  54966,  5, 0 } }, /* ogata */
    { .label = { 122468,  7, 0 } }, /* semboku */
    { .label = { 142647,  6, 0 } }, /* yokote */
    { .label = {  82710,  9, 0 } }, /* yurihonjo */

    /* entries 4344 to 4365 */
    { .label = {  86844,  6, 0 } }, /* aomori */
    { .label = { 142674,  6, 0 } }, /* gonohe */
    { .label = {  82753,  9, 0 } }, /* hachinohe */
    { .label = {  82577,  9, 0 } }, /* hashikami */
    { .label = { 122501,  7, 0 } }, /* hiranai */
    { .label = { 100371,  8, 0 } }, /* hirosaki */
    { .label = {  82792,  9, 0 } }, /* itayanagi */
    { .label = { 100404,  8, 0 } }, /* kuroishi */
    { .label = { 142700,  6, 0 } }, /* misawa */
    { .label = {  82868,  5, 0 } }, /* mutsu */
    { .label = {  69244, 10, 0 } }, /* nakadomari */
    { .label = { 142725,  6, 0 } }, /* noheji */
    { .label = { 142753,  6, 0 } }, /* oirase */
    { .label = { 158570,  5, 0 } }, /* owani */
    { .label = { 100439,  8, 0 } }, /* rokunohe */
    { .label = { 122528,  7, 0 } }, /* sannohe */
    { .label = {  69284, 10, 0 } }, /* shichinohe */
    { .label = { 142776,  6, 0 } }, /* shingo */
    { .label = { 158591,  5, 0 } }, /* takko */
    { .label = { 142802,  6, 0 } }, /* towada */
    { .label = { 122556,  7, 0 } }, /* tsugaru */
    { .label = { 122586,  7, 0 } }, /* tsuruta */

    /* entries 4366 to 4423 */
    { .label = { 158612,  5, 0 } }, /* abiko */
    { .label = {  69225,  5, 0 } }, /* asahi */
    { .label = { 142827,  6, 0 } }, /* chonan */
    { .label = { 142852,  6, 0 } }, /* chosei */
    { .label = { 142878,  6, 0 } }, /* choshi */
    { .label = {  55017,  4, 0 } }, /* chuo */
    { .label = {  82828,  9, 0 } }, /* funabashi */
    { .label = { 142905,  6, 0 } }, /* futtsu */
    { .label = {  69328, 10, 0 } }, /* hanamigawa */
    { .label = { 100474,  8, 0 } }, /* ichihara */
    { .label = {  26452,  8, 0 } }, /* ichikawa */
    { .label = {  69160, 10, 0 } }, /* ichinomiya */
    { .label = { 158634,  5, 0 } }, /* inzai */
    { .label = {  14642,  5, 0 } }, /* isumi */
    { .label = { 100507,  8, 0 } }, /* kamagaya */
    { .label = { 100540,  8, 0 } }, /* kamogawa */
    { .label = {  55996,  7, 0 } }, /* kashiwa */
    { .label = { 105172,  6, 0 } }, /* katori */
    { .label = {  34564,  8, 0 } }, /* katsuura */
    { .label = { 122615,  7, 0 } }, /* kimitsu */
    { .label = { 100574,  8, 0 } }, /* kisarazu */
    { .label = { 142933,  6, 0 } }, /* kozaki */
    { .label = { 100609,  8, 0 } }, /* kujukuri */
    { .label = { 142961,  6, 0 } }, /* kyonan */
    { .label = { 122646,  7, 0 } }, /* matsudo */
    { .label = { 142987,  6, 0 } }, /* midori */
    { .label = { 105980,  6, 0 } }, /* mihama */
    { .label = {  69369, 10, 0 } }, /* minamiboso */
    { .label = { 143013,  6, 0 } }, /* mobara */
    { .label = {  82868,  9, 0 } }, /* mutsuzawa */
    { .label = { 143038,  6, 0 } }, /* nagara */
    { .label = {  69412, 10, 0 } }, /* nagareyama */
    { .label = {  82910,  9, 0 } }, /* narashino */
    { .label = { 143060,  6, 0 } }, /* narita */
    { .label = {  96948,  4, 0 } }, /* noda */
    { .label = {  33599, 13, 0 } }, /* oamishirasato */
    { .label = { 122676,  7, 0 } }, /* omigawa */
    { .label = { 143082,  6, 0 } }, /* onjuku */
    { .label = { 102718,  5, 0 } }, /* otaki */
    { .label = { 158656,  5, 0 } }, /* sakae */
    { .label = {  69957,  6, 0 } }, /* sakura */
    { .label = {  82945,  9, 0 } }, /* shimofusa */
    { .label = { 122706,  7, 0 } }, /* shirako */
    { .label = {  85136,  6, 0 } }, /* shiroi */
    { .label = { 143112,  6, 0 } }, /* shisui */
    { .label = {  82985,  9, 0 } }, /* sodegaura */
    { .label = { 104501,  4, 0 } }, /* sosa */
    { .label = { 103664,  4, 0 } }, /* tako */
    { .label = { 100649,  8, 0 } }, /* tateyama */
    { .label = { 143138,  6, 0 } }, /* togane */
    { .label = { 100681,  8, 0 } }, /* tohnosho */
    { .label = { 100715,  8, 0 } }, /* tomisato */
    { .label = { 122735,  7, 0 } }, /* urayasu */
    { .label = {  83022,  9, 0 } }, /* yachimata */
    { .label = { 122765,  7, 0 } }, /* yachiyo */
    { .label = {  69452, 10, 0 } }, /* yokaichiba */
    { .label = {  19178, 15, 0 } }, /* yokoshibahikari */
    { .label = {  69497, 10, 0 } }, /* yotsukaido */

    /* entries 4424 to 4445 */
    { .label = { 122126,  5, 0 } }, /* ainan */
    { .label = { 143493,  5, 0 } }, /* honai */
    { .label = {  86907,  5, 0 } }, /* ikata */
    { .label = { 122798,  7, 0 } }, /* imabari */
    { .label = {  14660,  3, 0 } }, /* iyo */
    { .label = {  33842,  8, 0 } }, /* kamijima */
    { .label = { 143162,  6, 0 } }, /* kihoku */
    { .label = {  83060,  9, 0 } }, /* kumakogen */
    { .label = { 143190,  6, 0 } }, /* masaki */
    { .label = { 122827,  7, 0 } }, /* matsuno */
    { .label = {  14717,  9, 0 } }, /* matsuyama */
    { .label = { 100747,  8, 0 } }, /* namikata */
    { .label = { 122856,  7, 0 } }, /* niihama */
    { .label = {  71373,  3, 0 } }, /* ozu */
    { .label = { 158675,  5, 0 } }, /* saijo */
    { .label = { 158697,  5, 0 } }, /* seiyo */
    { .label = {  54985, 11, 0 } }, /* shikokuchuo */
    { .label = {  81980,  4, 0 } }, /* tobe */
    { .label = {  17178,  4, 0 } }, /* toon */
    { .label = {  19676,  6, 0 } }, /* uchiko */
    { .label = { 122884,  7, 0 } }, /* uwajima */
    { .label = {  69541, 10, 0 } }, /* yawatahama */

    /* entries 4446 to 4460 */
    { .label = {  33675,  7, 0 } }, /* echizen */
    { .label = { 122917,  7, 0 } }, /* eiheiji */
    { .label = { 158304,  5, 0 } }, /* fukui */
    { .label = { 158719,  5, 0 } }, /* ikeda */
    { .label = {  83100,  9, 0 } }, /* katsuyama */
    { .label = { 105980,  6, 0 } }, /* mihama */
    { .label = {  33650, 13, 0 } }, /* minamiechizen */
    { .label = { 158740,  5, 0 } }, /* obama */
    { .label = {  19365,  3, 0 } }, /* ohi */
    { .label = {    184,  3, 0 } }, /* ono */
    { .label = { 158761,  5, 0 } }, /* sabae */
    { .label = {  26437,  5, 0 } }, /* sakai */
    { .label = { 100203,  8, 0 } }, /* takahama */
    { .label = {  43102,  7, 0 } }, /* tsuruga */
    { .label = { 143214,  6, 0 } }, /* wakasa */

    /* entries 4461 to 4523 */
    { .label = {  34502,  6, 0 } }, /* ashiya */
    { .label = { 158781,  5, 0 } }, /* buzen */
    { .label = { 122949,  7, 0 } }, /* chikugo */
    { .label = {  85289,  7, 0 } }, /* chikuho */
    { .label = { 122982,  7, 0 } }, /* chikujo */
    { .label = {  69582, 10, 0 } }, /* chikushino */
    { .label = { 100778,  8, 0 } }, /* chikuzen */
    { .label = {  55017,  4, 0 } }, /* chuo */
    { .label = { 123017,  7, 0 } }, /* dazaifu */
    { .label = {  55897,  7, 0 } }, /* fukuchi */
    { .label = { 143238,  6, 0 } }, /* hakata */
    { .label = {  11045,  7, 0 } }, /* higashi */
    { .label = { 100817,  8, 0 } }, /* hirokawa */
    { .label = { 100851,  8, 0 } }, /* hisayama */
    { .label = { 143261,  6, 0 } }, /* iizuka */
    { .label = { 100884,  8, 0 } }, /* inatsuki */
    { .label = { 101521,  4, 0 } }, /* kaho */
    { .label = { 122264,  6, 0 } }, /* kasuga */
    { .label = { 143289,  6, 0 } }, /* kasuya */
    { .label = { 143315,  6, 0 } }, /* kawara */
    { .label = { 143339,  6, 0 } }, /* keisen */
    { .label = {  74281,  4, 0 } }, /* koga */
    { .label = { 143364,  6, 0 } }, /* kurate */
    { .label = { 143389,  6, 0 } }, /* kurogi */
    { .label = {  34460,  6, 0 } }, /* kurume */
    { .label = {  19306,  6, 0 } }, /* minami */
    { .label = {  70460,  6, 0 } }, /* miyako */
    { .label = {  19322,  6, 0 } }, /* miyama */
    { .label = { 100917,  8, 0 } }, /* miyawaka */
    { .label = { 100952,  8, 0 } }, /* mizumaki */
    { .label = { 100990,  8, 0 } }, /* munakata */
    { .label = { 101022,  8, 0 } }, /* nakagawa */
    { .label = { 143416,  6, 0 } }, /* nakama */
    { .label = {  42550,  5, 0 } }, /* nishi */
    { .label = { 143439,  6, 0 } }, /* nogata */
    { .label = { 158807,  5, 0 } }, /* ogori */
    { .label = { 123050,  7, 0 } }, /* okagaki */
    { .label = {  71086,  5, 0 } }, /* okawa */
    { .label = {   7754,  3, 0 } }, /* oki */
    { .label = { 158828,  5, 0 } }, /* omuta */
    { .label = { 127310,  4, 0 } }, /* onga */
    { .label = {  70483,  5, 0 } }, /* onojo */
    { .label = {  13097,  3, 0 } }, /* oto */
    { .label = { 123079,  7, 0 } }, /* saigawa */
    { .label = { 101054,  8, 0 } }, /* sasaguri */
    { .label = { 143462,  6, 0 } }, /* shingu */
    { .label = {  33708, 13, 0 } }, /* shinyoshitomi */
    { .label = { 143489,  6, 0 } }, /* shonai */
    { .label = { 158849,  5, 0 } }, /* soeda */
    { .label = {   5906,  3, 0 } }, /* sue */
    { .label = {  83138,  9, 0 } }, /* tachiarai */
    { .label = { 104163,  6, 0 } }, /* tagawa */
    { .label = {  34020,  6, 0 } }, /* takata */
    { .label = {  83705,  4, 0 } }, /* toho */
    { .label = { 123107,  7, 0 } }, /* toyotsu */
    { .label = { 143513,  6, 0 } }, /* tsuiki */
    { .label = { 158869,  5, 0 } }, /* ukiha */
    { .label = {  14650,  3, 0 } }, /* umi */
    { .label = { 159463,  4, 0 } }, /* usui */
    { .label = { 143539,  6, 0 } }, /* yamada */
    { .label = {  29768,  4, 0 } }, /* yame */
    { .label = { 101086,  8, 0 } }, /* yanagawa */
    { .label = {  83173,  9, 0 } }, /* yukuhashi */

    /* entries 4524 to 4574 */
    { .label = {  83215,  9, 0 } }, /* aizubange */
    { .label = {  69627, 10, 0 } }, /* aizumisato */
    { .label = {  33765, 13, 0 } }, /* aizuwakamatsu */
    { .label = { 123138,  7, 0 } }, /* asakawa */
    { .label = { 143564,  6, 0 } }, /* bandai */
    { .label = {  31483,  4, 0 } }, /* date */
    { .label = {  34279,  9, 0 } }, /* fukushima */
    { .label = { 101119,  8, 0 } }, /* furudono */
    { .label = { 143589,  6, 0 } }, /* futaba */
    { .label = { 143616,  6, 0 } }, /* hanawa */
    { .label = {  11045,  7, 0 } }, /* higashi */
    { .label = {  87659,  6, 0 } }, /* hirata */
    { .label = { 143640,  6, 0 } }, /* hirono */
    { .label = { 143665,  6, 0 } }, /* iitate */
    { .label = {  69670, 10, 0 } }, /* inawashiro */
    { .label = {  87582,  8, 0 } }, /* ishikawa */
    { .label = {  84387,  5, 0 } }, /* iwaki */
    { .label = {  83256,  9, 0 } }, /* izumizaki */
    { .label = {  69711, 10, 0 } }, /* kagamiishi */
    { .label = { 101156,  8, 0 } }, /* kaneyama */
    { .label = { 101189,  8, 0 } }, /* kawamata */
    { .label = { 101221,  8, 0 } }, /* kitakata */
    { .label = {  41997, 12, 0 } }, /* kitashiobara */
    { .label = { 158891,  5, 0 } }, /* koori */
    { .label = {  26301,  8, 0 } }, /* koriyama */
    { .label = { 143688,  6, 0 } }, /* kunimi */
    { .label = { 143715,  6, 0 } }, /* miharu */
    { .label = { 123165,  7, 0 } }, /* mishima */
    { .label = {  33659,  5, 0 } }, /* namie */
    { .label = { 158912,  5, 0 } }, /* nango */
    { .label = {  83300,  9, 0 } }, /* nishiaizu */
    { .label = { 123195,  7, 0 } }, /* nishigo */
    { .label = { 106357,  5, 0 } }, /* okuma */
    { .label = { 123225,  7, 0 } }, /* omotego */
    { .label = {    184,  3, 0 } }, /* ono */
    { .label = { 127051,  5, 0 } }, /* otama */
    { .label = { 101252,  8, 0 } }, /* samegawa */
    { .label = { 123255,  7, 0 } }, /* shimogo */
    { .label = {  14511,  9, 0 } }, /* shirakawa */
    { .label = { 158932,  5, 0 } }, /* showa */
    { .label = { 126854,  4, 0 } }, /* soma */
    { .label = { 101285,  8, 0 } }, /* sukagawa */
    { .label = { 123286,  7, 0 } }, /* taishin */
    { .label = { 101319,  8, 0 } }, /* tamakawa */
    { .label = { 101351,  8, 0 } }, /* tanagura */
    { .label = { 158954,  5, 0 } }, /* tenei */
    { .label = { 143741,  6, 0 } }, /* yabuki */
    { .label = {  26276,  6, 0 } }, /* yamato */
    { .label = {  83340,  9, 0 } }, /* yamatsuri */
    { .label = { 123314,  7, 0 } }, /* yanaizu */
    { .label = { 104119,  6, 0 } }, /* yugawa */

    /* entries 4575 to 4612 */
    { .label = { 123346,  7, 0 } }, /* anpachi */
    { .label = {   2007,  3, 0 } }, /* ena */
    { .label = {  82819,  4, 0 } }, /* gifu */
    { .label = { 158974,  5, 0 } }, /* ginan */
    { .label = { 167991,  4, 0 } }, /* godo */
    { .label = { 168009,  4, 0 } }, /* gujo */
    { .label = { 123376,  7, 0 } }, /* hashima */
    { .label = { 123405,  7, 0 } }, /* hichiso */
    { .label = {  56492,  4, 0 } }, /* hida */
    { .label = {  14481, 16, 0 } }, /* higashishirakawa */
    { .label = { 123436,  7, 0 } }, /* ibigawa */
    { .label = { 158719,  5, 0 } }, /* ikeda */
    { .label = {  42046, 12, 0 } }, /* kakamigahara */
    { .label = {  56372,  4, 0 } }, /* kani */
    { .label = { 101382,  8, 0 } }, /* kasahara */
    { .label = {  83378,  9, 0 } }, /* kasamatsu */
    { .label = { 143770,  6, 0 } }, /* kawaue */
    { .label = { 101412,  8, 0 } }, /* kitagata */
    { .label = {  17083,  4, 0 } }, /* mino */
    { .label = { 101443,  8, 0 } }, /* minokamo */
    { .label = { 105639,  6, 0 } }, /* mitake */
    { .label = { 101477,  8, 0 } }, /* mizunami */
    { .label = { 143796,  6, 0 } }, /* motosu */
    { .label = {  55036, 11, 0 } }, /* nakatsugawa */
    { .label = { 144541,  5, 0 } }, /* ogaki */
    { .label = { 101514,  8, 0 } }, /* sakahogi */
    { .label = {  42109,  4, 0 } }, /* seki */
    { .label = {  69753, 10, 0 } }, /* sekigahara */
    { .label = {  14511,  9, 0 } }, /* shirakawa */
    { .label = { 143822,  6, 0 } }, /* tajimi */
    { .label = { 100038,  8, 0 } }, /* takayama */
    { .label = { 158994,  5, 0 } }, /* tarui */
    { .label = {  83532,  4, 0 } }, /* toki */
    { .label = { 143849,  6, 0 } }, /* tomika */
    { .label = { 101547,  8, 0 } }, /* wanouchi */
    { .label = { 100070,  8, 0 } }, /* yamagata */
    { .label = { 143874,  6, 0 } }, /* yaotsu */
    { .label = { 144315,  4, 0 } }, /* yoro */

    /* entries 4613 to 4648 */
    { .label = { 143900,  6, 0 } }, /* annaka */
    { .label = { 123467,  7, 0 } }, /* chiyoda */
    { .label = { 123499,  7, 0 } }, /* fujioka */
    { .label = {  19244, 15, 0 } }, /* higashiagatsuma */
    { .label = { 123533,  7, 0 } }, /* isesaki */
    { .label = { 123561,  7, 0 } }, /* itakura */
    { .label = { 126713,  5, 0 } }, /* kanna */
    { .label = { 159014,  5, 0 } }, /* kanra */
    { .label = {  83414,  9, 0 } }, /* katashina */
    { .label = { 143922,  6, 0 } }, /* kawaba */
    { .label = { 159033,  5, 0 } }, /* kiryu */
    { .label = { 123589,  7, 0 } }, /* kusatsu */
    { .label = { 101583,  8, 0 } }, /* maebashi */
    { .label = { 159057,  5, 0 } }, /* meiwa */
    { .label = { 142987,  6, 0 } }, /* midori */
    { .label = { 101617,  8, 0 } }, /* minakami */
    { .label = {  69793, 10, 0 } }, /* naganohara */
    { .label = { 101650,  8, 0 } }, /* nakanojo */
    { .label = { 123619,  7, 0 } }, /* nanmoku */
    { .label = { 143948,  6, 0 } }, /* numata */
    { .label = {  86146,  6, 0 } }, /* oizumi */
    { .label = {   1542,  3, 0 } }, /* ora */
    { .label = {   5500,  3, 0 } }, /* ota */
    { .label = {  83449,  9, 0 } }, /* shibukawa */
    { .label = {  83490,  9, 0 } }, /* shimonita */
    { .label = { 102687,  6, 0 } }, /* shinto */
    { .label = { 158932,  5, 0 } }, /* showa */
    { .label = { 101684,  8, 0 } }, /* takasaki */
    { .label = { 100038,  8, 0 } }, /* takayama */
    { .label = { 101715,  8, 0 } }, /* tamamura */
    { .label = {  55081, 11, 0 } }, /* tatebayashi */
    { .label = { 123649,  7, 0 } }, /* tomioka */
    { .label = {  83527,  9, 0 } }, /* tsukiyono */
    { .label = { 101747,  8, 0 } }, /* tsumagoi */
    { .label = {  68022,  4, 0 } }, /* ueno */
    { .label = { 101781,  8, 0 } }, /* yoshioka */

    /* entries 4649 to 4673 */
    { .label = {  83567,  9, 0 } }, /* asaminami */
    { .label = { 127213,  5, 0 } }, /* daiwa */
    { .label = { 123678,  7, 0 } }, /* etajima */
    { .label = { 159079,  5, 0 } }, /* fuchu */
    { .label = { 101816,  8, 0 } }, /* fukuyama */
    { .label = {  55127, 11, 0 } }, /* hatsukaichi */
    { .label = {  14548, 16, 0 } }, /* higashihiroshima */
    { .label = { 159105,  5, 0 } }, /* hongo */
    { .label = {  42094, 12, 0 } }, /* jinsekikogen */
    { .label = { 155215,  5, 0 } }, /* kaita */
    { .label = {  55729,  3, 0 } }, /* kui */
    { .label = { 143972,  6, 0 } }, /* kumano */
    { .label = { 168030,  4, 0 } }, /* kure */
    { .label = {  70223,  6, 0 } }, /* mihara */
    { .label = {  14655,  7, 0 } }, /* miyoshi */
    { .label = {  26351,  4, 0 } }, /* naka */
    { .label = { 101854,  8, 0 } }, /* onomichi */
    { .label = {  33822, 13, 0 } }, /* osakikamijima */
    { .label = { 159127,  5, 0 } }, /* otake */
    { .label = {  26437,  4, 0 } }, /* saka */
    { .label = {  35599,  4, 0 } }, /* sera */
    { .label = {  83602,  9, 0 } }, /* seranishi */
    { .label = { 101889,  8, 0 } }, /* shinichi */
    { .label = { 123708,  7, 0 } }, /* shobara */
    { .label = { 101924,  8, 0 } }, /* takehara */

    /* entries 4674 to 4815 */
    { .label = { 101955,  8, 0 } }, /* abashiri */
    { .label = { 123775,  5, 0 } }, /* abira */
    { .label = { 123737,  7, 0 } }, /* aibetsu */
    { .label = { 123767,  7, 0 } }, /* akabira */
    { .label = { 123795,  7, 0 } }, /* akkeshi */
    { .label = {  83638,  9, 0 } }, /* asahikawa */
    { .label = {  83674,  9, 0 } }, /* ashibetsu */
    { .label = { 143998,  6, 0 } }, /* ashoro */
    { .label = { 144022,  6, 0 } }, /* assabu */
    { .label = {  19282,  6, 0 } }, /* atsuma */
    { .label = { 159147,  5, 0 } }, /* bibai */
    { .label = {   5133,  4, 0 } }, /* biei */
    { .label = { 144047,  6, 0 } }, /* bifuka */
    { .label = { 144076,  6, 0 } }, /* bihoro */
    { .label = { 101988,  8, 0 } }, /* biratori */
    { .label = {  55174, 11, 0 } }, /* chippubetsu */
    { .label = { 123825,  7, 0 } }, /* chitose */
    { .label = {  31483,  4, 0 } }, /* date */
    { .label = { 144103,  6, 0 } }, /* ebetsu */
    { .label = { 123855,  7, 0 } }, /* embetsu */
    { .label = { 146568,  5, 0 } }, /* eniwa */
    { .label = { 159170,  5, 0 } }, /* erimo */
    { .label = {   2217,  4, 0 } }, /* esan */
    { .label = { 144130,  6, 0 } }, /* esashi */
    { .label = { 102021,  8, 0 } }, /* fukagawa */
    { .label = {  34279,  9, 0 } }, /* fukushima */
    { .label = {  42324,  6, 0 } }, /* furano */
    { .label = { 102057,  8, 0 } }, /* furubira */
    { .label = { 144154,  6, 0 } }, /* haboro */
    { .label = { 102094,  8, 0 } }, /* hakodate */
    { .label = {  42148, 12, 0 } }, /* hamatonbetsu */
    { .label = { 144180,  6, 0 } }, /* hidaka */
    { .label = {  33878, 13, 0 } }, /* higashikagura */
    { .label = {  55228, 11, 0 } }, /* higashikawa */
    { .label = { 124142,  5, 0 } }, /* hiroo */
    { .label = { 123887,  7, 0 } }, /* hokuryu */
    { .label = { 144205,  6, 0 } }, /* hokuto */
    { .label = { 102127,  8, 0 } }, /* honbetsu */
    { .label = {  83713,  9, 0 } }, /* horokanai */
    { .label = { 102163,  8, 0 } }, /* horonobe */
    { .label = { 158719,  5, 0 } }, /* ikeda */
    { .label = { 123921,  7, 0 } }, /* imakane */
    { .label = { 102198,  8, 0 } }, /* ishikari */
    { .label = {  83749,  9, 0 } }, /* iwamizawa */
    { .label = { 144232,  6, 0 } }, /* iwanai */
    { .label = {  69831, 10, 0 } }, /* kamifurano */
    { .label = { 102231,  8, 0 } }, /* kamikawa */
    { .label = {  55275, 11, 0 } }, /* kamishihoro */
    { .label = {  42199, 12, 0 } }, /* kamisunagawa */
    { .label = { 102265,  8, 0 } }, /* kamoenai */
    { .label = { 144256,  6, 0 } }, /* kayabe */
    { .label = { 102297,  8, 0 } }, /* kembuchi */
    { .label = { 123949,  7, 0 } }, /* kikonai */
    { .label = {  83790,  9, 0 } }, /* kimobetsu */
    { .label = {  33933, 13, 0 } }, /* kitahiroshima */
    { .label = { 144283,  6, 0 } }, /* kitami */
    { .label = { 102336,  8, 0 } }, /* kiyosato */
    { .label = {  83831,  9, 0 } }, /* koshimizu */
    { .label = { 102370,  8, 0 } }, /* kunneppu */
    { .label = { 102409,  8, 0 } }, /* kuriyama */
    { .label = {  42249, 12, 0 } }, /* kuromatsunai */
    { .label = { 123978,  7, 0 } }, /* kushiro */
    { .label = { 124009,  7, 0 } }, /* kutchan */
    { .label = { 158546,  5, 0 } }, /* kyowa */
    { .label = { 124040,  7, 0 } }, /* mashike */
    { .label = { 102444,  8, 0 } }, /* matsumae */
    { .label = { 125917,  6, 0 } }, /* mikasa */
    { .label = {  42299, 12, 0 } }, /* minamifurano */
    { .label = { 102477,  8, 0 } }, /* mombetsu */
    { .label = { 102514,  8, 0 } }, /* moseushi */
    { .label = { 104056,  6, 0 } }, /* mukawa */
    { .label = { 124070,  7, 0 } }, /* muroran */
    { .label = {  75925,  4, 0 } }, /* naie */
    { .label = { 101022,  8, 0 } }, /* nakagawa */
    { .label = {  42350, 12, 0 } }, /* nakasatsunai */
    { .label = {  42396, 12, 0 } }, /* nakatombetsu */
    { .label = {  57059,  5, 0 } }, /* nanae */
    { .label = { 124099,  7, 0 } }, /* nanporo */
    { .label = { 144308,  6, 0 } }, /* nayoro */
    { .label = { 144333,  6, 0 } }, /* nemuro */
    { .label = { 102549,  8, 0 } }, /* niikappu */
    { .label = {  82627,  4, 0 } }, /* niki */
    { .label = {  55322, 11, 0 } }, /* nishiokoppe */
    { .label = {  55372, 11, 0 } }, /* noboribetsu */
    { .label = { 143948,  6, 0 } }, /* numata */
    { .label = { 124128,  7, 0 } }, /* obihiro */
    { .label = { 102073,  5, 0 } }, /* obira */
    { .label = { 159191,  5, 0 } }, /* oketo */
    { .label = {  55343,  6, 0 } }, /* okoppe */
    { .label = { 159212,  5, 0 } }, /* otaru */
    { .label = { 159232,  5, 0 } }, /* otobe */
    { .label = { 124159,  7, 0 } }, /* otofuke */
    { .label = {  83874,  9, 0 } }, /* otoineppu */
    { .label = { 168048,  4, 0 } }, /* oumu */
    { .label = { 154574,  5, 0 } }, /* ozora */
    { .label = { 159254,  5, 0 } }, /* pippu */
    { .label = { 102586,  8, 0 } }, /* rankoshi */
    { .label = { 159281,  5, 0 } }, /* rebun */
    { .label = {  83915,  9, 0 } }, /* rikubetsu */
    { .label = {  55421,  7, 0 } }, /* rishiri */
    { .label = {  55421, 11, 0 } }, /* rishirifuji */
    { .label = { 144359,  6, 0 } }, /* saroma */
    { .label = {  83956,  9, 0 } }, /* sarufutsu */
    { .label = { 102619,  8, 0 } }, /* shakotan */
    { .label = { 159304,  5, 0 } }, /* shari */
    { .label = { 102651,  8, 0 } }, /* shibecha */
    { .label = {  83677,  8, 0 } }, /* shibetsu */
    { .label = { 124191,  7, 0 } }, /* shikabe */
    { .label = { 124222,  7, 0 } }, /* shikaoi */
    { .label = {  83996,  9, 0 } }, /* shimamaki */
    { .label = {  55771,  7, 0 } }, /* shimizu */
    { .label = {  84034,  9, 0 } }, /* shimokawa */
    { .label = {  42447, 12, 0 } }, /* shinshinotsu */
    { .label = { 102687,  8, 0 } }, /* shintoku */
    { .label = {  84073,  9, 0 } }, /* shiranuka */
    { .label = { 124251,  7, 0 } }, /* shiraoi */
    { .label = {  84110,  9, 0 } }, /* shiriuchi */
    { .label = { 124279,  7, 0 } }, /* sobetsu */
    { .label = {  42216,  8, 0 } }, /* sunagawa */
    { .label = { 159324,  5, 0 } }, /* taiki */
    { .label = { 144382,  6, 0 } }, /* takasu */
    { .label = { 102722,  8, 0 } }, /* takikawa */
    { .label = { 102755,  8, 0 } }, /* takinoue */
    { .label = {  84150,  9, 0 } }, /* teshikaga */
    { .label = { 102828,  7, 0 } }, /* tobetsu */
    { .label = { 159344,  5, 0 } }, /* tohma */
    { .label = {  84187,  9, 0 } }, /* tomakomai */
    { .label = { 144406,  6, 0 } }, /* tomari */
    { .label = {  14730,  4, 0 } }, /* toya */
    { .label = { 144430,  6, 0 } }, /* toyako */
    { .label = { 102788,  8, 0 } }, /* toyotomi */
    { .label = { 124310,  7, 0 } }, /* toyoura */
    { .label = { 102823,  8, 0 } }, /* tsubetsu */
    { .label = {  84224,  9, 0 } }, /* tsukigata */
    { .label = { 124340,  7, 0 } }, /* urakawa */
    { .label = { 144456,  6, 0 } }, /* urausu */
    { .label = { 123901,  4, 0 } }, /* uryu */
    { .label = {  84261,  9, 0 } }, /* utashinai */
    { .label = { 102859,  8, 0 } }, /* wakkanai */
    { .label = { 124369,  7, 0 } }, /* wassamu */
    { .label = { 144482,  6, 0 } }, /* yakumo */
    { .label = { 144510,  6, 0 } }, /* yoichi */

    /* entries 4816 to 4861 */
    { .label = { 127185,  4, 0 } }, /* aioi */
    { .label = {  85602,  6, 0 } }, /* akashi */
    { .label = {  11348,  3, 0 } }, /* ako */
    { .label = {  84297,  9, 0 } }, /* amagasaki */
    { .label = { 144538,  6, 0 } }, /* aogaki */
    { .label = { 103040,  5, 0 } }, /* asago */
    { .label = {  34502,  6, 0 } }, /* ashiya */
    { .label = {  55497,  5, 0 } }, /* awaji */
    { .label = { 102892,  8, 0 } }, /* fukusaki */
    { .label = { 124399,  7, 0 } }, /* goshiki */
    { .label = { 144562,  6, 0 } }, /* harima */
    { .label = { 144586,  6, 0 } }, /* himeji */
    { .label = {  26452,  8, 0 } }, /* ichikawa */
    { .label = {  87205,  7, 0 } }, /* inagawa */
    { .label = { 144288,  5, 0 } }, /* itami */
    { .label = { 102929,  8, 0 } }, /* kakogawa */
    { .label = { 102963,  8, 0 } }, /* kamigori */
    { .label = { 102231,  8, 0 } }, /* kamikawa */
    { .label = {  72924,  5, 0 } }, /* kasai */
    { .label = { 122264,  6, 0 } }, /* kasuga */
    { .label = {  84332,  9, 0 } }, /* kawanishi */
    { .label = {  42811,  4, 0 } }, /* miki */
    { .label = {  55472, 11, 0 } }, /* minamiawaji */
    { .label = {  55520, 11, 0 } }, /* nishinomiya */
    { .label = {  84370,  9, 0 } }, /* nishiwaki */
    { .label = {    184,  3, 0 } }, /* ono */
    { .label = { 159365,  5, 0 } }, /* sanda */
    { .label = { 144615,  6, 0 } }, /* sannan */
    { .label = { 102997,  8, 0 } }, /* sasayama */
    { .label = { 147960,  4, 0 } }, /* sayo */
    { .label = { 143462,  6, 0 } }, /* shingu */
    { .label = {  84409,  9, 0 } }, /* shinonsen */
    { .label = { 159384,  5, 0 } }, /* shiso */
    { .label = {  84694,  6, 0 } }, /* sumoto */
    { .label = { 123286,  6, 0 } }, /* taishi */
    { .label = {  19797,  4, 0 } }, /* taka */
    { .label = {  69874, 10, 0 } }, /* takarazuka */
    { .label = { 103028,  8, 0 } }, /* takasago */
    { .label = { 102755,  6, 0 } }, /* takino */
    { .label = { 104402,  5, 0 } }, /* tamba */
    { .label = { 124430,  7, 0 } }, /* tatsuno */
    { .label = { 124458,  7, 0 } }, /* toyooka */
    { .label = { 143741,  4, 0 } }, /* yabu */
    { .label = {  86509,  7, 0 } }, /* yashiro */
    { .label = {  69452,  4, 0 } }, /* yoka */
    { .label = { 100275,  6, 0 } }, /* yokawa */

    /* entries 4862 to 4912 */
    { .label = {   3784,  3, 0 } }, /* ami */
    { .label = {  69225,  5, 0 } }, /* asahi */
    { .label = { 159405,  5, 0 } }, /* bando */
    { .label = { 103059,  8, 0 } }, /* chikusei */
    { .label = { 159427,  5, 0 } }, /* daigo */
    { .label = {  84446,  9, 0 } }, /* fujishiro */
    { .label = {  42498,  7, 0 } }, /* hitachi */
    { .label = {  55567, 11, 0 } }, /* hitachinaka */
    { .label = {  42498, 12, 0 } }, /* hitachiomiya */
    { .label = {  69916, 10, 0 } }, /* hitachiota */
    { .label = { 121885,  7, 0 } }, /* ibaraki */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = { 103095,  8, 0 } }, /* inashiki */
    { .label = { 159448,  5, 0 } }, /* itako */
    { .label = { 146551,  5, 0 } }, /* iwama */
    { .label = { 168067,  4, 0 } }, /* joso */
    { .label = {  42199,  6, 0 } }, /* kamisu */
    { .label = {  83378,  6, 0 } }, /* kasama */
    { .label = {  86624,  7, 0 } }, /* kashima */
    { .label = {  55612, 11, 0 } }, /* kasumigaura */
    { .label = {  74281,  4, 0 } }, /* koga */
    { .label = { 168086,  4, 0 } }, /* miho */
    { .label = {  51038,  4, 0 } }, /* mito */
    { .label = { 106560,  6, 0 } }, /* moriya */
    { .label = {  26351,  4, 0 } }, /* naka */
    { .label = { 103128,  8, 0 } }, /* namegata */
    { .label = { 111758,  5, 0 } }, /* oarai */
    { .label = {  19414,  5, 0 } }, /* ogawa */
    { .label = { 124488,  7, 0 } }, /* omitama */
    { .label = {  84489,  9, 0 } }, /* ryugasaki */
    { .label = {  26437,  5, 0 } }, /* sakai */
    { .label = {  69957, 10, 0 } }, /* sakuragawa */
    { .label = {  84528,  9, 0 } }, /* shimodate */
    { .label = {  69998, 10, 0 } }, /* shimotsuma */
    { .label = {  84566,  9, 0 } }, /* shirosato */
    { .label = {   9536,  4, 0 } }, /* sowa */
    { .label = { 159468,  5, 0 } }, /* suifu */
    { .label = { 103159,  8, 0 } }, /* takahagi */
    { .label = {  55658, 11, 0 } }, /* tamatsukuri */
    { .label = {  55140,  5, 0 } }, /* tokai */
    { .label = { 144637,  6, 0 } }, /* tomobe */
    { .label = {  60509,  4, 0 } }, /* tone */
    { .label = { 144664,  6, 0 } }, /* toride */
    { .label = {  84602,  9, 0 } }, /* tsuchiura */
    { .label = { 124516,  7, 0 } }, /* tsukuba */
    { .label = { 103191,  8, 0 } }, /* uchihara */
    { .label = { 144689,  6, 0 } }, /* ushiku */
    { .label = { 122765,  7, 0 } }, /* yachiyo */
    { .label = { 100070,  8, 0 } }, /* yamagata */
    { .label = { 144717,  6, 0 } }, /* yawara */
    { .label = { 144882,  4, 0 } }, /* yuki */

    /* entries 4913 to 4931 */
    { .label = { 124548,  7, 0 } }, /* anamizu */
    { .label = { 159492,  5, 0 } }, /* hakui */
    { .label = { 124579,  7, 0 } }, /* hakusan */
    { .label = {  34072,  4, 0 } }, /* kaga */
    { .label = { 144197,  6, 0 } }, /* kahoku */
    { .label = { 103225,  8, 0 } }, /* kanazawa */
    { .label = { 103259,  8, 0 } }, /* kawakita */
    { .label = {  43307,  7, 0 } }, /* komatsu */
    { .label = { 103292,  8, 0 } }, /* nakanoto */
    { .label = { 159514,  5, 0 } }, /* nanao */
    { .label = {  42643,  4, 0 } }, /* nomi */
    { .label = { 103323,  8, 0 } }, /* nonoichi */
    { .label = { 102798,  4, 0 } }, /* noto */
    { .label = {  33895,  5, 0 } }, /* shika */
    { .label = { 145467,  4, 0 } }, /* suzu */
    { .label = { 124608,  7, 0 } }, /* tsubata */
    { .label = { 124637,  7, 0 } }, /* tsurugi */
    { .label = { 103357,  8, 0 } }, /* uchinada */
    { .label = { 106300,  6, 0 } }, /* wajima */

    /* entries 4932 to 4965 */
    { .label = { 159532,  5, 0 } }, /* fudai */
    { .label = { 103391,  8, 0 } }, /* fujisawa */
    { .label = { 103429,  8, 0 } }, /* hanamaki */
    { .label = {  84641,  9, 0 } }, /* hiraizumi */
    { .label = { 143640,  6, 0 } }, /* hirono */
    { .label = {  69293,  8, 0 } }, /* ichinohe */
    { .label = {  70041, 10, 0 } }, /* ichinoseki */
    { .label = { 103461,  8, 0 } }, /* iwaizumi */
    { .label = {  20472,  5, 0 } }, /* iwate */
    { .label = { 144742,  6, 0 } }, /* joboji */
    { .label = { 103499,  8, 0 } }, /* kamaishi */
    { .label = {  70084, 10, 0 } }, /* kanegasaki */
    { .label = { 124668,  7, 0 } }, /* karumai */
    { .label = { 159555,  5, 0 } }, /* kawai */
    { .label = { 103532,  8, 0 } }, /* kitakami */
    { .label = { 168104,  4, 0 } }, /* kuji */
    { .label = { 100447,  6, 0 } }, /* kunohe */
    { .label = { 103565,  8, 0 } }, /* kuzumaki */
    { .label = {  70460,  6, 0 } }, /* miyako */
    { .label = { 103604,  8, 0 } }, /* mizusawa */
    { .label = { 124697,  7, 0 } }, /* morioka */
    { .label = { 144774,  6, 0 } }, /* ninohe */
    { .label = {  96948,  4, 0 } }, /* noda */
    { .label = { 124726,  7, 0 } }, /* ofunato */
    { .label = {  69100,  4, 0 } }, /* oshu */
    { .label = {  84598,  7, 0 } }, /* otsuchi */
    { .label = {  33987, 13, 0 } }, /* rikuzentakata */
    { .label = {  56004,  5, 0 } }, /* shiwa */
    { .label = {  55704, 11, 0 } }, /* shizukuishi */
    { .label = { 144799,  6, 0 } }, /* sumita */
    { .label = { 103641,  8, 0 } }, /* tanohata */
    { .label = {  42635,  4, 0 } }, /* tono */
    { .label = { 144824,  6, 0 } }, /* yahaba */
    { .label = { 143539,  6, 0 } }, /* yamada */

    /* entries 4966 to 4980 */
    { .label = { 105856,  7, 0 } }, /* ayagawa */
    { .label = {  34042, 13, 0 } }, /* higashikagawa */
    { .label = { 124756,  7, 0 } }, /* kanonji */
    { .label = { 103671,  8, 0 } }, /* kotohira */
    { .label = { 117796,  5, 0 } }, /* manno */
    { .label = { 103704,  8, 0 } }, /* marugame */
    { .label = { 144850,  6, 0 } }, /* mitoyo */
    { .label = { 103738,  8, 0 } }, /* naoshima */
    { .label = { 144877,  6, 0 } }, /* sanuki */
    { .label = { 124787,  7, 0 } }, /* tadotsu */
    { .label = {  33786,  9, 0 } }, /* takamatsu */
    { .label = { 124816,  7, 0 } }, /* tonosho */
    { .label = { 103770,  8, 0 } }, /* uchinomi */
    { .label = { 159576,  5, 0 } }, /* utazu */
    { .label = { 103806,  8, 0 } }, /* zentsuji */

    /* entries 4981 to 5000 */
    { .label = { 159600,  5, 0 } }, /* akune */
    { .label = { 146866,  5, 0 } }, /* amami */
    { .label = { 159621,  5, 0 } }, /* hioki */
    { .label = {   9230,  3, 0 } }, /* isa */
    { .label = {  88512,  4, 0 } }, /* isen */
    { .label = {  69630,  5, 0 } }, /* izumi */
    { .label = {  82183,  9, 0 } }, /* kagoshima */
    { .label = { 144902,  6, 0 } }, /* kanoya */
    { .label = { 103845,  8, 0 } }, /* kawanabe */
    { .label = { 159643,  5, 0 } }, /* kinko */
    { .label = { 124845,  7, 0 } }, /* kouyama */
    { .label = {  70124, 10, 0 } }, /* makurazaki */
    { .label = {  84682,  9, 0 } }, /* matsumoto */
    { .label = {  70168, 10, 0 } }, /* minamitane */
    { .label = { 103879,  8, 0 } }, /* nakatane */
    { .label = {  42550, 12, 0 } }, /* nishinoomote */
    { .label = {  34097, 13, 0 } }, /* satsumasendai */
    { .label = {  20833,  3, 0 } }, /* soo */
    { .label = { 103909,  8, 0 } }, /* tarumizu */
    { .label = { 159665,  5, 0 } }, /* yusui */

    /* entries 5001 to 5030 */
    { .label = {  70411,  6, 0 } }, /* aikawa */
    { .label = { 144927,  6, 0 } }, /* atsugi */
    { .label = { 159689,  5, 0 } }, /* ayase */
    { .label = {  84720,  9, 0 } }, /* chigasaki */
    { .label = { 159709,  5, 0 } }, /* ebina */
    { .label = { 103391,  8, 0 } }, /* fujisawa */
    { .label = { 144952,  6, 0 } }, /* hadano */
    { .label = { 144976,  6, 0 } }, /* hakone */
    { .label = {  84758,  9, 0 } }, /* hiratsuka */
    { .label = { 124876,  7, 0 } }, /* isehara */
    { .label = { 145001,  6, 0 } }, /* kaisei */
    { .label = { 103946,  8, 0 } }, /* kamakura */
    { .label = { 103979,  8, 0 } }, /* kiyokawa */
    { .label = { 124903,  7, 0 } }, /* matsuda */
    { .label = {  26159, 14, 0 } }, /* minamiashigara */
    { .label = { 159730,  5, 0 } }, /* miura */
    { .label = { 147647,  5, 0 } }, /* nakai */
    { .label = { 104015,  8, 0 } }, /* ninomiya */
    { .label = { 124932,  7, 0 } }, /* odawara */
    { .label = {     23,  2, 0 } }, /* oi */
    { .label = { 124271,  4, 0 } }, /* oiso */
    { .label = {  70208, 10, 0 } }, /* sagamihara */
    { .label = { 104049,  8, 0 } }, /* samukawa */
    { .label = { 145025,  6, 0 } }, /* tsukui */
    { .label = {  26318,  8, 0 } }, /* yamakita */
    { .label = {  26276,  6, 0 } }, /* yamato */
    { .label = { 104083,  8, 0 } }, /* yokosuka */
    { .label = { 104119,  8, 0 } }, /* yugawara */
    { .label = {  40317,  4, 0 } }, /* zama */
    { .label = {  71377,  5, 0 } }, /* zushi */

    /* entries 5031 to 5061 */
    { .label = {   5837,  3, 0 } }, /* aki */
    { .label = { 145052,  6, 0 } }, /* geisei */
    { .label = { 144180,  6, 0 } }, /* hidaka */
    { .label = {  42600, 12, 0 } }, /* higashitsuno */
    { .label = {    485,  3, 0 } }, /* ino */
    { .label = {  69711,  6, 0 } }, /* kagami */
    { .label = {  33842,  4, 0 } }, /* kami */
    { .label = { 104154,  8, 0 } }, /* kitagawa */
    { .label = { 158375,  5, 0 } }, /* kochi */
    { .label = {  70223,  6, 0 } }, /* mihara */
    { .label = { 104187,  8, 0 } }, /* motoyama */
    { .label = { 145077,  6, 0 } }, /* muroto */
    { .label = { 145103,  6, 0 } }, /* nahari */
    { .label = { 104221,  8, 0 } }, /* nakamura */
    { .label = { 124960,  7, 0 } }, /* nankoku */
    { .label = {  84795,  9, 0 } }, /* nishitosa */
    { .label = {  70247, 10, 0 } }, /* niyodogawa */
    { .label = {  19677,  4, 0 } }, /* ochi */
    { .label = {  71086,  5, 0 } }, /* okawa */
    { .label = { 124306,  5, 0 } }, /* otoyo */
    { .label = { 145126,  6, 0 } }, /* otsuki */
    { .label = { 123141,  6, 0 } }, /* sakawa */
    { .label = { 145152,  6, 0 } }, /* sukumo */
    { .label = { 145180,  6, 0 } }, /* susaki */
    { .label = {  55756,  4, 0 } }, /* tosa */
    { .label = {  55756, 11, 0 } }, /* tosashimizu */
    { .label = {  82559,  4, 0 } }, /* toyo */
    { .label = {  42630,  5, 0 } }, /* tsuno */
    { .label = { 159751,  5, 0 } }, /* umaji */
    { .label = { 145205,  6, 0 } }, /* yasuda */
    { .label = { 104253,  8, 0 } }, /* yusuhara */

    /* entries 5062 to 5084 */
    { .label = {  55822,  7, 0 } }, /* amakusa */
    { .label = {  31999,  4, 0 } }, /* arao */
    { .label = {    128,  3, 0 } }, /* aso */
    { .label = { 159775,  5, 0 } }, /* choyo */
    { .label = { 124990,  7, 0 } }, /* gyokuto */
    { .label = {  55805, 11, 0 } }, /* kamiamakusa */
    { .label = { 125023,  7, 0 } }, /* kikuchi */
    { .label = {  99896,  8, 0 } }, /* kumamoto */
    { .label = { 125056,  7, 0 } }, /* mashiki */
    { .label = { 145231,  6, 0 } }, /* mifune */
    { .label = { 104288,  8, 0 } }, /* minamata */
    { .label = {  55850, 11, 0 } }, /* minamioguni */
    { .label = { 145259,  6, 0 } }, /* nagasu */
    { .label = {  84831,  9, 0 } }, /* nishihara */
    { .label = {  55875,  5, 0 } }, /* oguni */
    { .label = {  71373,  3, 0 } }, /* ozu */
    { .label = {  84694,  6, 0 } }, /* sumoto */
    { .label = { 104319,  8, 0 } }, /* takamori */
    { .label = {   7753,  3, 0 } }, /* uki */
    { .label = {  26803,  3, 0 } }, /* uto */
    { .label = { 100070,  6, 0 } }, /* yamaga */
    { .label = {  26276,  6, 0 } }, /* yamato */
    { .label = {  70291, 10, 0 } }, /* yatsushiro */

    /* entries 5085 to 5115 */
    { .label = { 144261,  5, 0 } }, /* ayabe */
    { .label = {  55897, 11, 0 } }, /* fukuchiyama */
    { .label = {  34488, 11, 0 } }, /* higashiyama */
    { .label = {   2010,  3, 0 } }, /* ide */
    { .label = {    100,  3, 0 } }, /* ine */
    { .label = { 160218,  4, 0 } }, /* joyo */
    { .label = { 125086,  7, 0 } }, /* kameoka */
    { .label = { 100540,  4, 0 } }, /* kamo */
    { .label = {  26335,  4, 0 } }, /* kita */
    { .label = { 103469,  4, 0 } }, /* kizu */
    { .label = { 104351,  8, 0 } }, /* kumiyama */
    { .label = { 104387,  8, 0 } }, /* kyotamba */
    { .label = {  84867,  9, 0 } }, /* kyotanabe */
    { .label = { 104423,  8, 0 } }, /* kyotango */
    { .label = { 125115,  7, 0 } }, /* maizuru */
    { .label = {  19306,  6, 0 } }, /* minami */
    { .label = {  19306, 15, 0 } }, /* minamiyamashiro */
    { .label = { 145283,  6, 0 } }, /* miyazu */
    { .label = { 168125,  4, 0 } }, /* muko */
    { .label = {  70334, 10, 0 } }, /* nagaokakyo */
    { .label = { 125148,  7, 0 } }, /* nakagyo */
    { .label = { 145313,  6, 0 } }, /* nantan */
    { .label = {  84906,  9, 0 } }, /* oyamazaki */
    { .label = { 159799,  5, 0 } }, /* sakyo */
    { .label = { 159821,  5, 0 } }, /* seika */
    { .label = {  84882,  6, 0 } }, /* tanabe */
    { .label = {  19638,  3, 0 } }, /* uji */
    { .label = {  84946,  9, 0 } }, /* ujitawara */
    { .label = { 145335,  6, 0 } }, /* wazuka */
    { .label = {  84985,  9, 0 } }, /* yamashina */
    { .label = {  69541,  6, 0 } }, /* yawata */

    /* entries 5116 to 5145 */
    { .label = {  69225,  5, 0 } }, /* asahi */
    { .label = { 159841,  5, 0 } }, /* inabe */
    { .label = {  19958,  3, 0 } }, /* ise */
    { .label = { 104458,  8, 0 } }, /* kameyama */
    { .label = { 125178,  7, 0 } }, /* kawagoe */
    { .label = { 143162,  4, 0 } }, /* kiho */
    { .label = { 104492,  8, 0 } }, /* kisosaki */
    { .label = { 143205,  4, 0 } }, /* kiwa */
    { .label = { 145364,  6, 0 } }, /* komono */
    { .label = { 143972,  6, 0 } }, /* kumano */
    { .label = { 145390,  6, 0 } }, /* kuwana */
    { .label = {  85022,  9, 0 } }, /* matsusaka */
    { .label = { 159057,  5, 0 } }, /* meiwa */
    { .label = { 105980,  6, 0 } }, /* mihama */
    { .label = {  85058,  9, 0 } }, /* minamiise */
    { .label = { 145416,  6, 0 } }, /* misugi */
    { .label = {  19322,  6, 0 } }, /* miyama */
    { .label = { 145443,  6, 0 } }, /* nabari */
    { .label = {  11062,  5, 0 } }, /* shima */
    { .label = { 145467,  6, 0 } }, /* suzuka */
    { .label = { 124787,  4, 0 } }, /* tado */
    { .label = { 159324,  5, 0 } }, /* taiki */
    { .label = {  42110,  4, 0 } }, /* taki */
    { .label = { 145496,  6, 0 } }, /* tamaki */
    { .label = {  86279,  4, 0 } }, /* toba */
    { .label = {  11083,  3, 0 } }, /* tsu */
    { .label = { 101134,  5, 0 } }, /* udono */
    { .label = { 104525,  8, 0 } }, /* ureshino */
    { .label = { 125208,  7, 0 } }, /* watarai */
    { .label = {  85095,  9, 0 } }, /* yokkaichi */

    /* entries 5146 to 5177 */
    { .label = { 104559,  8, 0 } }, /* furukawa */
    { .label = {  11045, 17, 0 } }, /* higashimatsushima */
    { .label = {  70376, 10, 0 } }, /* ishinomaki */
    { .label = { 125235,  7, 0 } }, /* iwanuma */
    { .label = {  87682,  6, 0 } }, /* kakuda */
    { .label = {  33842,  4, 0 } }, /* kami */
    { .label = { 100102,  8, 0 } }, /* kawasaki */
    { .label = { 104596,  8, 0 } }, /* marumori */
    { .label = {  11075, 10, 0 } }, /* matsushima */
    { .label = {  34149, 13, 0 } }, /* minamisanriku */
    { .label = {  26487,  6, 0 } }, /* misato */
    { .label = { 145520,  6, 0 } }, /* murata */
    { .label = {  55406,  6, 0 } }, /* natori */
    { .label = { 104126,  7, 0 } }, /* ogawara */
    { .label = { 103684,  5, 0 } }, /* ohira */
    { .label = {  42221,  7, 0 } }, /* onagawa */
    { .label = {  33822,  5, 0 } }, /* osaki */
    { .label = {  55442,  4, 0 } }, /* rifu */
    { .label = { 145544,  6, 0 } }, /* semine */
    { .label = { 125265,  7, 0 } }, /* shibata */
    { .label = {  34203, 13, 0 } }, /* shichikashuku */
    { .label = { 125294,  7, 0 } }, /* shikama */
    { .label = { 104630,  8, 0 } }, /* shiogama */
    { .label = {  85136,  9, 0 } }, /* shiroishi */
    { .label = { 145569,  6, 0 } }, /* tagajo */
    { .label = { 159862,  5, 0 } }, /* taiwa */
    { .label = { 117769,  4, 0 } }, /* tome */
    { .label = {  99923,  6, 0 } }, /* tomiya */
    { .label = { 145595,  6, 0 } }, /* wakuya */
    { .label = { 145623,  6, 0 } }, /* watari */
    { .label = { 104663,  8, 0 } }, /* yamamoto */
    { .label = {  41596,  3, 0 } }, /* zao */

    /* entries 5178 to 5204 */
    { .label = {   5900,  3, 0 } }, /* aya */
    { .label = { 159882,  5, 0 } }, /* ebino */
    { .label = { 145647,  6, 0 } }, /* gokase */
    { .label = { 159904,  5, 0 } }, /* hyuga */
    { .label = { 104697,  8, 0 } }, /* kadogawa */
    { .label = {  70418, 10, 0 } }, /* kawaminami */
    { .label = { 168144,  4, 0 } }, /* kijo */
    { .label = { 104154,  8, 0 } }, /* kitagawa */
    { .label = { 101221,  8, 0 } }, /* kitakata */
    { .label = { 125323,  7, 0 } }, /* kitaura */
    { .label = {  85174,  9, 0 } }, /* kobayashi */
    { .label = { 104731,  8, 0 } }, /* kunitomi */
    { .label = {  34290,  7, 0 } }, /* kushima */
    { .label = { 145672,  6, 0 } }, /* mimata */
    { .label = {  70460, 10, 0 } }, /* miyakonojo */
    { .label = {  99931,  8, 0 } }, /* miyazaki */
    { .label = {  85214,  9, 0 } }, /* morotsuka */
    { .label = { 104766,  8, 0 } }, /* nichinan */
    { .label = {  85252,  9, 0 } }, /* nishimera */
    { .label = { 125351,  7, 0 } }, /* nobeoka */
    { .label = { 159928,  5, 0 } }, /* saito */
    { .label = { 145696,  6, 0 } }, /* shiiba */
    { .label = { 104799,  8, 0 } }, /* shintomi */
    { .label = { 104833,  8, 0 } }, /* takaharu */
    { .label = { 104865,  8, 0 } }, /* takanabe */
    { .label = { 104897,  8, 0 } }, /* takazaki */
    { .label = {  42630,  5, 0 } }, /* tsuno */

    /* entries 5205 to 5279 */
    { .label = {    187,  4, 0 } }, /* achi */
    { .label = { 104931,  8, 0 } }, /* agematsu */
    { .label = {  14780,  4, 0 } }, /* anan */
    { .label = {  34336,  4, 0 } }, /* aoki */
    { .label = {  69225,  5, 0 } }, /* asahi */
    { .label = { 125381,  7, 0 } }, /* azumino */
    { .label = {  85289,  9, 0 } }, /* chikuhoku */
    { .label = { 125413,  7, 0 } }, /* chikuma */
    { .label = {  69164,  5, 0 } }, /* chino */
    { .label = {  55450,  6, 0 } }, /* fujimi */
    { .label = { 145722,  6, 0 } }, /* hakuba */
    { .label = {  42079,  4, 0 } }, /* hara */
    { .label = { 145749,  6, 0 } }, /* hiraya */
    { .label = {  74157,  4, 0 } }, /* iida */
    { .label = { 145774,  6, 0 } }, /* iijima */
    { .label = { 145801,  6, 0 } }, /* iiyama */
    { .label = { 145826,  6, 0 } }, /* iizuna */
    { .label = { 158719,  5, 0 } }, /* ikeda */
    { .label = { 125445,  7, 0 } }, /* ikusaka */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = {  85332,  9, 0 } }, /* karuizawa */
    { .label = {  55258,  8, 0 } }, /* kawakami */
    { .label = {   6445,  4, 0 } }, /* kiso */
    { .label = {  34262, 13, 0 } }, /* kisofukushima */
    { .label = { 104964,  8, 0 } }, /* kitaaiki */
    { .label = { 104996,  8, 0 } }, /* komagane */
    { .label = { 145853,  6, 0 } }, /* komoro */
    { .label = {  85372,  9, 0 } }, /* matsukawa */
    { .label = {  84682,  9, 0 } }, /* matsumoto */
    { .label = { 159947,  5, 0 } }, /* miasa */
    { .label = {  70506, 10, 0 } }, /* minamiaiki */
    { .label = {  70547, 10, 0 } }, /* minamimaki */
    { .label = {  42651, 12, 0 } }, /* minamiminowa */
    { .label = {  42676,  6, 0 } }, /* minowa */
    { .label = { 145879,  6, 0 } }, /* miyada */
    { .label = { 145905,  6, 0 } }, /* miyota */
    { .label = {  85410,  9, 0 } }, /* mochizuki */
    { .label = {  34407,  6, 0 } }, /* nagano */
    { .label = {  42225,  6, 0 } }, /* nagawa */
    { .label = { 145931,  6, 0 } }, /* nagiso */
    { .label = { 101022,  8, 0 } }, /* nakagawa */
    { .label = { 101650,  6, 0 } }, /* nakano */
    { .label = {  55949, 11, 0 } }, /* nozawaonsen */
    { .label = {  13227,  5, 0 } }, /* obuse */
    { .label = {  19414,  5, 0 } }, /* ogawa */
    { .label = { 107568,  5, 0 } }, /* okaya */
    { .label = {  42726,  6, 0 } }, /* omachi */
    { .label = {  14651,  3, 0 } }, /* omi */
    { .label = { 145955,  6, 0 } }, /* ookuwa */
    { .label = { 125474,  7, 0 } }, /* ooshika */
    { .label = { 102718,  5, 0 } }, /* otaki */
    { .label = { 159966,  5, 0 } }, /* otari */
    { .label = { 158656,  5, 0 } }, /* sakae */
    { .label = { 145982,  6, 0 } }, /* sakaki */
    { .label = {  69957,  4, 0 } }, /* saku */
    { .label = { 146006,  6, 0 } }, /* sakuho */
    { .label = {  85454,  9, 0 } }, /* shimosuwa */
    { .label = {  42702, 12, 0 } }, /* shinanomachi */
    { .label = { 105029,  8, 0 } }, /* shiojiri */
    { .label = {  85476,  4, 0 } }, /* suwa */
    { .label = { 146032,  6, 0 } }, /* suzaka */
    { .label = { 146059,  6, 0 } }, /* takagi */
    { .label = { 104319,  8, 0 } }, /* takamori */
    { .label = { 100038,  8, 0 } }, /* takayama */
    { .label = {  85494,  9, 0 } }, /* tateshina */
    { .label = { 124430,  7, 0 } }, /* tatsuno */
    { .label = {  85529,  9, 0 } }, /* togakushi */
    { .label = { 146083,  6, 0 } }, /* togura */
    { .label = {  14647,  4, 0 } }, /* tomi */
    { .label = {  43968,  4, 0 } }, /* ueda */
    { .label = {  86249,  4, 0 } }, /* wada */
    { .label = { 100070,  8, 0 } }, /* yamagata */
    { .label = {  70589, 10, 0 } }, /* yamanouchi */
    { .label = { 146108,  6, 0 } }, /* yasaka */
    { .label = { 125503,  7, 0 } }, /* yasuoka */

    /* entries 5280 to 5301 */
    { .label = { 125533,  7, 0 } }, /* chijiwa */
    { .label = {  83972,  5, 0 } }, /* futsu */
    { .label = {  42786,  4, 0 } }, /* goto */
    { .label = { 146132,  6, 0 } }, /* hasami */
    { .label = { 146156,  6, 0 } }, /* hirado */
    { .label = {  42816,  3, 0 } }, /* iki */
    { .label = { 125567,  7, 0 } }, /* isahaya */
    { .label = { 101334,  8, 0 } }, /* kawatana */
    { .label = {  70633, 10, 0 } }, /* kuchinotsu */
    { .label = { 105065,  8, 0 } }, /* matsuura */
    { .label = {  99968,  8, 0 } }, /* nagasaki */
    { .label = { 158740,  5, 0 } }, /* obama */
    { .label = { 159985,  5, 0 } }, /* omura */
    { .label = { 105502,  5, 0 } }, /* oseto */
    { .label = { 146181,  6, 0 } }, /* saikai */
    { .label = { 146204,  6, 0 } }, /* sasebo */
    { .label = { 108844,  5, 0 } }, /* seihi */
    { .label = {  85568,  9, 0 } }, /* shimabara */
    { .label = {  42752, 12, 0 } }, /* shinkamigoto */
    { .label = { 125595,  7, 0 } }, /* togitsu */
    { .label = {  11083,  8, 0 } }, /* tsushima */
    { .label = { 160006,  5, 0 } }, /* unzen */

    /* entries 5302 to 5339 */
    { .label = {  16790,  4, 0 } }, /* ando */
    { .label = { 123838,  4, 0 } }, /* gose */
    { .label = { 146229,  6, 0 } }, /* heguri */
    { .label = {  26215, 14, 0 } }, /* higashiyoshino */
    { .label = { 125625,  7, 0 } }, /* ikaruga */
    { .label = { 104992,  5, 0 } }, /* ikoma */
    { .label = {  42803, 12, 0 } }, /* kamikitayama */
    { .label = { 125654,  7, 0 } }, /* kanmaki */
    { .label = { 125683,  7, 0 } }, /* kashiba */
    { .label = {  85605,  9, 0 } }, /* kashihara */
    { .label = {  85641,  9, 0 } }, /* katsuragi */
    { .label = { 159555,  5, 0 } }, /* kawai */
    { .label = {  55258,  8, 0 } }, /* kawakami */
    { .label = {  84332,  9, 0 } }, /* kawanishi */
    { .label = { 160030,  5, 0 } }, /* koryo */
    { .label = { 105098,  8, 0 } }, /* kurotaki */
    { .label = { 105341,  6, 0 } }, /* mitsue */
    { .label = { 146256,  6, 0 } }, /* miyake */
    { .label = {   8120,  4, 0 } }, /* nara */
    { .label = { 105132,  8, 0 } }, /* nosegawa */
    { .label = {    299,  3, 0 } }, /* oji */
    { .label = {  32101,  4, 0 } }, /* ouda */
    { .label = { 160053,  5, 0 } }, /* oyodo */
    { .label = { 125713,  7, 0 } }, /* sakurai */
    { .label = { 160076,  5, 0 } }, /* sango */
    { .label = {  85678,  9, 0 } }, /* shimoichi */
    { .label = {  34321, 13, 0 } }, /* shimokitayama */
    { .label = { 146283,  6, 0 } }, /* shinjo */
    { .label = {  95038,  4, 0 } }, /* soni */
    { .label = { 105165,  8, 0 } }, /* takatori */
    { .label = {  70678, 10, 0 } }, /* tawaramoto */
    { .label = { 125741,  7, 0 } }, /* tenkawa */
    { .label = { 160096,  5, 0 } }, /* tenri */
    { .label = {  22245,  3, 0 } }, /* uda */
    { .label = {  26276, 14, 0 } }, /* yamatokoriyama */
    { .label = {  42853, 12, 0 } }, /* yamatotakada */
    { .label = { 125770,  7, 0 } }, /* yamazoe */
    { .label = {  26245,  7, 0 } }, /* yoshino */

    /* entries 5340 to 5373 */
    { .label = {   9337,  3, 0 } }, /* aga */
    { .label = {  34411,  5, 0 } }, /* agano */
    { .label = { 160116,  5, 0 } }, /* gosen */
    { .label = { 105196,  8, 0 } }, /* itoigawa */
    { .label = {  85718,  9, 0 } }, /* izumozaki */
    { .label = { 146311,  6, 0 } }, /* joetsu */
    { .label = { 100540,  4, 0 } }, /* kamo */
    { .label = { 146339,  6, 0 } }, /* kariwa */
    { .label = {  55996, 11, 0 } }, /* kashiwazaki */
    { .label = {  42901, 12, 0 } }, /* minamiuonuma */
    { .label = { 125802,  7, 0 } }, /* mitsuke */
    { .label = { 160137,  5, 0 } }, /* muika */
    { .label = { 105229,  8, 0 } }, /* murakami */
    { .label = { 160159,  5, 0 } }, /* myoko */
    { .label = {  70334,  7, 0 } }, /* nagaoka */
    { .label = { 121914,  7, 0 } }, /* niigata */
    { .label = { 160183,  5, 0 } }, /* ojiya */
    { .label = {  14651,  3, 0 } }, /* omi */
    { .label = { 168164,  4, 0 } }, /* sado */
    { .label = { 160207,  5, 0 } }, /* sanjo */
    { .label = {  75295,  5, 0 } }, /* seiro */
    { .label = { 146364,  6, 0 } }, /* seirou */
    { .label = { 105263,  8, 0 } }, /* sekikawa */
    { .label = { 125265,  7, 0 } }, /* shibata */
    { .label = { 100347,  6, 0 } }, /* tagami */
    { .label = { 146389,  6, 0 } }, /* tainai */
    { .label = { 146411,  6, 0 } }, /* tochio */
    { .label = {  85762,  9, 0 } }, /* tokamachi */
    { .label = { 125833,  7, 0 } }, /* tsubame */
    { .label = { 123606,  6, 0 } }, /* tsunan */
    { .label = {  42926,  6, 0 } }, /* uonuma */
    { .label = { 146437,  6, 0 } }, /* yahiko */
    { .label = { 160229,  5, 0 } }, /* yoita */
    { .label = { 146464,  6, 0 } }, /* yuzawa */

    /* entries 5374 to 5392 */
    { .label = { 160250,  5, 0 } }, /* beppu */
    { .label = { 105297,  8, 0 } }, /* bungoono */
    { .label = {  56045, 11, 0 } }, /* bungotakada */
    { .label = { 146494,  6, 0 } }, /* hasama */
    { .label = { 125538,  4, 0 } }, /* hiji */
    { .label = {  85800,  9, 0 } }, /* himeshima */
    { .label = {  42498,  4, 0 } }, /* hita */
    { .label = { 105333,  8, 0 } }, /* kamitsue */
    { .label = { 125864,  7, 0 } }, /* kokonoe */
    { .label = { 100609,  4, 0 } }, /* kuju */
    { .label = { 105367,  8, 0 } }, /* kunisaki */
    { .label = { 107167,  4, 0 } }, /* kusu */
    { .label = {  72442,  4, 0 } }, /* oita */
    { .label = { 160277,  5, 0 } }, /* saiki */
    { .label = { 146517,  6, 0 } }, /* taketa */
    { .label = { 125894,  7, 0 } }, /* tsukumi */
    { .label = {  13094,  3, 0 } }, /* usa */
    { .label = { 160297,  5, 0 } }, /* usuki */
    { .label = { 168180,  4, 0 } }, /* yufu */

    /* entries 5393 to 5418 */
    { .label = { 146540,  6, 0 } }, /* akaiwa */
    { .label = { 105401,  8, 0 } }, /* asakuchi */
    { .label = { 160320,  5, 0 } }, /* bizen */
    { .label = {  85839,  9, 0 } }, /* hayashima */
    { .label = { 121885,  5, 0 } }, /* ibara */
    { .label = { 105435,  8, 0 } }, /* kagamino */
    { .label = { 125926,  7, 0 } }, /* kasaoka */
    { .label = { 105468,  8, 0 } }, /* kibichuo */
    { .label = { 125953,  7, 0 } }, /* kumenan */
    { .label = {  85877,  9, 0 } }, /* kurashiki */
    { .label = { 146564,  6, 0 } }, /* maniwa */
    { .label = { 146589,  6, 0 } }, /* misaki */
    { .label = {  82812,  4, 0 } }, /* nagi */
    { .label = { 160345,  5, 0 } }, /* niimi */
    { .label = {  42952, 12, 0 } }, /* nishiawakura */
    { .label = { 107568,  7, 0 } }, /* okayama */
    { .label = { 125983,  7, 0 } }, /* satosho */
    { .label = { 105506,  8, 0 } }, /* setouchi */
    { .label = { 146283,  6, 0 } }, /* shinjo */
    { .label = { 123214,  4, 0 } }, /* shoo */
    { .label = { 168202,  4, 0 } }, /* soja */
    { .label = {  85916,  9, 0 } }, /* takahashi */
    { .label = { 146614,  6, 0 } }, /* tamano */
    { .label = {  14725,  7, 0 } }, /* tsuyama */
    { .label = { 168220,  4, 0 } }, /* wake */
    { .label = { 146637,  6, 0 } }, /* yakage */

    /* entries 5419 to 5460 */
    { .label = { 105730,  5, 0 } }, /* aguni */
    { .label = { 126011,  7, 0 } }, /* ginowan */
    { .label = { 146663,  6, 0 } }, /* ginoza */
    { .label = {  85952,  9, 0 } }, /* gushikami */
    { .label = { 126041,  7, 0 } }, /* haebaru */
    { .label = {  11045,  7, 0 } }, /* higashi */
    { .label = { 146690,  6, 0 } }, /* hirara */
    { .label = { 160366,  5, 0 } }, /* iheya */
    { .label = { 105541,  8, 0 } }, /* ishigaki */
    { .label = {  87582,  8, 0 } }, /* ishikawa */
    { .label = { 146713,  6, 0 } }, /* itoman */
    { .label = { 160388,  5, 0 } }, /* izena */
    { .label = { 146737,  6, 0 } }, /* kadena */
    { .label = {   5840,  3, 0 } }, /* kin */
    { .label = {  85992,  9, 0 } }, /* kitadaito */
    { .label = {  26335, 14, 0 } }, /* kitanakagusuku */
    { .label = { 105575,  8, 0 } }, /* kumejima */
    { .label = { 105613,  8, 0 } }, /* kunigami */
    { .label = {  56092, 11, 0 } }, /* minamidaito */
    { .label = { 146761,  6, 0 } }, /* motobu */
    { .label = {  86933,  4, 0 } }, /* nago */
    { .label = {  87325,  4, 0 } }, /* naha */
    { .label = {  26351, 10, 0 } }, /* nakagusuku */
    { .label = { 126071,  7, 0 } }, /* nakijin */
    { .label = { 160410,  5, 0 } }, /* nanjo */
    { .label = {  84831,  9, 0 } }, /* nishihara */
    { .label = { 160432,  5, 0 } }, /* ogimi */
    { .label = { 121941,  7, 0 } }, /* okinawa */
    { .label = { 127460,  4, 0 } }, /* onna */
    { .label = { 126102,  7, 0 } }, /* shimoji */
    { .label = { 105648,  8, 0 } }, /* taketomi */
    { .label = { 146789,  6, 0 } }, /* tarama */
    { .label = {  86028,  9, 0 } }, /* tokashiki */
    { .label = {  70718, 10, 0 } }, /* tomigusuku */
    { .label = { 146811,  6, 0 } }, /* tonaki */
    { .label = { 146835,  6, 0 } }, /* urasoe */
    { .label = { 160454,  5, 0 } }, /* uruma */
    { .label = { 160476,  5, 0 } }, /* yaese */
    { .label = { 126135,  7, 0 } }, /* yomitan */
    { .label = { 105681,  8, 0 } }, /* yonabaru */
    { .label = { 105716,  8, 0 } }, /* yonaguni */
    { .label = { 146859,  6, 0 } }, /* zamami */

    /* entries 5461 to 5510 */
    { .label = { 160497,  5, 0 } }, /* abeno */
    { .label = {  26395, 14, 0 } }, /* chihayaakasaka */
    { .label = {  55017,  4, 0 } }, /* chuo */
    { .label = {  56117,  5, 0 } }, /* daito */
    { .label = {  86066,  9, 0 } }, /* fujiidera */
    { .label = { 105751,  8, 0 } }, /* habikino */
    { .label = { 146886,  6, 0 } }, /* hannan */
    { .label = {  43002, 12, 0 } }, /* higashiosaka */
    { .label = {  14616, 16, 0 } }, /* higashisumiyoshi */
    { .label = {  19369, 15, 0 } }, /* higashiyodogawa */
    { .label = { 105786,  8, 0 } }, /* hirakata */
    { .label = { 121885,  7, 0 } }, /* ibaraki */
    { .label = { 158719,  5, 0 } }, /* ikeda */
    { .label = {  69630,  5, 0 } }, /* izumi */
    { .label = {  86108,  9, 0 } }, /* izumiotsu */
    { .label = {  86150,  9, 0 } }, /* izumisano */
    { .label = {  69251,  6, 0 } }, /* kadoma */
    { .label = { 126165,  7, 0 } }, /* kaizuka */
    { .label = { 160518,  5, 0 } }, /* kanan */
    { .label = {  86190,  9, 0 } }, /* kashiwara */
    { .label = { 146909,  6, 0 } }, /* katano */
    { .label = {  34376, 13, 0 } }, /* kawachinagano */
    { .label = {  86227,  9, 0 } }, /* kishiwada */
    { .label = {  26335,  4, 0 } }, /* kita */
    { .label = { 105817,  8, 0 } }, /* kumatori */
    { .label = {  86266,  9, 0 } }, /* matsubara */
    { .label = {  56341,  6, 0 } }, /* minato */
    { .label = {  64826,  5, 0 } }, /* minoh */
    { .label = { 146589,  6, 0 } }, /* misaki */
    { .label = {  86303,  9, 0 } }, /* moriguchi */
    { .label = { 105851,  8, 0 } }, /* neyagawa */
    { .label = {  42550,  5, 0 } }, /* nishi */
    { .label = {  56431,  4, 0 } }, /* nose */
    { .label = {  56137, 11, 0 } }, /* osakasayama */
    { .label = {  26437,  5, 0 } }, /* sakai */
    { .label = {  56156,  6, 0 } }, /* sayama */
    { .label = { 146932,  6, 0 } }, /* sennan */
    { .label = { 146955,  6, 0 } }, /* settsu */
    { .label = {  56180, 11, 0 } }, /* shijonawate */
    { .label = {  86344,  9, 0 } }, /* shimamoto */
    { .label = { 160537,  5, 0 } }, /* suita */
    { .label = { 126197,  7, 0 } }, /* tadaoka */
    { .label = { 123286,  6, 0 } }, /* taishi */
    { .label = { 146980,  6, 0 } }, /* tajiri */
    { .label = { 105885,  8, 0 } }, /* takaishi */
    { .label = {  86382,  9, 0 } }, /* takatsuki */
    { .label = {  43051, 12, 0 } }, /* tondabayashi */
    { .label = { 105917,  8, 0 } }, /* toyonaka */
    { .label = { 147006,  6, 0 } }, /* toyono */
    { .label = {   4531,  3, 0 } }, /* yao */

    /* entries 5511 to 5536 */
    { .label = { 147032,  6, 0 } }, /* ariake */
    { .label = {  15143,  5, 0 } }, /* arita */
    { .label = { 105950,  8, 0 } }, /* fukudomi */
    { .label = { 147055,  6, 0 } }, /* genkai */
    { .label = { 105989,  8, 0 } }, /* hamatama */
    { .label = {  33684,  5, 0 } }, /* hizen */
    { .label = {  33975,  5, 0 } }, /* imari */
    { .label = { 106020,  8, 0 } }, /* kamimine */
    { .label = { 126224,  7, 0 } }, /* kanzaki */
    { .label = { 126255,  7, 0 } }, /* karatsu */
    { .label = {  86624,  7, 0 } }, /* kashima */
    { .label = { 101412,  8, 0 } }, /* kitagata */
    { .label = { 106054,  8, 0 } }, /* kitahata */
    { .label = {  70580,  6, 0 } }, /* kiyama */
    { .label = { 126283,  7, 0 } }, /* kouhoku */
    { .label = { 126316,  7, 0 } }, /* kyuragi */
    { .label = {  70764, 10, 0 } }, /* nishiarita */
    { .label = {  15242,  3, 0 } }, /* ogi */
    { .label = {  42726,  6, 0 } }, /* omachi */
    { .label = {  70610,  5, 0 } }, /* ouchi */
    { .label = {  47952,  4, 0 } }, /* saga */
    { .label = {  85136,  9, 0 } }, /* shiroishi */
    { .label = {  42242,  4, 0 } }, /* taku */
    { .label = {  26201,  4, 0 } }, /* tara */
    { .label = { 143805,  4, 0 } }, /* tosu */
    { .label = {  56228, 11, 0 } }, /* yoshinogari */

    /* entries 5537 to 5605 */
    { .label = { 126348,  7, 0 } }, /* arakawa */
    { .label = {  26434,  5, 0 } }, /* asaka */
    { .label = {  19465,  8, 0 } }, /* chichibu */
    { .label = {  55450,  6, 0 } }, /* fujimi */
    { .label = { 106085,  8, 0 } }, /* fujimino */
    { .label = { 147080,  6, 0 } }, /* fukaya */
    { .label = { 160557,  5, 0 } }, /* hanno */
    { .label = { 160577,  5, 0 } }, /* hanyu */
    { .label = { 147108,  6, 0 } }, /* hasuda */
    { .label = { 106124,  8, 0 } }, /* hatogaya */
    { .label = { 106157,  8, 0 } }, /* hatoyama */
    { .label = { 144180,  6, 0 } }, /* hidaka */
    { .label = {  19435, 15, 0 } }, /* higashichichibu */
    { .label = {  14687, 16, 0 } }, /* higashimatsuyama */
    { .label = {  82729,  5, 0 } }, /* honjo */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = { 160600,  5, 0 } }, /* iruma */
    { .label = { 106190,  8, 0 } }, /* iwatsuki */
    { .label = {  86419,  9, 0 } }, /* kamiizumi */
    { .label = { 102231,  8, 0 } }, /* kamikawa */
    { .label = { 106225,  8, 0 } }, /* kamisato */
    { .label = { 106257,  8, 0 } }, /* kasukabe */
    { .label = { 125178,  7, 0 } }, /* kawagoe */
    { .label = {  19654,  9, 0 } }, /* kawaguchi */
    { .label = { 106292,  8, 0 } }, /* kawajima */
    { .label = { 168238,  4, 0 } }, /* kazo */
    { .label = { 106328,  8, 0 } }, /* kitamoto */
    { .label = {  86461,  9, 0 } }, /* koshigaya */
    { .label = { 126375,  7, 0 } }, /* kounosu */
    { .label = {  34252,  4, 0 } }, /* kuki */
    { .label = { 106361,  8, 0 } }, /* kumagaya */
    { .label = {  70803, 10, 0 } }, /* matsubushi */
    { .label = { 147133,  6, 0 } }, /* minano */
    { .label = {  26487,  6, 0 } }, /* misato */
    { .label = {  86500,  9, 0 } }, /* miyashiro */
    { .label = {  14655,  7, 0 } }, /* miyoshi */
    { .label = { 106396,  8, 0 } }, /* moroyama */
    { .label = { 106430,  8, 0 } }, /* nagatoro */
    { .label = { 106461,  8, 0 } }, /* namegawa */
    { .label = { 160621,  5, 0 } }, /* niiza */
    { .label = {  37773,  5, 0 } }, /* ogano */
    { .label = {  19414,  5, 0 } }, /* ogawa */
    { .label = { 160643,  5, 0 } }, /* ogose */
    { .label = { 126406,  7, 0 } }, /* okegawa */
    { .label = {  42528,  5, 0 } }, /* omiya */
    { .label = { 102718,  5, 0 } }, /* otaki */
    { .label = { 147157,  6, 0 } }, /* ranzan */
    { .label = { 126436,  7, 0 } }, /* ryokami */
    { .label = { 121970,  7, 0 } }, /* saitama */
    { .label = { 147182,  6, 0 } }, /* sakado */
    { .label = { 160664,  5, 0 } }, /* satte */
    { .label = {  56156,  6, 0 } }, /* sayama */
    { .label = {  85894,  5, 0 } }, /* shiki */
    { .label = { 106494,  8, 0 } }, /* shiraoka */
    { .label = {   7089,  4, 0 } }, /* soka */
    { .label = { 147206,  6, 0 } }, /* sugito */
    { .label = { 123009,  4, 0 } }, /* toda */
    { .label = { 106526,  8, 0 } }, /* tokigawa */
    { .label = {  70848, 10, 0 } }, /* tokorozawa */
    { .label = {  43102, 12, 0 } }, /* tsurugashima */
    { .label = { 160683,  5, 0 } }, /* urawa */
    { .label = { 147232,  6, 0 } }, /* warabi */
    { .label = { 147258,  6, 0 } }, /* yashio */
    { .label = { 147284,  6, 0 } }, /* yokoze */
    { .label = {  83549,  4, 0 } }, /* yono */
    { .label = { 160704,  5, 0 } }, /* yorii */
    { .label = {  56478,  7, 0 } }, /* yoshida */
    { .label = {  86539,  9, 0 } }, /* yoshikawa */
    { .label = { 126467,  7, 0 } }, /* yoshimi */

    /* entries 5606 to 5628 */
    { .label = { 160726,  5, 0 } }, /* aisho */
    { .label = {  82662,  4, 0 } }, /* gamo */
    { .label = {  70892, 10, 0 } }, /* higashiomi */
    { .label = { 147314,  6, 0 } }, /* hikone */
    { .label = {  51890,  4, 0 } }, /* koka */
    { .label = { 158505,  5, 0 } }, /* konan */
    { .label = { 160746,  5, 0 } }, /* kosei */
    { .label = { 103671,  4, 0 } }, /* koto */
    { .label = { 123589,  7, 0 } }, /* kusatsu */
    { .label = { 126499,  7, 0 } }, /* maibara */
    { .label = { 106560,  8, 0 } }, /* moriyama */
    { .label = { 106594,  8, 0 } }, /* nagahama */
    { .label = {  86579,  9, 0 } }, /* nishiazai */
    { .label = { 106625,  8, 0 } }, /* notogawa */
    { .label = {  56275, 11, 0 } }, /* omihachiman */
    { .label = {  26494,  4, 0 } }, /* otsu */
    { .label = { 160767,  5, 0 } }, /* ritto */
    { .label = { 160787,  5, 0 } }, /* ryuoh */
    { .label = {  86617,  9, 0 } }, /* takashima */
    { .label = {  86382,  9, 0 } }, /* takatsuki */
    { .label = { 106658,  8, 0 } }, /* torahime */
    { .label = { 106691,  8, 0 } }, /* toyosato */
    { .label = {  43256,  4, 0 } }, /* yasu */

    /* entries 5629 to 5651 */
    { .label = { 146063,  5, 0 } }, /* akagi */
    { .label = {  11299,  3, 0 } }, /* ama */
    { .label = { 160811,  5, 0 } }, /* gotsu */
    { .label = { 147340,  6, 0 } }, /* hamada */
    { .label = {  43153, 12, 0 } }, /* higashiizumo */
    { .label = {  26461,  6, 0 } }, /* hikawa */
    { .label = { 147364,  6, 0 } }, /* hikimi */
    { .label = {  43183,  5, 0 } }, /* izumo */
    { .label = { 106724,  8, 0 } }, /* kakinoki */
    { .label = { 147391,  6, 0 } }, /* masuda */
    { .label = { 147416,  6, 0 } }, /* matsue */
    { .label = {  26487,  6, 0 } }, /* misato */
    { .label = {  43208, 12, 0 } }, /* nishinoshima */
    { .label = { 168257,  4, 0 } }, /* ohda */
    { .label = {  70935, 10, 0 } }, /* okinoshima */
    { .label = { 106758,  8, 0 } }, /* okuizumo */
    { .label = { 121996,  7, 0 } }, /* shimane */
    { .label = { 147441,  6, 0 } }, /* tamayu */
    { .label = { 126527,  7, 0 } }, /* tsuwano */
    { .label = { 160833,  5, 0 } }, /* unnan */
    { .label = { 144482,  6, 0 } }, /* yakumo */
    { .label = { 147467,  6, 0 } }, /* yasugi */
    { .label = { 126557,  7, 0 } }, /* yatsuka */

    /* entries 5652 to 5687 */
    { .label = {  66838,  4, 0 } }, /* arai */
    { .label = { 101433,  5, 0 } }, /* atami */
    { .label = {  19632,  4, 0 } }, /* fuji */
    { .label = { 126587,  7, 0 } }, /* fujieda */
    { .label = {  19632,  8, 0 } }, /* fujikawa */
    { .label = {  70977, 10, 0 } }, /* fujinomiya */
    { .label = { 126621,  7, 0 } }, /* fukuroi */
    { .label = { 126654,  7, 0 } }, /* gotemba */
    { .label = { 126685,  7, 0 } }, /* haibara */
    { .label = {  86653,  9, 0 } }, /* hamamatsu */
    { .label = {  43153, 10, 0 } }, /* higashiizu */
    { .label = {   3876,  3, 0 } }, /* ito */
    { .label = { 160853,  5, 0 } }, /* iwata */
    { .label = {  16920,  3, 0 } }, /* izu */
    { .label = {  86690,  9, 0 } }, /* izunokuni */
    { .label = { 106797,  8, 0 } }, /* kakegawa */
    { .label = { 126713,  7, 0 } }, /* kannami */
    { .label = {  86732,  9, 0 } }, /* kawanehon */
    { .label = { 147494,  6, 0 } }, /* kawazu */
    { .label = { 106831,  8, 0 } }, /* kikugawa */
    { .label = { 160268,  5, 0 } }, /* kosai */
    { .label = {  71025, 10, 0 } }, /* makinohara */
    { .label = {  86770,  9, 0 } }, /* matsuzaki */
    { .label = {  86810,  9, 0 } }, /* minamiizu */
    { .label = { 123165,  7, 0 } }, /* mishima */
    { .label = {  86851,  9, 0 } }, /* morimachi */
    { .label = { 106867,  8, 0 } }, /* nishiizu */
    { .label = { 147523,  6, 0 } }, /* numazu */
    { .label = { 106904,  8, 0 } }, /* omaezaki */
    { .label = { 126741,  7, 0 } }, /* shimada */
    { .label = {  55771,  7, 0 } }, /* shimizu */
    { .label = {  84528,  7, 0 } }, /* shimoda */
    { .label = {  99999,  8, 0 } }, /* shizuoka */
    { .label = { 147552,  6, 0 } }, /* susono */
    { .label = { 123321,  5, 0 } }, /* yaizu */
    { .label = {  56478,  7, 0 } }, /* yoshida */

    /* entries 5688 to 5718 */
    { .label = {  34056,  8, 0 } }, /* ashikaga */
    { .label = { 100993,  4, 0 } }, /* bato */
    { .label = { 168274,  4, 0 } }, /* haga */
    { .label = { 126770,  7, 0 } }, /* ichikai */
    { .label = { 126800,  7, 0 } }, /* iwafune */
    { .label = {  71065, 10, 0 } }, /* kaminokawa */
    { .label = { 147577,  6, 0 } }, /* kanuma */
    { .label = {  71107, 10, 0 } }, /* karasuyama */
    { .label = { 126832,  7, 0 } }, /* kuroiso */
    { .label = { 126862,  7, 0 } }, /* mashiko */
    { .label = { 168290,  4, 0 } }, /* mibu */
    { .label = {  55796,  4, 0 } }, /* moka */
    { .label = { 147602,  6, 0 } }, /* motegi */
    { .label = {  36253,  4, 0 } }, /* nasu */
    { .label = {  43258, 12, 0 } }, /* nasushiobara */
    { .label = { 160873,  5, 0 } }, /* nikko */
    { .label = {  86890,  9, 0 } }, /* nishikata */
    { .label = { 168310,  4, 0 } }, /* nogi */
    { .label = { 103684,  5, 0 } }, /* ohira */
    { .label = { 106939,  8, 0 } }, /* ohtawara */
    { .label = {  14734,  5, 0 } }, /* oyama */
    { .label = {  69957,  6, 0 } }, /* sakura */
    { .label = {  82818,  4, 0 } }, /* sano */
    { .label = {  71148, 10, 0 } }, /* shimotsuke */
    { .label = { 147628,  6, 0 } }, /* shioya */
    { .label = {  71192, 10, 0 } }, /* takanezawa */
    { .label = { 122025,  7, 0 } }, /* tochigi */
    { .label = {  55051,  5, 0 } }, /* tsuga */
    { .label = { 160895,  5, 0 } }, /* ujiie */
    { .label = {  71234, 10, 0 } }, /* utsunomiya */
    { .label = { 160919,  5, 0 } }, /* yaita */

    /* entries 5719 to 5735 */
    { .label = {  69627,  6, 0 } }, /* aizumi */
    { .label = {  14780,  4, 0 } }, /* anan */
    { .label = {  69470,  6, 0 } }, /* ichiba */
    { .label = { 160939,  5, 0 } }, /* itano */
    { .label = { 147654,  6, 0 } }, /* kainan */
    { .label = {  43307, 12, 0 } }, /* komatsushima */
    { .label = {  71278, 10, 0 } }, /* matsushige */
    { .label = {  70563,  4, 0 } }, /* mima */
    { .label = {  19306,  6, 0 } }, /* minami */
    { .label = {  14655,  7, 0 } }, /* miyoshi */
    { .label = { 168327,  4, 0 } }, /* mugi */
    { .label = { 101022,  8, 0 } }, /* nakagawa */
    { .label = { 147677,  6, 0 } }, /* naruto */
    { .label = {  86926,  9, 0 } }, /* sanagochi */
    { .label = {  86963,  9, 0 } }, /* shishikui */
    { .label = {  82221,  9, 0 } }, /* tokushima */
    { .label = { 147701,  6, 0 } }, /* wajiki */

    /* entries 5736 to 5792 */
    { .label = { 147730,  6, 0 } }, /* adachi */
    { .label = { 126892,  7, 0 } }, /* akiruno */
    { .label = { 106971,  8, 0 } }, /* akishima */
    { .label = {  87003,  9, 0 } }, /* aogashima */
    { .label = { 126348,  7, 0 } }, /* arakawa */
    { .label = { 147755,  6, 0 } }, /* bunkyo */
    { .label = { 123467,  7, 0 } }, /* chiyoda */
    { .label = { 160958,  5, 0 } }, /* chofu */
    { .label = {  55017,  4, 0 } }, /* chuo */
    { .label = { 104701,  7, 0 } }, /* edogawa */
    { .label = { 159079,  5, 0 } }, /* fuchu */
    { .label = { 160983,  5, 0 } }, /* fussa */
    { .label = { 126921,  7, 0 } }, /* hachijo */
    { .label = { 107004,  8, 0 } }, /* hachioji */
    { .label = { 147785,  6, 0 } }, /* hamura */
    { .label = {  34430, 13, 0 } }, /* higashikurume */
    { .label = {  19504, 15, 0 } }, /* higashimurayama */
    { .label = {  34488, 13, 0 } }, /* higashiyamato */
    { .label = {  26259,  4, 0 } }, /* hino */
    { .label = { 147810,  6, 0 } }, /* hinode */
    { .label = { 107041,  8, 0 } }, /* hinohara */
    { .label = { 161005,  5, 0 } }, /* inagi */
    { .label = { 107073,  8, 0 } }, /* itabashi */
    { .label = {  71321, 10, 0 } }, /* katsushika */
    { .label = {  26335,  4, 0 } }, /* kita */
    { .label = { 147836,  6, 0 } }, /* kiyose */
    { .label = { 126954,  7, 0 } }, /* kodaira */
    { .label = { 126982,  7, 0 } }, /* koganei */
    { .label = {  87039,  9, 0 } }, /* kokubunji */
    { .label = { 161025,  5, 0 } }, /* komae */
    { .label = { 103671,  4, 0 } }, /* koto */
    { .label = {  71363, 10, 0 } }, /* kouzushima */
    { .label = {  87084,  9, 0 } }, /* kunitachi */
    { .label = { 127011,  7, 0 } }, /* machida */
    { .label = { 147863,  6, 0 } }, /* meguro */
    { .label = {  56341,  6, 0 } }, /* minato */
    { .label = { 104824,  6, 0 } }, /* mitaka */
    { .label = { 147890,  6, 0 } }, /* mizuho */
    { .label = {  19568, 15, 0 } }, /* musashimurayama */
    { .label = {  87123,  9, 0 } }, /* musashino */
    { .label = { 101650,  6, 0 } }, /* nakano */
    { .label = { 147920,  6, 0 } }, /* nerima */
    { .label = {  87161,  9, 0 } }, /* ogasawara */
    { .label = { 127041,  7, 0 } }, /* okutama */
    { .label = {   3950,  3, 0 } }, /* ome */
    { .label = {  11092,  6, 0 } }, /* oshima */
    { .label = {   5500,  3, 0 } }, /* ota */
    { .label = { 107106,  8, 0 } }, /* setagaya */
    { .label = { 127070,  7, 0 } }, /* shibuya */
    { .label = {  87196,  9, 0 } }, /* shinagawa */
    { .label = { 107138,  8, 0 } }, /* shinjuku */
    { .label = { 107177,  8, 0 } }, /* suginami */
    { .label = { 142440,  6, 0 } }, /* sumida */
    { .label = {  87233,  9, 0 } }, /* tachikawa */
    { .label = {  79987,  5, 0 } }, /* taito */
    { .label = {  23484,  4, 0 } }, /* tama */
    { .label = {  11088,  7, 0 } }, /* toshima */

    /* entries 5793 to 5805 */
    { .label = {  85419,  5, 0 } }, /* chizu */
    { .label = {  26259,  4, 0 } }, /* hino */
    { .label = { 107211,  8, 0 } }, /* kawahara */
    { .label = {  42126,  4, 0 } }, /* koge */
    { .label = { 127103,  7, 0 } }, /* kotoura */
    { .label = { 147944,  6, 0 } }, /* misasa */
    { .label = { 161046,  5, 0 } }, /* nanbu */
    { .label = { 104766,  8, 0 } }, /* nichinan */
    { .label = {  56322, 11, 0 } }, /* sakaiminato */
    { .label = { 122056,  7, 0 } }, /* tottori */
    { .label = { 143214,  6, 0 } }, /* wakasa */
    { .label = { 145292,  4, 0 } }, /* yazu */
    { .label = { 147967,  6, 0 } }, /* yonago */

    /* entries 5806 to 5829 */
    { .label = {  69225,  5, 0 } }, /* asahi */
    { .label = { 159079,  5, 0 } }, /* fuchu */
    { .label = {  87271,  9, 0 } }, /* fukumitsu */
    { .label = {  87314,  9, 0 } }, /* funahashi */
    { .label = {  55775,  4, 0 } }, /* himi */
    { .label = {  55780,  5, 0 } }, /* imizu */
    { .label = {  19311,  5, 0 } }, /* inami */
    { .label = { 147993,  6, 0 } }, /* johana */
    { .label = { 107243,  8, 0 } }, /* kamiichi */
    { .label = { 148019,  6, 0 } }, /* kurobe */
    { .label = {  56365, 11, 0 } }, /* nakaniikawa */
    { .label = {  71410, 10, 0 } }, /* namerikawa */
    { .label = {  79356,  5, 0 } }, /* nanto */
    { .label = { 148047,  6, 0 } }, /* nyuzen */
    { .label = { 161068,  5, 0 } }, /* oyabe */
    { .label = { 161091,  5, 0 } }, /* taira */
    { .label = { 127132,  7, 0 } }, /* takaoka */
    { .label = { 100649,  8, 0 } }, /* tateyama */
    { .label = {  55056,  4, 0 } }, /* toga */
    { .label = { 100739,  6, 0 } }, /* tonami */
    { .label = {  14730,  6, 0 } }, /* toyama */
    { .label = { 127159,  7, 0 } }, /* unazuki */
    { .label = { 168346,  4, 0 } }, /* uozu */
    { .label = { 143539,  6, 0 } }, /* yamada */

    /* entries 5830 to 5858 */
    { .label = {  87353,  5, 0 } }, /* arida */
    { .label = {  87353,  9, 0 } }, /* aridagawa */
    { .label = { 164388,  4, 0 } }, /* gobo */
    { .label = {  87389,  9, 0 } }, /* hashimoto */
    { .label = { 144180,  6, 0 } }, /* hidaka */
    { .label = { 107278,  8, 0 } }, /* hirogawa */
    { .label = {  19311,  5, 0 } }, /* inami */
    { .label = {  44876,  5, 0 } }, /* iwade */
    { .label = { 147654,  6, 0 } }, /* kainan */
    { .label = {  87427,  9, 0 } }, /* kamitonda */
    { .label = {  85641,  9, 0 } }, /* katsuragi */
    { .label = { 148077,  6, 0 } }, /* kimino */
    { .label = { 107312,  8, 0 } }, /* kinokawa */
    { .label = {  34343,  8, 0 } }, /* kitayama */
    { .label = { 162001,  4, 0 } }, /* koya */
    { .label = { 107346,  4, 0 } }, /* koza */
    { .label = { 107346,  8, 0 } }, /* kozagawa */
    { .label = { 107382,  8, 0 } }, /* kudoyama */
    { .label = {  87464,  9, 0 } }, /* kushimoto */
    { .label = { 105980,  6, 0 } }, /* mihama */
    { .label = {  26487,  6, 0 } }, /* misato */
    { .label = {  34543, 13, 0 } }, /* nachikatsuura */
    { .label = { 143462,  6, 0 } }, /* shingu */
    { .label = {  87504,  9, 0 } }, /* shirahama */
    { .label = { 161109,  5, 0 } }, /* taiji */
    { .label = {  84882,  6, 0 } }, /* tanabe */
    { .label = { 100036,  8, 0 } }, /* wakayama */
    { .label = { 161131,  5, 0 } }, /* yuasa */
    { .label = { 126321,  4, 0 } }, /* yura */

    /* entries 5859 to 5892 */
    { .label = {  69225,  5, 0 } }, /* asahi */
    { .label = { 107418,  8, 0 } }, /* funagata */
    { .label = {  87540,  9, 0 } }, /* higashine */
    { .label = {  73520,  4, 0 } }, /* iide */
    { .label = { 144197,  6, 0 } }, /* kahoku */
    { .label = {  71451, 10, 0 } }, /* kaminoyama */
    { .label = { 101156,  8, 0 } }, /* kaneyama */
    { .label = {  84332,  9, 0 } }, /* kawanishi */
    { .label = {  71493, 10, 0 } }, /* mamurogawa */
    { .label = { 102239,  6, 0 } }, /* mikawa */
    { .label = {  19534,  8, 0 } }, /* murayama */
    { .label = { 161152,  5, 0 } }, /* nagai */
    { .label = { 107451,  8, 0 } }, /* nakayama */
    { .label = { 161171,  5, 0 } }, /* nanyo */
    { .label = {  87578,  9, 0 } }, /* nishikawa */
    { .label = {  87616,  9, 0 } }, /* obanazawa */
    { .label = {     21,  2, 0 } }, /* oe */
    { .label = {  55875,  5, 0 } }, /* oguni */
    { .label = { 148103,  6, 0 } }, /* ohkura */
    { .label = { 127192,  7, 0 } }, /* oishida */
    { .label = { 161192,  5, 0 } }, /* sagae */
    { .label = { 148129,  6, 0 } }, /* sakata */
    { .label = { 107483,  8, 0 } }, /* sakegawa */
    { .label = { 146283,  6, 0 } }, /* shinjo */
    { .label = {  87655,  9, 0 } }, /* shirataka */
    { .label = { 143489,  6, 0 } }, /* shonai */
    { .label = { 107516,  8, 0 } }, /* takahata */
    { .label = { 161211,  5, 0 } }, /* tendo */
    { .label = {  82883,  6, 0 } }, /* tozawa */
    { .label = { 107546,  8, 0 } }, /* tsuruoka */
    { .label = { 100070,  8, 0 } }, /* yamagata */
    { .label = { 107580,  8, 0 } }, /* yamanobe */
    { .label = { 107615,  8, 0 } }, /* yonezawa */
    { .label = { 146464,  4, 0 } }, /* yuza */

    /* entries 5893 to 5908 */
    { .label = {  14275,  3, 0 } }, /* abu */
    { .label = { 103174,  4, 0 } }, /* hagi */
    { .label = {  19219,  6, 0 } }, /* hikari */
    { .label = { 160963,  4, 0 } }, /* hofu */
    { .label = { 127221,  7, 0 } }, /* iwakuni */
    { .label = {  87690,  9, 0 } }, /* kudamatsu */
    { .label = { 161232,  5, 0 } }, /* mitou */
    { .label = { 106430,  6, 0 } }, /* nagato */
    { .label = {  11092,  6, 0 } }, /* oshima */
    { .label = {  56409, 11, 0 } }, /* shimonoseki */
    { .label = { 148151,  6, 0 } }, /* shunan */
    { .label = { 148176,  6, 0 } }, /* tabuse */
    { .label = { 107652,  8, 0 } }, /* tokuyama */
    { .label = { 142407,  6, 0 } }, /* toyota */
    { .label = {  51412,  3, 0 } }, /* ube */
    { .label = {  45854,  3, 0 } }, /* yuu */

    /* entries 5909 to 5936 */
    { .label = {  55017,  4, 0 } }, /* chuo */
    { .label = { 161254,  5, 0 } }, /* doshi */
    { .label = { 127252,  7, 0 } }, /* fuefuki */
    { .label = {  19632,  8, 0 } }, /* fujikawa */
    { .label = {  19632, 15, 0 } }, /* fujikawaguchiko */
    { .label = {  56456, 11, 0 } }, /* fujiyoshida */
    { .label = { 107687,  8, 0 } }, /* hayakawa */
    { .label = { 144205,  6, 0 } }, /* hokuto */
    { .label = {  26452, 14, 0 } }, /* ichikawamisato */
    { .label = {   2825,  3, 0 } }, /* kai */
    { .label = { 130073,  4, 0 } }, /* kofu */
    { .label = { 161276,  5, 0 } }, /* koshu */
    { .label = { 148202,  6, 0 } }, /* kosuge */
    { .label = {  56509, 11, 0 } }, /* minami-alps */
    { .label = { 148229,  6, 0 } }, /* minobu */
    { .label = {  87729,  9, 0 } }, /* nakamichi */
    { .label = { 161046,  5, 0 } }, /* nanbu */
    { .label = { 107721,  8, 0 } }, /* narusawa */
    { .label = { 107753,  8, 0 } }, /* nirasaki */
    { .label = {  43358, 12, 0 } }, /* nishikatsura */
    { .label = {  26251,  6, 0 } }, /* oshino */
    { .label = { 145126,  6, 0 } }, /* otsuki */
    { .label = { 158932,  5, 0 } }, /* showa */
    { .label = { 107784,  8, 0 } }, /* tabayama */
    { .label = {  43102,  5, 0 } }, /* tsuru */
    { .label = { 107817,  8, 0 } }, /* uenohara */
    { .label = {  71536, 10, 0 } }, /* yamanakako */
    { .label = {  82301,  9, 0 } }, /* yamanashi */

    /* entries 5937 to 5939 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5940, 1 } }, /* city */

    /* entry 5940 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5941 to 5943 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5944, 1 } }, /* city */

    /* entry 5944 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5945 to 5947 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5948, 1 } }, /* city */

    /* entry 5948 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5949 to 5951 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5952, 1 } }, /* city */

    /* entry 5952 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5953 to 5955 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5956, 1 } }, /* city */

    /* entry 5956 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5957 to 5959 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5960, 1 } }, /* city */

    /* entry 5960 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5961 to 5963 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  98160,  4, 1 } }, { .child = { 5964, 1 } }, /* city */

    /* entry 5964 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5965 to 5975 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 5976, 1 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 5976 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 5977 to 5982 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */

    /* entry 5983 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 5984 to 5990 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 5991 to 6007 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44385,  3, 0 } }, /* prd */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   2729,  3, 0 } }, /* ass */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = { 141213,  6, 0 } }, /* presse */
    { .label = { 120635,  7, 0 } }, /* medecin */
    { .label = {  99114,  8, 0 } }, /* notaires */
    { .label = {  56557, 11, 0 } }, /* pharmaciens */
    { .label = {  52479, 11, 0 } }, /* veterinaire */
    { .label = { 167752,  4, 0 } }, /* gouv */

    /* entries 6008 to 6011 */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 6012 to 6017 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  24388,  3, 0 } }, /* rep */
    { .label = {   3068,  3, 0 } }, /* tra */

    /* entries 6018 to 6047 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   3881,  2, 0 } }, /* hs */
    { .label = {   9000,  2, 0 } }, /* kg */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   5389,  2, 0 } }, /* pe */
    { .label = {     55,  2, 0 } }, /* re */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {  72536,  5, 0 } }, /* busan */
    { .label = { 107849,  8, 0 } }, /* chungbuk */
    { .label = { 107889,  8, 0 } }, /* chungnam */
    { .label = { 161299,  5, 0 } }, /* daegu */
    { .label = { 127287,  7, 0 } }, /* daejeon */
    { .label = { 127318,  7, 0 } }, /* gangwon */
    { .label = { 127349,  7, 0 } }, /* gwangju */
    { .label = {  87767,  9, 0 } }, /* gyeongbuk */
    { .label = { 107925,  8, 0 } }, /* gyeonggi */
    { .label = {  87811,  9, 0 } }, /* gyeongnam */
    { .label = { 127384,  7, 0 } }, /* incheon */
    { .label = { 168367,  4, 0 } }, /* jeju */
    { .label = { 127414,  7, 0 } }, /* jeonbuk */
    { .label = { 127449,  7, 0 } }, /* jeonnam */
    { .label = { 161321,  5, 0 } }, /* seoul */
    { .label = {   2312,  5, 0 } }, /* ulsan */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 6048 to 6054 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  20101,  3, 0 } }, /* emb */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6055 to 6059 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 6060 to 6066 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6067 to 6077 */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5389,  3, 0 } }, /* per */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   2762,  3, 0 } }, /* bnr */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6078 to 6082 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6083 to 6090 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44043,  3, 0 } }, /* nym */
    { .label = {    224,  2, 0 } }, /* oy */

    /* entries 6091 to 6094 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {    526,  3, 0 } }, /* caa */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6095 to 6109 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {   2773,  3, 0 } }, /* soc */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = { 168390,  4, 0 } }, /* assn */
    { .label = { 119167,  3, 0 } }, /* grp */
    { .label = {  60878,  5, 0 } }, /* hotel */
    { .label = {    103,  2, 0 } }, /* ac */

    /* entries 6110 to 6114 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 6115 to 6123 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    601,  2, 0 } }, /* sc */

    /* entries 6124 to 6126 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6127 to 6128 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6129 to 6137 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    143,  2, 0 } }, /* id */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   6682,  3, 0 } }, /* asn */
    { .label = {  65020,  4, 0 } }, /* conf */

    /* entries 6138 to 6146 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   2619,  3, 0 } }, /* plc */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    143,  2, 0 } }, /* id */

    /* entries 6147 to 6152 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  23006,  5, 0 } }, /* press */

    /* entries 6153 to 6154 */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {   2766,  4, 0 } }, /* asso */

    /* entry 6155 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 6156 to 6195 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  27938,  3, 0 } }, /* its */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = { 171753,  3, 0 } }, /* c66 */
    { .label = { 155872,  6, 1 } }, { .child = { 6196, 1 } }, /* daplie */
    { .label = {  65352,  8, 0 } }, /* filegear */
    { .label = {  65352, 11, 0 } }, /* filegear-au */
    { .label = {  65400, 11, 0 } }, /* filegear-de */
    { .label = {  65449, 11, 0 } }, /* filegear-gb */
    { .label = {  65500, 11, 0 } }, /* filegear-ie */
    { .label = {  65548, 11, 0 } }, /* filegear-jp */
    { .label = {  65601, 11, 0 } }, /* filegear-sg */
    { .label = { 156567,  6, 0 } }, /* glitch */
    { .label = {  97264,  7, 0 } }, /* ravendb */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 170848,  4, 0 } }, /* nctu */
    { .label = {  97651,  9, 0 } }, /* soundcast */
    { .label = { 170971,  4, 0 } }, /* tcp4 */
    { .label = { 118909,  8, 0 } }, /* brasilia */
    { .label = { 116839,  4, 0 } }, /* ddns */
    { .label = { 137128,  6, 0 } }, /* dnsfor */
    { .label = { 167142,  5, 0 } }, /* hopto */
    { .label = { 140079,  7, 0 } }, /* loginto */
    { .label = { 171027,  4, 0 } }, /* noip */
    { .label = { 156092,  6, 0 } }, /* webhop */
    { .label = {  44043,  3, 0 } }, /* nym */
    { .label = {   5493, 11, 0 } }, /* diskstation */
    { .label = { 140296,  7, 0 } }, /* dscloud */
    { .label = { 171103,  4, 0 } }, /* i234 */
    { .label = { 171132,  4, 0 } }, /* myds */
    { .label = {   5450,  8, 0 } }, /* synology */
    { .label = { 119751,  8, 0 } }, /* wedeploy */
    { .label = { 167640,  5, 0 } }, /* yombo */
    { .label = { 157702,  6, 0 } }, /* nohost */

    /* entry 6196 */
    { .label = {  96103,  9, 0 } }, /* localhost */

    /* entries 6197 to 6205 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44385,  3, 0 } }, /* prd */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 6206 to 6214 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5417,  3, 0 } }, /* inf */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 6215 to 6221 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = { 167752,  4, 0 } }, /* gouv */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 141213,  6, 0 } }, /* presse */

    /* entry 6222 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6223 to 6227 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 112281,  3, 0 } }, /* nyc */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6228 to 6232 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 6233 to 6234 */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 140296,  7, 0 } }, /* dscloud */

    /* entries 6235 to 6236 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 6237 to 6242 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   8680,  3, 0 } }, /* lab */

    /* entries 6243 to 6247 */
    { .label = {    106,  3, 1 } }, { .child = { 6248, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 6248 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 6249 to 6255 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     47,  2, 0 } }, /* or */

    /* entries 6256 to 6803 */
    { .label = { 127480,  7, 0 } }, /* academy */
    { .label = {  56604, 11, 0 } }, /* agriculture */
    { .label = {   2836,  3, 0 } }, /* air */
    { .label = { 107962,  8, 0 } }, /* airguard */
    { .label = { 127511,  7, 0 } }, /* alabama */
    { .label = { 148257,  6, 0 } }, /* alaska */
    { .label = {  89320,  5, 0 } }, /* amber */
    { .label = {  81307,  9, 0 } }, /* ambulance */
    { .label = {  14755,  8, 0 } }, /* american */
    { .label = {  14755,  9, 0 } }, /* americana */
    { .label = {  14755, 16, 0 } }, /* americanantiques */
    { .label = {  56652, 11, 0 } }, /* americanart */
    { .label = {  87851,  9, 0 } }, /* amsterdam */
    { .label = {    351,  3, 0 } }, /* and */
    { .label = {  87888,  9, 0 } }, /* annefrank */
    { .label = {  43407,  6, 0 } }, /* anthro */
    { .label = {  43407, 12, 0 } }, /* anthropology */
    { .label = {  14787,  8, 0 } }, /* antiques */
    { .label = { 107995,  8, 0 } }, /* aquarium */
    { .label = {  87925,  9, 0 } }, /* arboretum */
    { .label = {  26511, 14, 0 } }, /* archaeological */
    { .label = {  56695, 11, 0 } }, /* archaeology */
    { .label = {  43461, 12, 0 } }, /* architecture */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {  43512, 12, 0 } }, /* artanddesign */
    { .label = {  87964,  9, 0 } }, /* artcenter */
    { .label = { 127539,  7, 0 } }, /* artdeco */
    { .label = {  43561, 12, 0 } }, /* arteducation */
    { .label = {  71577, 10, 0 } }, /* artgallery */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {  34597, 13, 0 } }, /* artsandcrafts */
    { .label = { 108032,  8, 0 } }, /* asmatart */
    { .label = {  34650, 13, 0 } }, /* assassination */
    { .label = { 148280,  6, 0 } }, /* assisi */
    { .label = {   2766, 11, 0 } }, /* association */
    { .label = {  88000,  9, 0 } }, /* astronomy */
    { .label = { 127568,  7, 0 } }, /* atlanta */
    { .label = { 148303,  6, 0 } }, /* austin */
    { .label = {  88038,  9, 0 } }, /* australia */
    { .label = {  71620, 10, 0 } }, /* automotive */
    { .label = {  32497,  8, 0 } }, /* aviation */
    { .label = {  64356,  4, 0 } }, /* axis */
    { .label = { 127594,  7, 0 } }, /* badajoz */
    { .label = { 127629,  7, 0 } }, /* baghdad */
    { .label = {  88528,  4, 0 } }, /* bahn */
    { .label = {  31008,  4, 0 } }, /* bale */
    { .label = {  88073,  9, 0 } }, /* baltimore */
    { .label = {  88112,  9, 0 } }, /* barcelona */
    { .label = { 108062,  8, 0 } }, /* baseball */
    { .label = { 161343,  5, 0 } }, /* basel */
    { .label = { 161365,  5, 0 } }, /* baths */
    { .label = { 148327,  6, 0 } }, /* bauern */
    { .label = {  88150,  9, 0 } }, /* beauxarts */
    { .label = {  34699, 13, 0 } }, /* beeldengeluid */
    { .label = { 108098,  8, 0 } }, /* bellevue */
    { .label = { 127661,  7, 0 } }, /* bergbau */
    { .label = { 108137,  8, 0 } }, /* berkeley */
    { .label = {  79817,  6, 0 } }, /* berlin */
    { .label = {  52445,  4, 0 } }, /* bern */
    { .label = { 161387,  5, 0 } }, /* bible */
    { .label = { 148353,  6, 0 } }, /* bilbao */
    { .label = { 168405,  4, 0 } }, /* bill */
    { .label = { 127694,  7, 0 } }, /* birdart */
    { .label = {  71663, 10, 0 } }, /* birthplace */
    { .label = { 168425,  4, 0 } }, /* bonn */
    { .label = { 148381,  6, 0 } }, /* boston */
    { .label = {  19704,  9, 0 } }, /* botanical */
    { .label = {  19704, 15, 0 } }, /* botanicalgarden */
    { .label = {  34759, 13, 0 } }, /* botanicgarden */
    { .label = { 148407,  6, 0 } }, /* botany */
    { .label = {  14823, 16, 0 } }, /* brandywinevalley */
    { .label = { 118909,  6, 0 } }, /* brasil */
    { .label = { 127724,  7, 0 } }, /* bristol */
    { .label = {  19767,  7, 0 } }, /* british */
    { .label = {  19767, 15, 0 } }, /* britishcolumbia */
    { .label = {  88189,  9, 0 } }, /* broadcast */
    { .label = { 148434,  6, 0 } }, /* brunel */
    { .label = { 108175,  7, 0 } }, /* brussel */
    { .label = { 108175,  8, 0 } }, /* brussels */
    { .label = {  88227,  9, 0 } }, /* bruxelles */
    { .label = { 108211,  8, 0 } }, /* building */
    { .label = { 127755,  7, 0 } }, /* burghof */
    { .label = {   2959,  3, 0 } }, /* bus */
    { .label = { 148462,  6, 0 } }, /* bushey */
    { .label = { 108249,  8, 0 } }, /* cadaques */
    { .label = {  71709, 10, 0 } }, /* california */
    { .label = {  88270,  9, 0 } }, /* cambridge */
    { .label = {  14775,  3, 0 } }, /* can */
    { .label = { 148492,  6, 0 } }, /* canada */
    { .label = {  71751, 10, 0 } }, /* capebreton */
    { .label = { 127790,  7, 0 } }, /* carrier */
    { .label = {  71795, 10, 0 } }, /* cartoonart */
    { .label = {  26570, 14, 0 } }, /* casadelamoneda */
    { .label = { 148515,  6, 0 } }, /* castle */
    { .label = { 127818,  7, 0 } }, /* castres */
    { .label = {  24192,  6, 0 } }, /* celtic */
    { .label = {  26784,  6, 0 } }, /* center */
    { .label = {  56743, 11, 0 } }, /* chattanooga */
    { .label = {  71834, 10, 0 } }, /* cheltenham */
    { .label = {  34814, 13, 0 } }, /* chesapeakebay */
    { .label = { 127846,  7, 0 } }, /* chicago */
    { .label = {  19835,  8, 0 } }, /* children */
    { .label = {  19835,  9, 0 } }, /* childrens */
    { .label = {  19835, 15, 0 } }, /* childrensgarden */
    { .label = {  43610, 12, 0 } }, /* chiropractic */
    { .label = {  88311,  9, 0 } }, /* chocolate */
    { .label = {  26627, 14, 0 } }, /* christiansburg */
    { .label = {  71878, 10, 0 } }, /* cincinnati */
    { .label = { 148540,  6, 0 } }, /* cinema */
    { .label = { 148565,  6, 0 } }, /* circus */
    { .label = {  43663, 12, 0 } }, /* civilisation */
    { .label = {  43714, 12, 0 } }, /* civilization */
    { .label = { 108286,  8, 0 } }, /* civilwar */
    { .label = { 127877,  7, 0 } }, /* clinton */
    { .label = {  20606,  5, 0 } }, /* clock */
    { .label = {  32164,  4, 0 } }, /* coal */
    { .label = {  26688, 14, 0 } }, /* coastaldefence */
    { .label = { 168443,  4, 0 } }, /* cody */
    { .label = { 127907,  7, 0 } }, /* coldwar */
    { .label = {  71919, 10, 0 } }, /* collection */
    { .label = {   4201, 20, 0 } }, /* colonialwilliamsburg */
    { .label = {  19900, 15, 0 } }, /* coloradoplateau */
    { .label = {  19798,  8, 0 } }, /* columbia */
    { .label = { 108323,  8, 0 } }, /* columbus */
    { .label = {    385, 13, 0 } }, /* communication */
    { .label = {    385, 14, 0 } }, /* communications */
    { .label = {  88350,  9, 0 } }, /* community */
    { .label = {  19964,  8, 0 } }, /* computer */
    { .label = {  19964, 15, 0 } }, /* computerhistory */
    { .label = {   4291, 20, 0 } }, /* xn--comunicaes-v6a2o */
    { .label = {  20032, 12, 0 } }, /* contemporary */
    { .label = {  20032, 15, 0 } }, /* contemporaryart */
    { .label = { 127939,  7, 0 } }, /* convent */
    { .label = {  71963, 10, 0 } }, /* copenhagen */
    { .label = {  56787, 11, 0 } }, /* corporation */
    { .label = {     22, 36, 0 } }, /* xn--correios-e-telecomunicaes-ghc29a */
    { .label = { 108362,  8, 0 } }, /* corvette */
    { .label = { 127970,  7, 0 } }, /* costume */
    { .label = {  20438, 13, 0 } }, /* countryestate */
    { .label = { 148592,  6, 0 } }, /* county */
    { .label = {  34624,  6, 0 } }, /* crafts */
    { .label = {  88392,  9, 0 } }, /* cranbrook */
    { .label = {  67286,  8, 0 } }, /* creation */
    { .label = {  26748,  8, 0 } }, /* cultural */
    { .label = {  26748, 14, 0 } }, /* culturalcenter */
    { .label = {  56620,  7, 0 } }, /* culture */
    { .label = { 161412,  5, 0 } }, /* cyber */
    { .label = { 161437,  5, 0 } }, /* cymru */
    { .label = {  44426,  4, 0 } }, /* dali */
    { .label = { 148620,  6, 0 } }, /* dallas */
    { .label = { 108397,  8, 0 } }, /* database */
    { .label = {  67398,  3, 0 } }, /* ddr */
    { .label = {  15248, 14, 0 } }, /* decorativearts */
    { .label = {  20395,  8, 0 } }, /* delaware */
    { .label = {  56833, 11, 0 } }, /* delmenhorst */
    { .label = { 128001,  7, 0 } }, /* denmark */
    { .label = {  94484,  5, 0 } }, /* depot */
    { .label = {  26966,  6, 0 } }, /* design */
    { .label = { 128031,  7, 0 } }, /* detroit */
    { .label = { 108429,  8, 0 } }, /* dinosaur */
    { .label = {  88431,  9, 0 } }, /* discovery */
    { .label = { 161462,  5, 0 } }, /* dolls */
    { .label = { 108462,  8, 0 } }, /* donostia */
    { .label = { 148645,  6, 0 } }, /* durham */
    { .label = {  72007, 10, 0 } }, /* eastafrica */
    { .label = {  88473,  9, 0 } }, /* eastcoast */
    { .label = {  43572,  9, 0 } }, /* education */
    { .label = {  56881, 11, 0 } }, /* educational */
    { .label = { 108494,  8, 0 } }, /* egyptian */
    { .label = {  88508,  9, 0 } }, /* eisenbahn */
    { .label = { 148672,  6, 0 } }, /* elburg */
    { .label = {  72047, 10, 0 } }, /* elvendrell */
    { .label = {  72093, 10, 0 } }, /* embroidery */
    { .label = {  43768, 12, 0 } }, /* encyclopedic */
    { .label = { 128060,  7, 0 } }, /* england */
    { .label = {  72139, 10, 0 } }, /* entomology */
    { .label = {    561, 11, 0 } }, /* environment */
    { .label = {    561, 25, 0 } }, /* environmentalconservation */
    { .label = { 108530,  8, 0 } }, /* epilepsy */
    { .label = { 161485,  5, 0 } }, /* essex */
    { .label = {  20470,  6, 0 } }, /* estate */
    { .label = {  88546,  9, 0 } }, /* ethnology */
    { .label = { 148701,  6, 0 } }, /* exeter */
    { .label = {  72184, 10, 0 } }, /* exhibition */
    { .label = {  29712,  6, 0 } }, /* family */
    { .label = {  13412,  4, 0 } }, /* farm */
    { .label = {  34872, 13, 0 } }, /* farmequipment */
    { .label = { 128090,  7, 0 } }, /* farmers */
    { .label = {  88587,  9, 0 } }, /* farmstead */
    { .label = { 161507,  5, 0 } }, /* field */
    { .label = { 108569,  8, 0 } }, /* figueres */
    { .label = {  88625,  9, 0 } }, /* filatelia */
    { .label = {  81295,  4, 0 } }, /* film */
    { .label = { 108605,  7, 0 } }, /* fineart */
    { .label = { 108605,  8, 0 } }, /* finearts */
    { .label = { 128120,  7, 0 } }, /* finland */
    { .label = { 108638,  8, 0 } }, /* flanders */
    { .label = { 128151,  7, 0 } }, /* florida */
    { .label = { 113957,  5, 0 } }, /* force */
    { .label = {  43825, 12, 0 } }, /* fortmissoula */
    { .label = {  88663,  9, 0 } }, /* fortworth */
    { .label = {  72229, 10, 0 } }, /* foundation */
    { .label = {  88704,  9, 0 } }, /* francaise */
    { .label = {  88741,  9, 0 } }, /* frankfurt */
    { .label = {  43877, 12, 0 } }, /* franziskaner */
    { .label = {  56927, 11, 0 } }, /* freemasonry */
    { .label = { 108673,  8, 0 } }, /* freiburg */
    { .label = { 108711,  8, 0 } }, /* fribourg */
    { .label = { 134445,  4, 0 } }, /* frog */
    { .label = { 108749,  8, 0 } }, /* fundacio */
    { .label = {  88782,  9, 0 } }, /* furniture */
    { .label = {  71588,  7, 0 } }, /* gallery */
    { .label = {  19742,  6, 0 } }, /* garden */
    { .label = {  17800,  7, 0 } }, /* gateway */
    { .label = {  88822,  9, 0 } }, /* geelvinck */
    { .label = {  56975, 11, 0 } }, /* gemological */
    { .label = { 128182,  7, 0 } }, /* geology */
    { .label = { 128215,  7, 0 } }, /* georgia */
    { .label = { 128244,  7, 0 } }, /* giessen */
    { .label = { 161531,  4, 0 } }, /* glas */
    { .label = { 161531,  5, 0 } }, /* glass */
    { .label = { 161552,  5, 0 } }, /* gorge */
    { .label = {  57024, 11, 0 } }, /* grandrapids */
    { .label = { 168463,  4, 0 } }, /* graz */
    { .label = { 108785,  8, 0 } }, /* guernsey */
    { .label = {  72272, 10, 0 } }, /* halloffame */
    { .label = { 128273,  7, 0 } }, /* hamburg */
    { .label = { 128306,  7, 0 } }, /* handson */
    { .label = {   8719, 18, 0 } }, /* harvestcelebration */
    { .label = { 148727,  6, 0 } }, /* hawaii */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {  26809, 14, 0 } }, /* heimatunduhren */
    { .label = { 148752,  6, 0 } }, /* hellas */
    { .label = { 108821,  8, 0 } }, /* helsinki */
    { .label = {  20096, 15, 0 } }, /* hembygdsforbund */
    { .label = {  15137,  8, 0 } }, /* heritage */
    { .label = { 108856,  8, 0 } }, /* histoire */
    { .label = {  11117, 10, 0 } }, /* historical */
    { .label = {  11117, 17, 0 } }, /* historicalsociety */
    { .label = {  26870, 14, 0 } }, /* historichouses */
    { .label = {   6638, 10, 0 } }, /* historisch */
    { .label = {   6638, 12, 0 } }, /* historisches */
    { .label = {   4417,  7, 0 } }, /* history */
    { .label = {  14898, 16, 0 } }, /* historyofscience */
    { .label = { 108889,  8, 0 } }, /* horology */
    { .label = {  26904,  5, 0 } }, /* house */
    { .label = {  72318, 10, 0 } }, /* humanities */
    { .label = {  43929, 12, 0 } }, /* illustration */
    { .label = {  34934, 13, 0 } }, /* imageandsound */
    { .label = {  43979,  6, 0 } }, /* indian */
    { .label = {  43979,  7, 0 } }, /* indiana */
    { .label = {  43979, 12, 0 } }, /* indianapolis */
    { .label = {  44029, 12, 0 } }, /* indianmarket */
    { .label = {  44078, 12, 0 } }, /* intelligence */
    { .label = {  57071, 11, 0 } }, /* interactive */
    { .label = { 168482,  4, 0 } }, /* iraq */
    { .label = {    575,  4, 0 } }, /* iron */
    { .label = {  88864,  9, 0 } }, /* isleofman */
    { .label = { 128335,  7, 0 } }, /* jamison */
    { .label = {  88903,  9, 0 } }, /* jefferson */
    { .label = {  88946,  9, 0 } }, /* jerusalem */
    { .label = { 128366,  7, 0 } }, /* jewelry */
    { .label = {  88987,  6, 0 } }, /* jewish */
    { .label = {  88987,  9, 0 } }, /* jewishart */
    { .label = { 171467,  3, 0 } }, /* jfk */
    { .label = {  72360, 10, 0 } }, /* journalism */
    { .label = { 128402,  7, 0 } }, /* judaica */
    { .label = {  57117, 11, 0 } }, /* judygarland */
    { .label = {  72405, 10, 0 } }, /* juedisches */
    { .label = { 168501,  4, 0 } }, /* juif */
    { .label = { 148778,  6, 0 } }, /* karate */
    { .label = {  89028,  9, 0 } }, /* karikatur */
    { .label = { 129894,  4, 0 } }, /* kids */
    { .label = {  72452, 10, 0 } }, /* koebenhavn */
    { .label = { 161574,  5, 0 } }, /* koeln */
    { .label = {  26930,  5, 0 } }, /* kunst */
    { .label = {  34989, 13, 0 } }, /* kunstsammlung */
    { .label = {  26930, 14, 0 } }, /* kunstunddesign */
    { .label = { 161596,  5, 0 } }, /* labor */
    { .label = { 148801,  6, 0 } }, /* labour */
    { .label = { 128434,  7, 0 } }, /* lajolla */
    { .label = {  72497, 10, 0 } }, /* lancashire */
    { .label = { 148828,  6, 0 } }, /* landes */
    { .label = {  16674,  4, 0 } }, /* lans */
    { .label = {  57169, 11, 0 } }, /* xn--lns-qla */
    { .label = { 128466,  7, 0 } }, /* larsson */
    { .label = {  57223, 11, 0 } }, /* lewismiller */
    { .label = { 128494,  7, 0 } }, /* lincoln */
    { .label = { 119399,  4, 0 } }, /* linz */
    { .label = {  20502,  6, 0 } }, /* living */
    { .label = {  20502, 13, 0 } }, /* livinghistory */
    { .label = {  44130, 12, 0 } }, /* localhistory */
    { .label = { 148853,  6, 0 } }, /* london */
    { .label = {  72538, 10, 0 } }, /* losangeles */
    { .label = { 148879,  6, 0 } }, /* louvre */
    { .label = { 108926,  8, 0 } }, /* loyalist */
    { .label = { 128525,  7, 0 } }, /* lucerne */
    { .label = {  72580, 10, 0 } }, /* luxembourg */
    { .label = { 148907,  6, 0 } }, /* luzern */
    { .label = {  13386,  3, 0 } }, /* mad */
    { .label = { 148936,  6, 0 } }, /* madrid */
    { .label = { 108961,  8, 0 } }, /* mallorca */
    { .label = {  72629, 10, 0 } }, /* manchester */
    { .label = { 108995,  7, 0 } }, /* mansion */
    { .label = { 108995,  8, 0 } }, /* mansions */
    { .label = { 168523,  4, 0 } }, /* manx */
    { .label = { 128556,  7, 0 } }, /* marburg */
    { .label = { 109027,  8, 0 } }, /* maritime */
    { .label = { 109060,  8, 0 } }, /* maritimo */
    { .label = { 109093,  8, 0 } }, /* maryland */
    { .label = {  72671, 10, 0 } }, /* marylhurst */
    { .label = {  97740,  5, 0 } }, /* media */
    { .label = { 128588,  7, 0 } }, /* medical */
    { .label = {   6605, 19, 0 } }, /* medizinhistorisches */
    { .label = { 148962,  6, 0 } }, /* meeres */
    { .label = { 109128,  8, 0 } }, /* memorial */
    { .label = {  89065,  9, 0 } }, /* mesaverde */
    { .label = { 109162,  8, 0 } }, /* michigan */
    { .label = {  57273, 11, 0 } }, /* midatlantic */
    { .label = { 109197,  8, 0 } }, /* military */
    { .label = {  57246,  4, 0 } }, /* mill */
    { .label = { 148987,  6, 0 } }, /* miners */
    { .label = { 149012,  6, 0 } }, /* mining */
    { .label = {  89104,  9, 0 } }, /* minnesota */
    { .label = { 128619,  7, 0 } }, /* missile */
    { .label = {  43843,  8, 0 } }, /* missoula */
    { .label = { 149038,  6, 0 } }, /* modern */
    { .label = { 100964,  4, 0 } }, /* moma */
    { .label = { 161618,  5, 0 } }, /* money */
    { .label = { 109232,  8, 0 } }, /* monmouth */
    { .label = {  72716, 10, 0 } }, /* monticello */
    { .label = { 109268,  8, 0 } }, /* montreal */
    { .label = { 149064,  6, 0 } }, /* moscow */
    { .label = {  60953, 10, 0 } }, /* motorcycle */
    { .label = { 109301,  8, 0 } }, /* muenchen */
    { .label = { 109337,  8, 0 } }, /* muenster */
    { .label = { 109371,  8, 0 } }, /* mulhouse */
    { .label = { 149092,  6, 0 } }, /* muncie */
    { .label = { 149119,  6, 0 } }, /* museet */
    { .label = {  44183, 12, 0 } }, /* museumcenter */
    { .label = {  14969, 16, 0 } }, /* museumvereniging */
    { .label = {  39467,  5, 0 } }, /* music */
    { .label = {  15041,  8, 0 } }, /* national */
    { .label = {  15041, 16, 0 } }, /* nationalfirearms */
    { .label = {  15106, 16, 0 } }, /* nationalheritage */
    { .label = {  26992, 14, 0 } }, /* nativeamerican */
    { .label = {   4389, 14, 0 } }, /* naturalhistory */
    { .label = {   4389, 20, 0 } }, /* naturalhistorymuseum */
    { .label = {  20170, 15, 0 } }, /* naturalsciences */
    { .label = {   8908,  6, 0 } }, /* nature */
    { .label = {  11190, 17, 0 } }, /* naturhistorisches */
    { .label = {   6689, 19, 0 } }, /* natuurwetenschappen */
    { .label = { 109408,  8, 0 } }, /* naumburg */
    { .label = { 161641,  5, 0 } }, /* naval */
    { .label = { 109445,  8, 0 } }, /* nebraska */
    { .label = { 161662,  5, 0 } }, /* neues */
    { .label = {  44236, 12, 0 } }, /* newhampshire */
    { .label = {  89140,  9, 0 } }, /* newjersey */
    { .label = {  89183,  9, 0 } }, /* newmexico */
    { .label = { 128649,  7, 0 } }, /* newport */
    { .label = {  89225,  9, 0 } }, /* newspaper */
    { .label = { 128681,  7, 0 } }, /* newyork */
    { .label = { 149145,  6, 0 } }, /* niepce */
    { .label = { 128714,  7, 0 } }, /* norfolk */
    { .label = {    734,  5, 0 } }, /* north */
    { .label = {   8539,  3, 0 } }, /* nrw */
    { .label = {  89266,  9, 0 } }, /* nuernberg */
    { .label = {  89306,  9, 0 } }, /* nuremberg */
    { .label = { 112281,  3, 0 } }, /* nyc */
    { .label = { 168541,  4, 0 } }, /* nyny */
    { .label = {  35047, 13, 0 } }, /* oceanographic */
    { .label = {  20232, 15, 0 } }, /* oceanographique */
    { .label = { 161683,  5, 0 } }, /* omaha */
    { .label = {  65926,  6, 0 } }, /* online */
    { .label = { 128746,  7, 0 } }, /* ontario */
    { .label = { 128773,  7, 0 } }, /* openair */
    { .label = {  57319,  6, 0 } }, /* oregon */
    { .label = {  57319, 11, 0 } }, /* oregontrail */
    { .label = { 161703,  5, 0 } }, /* otago */
    { .label = { 149172,  6, 0 } }, /* oxford */
    { .label = { 128802,  7, 0 } }, /* pacific */
    { .label = {  89347,  9, 0 } }, /* paderborn */
    { .label = { 149201,  6, 0 } }, /* palace */
    { .label = { 118425,  5, 0 } }, /* paleo */
    { .label = {  57364, 11, 0 } }, /* palmsprings */
    { .label = {  26269,  6, 0 } }, /* panama */
    { .label = { 161723,  5, 0 } }, /* paris */
    { .label = { 109478,  8, 0 } }, /* pasadena */
    { .label = { 109510,  8, 0 } }, /* pharmacy */
    { .label = {  15170, 12, 0 } }, /* philadelphia */
    { .label = {  15170, 16, 0 } }, /* philadelphiaarea */
    { .label = {  89387,  9, 0 } }, /* philately */
    { .label = { 128835,  7, 0 } }, /* phoenix */
    { .label = {  57414, 11, 0 } }, /* photography */
    { .label = { 149227,  6, 0 } }, /* pilots */
    { .label = {  72760, 10, 0 } }, /* pittsburgh */
    { .label = {  57466, 11, 0 } }, /* planetarium */
    { .label = {  72807, 10, 0 } }, /* plantation */
    { .label = { 149254,  6, 0 } }, /* plants */
    { .label = { 161744,  5, 0 } }, /* plaza */
    { .label = { 149280,  6, 0 } }, /* portal */
    { .label = { 109547,  8, 0 } }, /* portland */
    { .label = {  72848, 10, 0 } }, /* portlligat */
    { .label = {    324, 28, 0 } }, /* posts-and-telecommunications */
    { .label = {  44290, 12, 0 } }, /* preservation */
    { .label = { 109582,  8, 0 } }, /* presidio */
    { .label = {  23006,  5, 0 } }, /* press */
    { .label = {  40207,  7, 0 } }, /* project */
    { .label = {  24396,  6, 0 } }, /* public */
    { .label = { 161768,  5, 0 } }, /* pubol */
    { .label = { 149306,  6, 0 } }, /* quebec */
    { .label = { 109617,  8, 0 } }, /* railroad */
    { .label = { 128868,  7, 0 } }, /* railway */
    { .label = {  29922,  8, 0 } }, /* research */
    { .label = {  72892, 10, 0 } }, /* resistance */
    { .label = {  44341, 12, 0 } }, /* riodejaneiro */
    { .label = {  89429,  9, 0 } }, /* rochester */
    { .label = { 128899,  7, 0 } }, /* rockart */
    { .label = {  23135,  4, 0 } }, /* roma */
    { .label = { 149338,  6, 0 } }, /* russia */
    { .label = {  72932, 10, 0 } }, /* saintlouis */
    { .label = {  32680,  5, 0 } }, /* salem */
    { .label = {  44392, 12, 0 } }, /* salvadordali */
    { .label = { 109649,  8, 0 } }, /* salzburg */
    { .label = { 109688,  8, 0 } }, /* sandiego */
    { .label = {  44443, 12, 0 } }, /* sanfrancisco */
    { .label = {  44493, 12, 0 } }, /* santabarbara */
    { .label = {  89467,  9, 0 } }, /* santacruz */
    { .label = { 128928,  7, 0 } }, /* santafe */
    { .label = {  44540, 12, 0 } }, /* saskatchewan */
    { .label = { 168561,  4, 0 } }, /* satx */
    { .label = {  72973, 10, 0 } }, /* savannahga */
    { .label = {  44590, 12, 0 } }, /* schlesisches */
    { .label = {  57513, 11, 0 } }, /* schoenbrunn */
    { .label = {  57562, 11, 0 } }, /* schokoladen */
    { .label = { 149362,  6, 0 } }, /* school */
    { .label = { 128956,  7, 0 } }, /* schweiz */
    { .label = {   8796,  7, 0 } }, /* science */
    { .label = {  11261, 17, 0 } }, /* scienceandhistory */
    { .label = {   8796, 18, 0 } }, /* scienceandindustry */
    { .label = {  27049, 13, 0 } }, /* sciencecenter */
    { .label = {  27049, 14, 0 } }, /* sciencecenters */
    { .label = {  20300, 15, 0 } }, /* science-fiction */
    { .label = {  27108, 14, 0 } }, /* sciencehistory */
    { .label = {   8874,  8, 0 } }, /* sciences */
    { .label = {   8874, 18, 0 } }, /* sciencesnaturelles */
    { .label = { 109721,  8, 0 } }, /* scotland */
    { .label = { 128991,  7, 0 } }, /* seaport */
    { .label = {  73013, 10, 0 } }, /* settlement */
    { .label = { 109755,  8, 0 } }, /* settlers */
    { .label = { 161794,  5, 0 } }, /* shell */
    { .label = {  73055, 10, 0 } }, /* sherbrooke */
    { .label = { 129020,  7, 0 } }, /* sibenik */
    { .label = { 168578,  4, 0 } }, /* silk */
    { .label = {   6441,  3, 0 } }, /* ski */
    { .label = { 161817,  5, 0 } }, /* skole */
    { .label = {  11159,  7, 0 } }, /* society */
    { .label = { 129051,  7, 0 } }, /* sologne */
    { .label = {  27169, 14, 0 } }, /* soundandvision */
    { .label = {  35103, 13, 0 } }, /* southcarolina */
    { .label = {  89506,  9, 0 } }, /* southwest */
    { .label = {  40011,  5, 0 } }, /* space */
    { .label = {  92080,  3, 0 } }, /* spy */
    { .label = { 136584,  6, 0 } }, /* square */
    { .label = {  92476,  5, 0 } }, /* stadt */
    { .label = { 109788,  8, 0 } }, /* stalbans */
    { .label = {  89546,  9, 0 } }, /* starnberg */
    { .label = {  20366,  5, 0 } }, /* state */
    { .label = {  20366, 15, 0 } }, /* stateofdelaware */
    { .label = {   5511,  7, 0 } }, /* station */
    { .label = {  22952,  5, 0 } }, /* steam */
    { .label = {  73099, 10, 0 } }, /* steiermark */
    { .label = { 149389,  6, 0 } }, /* stjohn */
    { .label = {  89584,  9, 0 } }, /* stockholm */
    { .label = {  44643, 12, 0 } }, /* stpetersburg */
    { .label = {  89625,  9, 0 } }, /* stuttgart */
    { .label = { 149417,  6, 0 } }, /* suisse */
    { .label = {  44697, 12, 0 } }, /* surgeonshall */
    { .label = { 149442,  6, 0 } }, /* surrey */
    { .label = { 109821,  8, 0 } }, /* svizzera */
    { .label = { 149469,  6, 0 } }, /* sweden */
    { .label = { 149496,  6, 0 } }, /* sydney */
    { .label = {  55985,  4, 0 } }, /* tank */
    { .label = {  26150,  3, 0 } }, /* tcm */
    { .label = {  73140, 10, 0 } }, /* technology */
    { .label = {  11334, 17, 0 } }, /* telekommunikation */
    { .label = {  73186, 10, 0 } }, /* television */
    { .label = { 161839,  5, 0 } }, /* texas */
    { .label = { 129081,  7, 0 } }, /* textile */
    { .label = { 129112,  7, 0 } }, /* theater */
    { .label = {  57610,  4, 0 } }, /* time */
    { .label = {  57610, 11, 0 } }, /* timekeeping */
    { .label = { 109860,  8, 0 } }, /* topology */
    { .label = { 142068,  6, 0 } }, /* torino */
    { .label = { 105514,  5, 0 } }, /* touch */
    { .label = {  17903,  4, 0 } }, /* town */
    { .label = {  67488,  9, 0 } }, /* transport */
    { .label = {  78788,  4, 0 } }, /* tree */
    { .label = { 129140,  7, 0 } }, /* trolley */
    { .label = {  75081,  5, 0 } }, /* trust */
    { .label = { 129172,  7, 0 } }, /* trustee */
    { .label = {  26848,  5, 0 } }, /* uhren */
    { .label = {  29205,  3, 0 } }, /* ulm */
    { .label = { 109898,  8, 0 } }, /* undersea */
    { .label = {  73229, 10, 0 } }, /* university */
    { .label = {  13094,  3, 0 } }, /* usa */
    { .label = {  73274, 10, 0 } }, /* usantiques */
    { .label = { 149525,  6, 0 } }, /* usarts */
    { .label = {  20429, 15, 0 } }, /* uscountryestate */
    { .label = {  89662,  9, 0 } }, /* usculture */
    { .label = {  15239, 16, 0 } }, /* usdecorativearts */
    { .label = { 109931,  8, 0 } }, /* usgarden */
    { .label = {  89703,  9, 0 } }, /* ushistory */
    { .label = { 129201,  7, 0 } }, /* ushuaia */
    { .label = {  20493, 15, 0 } }, /* uslivinghistory */
    { .label = { 168596,  4, 0 } }, /* utah */
    { .label = { 168613,  4, 0 } }, /* uvic */
    { .label = {  14869,  6, 0 } }, /* valley */
    { .label = { 149549,  6, 0 } }, /* vantaa */
    { .label = {  73319, 10, 0 } }, /* versailles */
    { .label = { 149572,  6, 0 } }, /* viking */
    { .label = { 129230,  7, 0 } }, /* village */
    { .label = { 109965,  8, 0 } }, /* virginia */
    { .label = {  40882,  7, 0 } }, /* virtual */
    { .label = { 129262,  7, 0 } }, /* virtuel */
    { .label = {  73362, 10, 0 } }, /* vlaanderen */
    { .label = {  57659, 11, 0 } }, /* volkenkunde */
    { .label = { 161860,  5, 0 } }, /* wales */
    { .label = { 109999,  8, 0 } }, /* wallonie */
    { .label = {  17042,  3, 0 } }, /* war */
    { .label = {  44749, 12, 0 } }, /* washingtondc */
    { .label = {  35157, 13, 0 } }, /* watchandclock */
    { .label = {  20561, 15, 0 } }, /* watch-and-clock */
    { .label = {   9868,  7, 0 } }, /* western */
    { .label = {  89743,  9, 0 } }, /* westfalen */
    { .label = { 129294,  7, 0 } }, /* whaling */
    { .label = { 110034,  8, 0 } }, /* wildlife */
    { .label = {   4235, 12, 0 } }, /* williamsburg */
    { .label = { 110073,  8, 0 } }, /* windmill */
    { .label = { 110111,  8, 0 } }, /* workshop */
    { .label = {  89783,  4, 0 } }, /* york */
    { .label = {  89783,  9, 0 } }, /* yorkshire */
    { .label = { 110149,  8, 0 } }, /* yosemite */
    { .label = { 161882,  5, 0 } }, /* youth */
    { .label = {  73404, 10, 0 } }, /* zoological */
    { .label = { 129326,  7, 0 } }, /* zoology */
    { .label = {  27229, 14, 0 } }, /* xn--9dbhblg6di */
    { .label = {  73450, 10, 0 } }, /* xn--h1aegh */

    /* entries 6804 to 6817 */
    { .label = {  81233,  4, 0 } }, /* aero */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  23051,  3, 0 } }, /* pro */

    /* entries 6818 to 6828 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6829 to 6835 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 6836 to 6843 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 6844 to 6851 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3989,  3, 0 } }, /* adv */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6852 to 6868 */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = { 149362,  6, 0 } }, /* school */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   3009,  2, 0 } }, /* dr */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {   2900,  2, 0 } }, /* mx */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    336,  2, 0 } }, /* ws */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6869 to 6872 */
    { .label = {  10067,  3, 1 } }, { .child = { 6873, 1 } }, /* her */
    { .label = {   4417,  3, 1 } }, { .child = { 6874, 1 } }, /* his */

    /* entry 6873 */
    { .label = { 155953,  6, 0 } }, /* forgot */

    /* entry 6874 */
    { .label = { 155953,  6, 0 } }, /* forgot */

    /* entries 6875 to 6876 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 6877 to 6995 */
    { .label = {  77945, 10, 0 } }, /* alwaysdata */
    { .label = {  77987, 10, 0 } }, /* cloudfront */
    { .label = { 116561,  8, 0 } }, /* t3l3p0rt */
    { .label = { 155789,  6, 0 } }, /* go-vip */
    { .label = { 136513,  7, 0 } }, /* myfritz */
    { .label = {  50116, 12, 0 } }, /* blackbaudcdn */
    { .label = { 155845,  6, 0 } }, /* boomla */
    { .label = { 136621,  7, 0 } }, /* bplaced */
    { .label = { 136584,  7, 0 } }, /* square7 */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {   1370,  2, 0 } }, /* hu */
    { .label = {  12581,  2, 0 } }, /* jp */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  63772, 11, 0 } }, /* cloudaccess */
    { .label = {  95969,  9, 0 } }, /* cdn77-ssl */
    { .label = {  50173,  5, 1 } }, { .child = { 6996, 1 } }, /* cdn77 */
    { .label = {  96019,  9, 0 } }, /* cloudeity */
    { .label = { 116748,  8, 0 } }, /* feste-ip */
    { .label = {  78358, 10, 0 } }, /* knx-server */
    { .label = {  38934, 13, 0 } }, /* static-access */
    { .label = {  63871, 11, 1 } }, { .child = { 6997, 1 } }, /* cryptonomic */
    { .label = {  78404, 10, 0 } }, /* dattolocal */
    { .label = { 136854,  7, 0 } }, /* mydatto */
    { .label = { 155899,  6, 0 } }, /* debian */
    { .label = {  50336, 12, 0 } }, /* at-band-camp */
    { .label = { 136983,  7, 0 } }, /* blogdns */
    { .label = { 116893,  8, 0 } }, /* broke-it */
    { .label = {  78537, 10, 0 } }, /* buyshouses */
    { .label = { 116929,  8, 0 } }, /* dnsalias */
    { .label = { 137047,  7, 0 } }, /* dnsdojo */
    { .label = { 137080,  7, 0 } }, /* does-it */
    { .label = {  96185,  9, 0 } }, /* dontexist */
    { .label = { 116961,  8, 0 } }, /* dynalias */
    { .label = {  96224,  9, 0 } }, /* dynathome */
    { .label = {  39167, 13, 0 } }, /* endofinternet */
    { .label = { 137300,  7, 0 } }, /* from-az */
    { .label = { 137366,  7, 0 } }, /* from-co */
    { .label = { 137796,  7, 0 } }, /* from-la */
    { .label = { 138325,  7, 0 } }, /* from-ny */
    { .label = { 138961,  7, 0 } }, /* gets-it */
    { .label = {  50390, 12, 0 } }, /* ham-radio-op */
    { .label = {  96246,  7, 0 } }, /* homeftp */
    { .label = { 156006,  6, 0 } }, /* homeip */
    { .label = {  96384,  9, 0 } }, /* homelinux */
    { .label = { 117031,  8, 0 } }, /* homeunix */
    { .label = {  64425, 11, 0 } }, /* in-the-band */
    { .label = {  96462,  9, 0 } }, /* is-a-chef */
    { .label = {  96503,  9, 0 } }, /* is-a-geek */
    { .label = { 117211,  8, 0 } }, /* isa-geek */
    { .label = {  96582,  9, 0 } }, /* kicks-ass */
    { .label = {  39835, 13, 0 } }, /* office-on-the */
    { .label = { 139141,  7, 0 } }, /* podzone */
    { .label = {  39895, 13, 0 } }, /* scrapper-site */
    { .label = { 156063,  6, 0 } }, /* selfip */
    { .label = { 117350,  8, 0 } }, /* sells-it */
    { .label = { 117385,  8, 0 } }, /* servebbs */
    { .label = { 117423,  8, 0 } }, /* serveftp */
    { .label = { 117495,  8, 0 } }, /* thruhere */
    { .label = { 156092,  6, 0 } }, /* webhop */
    { .label = { 117577,  8, 0 } }, /* definima */
    { .label = { 139211,  7, 0 } }, /* casacam */
    { .label = { 170512,  4, 0 } }, /* dynu */
    { .label = { 166762,  5, 0 } }, /* dynv6 */
    { .label = { 156263,  6, 0 } }, /* twmail */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {  65303, 11, 0 } }, /* channelsdvr */
    { .label = { 118280,  8, 1 } }, { .child = { 6998, 1 } }, /* fastlylb */
    { .label = {  17475,  6, 1 } }, { .child = { 6999, 4 } }, /* fastly */
    { .label = {  51286, 12, 0 } }, /* flynnhosting */
    { .label = {  31986, 14, 0 } }, /* cloudfunctions */
    { .label = {  97296,  9, 0 } }, /* moonscale */
    { .label = { 156624,  6, 0 } }, /* in-dsl */
    { .label = { 156651,  6, 0 } }, /* in-vpn */
    { .label = { 139664,  7, 0 } }, /* ipifony */
    { .label = { 170745,  4, 0 } }, /* iobb */
    { .label = { 118653,  8, 0 } }, /* kinghost */
    { .label = { 170765,  4, 0 } }, /* uni5 */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 156905,  6, 0 } }, /* memset */
    { .label = {  40414, 13, 0 } }, /* azurewebsites */
    { .label = {  51509, 12, 0 } }, /* azure-mobile */
    { .label = {  97128,  8, 0 } }, /* cloudapp */
    { .label = {  78314,  5, 0 } }, /* dnsup */
    { .label = { 167026,  5, 0 } }, /* hicam */
    { .label = { 139949,  7, 0 } }, /* now-dns */
    { .label = { 167048,  5, 0 } }, /* ownip */
    { .label = { 157004,  6, 0 } }, /* vpndns */
    { .label = {  32234, 14, 0 } }, /* eating-organic */
    { .label = {  97689,  9, 0 } }, /* mydissent */
    { .label = { 118942,  8, 0 } }, /* myeffect */
    { .label = {  97729,  9, 0 } }, /* mymediapc */
    { .label = { 167165,  5, 0 } }, /* mypsx */
    { .label = {  17687, 16, 0 } }, /* mysecuritycamera */
    { .label = { 157144,  6, 0 } }, /* nhlfan */
    { .label = { 167192,  5, 0 } }, /* no-ip */
    { .label = { 157171,  6, 0 } }, /* pgafan */
    { .label = {   1461, 24, 0 } }, /* privatizehealthinsurance */
    { .label = { 119024,  8, 0 } }, /* bounceme */
    { .label = { 116839,  4, 0 } }, /* ddns */
    { .label = {  80559, 10, 0 } }, /* redirectme */
    { .label = {  97853,  9, 0 } }, /* serveblog */
    { .label = {  32357, 14, 0 } }, /* serveminecraft */
    { .label = {  80447,  5, 0 } }, /* sytes */
    { .label = {  40704, 13, 0 } }, /* cloudycluster */
    { .label = { 119243,  8, 0 } }, /* rackmaze */
    { .label = {  80826, 10, 0 } }, /* schokokeks */
    { .label = {  17758, 16, 0 } }, /* firewall-gateway */
    { .label = { 119423,  8, 0 } }, /* siteleaf */
    { .label = { 171084,  4, 1 } }, { .child = { 7010, 2 } }, /* srcf */
    { .label = { 140329,  7, 0 } }, /* dsmynas */
    { .label = { 119567,  8, 0 } }, /* familyds */
    { .label = {   2924,  2, 0 } }, /* za */

    /* entry 6996 */
    { .label = {      1,  1, 0 } }, /* r */

    /* entry 6997 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 6998 */
    { .label = {  10158,  3, 0 } }, /* map */

    /* entries 6999 to 7004 */
    { .label = { 139572,  7, 0 } }, /* freetls */
    { .label = {  10158,  3, 0 } }, /* map */
    { .label = {  61099,  4, 1 } }, { .child = { 7005, 2 } }, /* prod */
    { .label = {  24052,  3, 1 } }, { .child = { 7007, 3 } }, /* ssl */

    /* entries 7005 to 7006 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = { 153813,  6, 0 } }, /* global */

    /* entries 7007 to 7009 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = { 153813,  6, 0 } }, /* global */

    /* entries 7010 to 7011 */
    { .label = {   2773,  3, 0 } }, /* soc */
    { .label = {  13237,  4, 0 } }, /* user */

    /* entries 7012 to 7021 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   5389,  3, 0 } }, /* per */
    { .label = {  13403,  3, 0 } }, /* rec */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = { 133511,  5, 0 } }, /* other */
    { .label = { 157748,  5, 0 } }, /* store */

    /* entries 7022 to 7035 */
    { .label = {    106,  3, 1 } }, { .child = { 7036, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     27,  1, 0 } }, /* i */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {   4201,  3, 0 } }, /* col */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = { 131279,  3, 0 } }, /* ltd */

    /* entry 7036 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 7037 to 7050 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 7051 to 7059 */
    { .label = {  31070, 14, 0 } }, /* virtueeldomein */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  23781, 15, 0 } }, /* hosting-cluster */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 156763,  6, 0 } }, /* khplay */
    { .label = { 119643,  8, 1 } }, { .child = { 7060, 1 } }, /* transurl */
    { .label = { 140692,  7, 0 } }, /* cistron */
    { .label = { 167618,  5, 0 } }, /* demon */

    /* entry 7060 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7061 to 7818 */
    { .label = {  13096,  3, 0 } }, /* fhs */
    { .label = {  28853,  3, 0 } }, /* vgs */
    { .label = {  73500, 10, 0 } }, /* fylkesbibl */
    { .label = {  89823,  9, 0 } }, /* folkebibl */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = { 149600,  6, 0 } }, /* idrett */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   5511,  4, 0 } }, /* stat */
    { .label = {   6988,  3, 0 } }, /* dep */
    { .label = { 129361,  7, 0 } }, /* kommune */
    { .label = {  11616,  5, 0 } }, /* herad */
    { .label = {     91,  2, 1 } }, { .child = { 7819, 1 } }, /* aa */
    { .label = {   1500,  2, 1 } }, { .child = { 7820, 1 } }, /* ah */
    { .label = {   2306,  2, 1 } }, { .child = { 7821, 1 } }, /* bu */
    { .label = {   3284,  2, 1 } }, { .child = { 7822, 1 } }, /* fm */
    { .label = {   3680,  2, 1 } }, { .child = { 7823, 1 } }, /* hl */
    { .label = {   7073,  2, 1 } }, { .child = { 7824, 1 } }, /* hm */
    { .label = {  89868,  9, 1 } }, { .child = { 7825, 1 } }, /* jan-mayen */
    { .label = {    205,  2, 1 } }, { .child = { 7826, 1 } }, /* mr */
    { .label = {   2989,  2, 1 } }, { .child = { 7827, 1 } }, /* nl */
    { .label = {    252,  2, 1 } }, { .child = { 7828, 1 } }, /* nt */
    { .label = {   5311,  2, 1 } }, { .child = { 7829, 1 } }, /* of */
    { .label = {    528,  2, 1 } }, { .child = { 7830, 1 } }, /* ol */
    { .label = { 157358,  4, 1 } }, { .child = { 7831, 1 } }, /* oslo */
    { .label = {    193,  2, 1 } }, { .child = { 7832, 1 } }, /* rl */
    { .label = {   2700,  2, 1 } }, { .child = { 7833, 1 } }, /* sf */
    { .label = {    214,  2, 1 } }, { .child = { 7834, 1 } }, /* st */
    { .label = { 110184,  8, 1 } }, { .child = { 7835, 1 } }, /* svalbard */
    { .label = {   2442,  2, 1 } }, { .child = { 7836, 1 } }, /* tm */
    { .label = {    163,  2, 1 } }, { .child = { 7837, 1 } }, /* tr */
    { .label = {     54,  2, 1 } }, { .child = { 7838, 1 } }, /* va */
    { .label = {  14586,  2, 1 } }, { .child = { 7839, 1 } }, /* vf */
    { .label = { 110220,  8, 0 } }, /* akrehamn */
    { .label = {  20630, 15, 0 } }, /* xn--krehamn-dxa */
    { .label = {  19734,  6, 0 } }, /* algard */
    { .label = {  35216, 13, 0 } }, /* xn--lgrd-poac */
    { .label = {  38326,  4, 0 } }, /* arna */
    { .label = {  73551, 10, 0 } }, /* brumunddal */
    { .label = { 161906,  5, 0 } }, /* bryne */
    { .label = {  57710, 11, 0 } }, /* bronnoysund */
    { .label = {   8950, 18, 0 } }, /* xn--brnnysund-m8ac */
    { .label = { 149625,  6, 0 } }, /* drobak */
    { .label = {  35278, 13, 0 } }, /* xn--drbak-wua */
    { .label = { 110253,  8, 0 } }, /* egersund */
    { .label = { 129393,  7, 0 } }, /* fetsund */
    { .label = { 161930,  5, 0 } }, /* floro */
    { .label = {  44802, 12, 0 } }, /* xn--flor-jra */
    { .label = {  57760, 11, 0 } }, /* fredrikstad */
    { .label = { 110288,  8, 0 } }, /* hokksund */
    { .label = { 110325,  8, 0 } }, /* honefoss */
    { .label = {  20699, 15, 0 } }, /* xn--hnefoss-q1a */
    { .label = { 110360,  8, 0 } }, /* jessheim */
    { .label = {  89909,  9, 0 } }, /* jorpeland */
    { .label = {  15306, 16, 0 } }, /* xn--jrpeland-54a */
    { .label = { 110397,  8, 0 } }, /* kirkenes */
    { .label = { 110431,  8, 0 } }, /* kopervik */
    { .label = {  44860, 12, 0 } }, /* krokstadelva */
    { .label = { 110469,  8, 0 } }, /* langevag */
    { .label = {  20774, 15, 0 } }, /* xn--langevg-jxa */
    { .label = { 129425,  7, 0 } }, /* leirvik */
    { .label = {  89951,  9, 0 } }, /* mjondalen */
    { .label = {  15390, 16, 0 } }, /* xn--mjndalen-64a */
    { .label = {  89992,  9, 0 } }, /* mo-i-rana */
    { .label = { 129457,  7, 0 } }, /* mosjoen */
    { .label = {  27309, 14, 0 } }, /* xn--mosjen-eya */
    { .label = {  44912, 12, 0 } }, /* nesoddtangen */
    { .label = { 110504,  8, 0 } }, /* orkanger */
    { .label = { 149652,  6, 0 } }, /* osoyro */
    { .label = {  35340, 13, 0 } }, /* xn--osyro-wua */
    { .label = { 149678,  6, 0 } }, /* raholt */
    { .label = {  35401, 13, 0 } }, /* xn--rholt-mra */
    { .label = {  44962, 12, 0 } }, /* sandnessjoen */
    { .label = {   6773, 19, 0 } }, /* xn--sandnessjen-ogb */
    { .label = {  35460, 13, 0 } }, /* skedsmokorset */
    { .label = { 129489,  7, 0 } }, /* slattum */
    { .label = {  73598, 10, 0 } }, /* spjelkavik */
    { .label = {  90029,  9, 0 } }, /* stathelle */
    { .label = { 129519,  7, 0 } }, /* stavern */
    { .label = {  20847, 15, 0 } }, /* stjordalshalsen */
    { .label = {   2387, 22, 0 } }, /* xn--stjrdalshalsen-sqb */
    { .label = { 110537,  8, 0 } }, /* tananger */
    { .label = { 149703,  6, 0 } }, /* tranby */
    { .label = {  57808, 11, 0 } }, /* vossevangen */
    { .label = {  27998,  6, 0 } }, /* afjord */
    { .label = {  35516, 13, 0 } }, /* xn--fjord-lra */
    { .label = { 129548,  7, 0 } }, /* agdenes */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {  90067,  9, 0 } }, /* xn--l-1fa */
    { .label = { 129577,  7, 0 } }, /* alesund */
    { .label = {  27375, 14, 0 } }, /* xn--lesund-hua */
    { .label = {  90114,  9, 0 } }, /* alstahaug */
    { .label = {  32923,  4, 0 } }, /* alta */
    { .label = {  57856, 11, 0 } }, /* xn--lt-liac */
    { .label = {  90151,  9, 0 } }, /* alaheadju */
    { .label = {  15473, 16, 0 } }, /* xn--laheadju-7ya */
    { .label = {  58920,  6, 0 } }, /* alvdal */
    { .label = { 162080,  4, 0 } }, /* amli */
    { .label = {  57907, 11, 0 } }, /* xn--mli-tla */
    { .label = {  39088,  4, 0 } }, /* amot */
    { .label = {  57958, 11, 0 } }, /* xn--mot-tla */
    { .label = { 149730,  6, 0 } }, /* andebu */
    { .label = { 151267,  5, 0 } }, /* andoy */
    { .label = {  45013, 12, 0 } }, /* xn--andy-ira */
    { .label = {  90191,  9, 0 } }, /* andasuolo */
    { .label = {  36482,  5, 0 } }, /* ardal */
    { .label = {  45067, 12, 0 } }, /* xn--rdal-poa */
    { .label = { 129607,  7, 0 } }, /* aremark */
    { .label = { 129635,  7, 0 } }, /* arendal */
    { .label = {  90228,  9, 0 } }, /* xn--s-1fa */
    { .label = { 149757,  6, 0 } }, /* aseral */
    { .label = {  35579, 13, 0 } }, /* xn--seral-lra */
    { .label = { 161953,  5, 0 } }, /* asker */
    { .label = { 161973,  5, 0 } }, /* askim */
    { .label = { 129663,  7, 0 } }, /* askvoll */
    { .label = { 161994,  5, 0 } }, /* askoy */
    { .label = {  45122, 12, 0 } }, /* xn--asky-ira */
    { .label = {  36798,  5, 0 } }, /* asnes */
    { .label = {  45176, 12, 0 } }, /* xn--snes-poa */
    { .label = {  90274,  9, 0 } }, /* audnedaln */
    { .label = { 162016,  5, 0 } }, /* aukra */
    { .label = { 168032,  4, 0 } }, /* aure */
    { .label = { 129695,  7, 0 } }, /* aurland */
    { .label = {  27440, 14, 0 } }, /* aurskog-holand */
    { .label = {   3625, 21, 0 } }, /* xn--aurskog-hland-jnb */
    { .label = {  90312,  9, 0 } }, /* austevoll */
    { .label = {  90352,  9, 0 } }, /* austrheim */
    { .label = { 149780,  6, 0 } }, /* averoy */
    { .label = {  35636, 13, 0 } }, /* xn--avery-yua */
    { .label = {  73647, 10, 0 } }, /* balestrand */
    { .label = {  90390,  9, 0 } }, /* ballangen */
    { .label = {  83926,  5, 0 } }, /* balat */
    { .label = {  45230, 12, 0 } }, /* xn--blt-elab */
    { .label = {  90429,  9, 0 } }, /* balsfjord */
    { .label = {  45288, 12, 0 } }, /* bahccavuotna */
    { .label = {   6860, 19, 0 } }, /* xn--bhccavuotna-k7a */
    { .label = { 149807,  6, 0 } }, /* bamble */
    { .label = { 162036,  5, 0 } }, /* bardu */
    { .label = { 149836,  6, 0 } }, /* beardu */
    { .label = { 149863,  6, 0 } }, /* beiarn */
    { .label = { 129724,  7, 0 } }, /* bajddar */
    { .label = {  27501, 14, 0 } }, /* xn--bjddar-pta */
    { .label = { 149888,  6, 0 } }, /* baidar */
    { .label = {  35698, 13, 0 } }, /* xn--bidr-5nac */
    { .label = {  22459,  4, 0 } }, /* berg */
    { .label = { 149913,  6, 0 } }, /* bergen */
    { .label = { 110568,  8, 0 } }, /* berlevag */
    { .label = {  20912, 15, 0 } }, /* xn--berlevg-jxa */
    { .label = {  58008, 11, 0 } }, /* bearalvahki */
    { .label = {   9039, 18, 0 } }, /* xn--bearalvhki-y4a */
    { .label = { 149940,  6, 0 } }, /* bindal */
    { .label = { 110605,  8, 0 } }, /* birkenes */
    { .label = { 129757,  7, 0 } }, /* bjarkoy */
    { .label = {  27569, 14, 0 } }, /* xn--bjarky-fya */
    { .label = {  90473,  9, 0 } }, /* bjerkreim */
    { .label = { 162059,  5, 0 } }, /* bjugn */
    { .label = { 168633,  4, 0 } }, /* bodo */
    { .label = {  58056, 11, 0 } }, /* xn--bod-2na */
    { .label = { 110640,  8, 0 } }, /* badaddja */
    { .label = {  20987, 15, 0 } }, /* xn--bdddj-mrabd */
    { .label = { 129792,  7, 0 } }, /* budejju */
    { .label = {  16047,  4, 0 } }, /* bokn */
    { .label = {  90516,  9, 0 } }, /* bremanger */
    { .label = {  57710,  7, 0 } }, /* bronnoy */
    { .label = {  27640, 14, 0 } }, /* xn--brnny-wuac */
    { .label = { 129831,  7, 0 } }, /* bygland */
    { .label = { 162086,  5, 0 } }, /* bykle */
    { .label = { 162112,  5, 0 } }, /* barum */
    { .label = {  45341, 12, 0 } }, /* xn--brum-voa */
    { .label = { 110677,  8, 1 } }, { .child = { 7840, 2 } }, /* telemark */
    { .label = { 110711,  8, 1 } }, { .child = { 7842, 4 } }, /* nordland */
    { .label = { 149967,  6, 0 } }, /* bievat */
    { .label = {  35763, 13, 0 } }, /* xn--bievt-0qa */
    { .label = { 162135,  5, 0 } }, /* bomlo */
    { .label = {  45399, 12, 0 } }, /* xn--bmlo-gra */
    { .label = {  90603,  9, 0 } }, /* batsfjord */
    { .label = {  15553, 16, 0 } }, /* xn--btsfjord-9za */
    { .label = {  58111, 11, 0 } }, /* bahcavuotna */
    { .label = {   9127, 18, 0 } }, /* xn--bhcavuotna-s4a */
    { .label = { 162159,  5, 0 } }, /* dovre */
    { .label = { 129865,  7, 0 } }, /* drammen */
    { .label = {  90646,  9, 0 } }, /* drangedal */
    { .label = { 162182,  5, 0 } }, /* dyroy */
    { .label = {  45456, 12, 0 } }, /* xn--dyry-ira */
    { .label = { 162207,  5, 0 } }, /* donna */
    { .label = {  45513, 12, 0 } }, /* xn--dnna-gra */
    { .label = {   4528,  3, 0 } }, /* eid */
    { .label = { 110745,  8, 0 } }, /* eidfjord */
    { .label = { 110784,  8, 0 } }, /* eidsberg */
    { .label = { 129895,  7, 0 } }, /* eidskog */
    { .label = { 110820,  8, 0 } }, /* eidsvoll */
    { .label = {  90684,  9, 0 } }, /* eigersund */
    { .label = { 129926,  7, 0 } }, /* elverum */
    { .label = { 129959,  7, 0 } }, /* enebakk */
    { .label = { 110857,  8, 0 } }, /* engerdal */
    { .label = { 129990,  4, 0 } }, /* etne */
    { .label = { 129990,  7, 0 } }, /* etnedal */
    { .label = { 149994,  6, 0 } }, /* evenes */
    { .label = { 110891,  8, 0 } }, /* evenassi */
    { .label = {  11407, 17, 0 } }, /* xn--eveni-0qa01ga */
    { .label = {  21063, 15, 0 } }, /* evje-og-hornnes */
    { .label = { 130019,  7, 0 } }, /* farsund */
    { .label = { 150020,  6, 0 } }, /* fauske */
    { .label = { 130050,  7, 0 } }, /* fuossko */
    { .label = { 130082,  7, 0 } }, /* fuoisku */
    { .label = { 162227,  5, 0 } }, /* fedje */
    { .label = {   7180,  3, 0 } }, /* fet */
    { .label = { 150047,  6, 0 } }, /* finnoy */
    { .label = {  35831, 13, 0 } }, /* xn--finny-yua */
    { .label = { 150075,  6, 0 } }, /* fitjar */
    { .label = { 150103,  6, 0 } }, /* fjaler */
    { .label = {  45798,  5, 0 } }, /* fjell */
    { .label = { 110924,  8, 0 } }, /* flakstad */
    { .label = {  90723,  9, 0 } }, /* flatanger */
    { .label = {  58159, 11, 0 } }, /* flekkefjord */
    { .label = { 110959,  8, 0 } }, /* flesberg */
    { .label = { 162253,  5, 0 } }, /* flora */
    { .label = {  44595,  3, 0 } }, /* fla */
    { .label = {  73689, 10, 0 } }, /* xn--fl-zia */
    { .label = { 130115,  7, 0 } }, /* folldal */
    { .label = { 130148,  7, 0 } }, /* forsand */
    { .label = { 150132,  6, 0 } }, /* fosnes */
    { .label = { 108673,  4, 0 } }, /* frei */
    { .label = { 162275,  5, 0 } }, /* frogn */
    { .label = { 130178,  7, 0 } }, /* froland */
    { .label = { 150158,  6, 0 } }, /* frosta */
    { .label = { 107025,  5, 0 } }, /* frana */
    { .label = {  45566, 12, 0 } }, /* xn--frna-woa */
    { .label = { 162298,  5, 0 } }, /* froya */
    { .label = {  45621, 12, 0 } }, /* xn--frya-hra */
    { .label = {  13088,  4, 0 } }, /* fusa */
    { .label = { 110997,  8, 0 } }, /* fyresdal */
    { .label = { 162321,  5, 0 } }, /* forde */
    { .label = {  45677, 12, 0 } }, /* xn--frde-gra */
    { .label = { 150183,  6, 0 } }, /* gamvik */
    { .label = {  73739, 10, 0 } }, /* gangaviika */
    { .label = {   6952, 19, 0 } }, /* xn--ggaviika-8ya47h */
    { .label = { 150211,  6, 0 } }, /* gaular */
    { .label = { 130209,  7, 0 } }, /* gausdal */
    { .label = {  90761,  9, 0 } }, /* gildeskal */
    { .label = {  15638, 16, 0 } }, /* xn--gildeskl-g0a */
    { .label = { 162344,  5, 0 } }, /* giske */
    { .label = { 130239,  7, 0 } }, /* gjemnes */
    { .label = { 111034,  8, 0 } }, /* gjerdrum */
    { .label = { 111073,  8, 0 } }, /* gjerstad */
    { .label = { 130272,  7, 0 } }, /* gjesdal */
    { .label = { 150236,  6, 0 } }, /* gjovik */
    { .label = {  35894, 13, 0 } }, /* xn--gjvik-wua */
    { .label = { 130305,  7, 0 } }, /* gloppen */
    { .label = {  22496,  3, 0 } }, /* gol */
    { .label = {  24220,  4, 0 } }, /* gran */
    { .label = { 162366,  5, 0 } }, /* grane */
    { .label = { 130339,  7, 0 } }, /* granvin */
    { .label = {  90801,  9, 0 } }, /* gratangen */
    { .label = { 111109,  8, 0 } }, /* grimstad */
    { .label = { 162386,  5, 0 } }, /* grong */
    { .label = {  90837,  9, 0 } }, /* kraanghke */
    { .label = {  15716, 16, 0 } }, /* xn--kranghke-b0a */
    { .label = {  48812,  4, 0 } }, /* grue */
    { .label = { 162408,  5, 0 } }, /* gulen */
    { .label = { 150267,  6, 0 } }, /* hadsel */
    { .label = { 150293,  6, 0 } }, /* halden */
    { .label = { 162431,  5, 0 } }, /* halsa */
    { .label = { 130369,  5, 0 } }, /* hamar */
    { .label = { 130369,  7, 0 } }, /* hamaroy */
    { .label = { 150319,  6, 0 } }, /* habmer */
    { .label = {  35960, 13, 0 } }, /* xn--hbmer-xqa */
    { .label = { 150346,  6, 0 } }, /* hapmir */
    { .label = {  36026, 13, 0 } }, /* xn--hpmir-xqa */
    { .label = {  73781, 10, 0 } }, /* hammerfest */
    { .label = {  45733, 12, 0 } }, /* hammarfeasta */
    { .label = {   7053, 19, 0 } }, /* xn--hmmrfeasta-s4ac */
    { .label = { 104273,  5, 0 } }, /* haram */
    { .label = { 150373,  6, 0 } }, /* hareid */
    { .label = { 130399,  7, 0 } }, /* harstad */
    { .label = { 150398,  6, 0 } }, /* hasvik */
    { .label = {  73825, 10, 0 } }, /* aknoluokta */
    { .label = {   7142, 19, 0 } }, /* xn--koluokta-7ya57h */
    { .label = {  45782, 12, 0 } }, /* hattfjelldal */
    { .label = { 111143,  8, 0 } }, /* aarborte */
    { .label = {  90875,  9, 0 } }, /* haugesund */
    { .label = { 150425,  5, 0 } }, /* hemne */
    { .label = { 150425,  6, 0 } }, /* hemnes */
    { .label = { 111175,  8, 0 } }, /* hemsedal */
    { .label = {  21132, 15, 1 } }, { .child = { 7846, 2 } }, /* more-og-romsdal */
    { .label = {   2491, 22, 1 } }, { .child = { 7848, 2 } }, /* xn--mre-og-romsdal-qqb */
    { .label = {  40462,  5, 0 } }, /* hitra */
    { .label = { 111210,  8, 0 } }, /* hjartdal */
    { .label = {  73867, 10, 0 } }, /* hjelmeland */
    { .label = { 162474,  5, 0 } }, /* hobol */
    { .label = {  45893, 12, 0 } }, /* xn--hobl-ira */
    { .label = {   8510,  3, 0 } }, /* hof */
    { .label = {  21218,  3, 0 } }, /* hol */
    { .label = { 168652,  4, 0 } }, /* hole */
    { .label = {  58214, 11, 0 } }, /* holmestrand */
    { .label = { 111246,  8, 0 } }, /* holtalen */
    { .label = {  21198, 15, 0 } }, /* xn--holtlen-hxa */
    { .label = {  90915,  9, 0 } }, /* hornindal */
    { .label = { 150451,  6, 0 } }, /* horten */
    { .label = { 150476,  6, 0 } }, /* hurdal */
    { .label = { 162498,  5, 0 } }, /* hurum */
    { .label = { 150503,  6, 0 } }, /* hvaler */
    { .label = {  90953,  9, 0 } }, /* hyllestad */
    { .label = {  73914, 10, 0 } }, /* hagebostad */
    { .label = {  11497, 17, 0 } }, /* xn--hgebostad-g3a */
    { .label = { 111280,  8, 0 } }, /* hoyanger */
    { .label = {  21268, 15, 0 } }, /* xn--hyanger-q1a */
    { .label = {  90994,  9, 0 } }, /* hoylandet */
    { .label = {  15793, 16, 0 } }, /* xn--hylandet-54a */
    { .label = {   2443,  2, 0 } }, /* ha */
    { .label = {  91034,  9, 0 } }, /* xn--h-2fa */
    { .label = { 130427,  7, 0 } }, /* ibestad */
    { .label = { 130457,  7, 0 } }, /* inderoy */
    { .label = {  27708, 14, 0 } }, /* xn--indery-fya */
    { .label = { 130488,  7, 0 } }, /* iveland */
    { .label = { 111315,  8, 0 } }, /* jevnaker */
    { .label = {  89956,  6, 0 } }, /* jondal */
    { .label = { 130519,  7, 0 } }, /* jolster */
    { .label = {  27775, 14, 0 } }, /* xn--jlster-bya */
    { .label = { 111352,  8, 0 } }, /* karasjok */
    { .label = {  73957, 10, 0 } }, /* karasjohka */
    { .label = {   7243, 19, 0 } }, /* xn--krjohka-hwab49j */
    { .label = { 130551,  7, 0 } }, /* karlsoy */
    { .label = { 162522,  5, 0 } }, /* galsa */
    { .label = {  45949, 12, 0 } }, /* xn--gls-elac */
    { .label = { 150530,  6, 0 } }, /* karmoy */
    { .label = {  36092, 13, 0 } }, /* xn--karmy-yua */
    { .label = {  74000, 10, 0 } }, /* kautokeino */
    { .label = {  36154, 13, 0 } }, /* guovdageaidnu */
    { .label = { 162542,  5, 0 } }, /* klepp */
    { .label = { 162568,  5, 0 } }, /* klabu */
    { .label = {  46005, 12, 0 } }, /* xn--klbu-woa */
    { .label = {  91081,  9, 0 } }, /* kongsberg */
    { .label = {  58261, 11, 0 } }, /* kongsvinger */
    { .label = { 130582,  7, 0 } }, /* kragero */
    { .label = {  27843, 14, 0 } }, /* xn--krager-gya */
    { .label = {  46064, 12, 0 } }, /* kristiansand */
    { .label = {  46112, 12, 0 } }, /* kristiansund */
    { .label = {  74042, 10, 0 } }, /* krodsherad */
    { .label = {  11578, 17, 0 } }, /* xn--krdsherad-m8a */
    { .label = { 111387,  8, 0 } }, /* kvalsund */
    { .label = {  58310, 11, 0 } }, /* rahkkeravju */
    { .label = {   9213, 18, 0 } }, /* xn--rhkkervju-01af */
    { .label = { 168670,  4, 0 } }, /* kvam */
    { .label = {  91122,  9, 0 } }, /* kvinesdal */
    { .label = {  74085, 10, 0 } }, /* kvinnherad */
    { .label = {  91162,  9, 0 } }, /* kviteseid */
    { .label = { 130611,  7, 0 } }, /* kvitsoy */
    { .label = {  27907, 14, 0 } }, /* xn--kvitsy-fya */
    { .label = { 111424,  8, 0 } }, /* kvafjord */
    { .label = {  21343, 15, 0 } }, /* xn--kvfjord-nxa */
    { .label = {  36212, 13, 0 } }, /* giehtavuoatna */
    { .label = {  91202,  9, 0 } }, /* kvanangen */
    { .label = {  15875, 16, 0 } }, /* xn--kvnangen-k0a */
    { .label = { 111464,  8, 0 } }, /* navuotna */
    { .label = {  21418, 15, 0 } }, /* xn--nvuotna-hwa */
    { .label = { 130644,  7, 0 } }, /* kafjord */
    { .label = {  27976, 14, 0 } }, /* xn--kfjord-iua */
    { .label = {  91240,  9, 0 } }, /* gaivuotna */
    { .label = {  15951, 16, 0 } }, /* xn--givuotna-8ya */
    { .label = { 150557,  6, 0 } }, /* larvik */
    { .label = { 111497,  8, 0 } }, /* lavangen */
    { .label = { 130678,  7, 0 } }, /* lavagis */
    { .label = { 150584,  6, 0 } }, /* loabat */
    { .label = {  36266, 13, 0 } }, /* xn--loabt-0qa */
    { .label = { 130708,  7, 0 } }, /* lebesby */
    { .label = {  74129, 10, 0 } }, /* davvesiida */
    { .label = {  91278,  9, 0 } }, /* leikanger */
    { .label = {  91316,  9, 0 } }, /* leirfjord */
    { .label = {  92684,  4, 0 } }, /* leka */
    { .label = { 130743,  7, 0 } }, /* leksvik */
    { .label = { 150609,  6, 0 } }, /* lenvik */
    { .label = {  58361, 11, 0 } }, /* leangaviika */
    { .label = {   9308, 18, 0 } }, /* xn--leagaviika-52b */
    { .label = { 162592,  5, 0 } }, /* lesja */
    { .label = { 111531,  8, 0 } }, /* levanger */
    { .label = {  73106,  4, 0 } }, /* lier */
    { .label = { 150637,  6, 0 } }, /* lierne */
    { .label = {  58407, 11, 0 } }, /* lillehammer */
    { .label = {  91359,  9, 0 } }, /* lillesand */
    { .label = {  91398,  9, 0 } }, /* lindesnes */
    { .label = { 150662,  6, 0 } }, /* lindas */
    { .label = {  36332, 13, 0 } }, /* xn--linds-pra */
    { .label = {  18046,  3, 0 } }, /* lom */
    { .label = { 162615,  5, 0 } }, /* loppa */
    { .label = { 150687,  6, 0 } }, /* lahppi */
    { .label = {  36392, 13, 0 } }, /* xn--lhppi-xqa */
    { .label = { 115572,  4, 0 } }, /* lund */
    { .label = { 150716,  6, 0 } }, /* lunner */
    { .label = { 162639,  5, 0 } }, /* luroy */
    { .label = {  46162, 12, 0 } }, /* xn--lury-ira */
    { .label = {  23821,  6, 0 } }, /* luster */
    { .label = { 130776,  7, 0 } }, /* lyngdal */
    { .label = { 150742,  6, 0 } }, /* lyngen */
    { .label = { 168689,  4, 0 } }, /* ivgu */
    { .label = { 150770,  6, 0 } }, /* lardal */
    { .label = { 150795,  6, 0 } }, /* lerdal */
    { .label = {  36460, 13, 0 } }, /* xn--lrdal-sra */
    { .label = { 111566,  8, 0 } }, /* lodingen */
    { .label = {  21487, 15, 0 } }, /* xn--ldingen-q1a */
    { .label = {  91436,  9, 0 } }, /* lorenskog */
    { .label = {  16029, 16, 0 } }, /* xn--lrenskog-54a */
    { .label = { 162663,  5, 0 } }, /* loten */
    { .label = {  46218, 12, 0 } }, /* xn--lten-gra */
    { .label = { 131545,  6, 0 } }, /* malvik */
    { .label = { 130560,  5, 0 } }, /* masoy */
    { .label = {  36518, 13, 0 } }, /* xn--msy-ula0h */
    { .label = { 150821,  6, 0 } }, /* muosat */
    { .label = {  36584, 13, 0 } }, /* xn--muost-0qa */
    { .label = { 150846,  6, 0 } }, /* mandal */
    { .label = { 150871,  6, 0 } }, /* marker */
    { .label = {  91475,  9, 0 } }, /* marnardal */
    { .label = {  74173, 10, 0 } }, /* masfjorden */
    { .label = {  73888,  6, 0 } }, /* meland */
    { .label = { 150896,  6, 0 } }, /* meldal */
    { .label = { 150923,  6, 0 } }, /* melhus */
    { .label = { 162684,  5, 0 } }, /* meloy */
    { .label = {  46272, 12, 0 } }, /* xn--mely-ira */
    { .label = { 130809,  7, 0 } }, /* meraker */
    { .label = {  28044, 14, 0 } }, /* xn--merker-kua */
    { .label = { 130838,  7, 0 } }, /* moareke */
    { .label = {  28108, 14, 0 } }, /* xn--moreke-jua */
    { .label = { 130867,  7, 0 } }, /* midsund */
    { .label = {  28174, 14, 0 } }, /* midtre-gauldal */
    { .label = { 130899,  7, 0 } }, /* modalen */
    { .label = { 162708,  5, 0 } }, /* modum */
    { .label = { 162732,  5, 0 } }, /* molde */
    { .label = { 111601,  8, 0 } }, /* moskenes */
    { .label = { 168709,  4, 0 } }, /* moss */
    { .label = { 150951,  6, 0 } }, /* mosvik */
    { .label = { 130929,  7, 0 } }, /* malselv */
    { .label = {  28236, 14, 0 } }, /* xn--mlselv-iua */
    { .label = {  58456, 11, 0 } }, /* malatvuopmi */
    { .label = {   9398, 18, 0 } }, /* xn--mlatvuopmi-s4a */
    { .label = {  74219, 10, 0 } }, /* namdalseid */
    { .label = { 150979,  6, 0 } }, /* aejrie */
    { .label = { 151005,  6, 0 } }, /* namsos */
    { .label = {  74261, 10, 0 } }, /* namsskogan */
    { .label = {  28302, 14, 0 } }, /* naamesjevuemie */
    { .label = {   3724, 21, 0 } }, /* xn--nmesjevuemie-tcba */
    { .label = {  46328, 12, 0 } }, /* laakesvuemie */
    { .label = {  91511,  9, 0 } }, /* nannestad */
    { .label = { 151029,  6, 0 } }, /* narvik */
    { .label = { 111635,  8, 0 } }, /* narviika */
    { .label = { 111668,  8, 0 } }, /* naustdal */
    { .label = {  58506, 11, 0 } }, /* nedre-eiker */
    { .label = { 111701,  8, 1 } }, { .child = { 7850, 1 } }, /* akershus */
    { .label = { 111735,  8, 1 } }, { .child = { 7851, 1 } }, /* buskerud */
    { .label = { 111623,  5, 0 } }, /* nesna */
    { .label = { 111773,  8, 0 } }, /* nesodden */
    { .label = { 130961,  7, 0 } }, /* nesseby */
    { .label = { 130993,  7, 0 } }, /* unjarga */
    { .label = {  28364, 14, 0 } }, /* xn--unjrga-rta */
    { .label = { 151055,  6, 0 } }, /* nesset */
    { .label = { 111807,  8, 0 } }, /* nissedal */
    { .label = { 111840,  8, 0 } }, /* nittedal */
    { .label = {  58553, 11, 0 } }, /* nord-aurdal */
    { .label = {  91546,  9, 0 } }, /* nord-fron */
    { .label = {  91586,  9, 0 } }, /* nord-odal */
    { .label = { 131024,  7, 0 } }, /* norddal */
    { .label = { 111873,  8, 0 } }, /* nordkapp */
    { .label = {  58600, 11, 0 } }, /* davvenjarga */
    { .label = {   9486, 18, 0 } }, /* xn--davvenjrga-y4a */
    { .label = {  58650, 11, 0 } }, /* nordre-land */
    { .label = {  91625,  9, 0 } }, /* nordreisa */
    { .label = { 162755,  5, 0 } }, /* raisa */
    { .label = {  46380, 12, 0 } }, /* xn--risa-5na */
    { .label = {  36650, 13, 0 } }, /* nore-og-uvdal */
    { .label = { 111910,  8, 0 } }, /* notodden */
    { .label = { 162773,  5, 0 } }, /* naroy */
    { .label = {  36709, 13, 0 } }, /* xn--nry-yla5g */
    { .label = { 111944,  8, 0 } }, /* notteroy */
    { .label = {  21562, 15, 0 } }, /* xn--nttery-byae */
    { .label = {  25780,  4, 0 } }, /* odda */
    { .label = { 151079,  6, 0 } }, /* oksnes */
    { .label = {  36776, 13, 0 } }, /* xn--ksnes-uua */
    { .label = { 151104,  6, 0 } }, /* oppdal */
    { .label = { 111978,  8, 0 } }, /* oppegard */
    { .label = {  21632, 15, 0 } }, /* xn--oppegrd-ixa */
    { .label = { 151133,  6, 0 } }, /* orkdal */
    { .label = { 129699,  6, 0 } }, /* orland */
    { .label = {  36835, 13, 0 } }, /* xn--rland-uua */
    { .label = {   3649,  6, 0 } }, /* orskog */
    { .label = {  36894, 13, 0 } }, /* xn--rskog-uua */
    { .label = { 162794,  5, 0 } }, /* orsta */
    { .label = {  46436, 12, 0 } }, /* xn--rsta-fra */
    { .label = { 131054,  7, 1 } }, { .child = { 7852, 3 } }, /* hedmark */
    { .label = {  91661,  9, 1 } }, { .child = { 7855, 1 } }, /* hordaland */
    { .label = { 109396,  4, 0 } }, /* osen */
    { .label = { 131085,  7, 0 } }, /* osteroy */
    { .label = {  28428, 14, 0 } }, /* xn--ostery-fya */
    { .label = {  58697, 11, 0 } }, /* ostre-toten */
    { .label = {   9576, 18, 0 } }, /* xn--stre-toten-zcb */
    { .label = {  91699,  9, 0 } }, /* overhalla */
    { .label = {  74302, 10, 0 } }, /* ovre-eiker */
    { .label = {  11659, 17, 0 } }, /* xn--vre-eiker-k8a */
    { .label = { 168726,  4, 0 } }, /* oyer */
    { .label = {  58742, 11, 0 } }, /* xn--yer-zna */
    { .label = { 112015,  8, 0 } }, /* oygarden */
    { .label = {  21704, 15, 0 } }, /* xn--ygarden-p1a */
    { .label = {  36954, 13, 0 } }, /* oystre-slidre */
    { .label = {   4476, 20, 0 } }, /* xn--ystre-slidre-ujb */
    { .label = {  91738,  9, 0 } }, /* porsanger */
    { .label = { 112050,  8, 0 } }, /* porsangu */
    { .label = {  11741, 17, 0 } }, /* xn--porsgu-sta26f */
    { .label = {  91776,  9, 0 } }, /* porsgrunn */
    { .label = { 162813,  5, 0 } }, /* radoy */
    { .label = {  46489, 12, 0 } }, /* xn--rady-ira */
    { .label = {  91816,  9, 0 } }, /* rakkestad */
    { .label = {  69786,  4, 0 } }, /* rana */
    { .label = { 151159,  6, 0 } }, /* ruovat */
    { .label = {  91853,  9, 0 } }, /* randaberg */
    { .label = { 159744,  5, 0 } }, /* rauma */
    { .label = { 112085,  8, 0 } }, /* rendalen */
    { .label = { 131115,  7, 0 } }, /* rennebu */
    { .label = { 112118,  8, 0 } }, /* rennesoy */
    { .label = {  21777, 15, 0 } }, /* xn--rennesy-v1a */
    { .label = { 151185,  6, 0 } }, /* rindal */
    { .label = { 131146,  7, 0 } }, /* ringebu */
    { .label = {  91891,  9, 0 } }, /* ringerike */
    { .label = {  91929,  9, 0 } }, /* ringsaker */
    { .label = { 162835,  5, 0 } }, /* rissa */
    { .label = { 162854,  5, 0 } }, /* risor */
    { .label = {  46543, 12, 0 } }, /* xn--risr-ira */
    { .label = {   2711,  4, 0 } }, /* roan */
    { .label = { 151210,  6, 0 } }, /* rollag */
    { .label = { 162874,  5, 0 } }, /* rygge */
    { .label = { 112152,  8, 0 } }, /* ralingen */
    { .label = {  21849, 15, 0 } }, /* xn--rlingen-mxa */
    { .label = { 162898,  5, 0 } }, /* rodoy */
    { .label = {  46595, 12, 0 } }, /* xn--rdy-0nab */
    { .label = { 131178,  7, 0 } }, /* romskog */
    { .label = {  28494, 14, 0 } }, /* xn--rmskog-bya */
    { .label = { 162921,  5, 0 } }, /* roros */
    { .label = {  46656, 12, 0 } }, /* xn--rros-gra */
    { .label = {  92544,  4, 0 } }, /* rost */
    { .label = {  58795, 11, 0 } }, /* xn--rst-0na */
    { .label = { 151236,  6, 0 } }, /* royken */
    { .label = {  37011, 13, 0 } }, /* xn--ryken-vua */
    { .label = { 131209,  7, 0 } }, /* royrvik */
    { .label = {  28561, 14, 0 } }, /* xn--ryrvik-bya */
    { .label = {  40105,  4, 0 } }, /* rade */
    { .label = {  58847, 11, 0 } }, /* xn--rde-ula */
    { .label = { 112185,  8, 0 } }, /* salangen */
    { .label = { 131242,  7, 0 } }, /* siellak */
    { .label = { 131272,  7, 0 } }, /* saltdal */
    { .label = { 114947,  5, 0 } }, /* salat */
    { .label = {  46709, 12, 0 } }, /* xn--slt-elab */
    { .label = {  46765, 12, 0 } }, /* xn--slat-5na */
    { .label = {  91966,  9, 0 } }, /* samnanger */
    { .label = { 112217,  8, 1 } }, { .child = { 7856, 1 } }, /* vestfold */
    { .label = {  74346, 10, 0 } }, /* sandefjord */
    { .label = {   6793,  7, 0 } }, /* sandnes */
    { .label = { 151263,  6, 0 } }, /* sandoy */
    { .label = {  37073, 13, 0 } }, /* xn--sandy-yua */
    { .label = {  92002,  9, 0 } }, /* sarpsborg */
    { .label = { 159415,  5, 0 } }, /* sauda */
    { .label = { 112255,  8, 0 } }, /* sauherad */
    { .label = {  28266,  3, 0 } }, /* sel */
    { .label = { 162941,  5, 0 } }, /* selbu */
    { .label = { 162965,  5, 0 } }, /* selje */
    { .label = { 131301,  7, 0 } }, /* seljord */
    { .label = { 151289,  6, 0 } }, /* sigdal */
    { .label = { 151315,  6, 0 } }, /* siljan */
    { .label = { 151342,  6, 0 } }, /* sirdal */
    { .label = { 162989,  5, 0 } }, /* skaun */
    { .label = {  35460,  7, 0 } }, /* skedsmo */
    { .label = {   6441,  3, 0 } }, /* ski */
    { .label = { 115299,  5, 0 } }, /* skien */
    { .label = { 112288,  8, 0 } }, /* skiptvet */
    { .label = { 112325,  8, 0 } }, /* skjervoy */
    { .label = {  21918, 15, 0 } }, /* xn--skjervy-v1a */
    { .label = { 131334,  7, 0 } }, /* skierva */
    { .label = {  28630, 14, 0 } }, /* xn--skierv-uta */
    { .label = { 163010,  5, 0 } }, /* skjak */
    { .label = {  46822, 12, 0 } }, /* xn--skjk-soa */
    { .label = { 151367,  6, 0 } }, /* skodje */
    { .label = { 112365,  8, 0 } }, /* skanland */
    { .label = {  21996, 15, 0 } }, /* xn--sknland-fxa */
    { .label = { 151396,  6, 0 } }, /* skanit */
    { .label = {  37134, 13, 0 } }, /* xn--sknit-yqa */
    { .label = { 163034,  5, 0 } }, /* smola */
    { .label = {  46879, 12, 0 } }, /* xn--smla-hra */
    { .label = {  74392, 10, 0 } }, /* snillfjord */
    { .label = { 163055,  5, 0 } }, /* snasa */
    { .label = {  46933, 12, 0 } }, /* xn--snsa-roa */
    { .label = { 151420,  6, 0 } }, /* snoasa */
    { .label = { 151442,  6, 0 } }, /* snaase */
    { .label = {  37197, 13, 0 } }, /* xn--snase-nra */
    { .label = { 131364,  7, 0 } }, /* sogndal */
    { .label = { 131394,  7, 0 } }, /* sokndal */
    { .label = {  60999,  4, 0 } }, /* sola */
    { .label = { 151464,  6, 0 } }, /* solund */
    { .label = {  92042,  9, 0 } }, /* songdalen */
    { .label = { 112398,  8, 0 } }, /* sortland */
    { .label = {  92080,  9, 0 } }, /* spydeberg */
    { .label = { 151491,  6, 0 } }, /* stange */
    { .label = {  92124,  9, 0 } }, /* stavanger */
    { .label = { 131424,  7, 0 } }, /* steigen */
    { .label = {  92161,  9, 0 } }, /* steinkjer */
    { .label = {  20847,  8, 0 } }, /* stjordal */
    { .label = {  22066, 15, 0 } }, /* xn--stjrdal-s1a */
    { .label = { 151515,  6, 0 } }, /* stokke */
    { .label = {  58898, 11, 0 } }, /* stor-elvdal */
    { .label = {  95868,  5, 0 } }, /* stord */
    { .label = { 131453,  7, 0 } }, /* stordal */
    { .label = {  92201,  9, 0 } }, /* storfjord */
    { .label = {  74440, 10, 0 } }, /* omasvuotna */
    { .label = {  58237,  6, 0 } }, /* strand */
    { .label = { 131482,  7, 0 } }, /* stranda */
    { .label = { 163073,  5, 0 } }, /* stryn */
    { .label = {  93222,  4, 0 } }, /* sula */
    { .label = { 151541,  6, 0 } }, /* suldal */
    { .label = {   8994,  4, 0 } }, /* sund */
    { .label = { 131509,  7, 0 } }, /* sunndal */
    { .label = { 112431,  8, 0 } }, /* surnadal */
    { .label = { 163095,  5, 0 } }, /* sveio */
    { .label = { 131539,  7, 0 } }, /* svelvik */
    { .label = {  92243,  9, 0 } }, /* sykkylven */
    { .label = { 163117,  5, 0 } }, /* sogne */
    { .label = {  46984, 12, 0 } }, /* xn--sgne-gra */
    { .label = { 163138,  5, 0 } }, /* somna */
    { .label = {  47038, 12, 0 } }, /* xn--smna-gra */
    { .label = {  58947, 11, 0 } }, /* sondre-land */
    { .label = {   9660, 18, 0 } }, /* xn--sndre-land-0cb */
    { .label = {  74482, 10, 0 } }, /* sor-aurdal */
    { .label = {  11828, 17, 0 } }, /* xn--sr-aurdal-l8a */
    { .label = { 112464,  8, 0 } }, /* sor-fron */
    { .label = {  22138, 15, 0 } }, /* xn--sr-fron-q1a */
    { .label = { 112499,  8, 0 } }, /* sor-odal */
    { .label = {  22213, 15, 0 } }, /* xn--sr-odal-q1a */
    { .label = {  47091, 12, 0 } }, /* sor-varanger */
    { .label = {   7347, 19, 0 } }, /* xn--sr-varanger-ggb */
    { .label = {  37252, 13, 0 } }, /* matta-varjjat */
    { .label = {   4572, 20, 0 } }, /* xn--mtta-vrjjat-k7af */
    { .label = { 131573,  7, 0 } }, /* sorfold */
    { .label = {  28694, 14, 0 } }, /* xn--srfold-bya */
    { .label = { 112533,  8, 0 } }, /* sorreisa */
    { .label = {  22287, 15, 0 } }, /* xn--srreisa-q1a */
    { .label = { 163158,  5, 0 } }, /* sorum */
    { .label = {  47141, 12, 0 } }, /* xn--srum-gra */
    { .label = {   6306,  4, 0 } }, /* tana */
    { .label = { 151568,  6, 0 } }, /* deatnu */
    { .label = {  57610,  4, 0 } }, /* time */
    { .label = { 112564,  8, 0 } }, /* tingvoll */
    { .label = { 136323,  4, 0 } }, /* tinn */
    { .label = {  92288,  9, 0 } }, /* tjeldsund */
    { .label = {  37310, 13, 0 } }, /* dielddanuorri */
    { .label = { 163180,  5, 0 } }, /* tjome */
    { .label = {  47196, 12, 0 } }, /* xn--tjme-hra */
    { .label = { 151519,  5, 0 } }, /* tokke */
    { .label = { 101024,  5, 0 } }, /* tolga */
    { .label = { 131605,  7, 0 } }, /* torsken */
    { .label = { 151593,  6, 0 } }, /* tranoy */
    { .label = {  37366, 13, 0 } }, /* xn--trany-yua */
    { .label = { 151618,  6, 0 } }, /* tromso */
    { .label = {  37426, 13, 0 } }, /* xn--troms-zua */
    { .label = { 151643,  6, 0 } }, /* tromsa */
    { .label = { 151647,  5, 0 } }, /* romsa */
    { .label = {  92331,  9, 0 } }, /* trondheim */
    { .label = { 112601,  8, 0 } }, /* troandin */
    { .label = { 151667,  6, 0 } }, /* trysil */
    { .label = { 163204,  5, 0 } }, /* trana */
    { .label = {  47253, 12, 0 } }, /* xn--trna-woa */
    { .label = { 112633,  8, 0 } }, /* trogstad */
    { .label = {  22358, 15, 0 } }, /* xn--trgstad-r1a */
    { .label = {  58994, 11, 0 } }, /* tvedestrand */
    { .label = { 148610,  5, 0 } }, /* tydal */
    { .label = { 151694,  6, 0 } }, /* tynset */
    { .label = { 112666,  8, 0 } }, /* tysfjord */
    { .label = {  47306, 12, 0 } }, /* divtasvuodna */
    { .label = {  37487, 13, 0 } }, /* divttasvuotna */
    { .label = { 151720,  6, 0 } }, /* tysnes */
    { .label = { 151746,  6, 0 } }, /* tysvar */
    { .label = {  37543, 13, 0 } }, /* xn--tysvr-vra */
    { .label = { 112706,  8, 0 } }, /* tonsberg */
    { .label = {  22427, 15, 0 } }, /* xn--tnsberg-q1a */
    { .label = {  74524, 10, 0 } }, /* ullensaker */
    { .label = {  74567, 10, 0 } }, /* ullensvang */
    { .label = {  73622,  5, 0 } }, /* ulvik */
    { .label = { 151773,  6, 0 } }, /* utsira */
    { .label = { 163222,  5, 0 } }, /* vadso */
    { .label = {  47359, 12, 0 } }, /* xn--vads-jra */
    { .label = {  74612, 10, 0 } }, /* cahcesuolo */
    { .label = {   7434, 19, 0 } }, /* xn--hcesuolo-7ya35b */
    { .label = { 131634,  7, 0 } }, /* vaksdal */
    { .label = {   2925,  5, 0 } }, /* valle */
    { .label = {  57830,  4, 0 } }, /* vang */
    { .label = { 112741,  8, 0 } }, /* vanylven */
    { .label = { 139648,  5, 0 } }, /* vardo */
    { .label = {  47416, 12, 0 } }, /* xn--vard-jra */
    { .label = { 131665,  7, 0 } }, /* varggat */
    { .label = {  28762, 14, 0 } }, /* xn--vrggt-xqad */
    { .label = { 163244,  5, 0 } }, /* vefsn */
    { .label = { 131695,  7, 0 } }, /* vaapste */
    { .label = {  92370,  4, 0 } }, /* vega */
    { .label = {  92370,  9, 0 } }, /* vegarshei */
    { .label = {  16110, 16, 0 } }, /* xn--vegrshei-c0a */
    { .label = { 112779,  8, 0 } }, /* vennesla */
    { .label = { 151797,  6, 0 } }, /* verdal */
    { .label = { 151824,  6, 0 } }, /* verran */
    { .label = { 151849,  6, 0 } }, /* vestby */
    { .label = { 131725,  7, 0 } }, /* vestnes */
    { .label = {  37605, 13, 0 } }, /* vestre-slidre */
    { .label = {  47473, 12, 0 } }, /* vestre-toten */
    { .label = {  92409,  9, 0 } }, /* vestvagoy */
    { .label = {  11908, 17, 0 } }, /* xn--vestvgy-ixa6o */
    { .label = {  92451,  9, 0 } }, /* vevelstad */
    { .label = {  23111,  3, 0 } }, /* vik */
    { .label = { 163268,  5, 0 } }, /* vikna */
    { .label = {  74656, 10, 0 } }, /* vindafjord */
    { .label = { 163290,  5, 0 } }, /* volda */
    { .label = {  57808,  4, 0 } }, /* voss */
    { .label = { 163313,  5, 0 } }, /* varoy */
    { .label = {  37662, 13, 0 } }, /* xn--vry-yla5g */
    { .label = { 163336,  5, 0 } }, /* vagan */
    { .label = {  47524, 12, 0 } }, /* xn--vgan-qoa */
    { .label = { 151879,  6, 0 } }, /* voagat */
    { .label = { 151904,  6, 0 } }, /* vagsoy */
    { .label = {  28833, 14, 0 } }, /* xn--vgsy-qoa0j */
    { .label = { 107356,  4, 0 } }, /* vaga */
    { .label = {  59041, 11, 0 } }, /* xn--vg-yiab */
    { .label = { 131755,  7, 1 } }, { .child = { 7857, 1 } }, /* ostfold */
    { .label = {  28909, 14, 1 } }, { .child = { 7858, 1 } }, /* xn--stfold-9xa */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entry 7819 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7820 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7821 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7822 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7823 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7824 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7825 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7826 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7827 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7828 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7829 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7830 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7831 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7832 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7833 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7834 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7835 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7836 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7837 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7838 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7839 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entries 7840 to 7841 */
    { .label = {   2883,  2, 0 } }, /* bo */
    { .label = {  90555,  9, 0 } }, /* xn--b-5ga */

    /* entries 7842 to 7845 */
    { .label = {   2883,  2, 0 } }, /* bo */
    { .label = {  90555,  9, 0 } }, /* xn--b-5ga */
    { .label = { 162451,  5, 0 } }, /* heroy */
    { .label = {  45838, 12, 0 } }, /* xn--hery-ira */

    /* entries 7846 to 7847 */
    { .label = { 162451,  5, 0 } }, /* heroy */
    { .label = {  74346,  5, 0 } }, /* sande */

    /* entries 7848 to 7849 */
    { .label = {  45838, 12, 0 } }, /* xn--hery-ira */
    { .label = {  74346,  5, 0 } }, /* sande */

    /* entry 7850 */
    { .label = {   6809,  3, 0 } }, /* nes */

    /* entry 7851 */
    { .label = {   6809,  3, 0 } }, /* nes */

    /* entries 7852 to 7854 */
    { .label = {     67,  2, 0 } }, /* os */
    { .label = { 150508,  5, 0 } }, /* valer */
    { .label = {  47582, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7855 */
    { .label = {     67,  2, 0 } }, /* os */

    /* entry 7856 */
    { .label = {  74346,  5, 0 } }, /* sande */

    /* entry 7857 */
    { .label = { 150508,  5, 0 } }, /* valer */

    /* entry 7858 */
    { .label = {  47582, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7859 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7860 to 7866 */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 7867 to 7873 */
    { .label = { 117245,  8, 0 } }, /* merseine */
    { .label = {  32379,  4, 0 } }, /* mine */
    { .label = { 117461,  8, 0 } }, /* shacknet */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = { 114298,  7, 1 } }, { .child = { 7874, 1 } }, /* builder */
    { .label = {  24976, 15, 0 } }, /* enterprisecloud */

    /* entry 7874 */
    { .label = {    699,  4, 0 } }, /* site */

    /* entries 7875 to 7892 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 7893, 1 } }, /* co */
    { .label = {   1462,  3, 0 } }, /* cri */
    { .label = {  78916,  4, 0 } }, /* geek */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = { 168744,  4, 0 } }, /* govt */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {   2052,  3, 0 } }, /* iwi */
    { .label = { 168763,  4, 0 } }, /* kiwi */
    { .label = {  85423,  5, 0 } }, /* maori */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  47641, 12, 0 } }, /* xn--mori-qsa */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  67773, 10, 0 } }, /* parliament */
    { .label = { 149362,  6, 0 } }, /* school */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entry 7893 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 7894 to 7902 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  23051,  3, 0 } }, /* pro */

    /* entries 7903 to 8017 */
    { .label = { 120228,  5, 1 } }, { .child = { 8018, 1 } }, /* amune */
    { .label = { 116608,  8, 0 } }, /* pimienta */
    { .label = { 136451,  7, 0 } }, /* poivron */
    { .label = { 136483,  7, 0 } }, /* potager */
    { .label = {  63669, 11, 0 } }, /* sweetpepper */
    { .label = {     99,  2, 0 } }, /* ae */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = { 136655,  7, 0 } }, /* certmgr */
    { .label = {  50173,  5, 1 } }, { .child = { 8019, 2 } }, /* cdn77 */
    { .label = {  50173, 12, 1 } }, { .child = { 8021, 1 } }, /* cdn77-secure */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = { 136950,  7, 0 } }, /* duckdns */
    { .label = { 170494,  4, 0 } }, /* tunk */
    { .label = {  31132,  6, 1 } }, { .child = { 8024, 2 } }, /* dyndns */
    { .label = { 136983,  7, 0 } }, /* blogdns */
    { .label = { 116857,  8, 0 } }, /* blogsite */
    { .label = {  10000, 18, 0 } }, /* boldlygoingnowhere */
    { .label = { 116929,  8, 0 } }, /* dnsalias */
    { .label = { 137047,  7, 0 } }, /* dnsdojo */
    { .label = {  64330, 11, 0 } }, /* doesntexist */
    { .label = {  96185,  9, 0 } }, /* dontexist */
    { .label = { 137110,  7, 0 } }, /* doomdns */
    { .label = { 155925,  6, 0 } }, /* dvrdns */
    { .label = { 116961,  8, 0 } }, /* dynalias */
    { .label = {  39167, 13, 0 } }, /* endofinternet */
    { .label = {  16789, 16, 0 } }, /* endoftheinternet */
    { .label = { 137894,  7, 0 } }, /* from-me */
    { .label = {  96305,  9, 0 } }, /* game-host */
    { .label = { 155980,  6, 0 } }, /* gotdns */
    { .label = {  78718, 10, 0 } }, /* hobby-site */
    { .label = { 138991,  7, 0 } }, /* homedns */
    { .label = {  96246,  7, 0 } }, /* homeftp */
    { .label = {  96384,  9, 0 } }, /* homelinux */
    { .label = { 117031,  8, 0 } }, /* homeunix */
    { .label = {  31316, 14, 0 } }, /* is-a-bruinsfan */
    { .label = {  31441, 14, 0 } }, /* is-a-candidate */
    { .label = {  24171, 15, 0 } }, /* is-a-celticsfan */
    { .label = {  96462,  9, 0 } }, /* is-a-chef */
    { .label = {  96503,  9, 0 } }, /* is-a-geek */
    { .label = {  64568, 11, 0 } }, /* is-a-knight */
    { .label = {  24300, 15, 0 } }, /* is-a-linux-user */
    { .label = {  50648, 12, 0 } }, /* is-a-patsfan */
    { .label = {  64714, 11, 0 } }, /* is-a-soxfan */
    { .label = { 117103,  8, 0 } }, /* is-found */
    { .label = { 139082,  7, 0 } }, /* is-lost */
    { .label = { 117140,  8, 0 } }, /* is-saved */
    { .label = {  64903, 11, 0 } }, /* is-very-bad */
    { .label = {  50951, 12, 0 } }, /* is-very-evil */
    { .label = {  51008, 12, 0 } }, /* is-very-good */
    { .label = {  51064, 12, 0 } }, /* is-very-nice */
    { .label = {  39717, 13, 0 } }, /* is-very-sweet */
    { .label = { 117211,  8, 0 } }, /* isa-geek */
    { .label = {  96582,  9, 0 } }, /* kicks-ass */
    { .label = {  65007, 11, 0 } }, /* misconfused */
    { .label = { 139141,  7, 0 } }, /* podzone */
    { .label = {  79160, 10, 0 } }, /* readmyblog */
    { .label = { 156063,  6, 0 } }, /* selfip */
    { .label = {  39952, 13, 0 } }, /* sellsyourhome */
    { .label = { 117385,  8, 0 } }, /* servebbs */
    { .label = { 117423,  8, 0 } }, /* serveftp */
    { .label = {  96703,  9, 0 } }, /* servegame */
    { .label = {  51119, 12, 0 } }, /* stuff-4-sale */
    { .label = { 156092,  6, 0 } }, /* webhop */
    { .label = { 166666,  5, 0 } }, /* ddnss */
    { .label = {  96785,  9, 0 } }, /* accesscam */
    { .label = { 156152,  6, 0 } }, /* camdvr */
    { .label = { 117663,  8, 0 } }, /* freeddns */
    { .label = { 156180,  6, 0 } }, /* mywire */
    { .label = {  65108, 11, 0 } }, /* webredirect */
    { .label = {   2994,  2, 1 } }, { .child = { 8026, 55 } }, /* eu */
    { .label = { 156263,  6, 0 } }, /* twmail */
    { .label = {  17545, 16, 0 } }, /* fedorainfracloud */
    { .label = {  51231, 12, 0 } }, /* fedorapeople */
    { .label = {  40181, 13, 1 } }, { .child = { 8081, 3 } }, /* fedoraproject */
    { .label = {  65700, 11, 0 } }, /* freedesktop */
    { .label = { 118541,  8, 0 } }, /* hepforge */
    { .label = { 156624,  6, 0 } }, /* in-dsl */
    { .label = { 156651,  6, 0 } }, /* in-vpn */
    { .label = {  15265,  2, 0 } }, /* js */
    { .label = { 156876,  6, 0 } }, /* uklugs */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 118725,  8, 0 } }, /* mayfirst */
    { .label = {  66091, 11, 0 } }, /* mozilla-iot */
    { .label = {  32174, 14, 0 } }, /* bmoattachments */
    { .label = { 139981,  7, 0 } }, /* dynserv */
    { .label = { 139949,  7, 0 } }, /* now-dns */
    { .label = {  66141, 11, 0 } }, /* cable-modem */
    { .label = {  80151, 10, 0 } }, /* collegefan */
    { .label = {  17616, 16, 0 } }, /* couchpotatofries */
    { .label = { 157061,  6, 0 } }, /* mlbfan */
    { .label = {  17687, 16, 0 } }, /* mysecuritycamera */
    { .label = { 157116,  6, 0 } }, /* nflfan */
    { .label = {  80469, 10, 0 } }, /* read-books */
    { .label = { 157198,  6, 0 } }, /* ufcfan */
    { .label = { 167142,  5, 0 } }, /* hopto */
    { .label = { 167215,  5, 0 } }, /* myftp */
    { .label = { 167192,  5, 0 } }, /* no-ip */
    { .label = { 167095,  5, 0 } }, /* zapto */
    { .label = {  66536, 11, 0 } }, /* my-firewall */
    { .label = {  80918, 10, 0 } }, /* myfirewall */
    { .label = { 167447,  5, 0 } }, /* spdns */
    { .label = { 140329,  7, 0 } }, /* dsmynas */
    { .label = { 119567,  8, 0 } }, /* familyds */
    { .label = { 157500,  6, 0 } }, /* edugit */
    { .label = {  98179,  9, 0 } }, /* tuxfamily */
    { .label = {   5493, 11, 0 } }, /* diskstation */
    { .label = {   4197,  2, 0 } }, /* hk */
    { .label = { 140657,  7, 0 } }, /* wmflabs */
    { .label = {   2924,  2, 0 } }, /* za */

    /* entry 8018 */
    { .label = {     89,  4, 0 } }, /* tele */

    /* entries 8019 to 8020 */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {   4363,  3, 0 } }, /* rsc */

    /* entries 8021 to 8022 */
    { .label = { 135365,  6, 1 } }, { .child = { 8023, 1 } }, /* origin */

    /* entry 8023 */
    { .label = {  24052,  3, 0 } }, /* ssl */

    /* entries 8024 to 8025 */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  24700,  4, 0 } }, /* home */

    /* entries 8026 to 8080 */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    160,  2, 0 } }, /* at */
    { .label = {    117,  2, 0 } }, /* au */
    { .label = {    555,  2, 0 } }, /* be */
    { .label = {   5497,  2, 0 } }, /* bg */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {   2713,  2, 0 } }, /* cd */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {    674,  2, 0 } }, /* cy */
    { .label = {   5585,  2, 0 } }, /* cz */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {   1421,  2, 0 } }, /* dk */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {     98,  2, 0 } }, /* ee */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = {    298,  2, 0 } }, /* fr */
    { .label = {   2701,  2, 0 } }, /* gr */
    { .label = {   1659,  2, 0 } }, /* hr */
    { .label = {   1370,  2, 0 } }, /* hu */
    { .label = {    119,  2, 0 } }, /* ie */
    { .label = {    556,  2, 0 } }, /* il */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = {    151,  2, 0 } }, /* it */
    { .label = {  12581,  2, 0 } }, /* jp */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = {   2993,  2, 0 } }, /* lu */
    { .label = {   3767,  2, 0 } }, /* lv */
    { .label = {   4196,  2, 0 } }, /* mc */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {    749,  2, 0 } }, /* mk */
    { .label = {    158,  2, 0 } }, /* mt */
    { .label = {   1064,  2, 0 } }, /* my */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    761,  2, 0 } }, /* ng */
    { .label = {   2989,  2, 0 } }, /* nl */
    { .label = {    188,  2, 0 } }, /* no */
    { .label = {   3369,  2, 0 } }, /* nz */
    { .label = { 161723,  5, 0 } }, /* paris */
    { .label = {   2619,  2, 0 } }, /* pl */
    { .label = {   1981,  2, 0 } }, /* pt */
    { .label = { 171796,  3, 0 } }, /* q-a */
    { .label = {     17,  2, 0 } }, /* ro */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {    699,  2, 0 } }, /* si */
    { .label = {    312,  2, 0 } }, /* sk */
    { .label = {    163,  2, 0 } }, /* tr */
    { .label = {   2514,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */

    /* entries 8081 to 8085 */
    { .label = {  13493,  5, 0 } }, /* cloud */
    { .label = {     67,  2, 1 } }, { .child = { 8086, 1 } }, /* os */
    { .label = {  28789,  3, 1 } }, { .child = { 8087, 1 } }, /* stg */

    /* entry 8086 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entries 8087 to 8088 */
    { .label = {     67,  2, 1 } }, { .child = { 8089, 1 } }, /* os */

    /* entry 8089 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entries 8090 to 8100 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 108388,  3, 0 } }, /* sld */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  10040,  3, 0 } }, /* ing */
    { .label = {   9997,  3, 0 } }, /* abo */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8101 to 8109 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 8110 to 8112 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */

    /* entry 8113 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8114 to 8121 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {     27,  1, 0 } }, /* i */

    /* entries 8122 to 8135 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25779,  3, 0 } }, /* fam */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  42794,  3, 0 } }, /* gok */
    { .label = {   4380,  3, 0 } }, /* gon */
    { .label = {  12949,  3, 0 } }, /* gop */
    { .label = {   9296,  3, 0 } }, /* gos */
    { .label = { 112595,  4, 0 } }, /* info */

    /* entries 8136 to 8308 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4529,  3, 0 } }, /* aid */
    { .label = {  94681,  4, 0 } }, /* agro */
    { .label = {  72992,  3, 0 } }, /* atm */
    { .label = {  71620,  4, 0 } }, /* auto */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = { 163357,  5, 0 } }, /* gmina */
    { .label = { 156896,  3, 0 } }, /* gsm */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  13622,  4, 0 } }, /* mail */
    { .label = { 151932,  6, 0 } }, /* miasta */
    { .label = {  97740,  5, 0 } }, /* media */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  37731, 13, 0 } }, /* nieruchomosci */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   1999,  2, 0 } }, /* pc */
    { .label = { 151955,  6, 0 } }, /* powiat */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  74704, 10, 0 } }, /* realestate */
    { .label = {   2926,  3, 0 } }, /* rel */
    { .label = {   6268,  3, 0 } }, /* sex */
    { .label = {  51997,  4, 0 } }, /* shop */
    { .label = { 163378,  5, 0 } }, /* sklep */
    { .label = {  39373,  3, 0 } }, /* sos */
    { .label = { 151982,  6, 0 } }, /* szkola */
    { .label = { 163402,  5, 0 } }, /* targi */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 131787,  7, 0 } }, /* tourism */
    { .label = {   9925,  6, 0 } }, /* travel */
    { .label = {  92492,  9, 0 } }, /* turystyka */
    { .label = {   3879,  3, 1 } }, { .child = { 8309, 47 } }, /* gov */
    { .label = { 112847,  8, 0 } }, /* augustow */
    { .label = {  74743, 10, 0 } }, /* babia-gora */
    { .label = { 152043,  6, 0 } }, /* bedzin */
    { .label = { 131817,  7, 0 } }, /* beskidy */
    { .label = {  74786, 10, 0 } }, /* bialowieza */
    { .label = {  92570,  9, 0 } }, /* bialystok */
    { .label = { 131851,  7, 0 } }, /* bielawa */
    { .label = {  74832, 10, 0 } }, /* bieszczady */
    { .label = {  59096, 11, 0 } }, /* boleslawiec */
    { .label = {  92611,  9, 0 } }, /* bydgoszcz */
    { .label = { 163502,  5, 0 } }, /* bytom */
    { .label = { 131882,  7, 0 } }, /* cieszyn */
    { .label = { 131916,  7, 0 } }, /* czeladz */
    { .label = { 163527,  5, 0 } }, /* czest */
    { .label = {  92660,  9, 0 } }, /* dlugoleka */
    { .label = { 152073,  6, 0 } }, /* elblag */
    { .label = {  16693,  3, 0 } }, /* elk */
    { .label = { 152101,  6, 0 } }, /* glogow */
    { .label = { 131952,  7, 0 } }, /* gniezno */
    { .label = { 131984,  7, 0 } }, /* gorlice */
    { .label = { 132015,  7, 0 } }, /* grajewo */
    { .label = { 163551,  5, 0 } }, /* ilawa */
    { .label = { 112883,  8, 0 } }, /* jaworzno */
    { .label = {  47698, 12, 0 } }, /* jelenia-gora */
    { .label = { 163572,  5, 0 } }, /* jgora */
    { .label = { 152130,  6, 0 } }, /* kalisz */
    { .label = {  22502, 15, 0 } }, /* kazimierz-dolny */
    { .label = { 132048,  7, 0 } }, /* karpacz */
    { .label = { 132081,  7, 0 } }, /* kartuzy */
    { .label = { 132115,  7, 0 } }, /* kaszuby */
    { .label = { 112922,  8, 0 } }, /* katowice */
    { .label = { 163595,  5, 0 } }, /* kepno */
    { .label = { 132151,  7, 0 } }, /* ketrzyn */
    { .label = { 132185,  7, 0 } }, /* klodzko */
    { .label = {  74883, 10, 0 } }, /* kobierzyce */
    { .label = {  92701,  9, 0 } }, /* kolobrzeg */
    { .label = { 163618,  5, 0 } }, /* konin */
    { .label = {  74932, 10, 0 } }, /* konskowola */
    { .label = { 163639,  5, 0 } }, /* kutno */
    { .label = { 168996,  4, 0 } }, /* lapy */
    { .label = { 152158,  6, 0 } }, /* lebork */
    { .label = { 132220,  7, 0 } }, /* legnica */
    { .label = { 132250,  7, 0 } }, /* lezajsk */
    { .label = { 112957,  8, 0 } }, /* limanowa */
    { .label = { 163661,  5, 0 } }, /* lomza */
    { .label = { 152186,  6, 0 } }, /* lowicz */
    { .label = { 163685,  5, 0 } }, /* lubin */
    { .label = { 163709,  5, 0 } }, /* lukow */
    { .label = { 132285,  7, 0 } }, /* malbork */
    { .label = {  74976, 10, 0 } }, /* malopolska */
    { .label = { 112991,  8, 0 } }, /* mazowsze */
    { .label = { 152217,  6, 0 } }, /* mazury */
    { .label = { 152247,  6, 0 } }, /* mielec */
    { .label = { 152274,  6, 0 } }, /* mielno */
    { .label = { 132317,  7, 0 } }, /* mragowo */
    { .label = {  70814,  5, 0 } }, /* naklo */
    { .label = { 113031,  8, 0 } }, /* nowaruda */
    { .label = {  46086,  4, 0 } }, /* nysa */
    { .label = { 163734,  5, 0 } }, /* olawa */
    { .label = { 152300,  6, 0 } }, /* olecko */
    { .label = { 152327,  6, 0 } }, /* olkusz */
    { .label = { 132348,  7, 0 } }, /* olsztyn */
    { .label = { 132382,  7, 0 } }, /* opoczno */
    { .label = { 163755,  5, 0 } }, /* opole */
    { .label = { 132416,  7, 0 } }, /* ostroda */
    { .label = {  92745,  9, 0 } }, /* ostroleka */
    { .label = {  92782,  9, 0 } }, /* ostrowiec */
    { .label = {  75020, 10, 0 } }, /* ostrowwlkp */
    { .label = { 169016,  4, 0 } }, /* pila */
    { .label = { 169034,  4, 0 } }, /* pisz */
    { .label = { 132444,  7, 0 } }, /* podhale */
    { .label = { 113065,  8, 0 } }, /* podlasie */
    { .label = {  92821,  9, 0 } }, /* polkowice */
    { .label = { 132476,  7, 0 } }, /* pomorze */
    { .label = {  92864,  9, 0 } }, /* pomorskie */
    { .label = {  75068, 10, 0 } }, /* prochowice */
    { .label = { 113100,  8, 0 } }, /* pruszkow */
    { .label = {  92904,  9, 0 } }, /* przeworsk */
    { .label = { 152357,  6, 0 } }, /* pulawy */
    { .label = { 163778,  5, 0 } }, /* radom */
    { .label = { 113141,  8, 0 } }, /* rawa-maz */
    { .label = { 152388,  6, 0 } }, /* rybnik */
    { .label = { 132510,  7, 0 } }, /* rzeszow */
    { .label = {  86175,  5, 0 } }, /* sanok */
    { .label = { 163799,  5, 0 } }, /* sejny */
    { .label = { 163824,  5, 0 } }, /* slask */
    { .label = { 152417,  6, 0 } }, /* slupsk */
    { .label = {  92948,  9, 0 } }, /* sosnowiec */
    { .label = {  47750, 12, 0 } }, /* stalowa-wola */
    { .label = { 132546,  7, 0 } }, /* skoczow */
    { .label = {  47802, 12, 0 } }, /* starachowice */
    { .label = { 113177,  8, 0 } }, /* stargard */
    { .label = { 132581,  7, 0 } }, /* suwalki */
    { .label = { 113209,  8, 0 } }, /* swidnica */
    { .label = {  75115, 10, 0 } }, /* swiebodzin */
    { .label = {  59146, 11, 0 } }, /* swinoujscie */
    { .label = { 113244,  8, 0 } }, /* szczecin */
    { .label = { 113284,  8, 0 } }, /* szczytno */
    { .label = {  75163, 10, 0 } }, /* tarnobrzeg */
    { .label = { 163845,  5, 0 } }, /* tgory */
    { .label = { 163868,  5, 0 } }, /* turek */
    { .label = { 163890,  5, 0 } }, /* tychy */
    { .label = { 163916,  5, 0 } }, /* ustka */
    { .label = {  92987,  9, 0 } }, /* walbrzych */
    { .label = { 152446,  6, 0 } }, /* warmia */
    { .label = { 113325,  8, 0 } }, /* warszawa */
    { .label = {  19417,  3, 0 } }, /* waw */
    { .label = { 152471,  6, 0 } }, /* wegrow */
    { .label = { 152500,  6, 0 } }, /* wielun */
    { .label = {  93034,  5, 0 } }, /* wlocl */
    { .label = {  93034,  9, 0 } }, /* wloclawek */
    { .label = {  93077,  9, 0 } }, /* wodzislaw */
    { .label = { 132613,  7, 0 } }, /* wolomin */
    { .label = { 132645,  7, 0 } }, /* wroclaw */
    { .label = {  93121,  9, 0 } }, /* zachpomor */
    { .label = { 163937,  5, 0 } }, /* zagan */
    { .label = { 163959,  5, 0 } }, /* zarow */
    { .label = { 163983,  5, 0 } }, /* zgora */
    { .label = {  93164,  9, 0 } }, /* zgorzelec */
    { .label = { 108539,  4, 0 } }, /* beep */
    { .label = { 139760,  7, 0 } }, /* krasnik */
    { .label = { 156819,  6, 0 } }, /* leczna */
    { .label = { 118688,  8, 0 } }, /* lubartow */
    { .label = { 156847,  6, 0 } }, /* lublin */
    { .label = {  97573,  9, 0 } }, /* poniatowa */
    { .label = { 139789,  7, 0 } }, /* swidnik */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = { 140167,  7, 0 } }, /* gliwice */
    { .label = { 157227,  6, 0 } }, /* krakow */
    { .label = { 157254,  6, 0 } }, /* poznan */
    { .label = { 132645,  4, 0 } }, /* wroc */
    { .label = { 119173,  8, 0 } }, /* zakopane */
    { .label = {  12334,  3, 0 } }, /* gda */
    { .label = { 157447,  6, 0 } }, /* gdansk */
    { .label = { 157473,  6, 0 } }, /* gdynia */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = { 167545,  5, 0 } }, /* sopot */

    /* entries 8309 to 8355 */
    { .label = {    321,  2, 0 } }, /* ap */
    { .label = {    129,  2, 0 } }, /* ic */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = { 163422,  5, 0 } }, /* kmpsp */
    { .label = { 163448,  5, 0 } }, /* kppsp */
    { .label = { 163475,  5, 0 } }, /* kwpsp */
    { .label = {  56547,  3, 0 } }, /* psp */
    { .label = { 168782,  4, 0 } }, /* wskr */
    { .label = {  99311,  3, 0 } }, /* kwp */
    { .label = {  11516,  2, 0 } }, /* mw */
    { .label = {   2528,  2, 0 } }, /* ug */
    { .label = {    110,  2, 0 } }, /* um */
    { .label = {  55624,  4, 0 } }, /* umig */
    { .label = { 168801,  4, 0 } }, /* ugim */
    { .label = { 168820,  4, 0 } }, /* upow */
    { .label = {    261,  2, 0 } }, /* uw */
    { .label = {  92533,  9, 0 } }, /* starostwo */
    { .label = {    490,  2, 0 } }, /* pa */
    { .label = {     41,  2, 0 } }, /* po */
    { .label = { 168841,  4, 0 } }, /* psse */
    { .label = {  55345,  3, 0 } }, /* pup */
    { .label = { 168859,  4, 0 } }, /* rzgw */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {    131,  2, 0 } }, /* so */
    { .label = {      2,  2, 0 } }, /* sr */
    { .label = {  34602,  3, 0 } }, /* wsa */
    { .label = {   3657,  3, 0 } }, /* sko */
    { .label = {  89494,  3, 0 } }, /* uzs */
    { .label = { 168881,  4, 0 } }, /* wiih */
    { .label = { 148313,  4, 0 } }, /* winb */
    { .label = { 168900,  4, 0 } }, /* pinb */
    { .label = { 168920,  4, 0 } }, /* wios */
    { .label = { 157513,  4, 0 } }, /* witd */
    { .label = { 152010,  6, 0 } }, /* wzmiuw */
    { .label = {  57832,  3, 0 } }, /* piw */
    { .label = { 101537,  3, 0 } }, /* wiw */
    { .label = { 168938,  4, 0 } }, /* griw */
    { .label = {  17239,  3, 0 } }, /* wif */
    { .label = {  65542,  3, 0 } }, /* oum */
    { .label = {   5475,  3, 0 } }, /* sdn */
    { .label = {   9086,  2, 0 } }, /* zp */
    { .label = { 135917,  4, 0 } }, /* uppo */
    { .label = {  19924,  3, 0 } }, /* mup */
    { .label = { 168957,  4, 0 } }, /* wuoz */
    { .label = { 112813,  8, 0 } }, /* konsulat */
    { .label = { 168979,  4, 0 } }, /* oirm */

    /* entry 8356 */
    { .label = {  17907,  3, 0 } }, /* own */

    /* entries 8357 to 8361 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 8362 to 8374 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  93099,  4, 0 } }, /* isla */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {    758,  3, 0 } }, /* est */
    { .label = {  52386,  4, 0 } }, /* prof */
    { .label = {    103,  2, 0 } }, /* ac */

    /* entries 8375 to 8389 */
    { .label = {   3681,  3, 0 } }, /* aaa */
    { .label = {    488,  3, 0 } }, /* aca */
    { .label = { 169055,  4, 0 } }, /* acct */
    { .label = { 141239,  6, 0 } }, /* avocat */
    { .label = {   3030,  3, 0 } }, /* bar */
    { .label = {  32963,  3, 0 } }, /* cpa */
    { .label = {   2740,  3, 0 } }, /* eng */
    { .label = {  98970,  3, 0 } }, /* jur */
    { .label = {  20404,  3, 0 } }, /* law */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = { 164006,  5, 0 } }, /* recht */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = { 117612,  8, 1 } }, { .child = { 8390, 1 } }, /* dnstrace */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entry 8390 */
    { .label = {  21793,  3, 0 } }, /* bci */

    /* entries 8391 to 8397 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  17698,  3, 0 } }, /* sec */
    { .label = {  13492,  3, 0 } }, /* plo */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */

    /* entries 8398 to 8407 */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  24396,  4, 0 } }, /* publ */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  25698,  4, 0 } }, /* nome */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 8408 to 8416 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    123,  2, 0 } }, /* ed */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 164028,  5, 0 } }, /* belau */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = { 170995,  4, 0 } }, /* x443 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8417 to 8423 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8424 to 8433 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8434 to 8437 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 8438 to 8451 */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13403,  3, 0 } }, /* rec */
    { .label = { 157748,  5, 0 } }, /* store */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = { 156955,  3, 0 } }, /* www */
    { .label = {  51997,  4, 0 } }, /* shop */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 8452 to 8461 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1971,  2, 0 } }, /* ua */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   2542,  2, 0 } }, /* ox */

    /* entries 8462 to 8495 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {   3901,  4, 0 } }, /* test */
    { .label = { 139239,  7, 0 } }, /* adygeya */
    { .label = {  96823,  9, 0 } }, /* bashkiria */
    { .label = {  57187,  3, 0 } }, /* bir */
    { .label = {  22317,  3, 0 } }, /* cbg */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 117861,  8, 0 } }, /* dagestan */
    { .label = { 156290,  6, 0 } }, /* grozny */
    { .label = { 117893,  8, 0 } }, /* kalmykia */
    { .label = { 117929,  8, 0 } }, /* kustanai */
    { .label = { 156320,  6, 0 } }, /* marine */
    { .label = { 117961,  8, 0 } }, /* mordovia */
    { .label = {  15147,  3, 0 } }, /* msk */
    { .label = { 166841,  5, 0 } }, /* mytis */
    { .label = { 139271,  7, 0 } }, /* nalchik */
    { .label = {  65147,  3, 0 } }, /* nov */
    { .label = {  79343, 10, 0 } }, /* pyatigorsk */
    { .label = {     52,  3, 0 } }, /* spb */
    { .label = {  65158, 11, 0 } }, /* vladikavkaz */
    { .label = { 117996,  8, 0 } }, /* vladimir */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = { 156680,  6, 1 } }, { .child = { 8496, 4 } }, /* myjino */
    { .label = { 139821,  7, 1 } }, { .child = { 8508, 1 } }, /* cldmail */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6753,  2, 0 } }, /* pp */
    { .label = {   4781,  3, 0 } }, /* ras */

    /* entries 8496 to 8503 */
    { .label = {  23781,  7, 1 } }, { .child = { 8504, 1 } }, /* hosting */
    { .label = { 139698,  7, 1 } }, { .child = { 8505, 1 } }, /* landing */
    { .label = { 118616,  8, 1 } }, { .child = { 8506, 1 } }, /* spectrum */
    { .label = {  31939,  3, 1 } }, { .child = { 8507, 1 } }, /* vps */

    /* entry 8504 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8505 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8506 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8507 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8508 */
    { .label = {     90,  2, 0 } }, /* hb */

    /* entries 8509 to 8515 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8516 to 8523 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  10104,  3, 0 } }, /* pub */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   6667,  3, 0 } }, /* sch */

    /* entries 8524 to 8528 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8529 to 8533 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */

    /* entries 8534 to 8541 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */

    /* entries 8542 to 8583 */
    { .label = {     26,  1, 0 } }, /* a */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = {  21007,  2, 0 } }, /* bd */
    { .label = {  14823,  5, 0 } }, /* brand */
    { .label = {     19,  1, 0 } }, /* c */
    { .label = {     30,  1, 0 } }, /* d */
    { .label = {     25,  1, 0 } }, /* e */
    { .label = {     68,  1, 0 } }, /* f */
    { .label = {   4747,  2, 0 } }, /* fh */
    { .label = { 169072,  4, 0 } }, /* fhsk */
    { .label = { 171485,  3, 0 } }, /* fhv */
    { .label = {      3,  1, 0 } }, /* g */
    { .label = {     90,  1, 0 } }, /* h */
    { .label = {     27,  1, 0 } }, /* i */
    { .label = {     24,  1, 0 } }, /* k */
    { .label = { 132678,  7, 0 } }, /* komforb */
    { .label = {  22574, 15, 0 } }, /* kommunalforbund */
    { .label = { 152528,  6, 0 } }, /* komvux */
    { .label = {     79,  1, 0 } }, /* l */
    { .label = { 152559,  6, 0 } }, /* lanbib */
    { .label = {     29,  1, 0 } }, /* m */
    { .label = {     28,  1, 0 } }, /* n */
    { .label = {  28981, 14, 0 } }, /* naturbruksgymn */
    { .label = {     21,  1, 0 } }, /* o */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     18,  1, 0 } }, /* p */
    { .label = { 164051,  5, 0 } }, /* parti */
    { .label = {   6753,  2, 0 } }, /* pp */
    { .label = {  23006,  5, 0 } }, /* press */
    { .label = {      1,  1, 0 } }, /* r */
    { .label = {      2,  1, 0 } }, /* s */
    { .label = {      4,  1, 0 } }, /* t */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {     46,  1, 0 } }, /* u */
    { .label = {      8,  1, 0 } }, /* w */
    { .label = {     20,  1, 0 } }, /* x */
    { .label = {     38,  1, 0 } }, /* y */
    { .label = {    202,  1, 0 } }, /* z */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  65020,  4, 0 } }, /* conf */

    /* entries 8584 to 8590 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   5389,  3, 0 } }, /* per */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 8591 to 8600 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 118506,  8, 0 } }, /* hashbang */
    { .label = {  80691,  8, 1 } }, { .child = { 8601, 1 } }, /* platform */
    { .label = { 119751,  8, 0 } }, /* wedeploy */
    { .label = {    540,  3, 0 } }, /* now */

    /* entry 8601 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8602 to 8603 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8604 to 8605 */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 8606 to 8610 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8611 to 8618 */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = { 167752,  4, 0 } }, /* gouv */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   5389,  5, 0 } }, /* perso */
    { .label = {  73229,  4, 0 } }, /* univ */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 8619 to 8622 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */

    /* entries 8623 to 8636 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  93209,  9, 0 } }, /* consulado */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  93248,  9, 0 } }, /* embaixada */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 113361,  8, 0 } }, /* principe */
    { .label = { 132712,  7, 0 } }, /* saotome */
    { .label = { 157748,  5, 0 } }, /* store */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = { 157702,  4, 0 } }, /* noho */

    /* entries 8637 to 8689 */
    { .label = { 118032,  8, 0 } }, /* abkhazia */
    { .label = { 139239,  7, 0 } }, /* adygeya */
    { .label = {  79388, 10, 0 } }, /* aktyubinsk */
    { .label = {  65210, 11, 0 } }, /* arkhangelsk */
    { .label = { 139302,  7, 0 } }, /* armenia */
    { .label = { 118068,  8, 0 } }, /* ashgabad */
    { .label = {  79434, 10, 0 } }, /* azerbaijan */
    { .label = { 118102,  8, 0 } }, /* balashov */
    { .label = {  96823,  9, 0 } }, /* bashkiria */
    { .label = { 139329,  7, 0 } }, /* bryansk */
    { .label = { 139361,  7, 0 } }, /* bukhara */
    { .label = { 118138,  8, 0 } }, /* chimkent */
    { .label = { 117861,  8, 0 } }, /* dagestan */
    { .label = {  24563, 15, 0 } }, /* east-kazakhstan */
    { .label = { 166864,  5, 0 } }, /* exnet */
    { .label = { 128215,  7, 0 } }, /* georgia */
    { .label = { 156290,  6, 0 } }, /* grozny */
    { .label = { 139392,  7, 0 } }, /* ivanovo */
    { .label = { 156344,  6, 0 } }, /* jambyl */
    { .label = { 117893,  8, 0 } }, /* kalmykia */
    { .label = { 156376,  6, 0 } }, /* kaluga */
    { .label = { 139423,  7, 0 } }, /* karacol */
    { .label = {  96861,  9, 0 } }, /* karaganda */
    { .label = { 139452,  7, 0 } }, /* karelia */
    { .label = {  96896,  9, 0 } }, /* khakassia */
    { .label = {  96932,  9, 0 } }, /* krasnodar */
    { .label = { 156402,  6, 0 } }, /* kurgan */
    { .label = { 117929,  8, 0 } }, /* kustanai */
    { .label = { 166886,  5, 0 } }, /* lenug */
    { .label = {  79479, 10, 0 } }, /* mangyshlak */
    { .label = { 117961,  8, 0 } }, /* mordovia */
    { .label = {  15147,  3, 0 } }, /* msk */
    { .label = { 118174,  8, 0 } }, /* murmansk */
    { .label = { 139271,  7, 0 } }, /* nalchik */
    { .label = { 166909,  5, 0 } }, /* navoi */
    { .label = {  17406, 16, 0 } }, /* north-kazakhstan */
    { .label = {  65147,  3, 0 } }, /* nov */
    { .label = { 139480,  7, 0 } }, /* obninsk */
    { .label = {  99702,  5, 0 } }, /* penza */
    { .label = { 118209,  8, 0 } }, /* pokrovsk */
    { .label = { 166930,  5, 0 } }, /* sochi */
    { .label = {     52,  3, 0 } }, /* spb */
    { .label = { 118247,  8, 0 } }, /* tashkent */
    { .label = { 156428,  6, 0 } }, /* termez */
    { .label = {  96968,  9, 0 } }, /* togliatti */
    { .label = { 139511,  7, 0 } }, /* troitsk */
    { .label = {  65257, 11, 0 } }, /* tselinograd */
    { .label = { 170710,  4, 0 } }, /* tula */
    { .label = { 170727,  4, 0 } }, /* tuva */
    { .label = {  65158, 11, 0 } }, /* vladikavkaz */
    { .label = { 117996,  8, 0 } }, /* vladimir */
    { .label = { 139540,  7, 0 } }, /* vologda */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 8690 to 8694 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   9449,  3, 0 } }, /* red */

    /* entries 8695 to 8696 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entries 8697 to 8702 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8703 to 8705 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 8706 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 8707 to 8715 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    290,  2, 0 } }, /* mi */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  65926,  6, 0 } }, /* online */
    { .label = {  51997,  4, 0 } }, /* shop */

    /* entries 8716 to 8731 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3901,  4, 0 } }, /* test */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 8732 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 8733 to 8740 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  43572,  3, 0 } }, /* edu */

    /* entries 8741 to 8760 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    226,  3, 0 } }, /* ens */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {  72939,  4, 0 } }, /* intl */
    { .label = {   4389,  3, 0 } }, /* nat */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   5389,  5, 0 } }, /* perso */
    { .label = { 131787,  7, 0 } }, /* tourism */
    { .label = { 152587,  6, 0 } }, /* edunet */
    { .label = { 169092,  4, 0 } }, /* rnrt */
    { .label = {  21833,  3, 0 } }, /* rns */
    { .label = {  56561,  3, 0 } }, /* rnu */
    { .label = { 152613,  6, 0 } }, /* mincom */
    { .label = { 132740,  7, 0 } }, /* agrinet */
    { .label = { 132768,  7, 0 } }, /* defense */
    { .label = { 112076,  5, 0 } }, /* turen */

    /* entries 8761 to 8767 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 140360,  7, 0 } }, /* vpnplus */

    /* entries 8768 to 8791 */
    { .label = {    586,  2, 0 } }, /* av */
    { .label = {  25084,  3, 0 } }, /* bbs */
    { .label = {   4240,  3, 0 } }, /* bel */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {    106,  3, 1 } }, { .child = { 8792, 1 } }, /* com */
    { .label = {   3009,  2, 0 } }, /* dr */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = { 163595,  3, 0 } }, /* kep */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4200,  3, 0 } }, /* pol */
    { .label = {     89,  3, 0 } }, /* tel */
    { .label = {  34409,  3, 0 } }, /* tsk */
    { .label = {   1222,  2, 0 } }, /* tv */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {    311,  2, 1 } }, { .child = { 8793, 1 } }, /* nc */

    /* entry 8792 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entry 8793 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 8794 to 8810 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  52339,  4, 0 } }, /* coop */
    { .label = { 167898,  4, 0 } }, /* jobs */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {   9925,  6, 0 } }, /* travel */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  81233,  4, 0 } }, /* aero */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */

    /* entries 8811 to 8814 */
    { .label = {  31132,  6, 0 } }, /* dyndns */
    { .label = {  64283, 11, 0 } }, /* better-than */
    { .label = {  79113, 10, 0 } }, /* on-the-web */
    { .label = {  79254, 10, 0 } }, /* worse-than */

    /* entries 8815 to 8831 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    106,  3, 1 } }, { .child = { 8832, 1 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  87628,  3, 0 } }, /* idv */
    { .label = {  39696,  4, 0 } }, /* game */
    { .label = { 169108,  4, 0 } }, /* ebiz */
    { .label = {  98320,  4, 0 } }, /* club */
    { .label = {  47853, 12, 0 } }, /* xn--zf0ao64a */
    { .label = {  68034, 10, 0 } }, /* xn--uc0atv */
    { .label = {  59197, 11, 0 } }, /* xn--czrw28b */
    { .label = {   1489,  3, 0 } }, /* url */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  44043,  3, 0 } }, /* nym */

    /* entry 8832 */
    { .label = { 117825,  8, 0 } }, /* mymailer */

    /* entries 8833 to 8844 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  60878,  5, 0 } }, /* hotel */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {   1222,  2, 0 } }, /* tv */

    /* entries 8845 to 8926 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  93287,  9, 0 } }, /* cherkassy */
    { .label = { 113398,  8, 0 } }, /* cherkasy */
    { .label = {  93327,  9, 0 } }, /* chernigov */
    { .label = {  93368,  9, 0 } }, /* chernihiv */
    { .label = {  75208, 10, 0 } }, /* chernivtsi */
    { .label = {  75252, 10, 0 } }, /* chernovtsy */
    { .label = {     19,  2, 0 } }, /* ck */
    { .label = {   2854,  2, 0 } }, /* cn */
    { .label = {   1284,  2, 0 } }, /* cr */
    { .label = { 152640,  6, 0 } }, /* crimea */
    { .label = {   6329,  2, 0 } }, /* cv */
    { .label = {    147,  2, 0 } }, /* dn */
    { .label = {  29045, 14, 0 } }, /* dnepropetrovsk */
    { .label = {  29109, 14, 0 } }, /* dnipropetrovsk */
    { .label = { 132799,  7, 0 } }, /* dominic */
    { .label = { 132830,  7, 0 } }, /* donetsk */
    { .label = {   2718,  2, 0 } }, /* dp */
    { .label = {    539,  2, 0 } }, /* if */
    { .label = {  22644, 15, 0 } }, /* ivano-frankivsk */
    { .label = {   8714,  2, 0 } }, /* kh */
    { .label = { 132860,  7, 0 } }, /* kharkiv */
    { .label = { 132892,  7, 0 } }, /* kharkov */
    { .label = { 132924,  7, 0 } }, /* kherson */
    { .label = {  47922, 12, 0 } }, /* khmelnitskiy */
    { .label = {  47977, 12, 0 } }, /* khmelnytskyi */
    { .label = { 169129,  4, 0 } }, /* kiev */
    { .label = {  75298, 10, 0 } }, /* kirovograd */
    { .label = {     24,  2, 0 } }, /* km */
    { .label = {     43,  2, 0 } }, /* kr */
    { .label = { 109217,  4, 0 } }, /* krym */
    { .label = {   2727,  2, 0 } }, /* ks */
    { .label = {    584,  2, 0 } }, /* kv */
    { .label = { 169148,  4, 0 } }, /* kyiv */
    { .label = {   2037,  2, 0 } }, /* lg */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = { 132954,  7, 0 } }, /* lugansk */
    { .label = { 164072,  5, 0 } }, /* lutsk */
    { .label = {   3767,  2, 0 } }, /* lv */
    { .label = { 169169,  4, 0 } }, /* lviv */
    { .label = {    749,  2, 0 } }, /* mk */
    { .label = { 113434,  8, 0 } }, /* mykolaiv */
    { .label = { 113472,  8, 0 } }, /* nikolaev */
    { .label = {     69,  2, 0 } }, /* od */
    { .label = { 164095,  5, 0 } }, /* odesa */
    { .label = { 152665,  6, 0 } }, /* odessa */
    { .label = {   2619,  2, 0 } }, /* pl */
    { .label = { 132985,  7, 0 } }, /* poltava */
    { .label = { 164115,  5, 0 } }, /* rivne */
    { .label = { 164137,  5, 0 } }, /* rovno */
    { .label = {     12,  2, 0 } }, /* rv */
    { .label = {    424,  2, 0 } }, /* sb */
    { .label = {  75342, 10, 0 } }, /* sebastopol */
    { .label = {  75386, 10, 0 } }, /* sevastopol */
    { .label = {   1519,  2, 0 } }, /* sm */
    { .label = { 167156,  4, 0 } }, /* sumy */
    { .label = {     89,  2, 0 } }, /* te */
    { .label = { 113507,  8, 0 } }, /* ternopil */
    { .label = {   3282,  2, 0 } }, /* uz */
    { .label = { 113542,  8, 0 } }, /* uzhgorod */
    { .label = { 133016,  7, 0 } }, /* vinnica */
    { .label = {  93409,  9, 0 } }, /* vinnytsia */
    { .label = {  11137,  2, 0 } }, /* vn */
    { .label = { 164159,  5, 0 } }, /* volyn */
    { .label = { 164184,  5, 0 } }, /* yalta */
    { .label = {  59262, 11, 0 } }, /* zaporizhzhe */
    { .label = {  48034, 12, 0 } }, /* zaporizhzhia */
    { .label = { 113581,  8, 0 } }, /* zhitomir */
    { .label = { 113618,  8, 0 } }, /* zhytomyr */
    { .label = {   9086,  2, 0 } }, /* zp */
    { .label = {   9112,  2, 0 } }, /* zt */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {   5417,  3, 0 } }, /* inf */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   6753,  2, 0 } }, /* pp */

    /* entries 8927 to 8936 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    601,  2, 0 } }, /* sc */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 8937 to 8952 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 8953, 8 } }, /* co */
    { .label = {   3879,  3, 1 } }, { .child = { 8964, 2 } }, /* gov */
    { .label = { 131279,  3, 0 } }, /* ltd */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {   3877,  3, 0 } }, /* nhs */
    { .label = {    209,  3, 1 } }, { .child = { 8966, 3 } }, /* org */
    { .label = {   2619,  3, 0 } }, /* plc */
    { .label = { 152689,  6, 0 } }, /* police */
    { .label = {   6667,  3, 1 } }, { .child = { 8969, 1 } }, /* sch */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entries 8953 to 8961 */
    { .label = { 116642,  8, 1 } }, { .child = { 8962, 2 } }, /* bytemark */
    { .label = { 118432,  8, 0 } }, /* blogspot */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = {  65903, 11, 0 } }, /* barsyonline */
    { .label = { 139886,  7, 0 } }, /* nh-serv */
    { .label = { 167192,  5, 0 } }, /* no-ip */
    { .label = {  40765, 13, 0 } }, /* wellbeingzone */
    { .label = { 140427,  7, 0 } }, /* gwiddle */

    /* entries 8962 to 8963 */
    { .label = {   3248,  2, 0 } }, /* dh */
    { .label = {  17305,  2, 0 } }, /* vm */

    /* entries 8964 to 8965 */
    { .label = {  98476,  7, 0 } }, /* service */
    { .label = {  79571, 10, 0 } }, /* homeoffice */

    /* entries 8966 to 8968 */
    { .label = { 170808,  4, 0 } }, /* glug */
    { .label = {  76448,  3, 0 } }, /* lug */
    { .label = { 156886,  4, 0 } }, /* lugs */

    /* entry 8969 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8970 to 9093 */
    { .label = {  20678,  3, 0 } }, /* dni */
    { .label = {   9447,  3, 0 } }, /* fed */
    { .label = {   9230,  3, 0 } }, /* isa */
    { .label = { 129894,  4, 0 } }, /* kids */
    { .label = {   7029,  3, 0 } }, /* nsn */
    { .label = {    619,  2, 1 } }, { .child = { 9094, 3 } }, /* ak */
    { .label = {     94,  2, 1 } }, { .child = { 9097, 3 } }, /* al */
    { .label = {     45,  2, 1 } }, { .child = { 9100, 3 } }, /* ar */
    { .label = {    128,  2, 1 } }, { .child = { 9103, 3 } }, /* as */
    { .label = {    199,  2, 1 } }, { .child = { 9106, 3 } }, /* az */
    { .label = {    133,  2, 1 } }, { .child = { 9109, 3 } }, /* ca */
    { .label = {     42,  2, 1 } }, { .child = { 9112, 3 } }, /* co */
    { .label = {   1982,  2, 1 } }, { .child = { 9115, 3 } }, /* ct */
    { .label = {   6749,  2, 1 } }, { .child = { 9118, 3 } }, /* dc */
    { .label = {    243,  2, 1 } }, { .child = { 9121, 3 } }, /* de */
    { .label = {    191,  2, 1 } }, { .child = { 9124, 3 } }, /* fl */
    { .label = {    313,  2, 1 } }, { .child = { 9127, 3 } }, /* ga */
    { .label = {   3007,  2, 1 } }, { .child = { 9130, 3 } }, /* gu */
    { .label = {    195,  2, 1 } }, { .child = { 9133, 2 } }, /* hi */
    { .label = {     27,  2, 1 } }, { .child = { 9135, 3 } }, /* ia */
    { .label = {    143,  2, 1 } }, { .child = { 9138, 3 } }, /* id */
    { .label = {    556,  2, 1 } }, { .child = { 9141, 3 } }, /* il */
    { .label = {    100,  2, 1 } }, { .child = { 9144, 3 } }, /* in */
    { .label = {   2727,  2, 1 } }, { .child = { 9147, 3 } }, /* ks */
    { .label = {    494,  2, 1 } }, { .child = { 9150, 3 } }, /* ky */
    { .label = {    557,  2, 1 } }, { .child = { 9153, 3 } }, /* la */
    { .label = {    194,  2, 1 } }, { .child = { 9156, 3 } }, /* ma */
    { .label = {   6744,  2, 1 } }, { .child = { 9163, 3 } }, /* md */
    { .label = {    591,  2, 1 } }, { .child = { 9166, 3 } }, /* me */
    { .label = {    290,  2, 1 } }, { .child = { 9169, 11 } }, /* mi */
    { .label = {    571,  2, 1 } }, { .child = { 9180, 3 } }, /* mn */
    { .label = {   3360,  2, 1 } }, { .child = { 9183, 3 } }, /* mo */
    { .label = {    126,  2, 1 } }, { .child = { 9186, 3 } }, /* ms */
    { .label = {    158,  2, 1 } }, { .child = { 9189, 3 } }, /* mt */
    { .label = {    311,  2, 1 } }, { .child = { 9192, 3 } }, /* nc */
    { .label = {    354,  2, 1 } }, { .child = { 9195, 2 } }, /* nd */
    { .label = {     40,  2, 1 } }, { .child = { 9197, 3 } }, /* ne */
    { .label = {    704,  2, 1 } }, { .child = { 9200, 3 } }, /* nh */
    { .label = {   9530,  2, 1 } }, { .child = { 9203, 3 } }, /* nj */
    { .label = {    201,  2, 1 } }, { .child = { 9206, 3 } }, /* nm */
    { .label = {    152,  2, 1 } }, { .child = { 9209, 3 } }, /* nv */
    { .label = {   3084,  2, 1 } }, { .child = { 9212, 3 } }, /* ny */
    { .label = {   1412,  2, 1 } }, { .child = { 9215, 3 } }, /* oh */
    { .label = {    468,  2, 1 } }, { .child = { 9218, 3 } }, /* ok */
    { .label = {     47,  2, 1 } }, { .child = { 9221, 3 } }, /* or */
    { .label = {    490,  2, 1 } }, { .child = { 9224, 3 } }, /* pa */
    { .label = {   1283,  2, 1 } }, { .child = { 9227, 3 } }, /* pr */
    { .label = {    393,  2, 1 } }, { .child = { 9230, 3 } }, /* ri */
    { .label = {    601,  2, 1 } }, { .child = { 9233, 3 } }, /* sc */
    { .label = {    253,  2, 1 } }, { .child = { 9236, 2 } }, /* sd */
    { .label = {    700,  2, 1 } }, { .child = { 9238, 3 } }, /* tn */
    { .label = {   1015,  2, 1 } }, { .child = { 9241, 3 } }, /* tx */
    { .label = {    635,  2, 1 } }, { .child = { 9244, 3 } }, /* ut */
    { .label = {    569,  2, 1 } }, { .child = { 9247, 3 } }, /* vi */
    { .label = {   2412,  2, 1 } }, { .child = { 9250, 3 } }, /* vt */
    { .label = {     54,  2, 1 } }, { .child = { 9253, 3 } }, /* va */
    { .label = {    548,  2, 1 } }, { .child = { 9256, 3 } }, /* wa */
    { .label = {    216,  2, 1 } }, { .child = { 9259, 3 } }, /* wi */
    { .label = {   1874,  2, 1 } }, { .child = { 9262, 1 } }, /* wv */
    { .label = {   5476,  2, 1 } }, { .child = { 9263, 3 } }, /* wy */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = { 170475,  4, 0 } }, /* drud */
    { .label = { 166641,  5, 0 } }, /* is-by */
    { .label = {  64955, 11, 0 } }, /* land-4-sale */
    { .label = {  51119, 12, 0 } }, /* stuff-4-sale */
    { .label = { 117663,  8, 0 } }, /* freeddns */
    { .label = { 140046,  7, 0 } }, /* golffan */
    { .label = { 171027,  4, 0 } }, /* noip */
    { .label = { 140109,  7, 0 } }, /* pointto */

    /* entries 9094 to 9096 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9097 to 9099 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9100 to 9102 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9103 to 9105 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9106 to 9108 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9109 to 9111 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9112 to 9114 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9115 to 9117 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9118 to 9120 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9121 to 9123 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9124 to 9126 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9127 to 9129 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9130 to 9132 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9133 to 9134 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9135 to 9137 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9138 to 9140 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9141 to 9143 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9144 to 9146 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9147 to 9149 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9150 to 9152 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9153 to 9155 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9156 to 9159 */
    { .label = { 171429,  3, 1 } }, { .child = { 9160, 3 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9160 to 9162 */
    { .label = {  68391,  3, 0 } }, /* pvt */
    { .label = { 169190,  4, 0 } }, /* chtr */
    { .label = { 152717,  6, 0 } }, /* paroch */

    /* entries 9163 to 9165 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9166 to 9168 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9169 to 9179 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */
    { .label = {  93448,  9, 0 } }, /* ann-arbor */
    { .label = {  89648,  3, 0 } }, /* cog */
    { .label = {   7392,  3, 0 } }, /* dst */
    { .label = {  43044,  5, 0 } }, /* eaton */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   4448,  3, 0 } }, /* mus */
    { .label = {   7129,  3, 0 } }, /* tec */
    { .label = {  93485,  9, 0 } }, /* washtenaw */

    /* entries 9180 to 9182 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9183 to 9185 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9186 to 9188 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9189 to 9191 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9192 to 9194 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9195 to 9196 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9197 to 9199 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9200 to 9202 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9203 to 9205 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9206 to 9208 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9209 to 9211 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9212 to 9214 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9215 to 9217 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9218 to 9220 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9221 to 9223 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9224 to 9226 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9227 to 9229 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9230 to 9232 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9233 to 9235 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9236 to 9237 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9238 to 9240 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9241 to 9243 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9244 to 9246 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9247 to 9249 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9250 to 9252 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9253 to 9255 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9256 to 9258 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9259 to 9261 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entry 9262 */
    { .label = {    466,  2, 0 } }, /* cc */

    /* entries 9263 to 9265 */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  17021,  3, 0 } }, /* lib */

    /* entries 9266 to 9273 */
    { .label = {    106,  3, 1 } }, { .child = { 9274, 1 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  34982,  3, 0 } }, /* gub */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entry 9274 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 9275 to 9278 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9279 to 9285 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 9286 to 9302 */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 171430,  3, 0 } }, /* e12 */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = { 115078,  4, 0 } }, /* firm */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  13403,  3, 0 } }, /* rec */
    { .label = { 157748,  5, 0 } }, /* store */
    { .label = {   7129,  3, 0 } }, /* tec */
    { .label = {    683,  3, 0 } }, /* web */

    /* entry 9303 */
    { .label = {   1460,  3, 0 } }, /* nom */

    /* entries 9304 to 9308 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 171429,  3, 0 } }, /* k12 */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9309 to 9321 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  29770,  4, 0 } }, /* name */
    { .label = {  23051,  3, 0 } }, /* pro */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 9322 to 9325 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9326 to 9335 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3989,  7, 1 } }, { .child = { 9336, 1 } }, /* advisor */
    { .label = { 136686,  7, 0 } }, /* cloud66 */
    { .label = {  31132,  6, 0 } }, /* dyndns */
    { .label = { 156034,  6, 0 } }, /* mypets */

    /* entry 9336 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9337 to 9342 */
    { .label = {  67605, 10, 0 } }, /* xn--55qx5d */
    { .label = {  52524, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  67815, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  67871, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  67723, 10, 0 } }, /* xn--od0alg */
    { .label = {  68034, 10, 0 } }, /* xn--uc0atv */

    /* entries 9343 to 9348 */
    { .label = {  93815,  8, 0 } }, /* xn--o1ac */
    { .label = {  93715,  9, 0 } }, /* xn--c1avg */
    { .label = {  93762,  9, 0 } }, /* xn--90azh */
    { .label = { 113783,  8, 0 } }, /* xn--d1at */
    { .label = {  93815,  9, 0 } }, /* xn--o1ach */
    { .label = { 113823,  8, 0 } }, /* xn--80au */

    /* entries 9349 to 9354 */
    { .label = {  38164, 13, 0 } }, /* xn--12c1fe0br */
    { .label = {  16361, 16, 0 } }, /* xn--12co0c3b4eva */
    { .label = {  38241, 13, 0 } }, /* xn--h3cuzk1di */
    { .label = {  59971, 11, 0 } }, /* xn--o3cyx2a */
    { .label = {  48574, 12, 0 } }, /* xn--m3ch0j3a */
    { .label = {  22874, 15, 0 } }, /* xn--12cfi8ixb8l */

    /* entry 9355 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9356 to 9373 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  56604,  5, 0 } }, /* agric */
    { .label = {   1512,  3, 0 } }, /* alt */
    { .label = {     42,  2, 1 } }, { .child = { 9374, 1 } }, /* co */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 133046,  7, 0 } }, /* grondar */
    { .label = {  20404,  3, 0 } }, /* law */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {  17062,  3, 0 } }, /* nis */
    { .label = {   1460,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 149362,  6, 0 } }, /* school */
    { .label = {   2442,  2, 0 } }, /* tm */
    { .label = {    683,  3, 0 } }, /* web */

    /* entry 9374 */
    { .label = { 118432,  8, 0 } }, /* blogspot */

    /* entries 9375 to 9385 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3641,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43572,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 112595,  4, 0 } }, /* info */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {  13560,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */

    /* entries 9386 to 9390 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  25180,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 9391 */
    { .label = { 119867,  8, 0 } }, /* official */

    /* entries 9392 to 9398 */
    { .label = { 166593,  5, 0 } }, /* wnext */
    { .label = {  32012,  3, 1 } }, { .child = { 9399, 1 } }, /* run */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  79753,  6, 0 } }, /* hasura */
    { .label = {  97534,  9, 0 } }, /* loginline */
    { .label = { 140396,  7, 0 } }, /* telebit */

    /* entry 9399 */
    { .label = {     26,  1, 0 } }, /* a */

    /* entry 9400 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 9401 to 9402 */
    { .label = { 143743,  4, 1 } }, { .child = { 9403, 1 } }, /* nabu */

    /* entry 9403 */
    { .label = {   3816,  2, 0 } }, /* ui */

    /* entry 9404 */
    { .label = {    761,  2, 0 } }, /* ng */

    /* entries 9405 to 9416 */
    { .label = { 139603,  7, 1 } }, { .child = { 9417, 1 } }, /* statics */
    { .label = {  32050,  8, 0 } }, /* linkyard */
    { .label = {  65999, 11, 1 } }, { .child = { 9418, 1 } }, /* magentosite */
    { .label = {  48035,  5, 0 } }, /* vapor */
    { .label = {  80784, 10, 1 } }, { .child = { 9419, 1 } }, /* on-rancher */
    { .label = {  80966, 10, 1 } }, { .child = { 9420, 1 } }, /* sensiosite */
    { .label = {  66644, 11, 0 } }, /* trafficplex */
    { .label = {  98264,  9, 0 } }, /* voorloper */

    /* entry 9417 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9418 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9419 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9420 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9421 to 9423 */
    { .label = { 136759,  7, 0 } }, /* cloudns */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = { 170828,  4, 0 } }, /* pony */

    /* entry 9424 */
    { .label = {  97264,  7, 0 } }, /* ravendb */

    /* entry 9425 */
    { .label = {    243,  2, 0 } }, /* de */

    /* entry 9426 */
    { .label = { 116554,  3, 0 } }, /* bss */

    /* entries 9427 to 9432 */
    { .label = {  31712,  3, 1 } }, { .child = { 9433, 1 } }, /* lcl */
    { .label = {  28789,  3, 1 } }, { .child = { 9434, 1 } }, /* stg */
    { .label = { 136728,  7, 0 } }, /* workers */
    { .label = {  97534,  9, 0 } }, /* loginline */

    /* entry 9433 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9434 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9435 to 9436 */
    { .label = {  97128,  9, 1 } }, { .child = { 9437, 1 } }, /* cloudapps */

    /* entry 9437 */
    { .label = { 148853,  6, 0 } }, /* london */

    /* entry 9438 */
    { .label = {  97005,  9, 0 } }, /* fastpanel */

    /* entries 9439 to 9440 */
    { .label = {  97147,  5, 1 } }, { .child = { 9441, 2 } }, /* dapps */

    /* entries 9441 to 9443 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 171776,  3, 1 } }, { .child = { 9444, 1 } }, /* bzz */

    /* entry 9444 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9445 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 9446 to 9447 */
    { .label = {  19964,  7, 1 } }, { .child = { 9448, 1 } }, /* compute */

    /* entry 9448 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9449 to 9450 */
    { .label = { 165693,  5, 1 } }, { .child = { 9451, 1 } }, /* party */

    /* entry 9451 */
    { .label = {  13237,  4, 0 } }, /* user */

    /* entry 9452 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entry 9453 */
    { .label = {  65436,  3, 0 } }, /* ybo */

    /* entry 9454 */
    { .label = { 167498,  5, 0 } }, /* storj */

    /* entries 9455 to 9456 */
    { .label = {   5311,  2, 0 } }, /* of */
    { .label = {    121,  2, 0 } }, /* on */

    /* entry 9457 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entry 9458 */
    { .label = { 157336,  6, 0 } }, /* ptplus */

    /* entry 9459 */
    { .label = {   5311,  2, 0 } }, /* of */

    /* entry 9460 */
    { .label = { 170435,  4, 0 } }, /* cnpy */

    /* entry 9461 */
    { .label = {  13493,  5, 0 } }, /* cloud */

    /* entry 9462 */
    { .label = {  95884,  9, 0 } }, /* discourse */

    /* entries 9463 to 9466 */
    { .label = {  63772, 11, 0 } }, /* cloudaccess */
    { .label = { 116679,  8, 0 } }, /* freesite */
    { .label = {  13487,  6, 0 } }, /* pcloud */
    { .label = {  40666,  4, 0 } }, /* half */

    /* entry 9467 */
    { .label = {  97977,  9, 0 } }, /* opencraft */

    /* entry 9468 */
    { .label = {    761,  2, 0 } }, /* ng */

    /* entries 9469 to 9470 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  43572,  3, 0 } }, /* edu */

    /* entries 9471 to 9472 */
    { .label = {  38934,  6, 1 } }, { .child = { 9473, 2 } }, /* static */

    /* entries 9473 to 9474 */
    { .label = {   9075,  3, 0 } }, /* dev */
    { .label = {  39936,  5, 0 } }, /* sites */

    /* entries 9475 to 9478 */
    { .label = { 170456,  4, 0 } }, /* cyon */
    { .label = { 167337,  5, 0 } }, /* mypep */
    { .label = {  78263,  4, 1 } }, { .child = { 9479, 1 } }, /* dweb */

    /* entry 9479 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9480 to 9481 */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {   5311,  2, 0 } }, /* of */

    /* entry 9482 */
    { .label = {  98073,  6, 0 } }, /* router */

    /* entry 9483 */
    { .label = {   6325,  3, 0 } }, /* for */

    /* entry 9484 */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entries 9485 to 9486 */
    { .label = {    351,  3, 0 } }, /* and */
    { .label = {   6325,  3, 0 } }, /* for */

    /* entries 9487 to 9491 */
    { .label = { 166527,  5, 1 } }, { .child = { 9492, 1 } }, /* alces */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    858,  4, 0 } }, /* arvo */
    { .label = { 140490,  7, 0 } }, /* azimuth */

    /* entry 9492 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9493 to 9496 */
    { .label = { 166792,  5, 1 } }, { .child = { 9497, 1 } }, /* onred */
    { .label = {   6325,  3, 0 } }, /* for */
    { .label = { 119938,  8, 0 } }, /* homelink */

    /* entry 9497 */
    { .label = {  17944,  7, 0 } }, /* staging */

    /* entry 9498 */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entry 9499 */
    { .label = { 140014,  7, 0 } }, /* nerdpol */

    /* entry 9500 */
    { .label = { 167420,  5, 0 } }, /* prvcy */

    /* entry 9501 */
    { .label = {  65436,  3, 0 } }, /* ybo */

    /* entry 9502 */
    { .label = { 171179,  4, 0 } }, /* 1337 */

    /* entry 9503 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entry 9504 */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entry 9505 */
    { .label = {  65436,  3, 0 } }, /* ybo */

    /* entry 9506 */
    { .label = {  50080,  4, 0 } }, /* clan */

    /* entries 9507 to 9509 */
    { .label = { 156209,  6, 0 } }, /* myddns */
    { .label = {  98138,  9, 0 } }, /* lima-city */
    { .label = { 119605,  8, 0 } }, /* webspace */

    /* entries 9510 to 9512 */
    { .label = {  65803, 11, 0 } }, /* development */
    { .label = {  97264,  7, 0 } }, /* ravendb */
    { .label = { 171065,  4, 0 } }, /* repl */

    /* entry 9513 */
    { .label = {   6325,  3, 0 } }, /* for */

    /* entry 9514 */
    { .label = {  65436,  3, 0 } }, /* ybo */

    /* entry 9515 */
    { .label = {  97534,  9, 0 } }, /* loginline */

    /* entry 9516 */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entries 9517 to 9523 */
    { .label = { 116713,  8, 0 } }, /* cloudera */
    { .label = { 170456,  4, 0 } }, /* cyon */
    { .label = {  97534,  9, 0 } }, /* loginline */
    { .label = {  65903,  5, 0 } }, /* barsy */
    { .label = {  80691, 10, 1 } }, { .child = { 9524, 1 } }, /* platformsh */
    { .label = { 171045,  4, 0 } }, /* byen */

    /* entry 9524 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9525 to 9527 */
    { .label = {  79976, 10, 0 } }, /* linkitools */
    { .label = {  52440,  4, 0 } }, /* uber */
    { .label = { 157670,  6, 0 } }, /* xs4all */

    /* entry 9528 */
    { .label = {  65903,  5, 0 } }, /* barsy */

    /* entry 9529 */
    { .label = {  65854, 11, 0 } }, /* knightpoint */

    /* entry 9530 */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 9531 to 9532 */
    { .label = { 139949,  7, 0 } }, /* now-dns */
    { .label = { 167072,  5, 0 } }, /* ntdll */

    /* entry 9533 */
    { .label = {  65436,  3, 0 } }, /* ybo */

    /* entries 9534 to 9535 */
    { .label = {   5311,  2, 0 } }, /* of */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 9536 to 9541 */
    { .label = { 116857,  8, 0 } }, /* blogsite */
    { .label = { 166952,  5, 0 } }, /* fhapp */
    { .label = { 118836,  8, 0 } }, /* crafting */
    { .label = { 167095,  5, 0 } }, /* zapto */
    { .label = { 140396,  7, 1 } }, { .child = { 9542, 1 } }, /* telebit */

    /* entry 9542 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9543 to 9546 */
    { .label = { 136686,  7, 0 } }, /* cloud66 */
    { .label = { 156710,  6, 1 } }, { .child = { 9547, 1 } }, /* triton */
    { .label = {  98138,  4, 0 } }, /* lima */

    /* entry 9547 */
    { .label = {      0,  1, 0 } }, /* * */

};

